(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    983392,      17462]
NotebookOptionsPosition[    971049,      17273]
NotebookOutlinePosition[    971545,      17292]
CellTagsIndexPosition[    971502,      17289]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Two-outcome experiments on incentivizing honest performative predictions with \
proper scoring rules\
\>", "Title",
 CellChangeTimes->{{3.8801795760792418`*^9, 3.880179609287849*^9}, {
  3.885595100334029*^9, 3.885595104494279*^9}, {3.885596955981344*^9, 
  3.8855969597001667`*^9}, {3.894047098808775*^9, 
  3.894047134035479*^9}},ExpressionUUID->"8fe05bec-0f87-4bb9-b500-\
b37d3515c1f6"],

Cell["\<\
Caspar Oesterheld*, Johannes Treutlein*, Emery Cooper, and Rubi Hudson\
\>", "Subtitle",
 CellChangeTimes->{{3.8940471437200127`*^9, 
  3.894047184355805*^9}},ExpressionUUID->"fd6abcc8-4ec2-4e2f-9b96-\
aea3c5be9762"],

Cell[TextData[StyleBox["Definitions of scoring rules", "Section"]], "Text",
 CellChangeTimes->{{3.879702249791383*^9, 3.879702285739993*^9}, 
   3.8797138302232847`*^9},ExpressionUUID->"5e2aa8b8-3818-45b9-9eef-\
d539158e25a6"],

Cell[TextData[StyleBox["Log scoring rule", "Subsection"]], "Text",
 CellChangeTimes->{{3.880035951600932*^9, 
  3.880035955874506*^9}},ExpressionUUID->"e255552b-52b9-480b-8104-\
74edc0b5e7df"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"logscore", "[", 
    RowBox[{"0", ",", "0"}], "]"}], ":=", "0"}], ";", " ", 
  RowBox[{
   RowBox[{"logscore", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"logscore", "[", 
   RowBox[{"p_", ",", "q_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"q", "*", 
    RowBox[{"Log", "[", "p", "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "q"}], ")"}], "*", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "p"}], "]"}]}]}]}]}], "Input",
 CellChangeTimes->{
  3.87970229473666*^9, {3.879925448797014*^9, 3.879925460223371*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"ffc503ac-226e-4419-8f2c-3f41b68afa53"],

Cell[TextData[StyleBox["Tests", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.8800359617173567`*^9, 3.880035963755733*^9}, 
   3.880104860748631*^9},ExpressionUUID->"0d8c6482-a2a0-4ff3-bcc7-\
97188d60fe67"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.23"}], "<=", 
  RowBox[{"logscore", "[", 
   RowBox[{"0.8", ",", "1"}], "]"}], "<=", 
  RowBox[{"-", "0.21"}]}]], "Input",
 CellChangeTimes->{3.8797023017959433`*^9},
 CellLabel->"In[3]:=",ExpressionUUID->"8aeadadb-adb3-4982-bf8b-17ffab927907"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.87970230249399*^9, 3.87971448051847*^9, 3.879859582652851*^9, 
   3.879860904628374*^9, 3.879924372428751*^9, 3.879925462570593*^9, 
   3.879925497963229*^9, 3.880014485548139*^9, 3.880037071941106*^9, 
   3.880042975399191*^9, 3.8800438525800333`*^9, 3.8800922041370573`*^9, 
   3.88009232263829*^9, 3.880097898285598*^9, 3.880098134247473*^9, 
   3.880104358248867*^9, 3.8801074628897247`*^9, 3.8801104977740383`*^9, 
   3.880133788339674*^9, 3.880183008129889*^9, 3.884982976090199*^9, 
   3.885212462160128*^9, 3.885597046796056*^9, {3.885597098381119*^9, 
   3.8855971209831963`*^9}, 3.88565698953871*^9, 3.885699385229554*^9, 
   3.894041465309949*^9, 3.894043560324679*^9, 3.894046620415202*^9, 
   3.894047324919484*^9, 3.894047444091099*^9, 3.894047475985116*^9, 
   3.8940480957154922`*^9, 3.894048161169066*^9, 3.894049113973901*^9, 
   3.894061281423971*^9, 3.894063592056262*^9, 3.894063646924529*^9, 
   3.894066776219874*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"9166c45d-899f-4633-a391-90dec092c079"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"logscore", "[", 
   RowBox[{"1", ",", "1"}], "]"}], "==", "0"}]], "Input",
 CellChangeTimes->{{3.879925380405258*^9, 3.87992544634754*^9}, {
  3.879925958596752*^9, 3.8799259643666077`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"4d08099f-db8a-4fe5-99d9-141dbad9d2db"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.879925991329262*^9, 3.880014485572339*^9, 3.880037071997594*^9, 
   3.8800429754262667`*^9, 3.8800438526111307`*^9, 3.880092204155343*^9, 
   3.880092322640966*^9, 3.880097898290855*^9, 3.8800981342774*^9, 
   3.880104358281822*^9, 3.8801074629115763`*^9, 3.880110497799795*^9, 
   3.880133788342757*^9, 3.880183008147373*^9, 3.88498297684951*^9, 
   3.885212462199642*^9, 3.8855970469124727`*^9, {3.885597098527025*^9, 
   3.8855971211522923`*^9}, 3.885656989624165*^9, 3.88569938527614*^9, 
   3.8940414653611937`*^9, 3.89404356034695*^9, 3.894046620458912*^9, 
   3.8940473249707317`*^9, 3.894047444122089*^9, 3.8940474760171347`*^9, 
   3.894048095760742*^9, 3.89404816120851*^9, 3.8940491140238934`*^9, 
   3.894061281485971*^9, 3.894063592083934*^9, 3.89406364695856*^9, 
   3.894066776264522*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"05758a32-2986-40b6-9349-42272f54dcf0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"logscore", "[", 
   RowBox[{"0", ",", "0"}], "]"}], "==", "0"}]], "Input",
 CellChangeTimes->{{3.87992543506623*^9, 3.879925441745432*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"4516bade-5369-4683-99fb-e3df6b8cce70"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.879925442352977*^9, 3.8799254668989277`*^9}, 
   3.8799254979932127`*^9, 3.8799259913942213`*^9, 3.88001448559457*^9, 
   3.880037072035417*^9, 3.88004297545284*^9, 3.880043852641663*^9, 
   3.880092204157961*^9, 3.8800923226585093`*^9, 3.880097898310995*^9, 
   3.880098134305315*^9, 3.8801043583128967`*^9, 3.8801074629298153`*^9, 
   3.880110497826294*^9, 3.880133788370708*^9, 3.880183008149929*^9, 
   3.8849829775297213`*^9, 3.885212462246162*^9, 3.8855970470434837`*^9, {
   3.885597098655922*^9, 3.885597121242478*^9}, 3.885656989670813*^9, 
   3.885699385345497*^9, 3.8940414654110327`*^9, 3.8940435603672857`*^9, 
   3.894046620485783*^9, 3.8940473250186653`*^9, 3.894047444148885*^9, 
   3.894047476045699*^9, 3.894048095800827*^9, 3.894048161243965*^9, 
   3.894049114080201*^9, 3.894061281534006*^9, 3.894063592114573*^9, 
   3.894063646977786*^9, 3.8940667762890987`*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"61eeca36-173d-4759-8213-bfc907e7374d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"logscore", "[", 
   RowBox[{"0", ",", "0.001"}], "]"}], "==", 
  RowBox[{"-", "\[Infinity]"}]}]], "Input",
 CellChangeTimes->{{3.879926001818185*^9, 3.8799260403676434`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"f6c8c8c4-7797-4df0-937f-f47d61afd4c9"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.879926008271338*^9, 3.879926041522628*^9}, 
   3.880014485615481*^9, 3.880037072073389*^9, 3.880042975480756*^9, 
   3.8800438526777773`*^9, 3.880092204173588*^9, 3.8800923226630087`*^9, 
   3.880097898316835*^9, 3.880098134333681*^9, 3.880104369868785*^9, 
   3.8801074629476957`*^9, 3.880110497852585*^9, 3.880133788374221*^9, 
   3.880183008151956*^9, 3.88498297815066*^9, 3.8852124622875443`*^9, 
   3.8855970471678247`*^9, {3.885597098772975*^9, 3.8855971214836597`*^9}, 
   3.8856569896858473`*^9, 3.8856993853970003`*^9, 3.894041465461307*^9, 
   3.894043560387128*^9, 3.894046620508584*^9, 3.8940473250700808`*^9, 
   3.894047444193533*^9, 3.894047476074778*^9, 3.894048095845706*^9, 
   3.894048161281296*^9, 3.89404911413982*^9, 3.8940612815813227`*^9, 
   3.894063592140581*^9, 3.894063646997938*^9, 3.89406677631248*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"d9275425-cd31-48cc-9687-b2bde4862af6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Last", " ", "@", 
   RowBox[{"Last", "@", 
    RowBox[{"Last", "@", 
     RowBox[{"Maximize", "[", 
      RowBox[{
       RowBox[{"logscore", "[", 
        RowBox[{"p", ",", 
         RowBox[{"1", "/", "3"}]}], "]"}], ",", "p"}], "]"}]}]}]}], "==", 
  RowBox[{"1", "/", "3"}]}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"fe74678d-2557-4a1e-9444-fccfbdcf7fcd"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.880014485873707*^9, 3.8800370722392817`*^9, 3.880042975739012*^9, 
   3.880043852851719*^9, 3.880092204268649*^9, 3.88009232269946*^9, 
   3.880097898416506*^9, 3.88009813459379*^9, 3.880104370316722*^9, 
   3.880107463112166*^9, 3.8801104980665073`*^9, 3.8801337884763107`*^9, 
   3.8801830082546988`*^9, 3.8849829789419603`*^9, 3.885212462601616*^9, 
   3.885597047535205*^9, {3.885597098987295*^9, 3.8855971223424387`*^9}, 
   3.8856569899976063`*^9, 3.8856993855630827`*^9, 3.894041465773562*^9, 
   3.894043560562872*^9, 3.894046620673244*^9, 3.8940473252603197`*^9, 
   3.894047444309235*^9, 3.894047476265895*^9, 3.894048096126761*^9, 
   3.894048161565548*^9, 3.8940491144576883`*^9, 3.894061281787386*^9, 
   3.894063592303385*^9, 3.8940636471609907`*^9, 3.8940667764811296`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"29c4ad74-89da-4b65-ac7c-869859ae3a27"]
}, Open  ]],

Cell[TextData[StyleBox["Brier scoring rule", "Subsection"]], "Text",
 CellChangeTimes->{{3.88003597186812*^9, 3.880035977477973*^9}, {
  3.8800361798232203`*^9, 
  3.88003618094166*^9}},ExpressionUUID->"b3e7c80c-6ff2-4f20-a72e-\
9d88bf1dd1e5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"brierscore", "[", 
   RowBox[{"p_", ",", "q_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"q", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "*", "p"}], "-", 
      RowBox[{"p", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], "^", "2"}]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "q"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}]}], "-", 
      RowBox[{"p", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], "^", "2"}]}], ")"}]}]}]}]], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"4c28895a-7247-4173-9d29-7d43df4be069"],

Cell[TextData[StyleBox["Test", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.880104874431834*^9, 
  3.880104874891471*^9}},ExpressionUUID->"ab4eb933-1153-4edb-a9f2-\
90b9e90ac951"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Last", "@", 
   RowBox[{"Last", "@", 
    RowBox[{"Last", "@", 
     RowBox[{"Maximize", "[", 
      RowBox[{
       RowBox[{"brierscore", "[", 
        RowBox[{"p", ",", 
         RowBox[{"1", "/", "5"}]}], "]"}], ",", "p"}], "]"}]}]}]}], "==", 
  RowBox[{"1", "/", "5"}]}]], "Input",
 CellChangeTimes->{{3.880025755228335*^9, 3.880025757480744*^9}, {
  3.8940414955652647`*^9, 3.894041500026354*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"4a1182d0-23f8-44a9-8ff0-6801412f579a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.879702327942276*^9, 3.879714483121862*^9, 3.879859585113536*^9, 
   3.8798609048069067`*^9, 3.879924372643778*^9, 3.879925498182254*^9, 
   3.880014485983007*^9, {3.880025755627042*^9, 3.880025758052705*^9}, 
   3.880037072409378*^9, 3.88004297588169*^9, 3.8800438529429092`*^9, 
   3.880092204301096*^9, 3.880092322732709*^9, 3.880097898453933*^9, 
   3.880098134698512*^9, 3.880104370437503*^9, 3.880107463178259*^9, 
   3.88011049816545*^9, 3.880133788500554*^9, 3.880183008285334*^9, 
   3.8849829818101187`*^9, 3.8852124627516193`*^9, 3.885597047822781*^9, {
   3.8855970992347727`*^9, 3.885597122957951*^9}, 3.885656990132834*^9, 
   3.8856993856962347`*^9, 3.894041465908743*^9, 3.894043563212756*^9, 
   3.894046620746737*^9, 3.894047327846993*^9, 3.8940474443997927`*^9, 
   3.894047476349378*^9, 3.894048096229196*^9, 3.894048164144082*^9, 
   3.8940491145680437`*^9, 3.8940612818991823`*^9, 3.894063592357662*^9, 
   3.89406364721237*^9, 3.894066776555058*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"3765b4fb-3ed7-4aeb-8323-77f65cb15812"]
}, Open  ]],

Cell[TextData[StyleBox["Exponential Scoring rule", "Subsection"]], "Text",
 CellChangeTimes->{{3.88003620621749*^9, 
  3.880036210517733*^9}},ExpressionUUID->"ca7eb32f-0c5a-43ec-8a5b-\
c688cd7d7575"],

Cell[BoxData[
 RowBox[{
  RowBox[{"exponentialscore", "[", 
   RowBox[{"K_", ",", "p_", ",", "q_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"K", "*", "p"}], "]"}], "/", "K"}], "+", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"K", "*", "p"}], "]"}], 
    RowBox[{"(", 
     RowBox[{"q", "-", "p"}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8800254905304747`*^9, 3.880025506294858*^9}, {
   3.880025587415861*^9, 3.880025604348865*^9}, {3.8800256370397453`*^9, 
   3.880025716558617*^9}, {3.8800259580888577`*^9, 3.880025961792007*^9}, 
   3.8800263766598454`*^9, {3.880043997249164*^9, 3.88004399881548*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"355cb0f4-9475-48d5-b4cd-bf63a608394d"],

Cell[TextData[StyleBox["Test", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.880036240783257*^9, 3.880036243133485*^9}, 
   3.880104883480103*^9},ExpressionUUID->"2b33bda9-537f-4946-85d6-\
249b34eccbac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"Last", "@", 
    RowBox[{"Last", "@", 
     RowBox[{"Last", "@", 
      RowBox[{"Maximize", "[", 
       RowBox[{
        RowBox[{"exponentialscore", "[", 
         RowBox[{
          RowBox[{"1", "/", "3"}], ",", "p", ",", 
          RowBox[{"1", "/", "5"}]}], "]"}], ",", "p"}], "]"}]}]}]}], "==", 
   RowBox[{"1", "/", "5"}]}]}]], "Input",
 CellChangeTimes->{{3.8800256972803373`*^9, 3.880025763493759*^9}, {
  3.880026069911869*^9, 3.8800260818039227`*^9}, {3.880036219853922*^9, 
  3.880036232810117*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"b38d45e1-5793-4524-b0bb-1d016751116f"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.880025731722454*^9, 3.880025764772677*^9}, 
   3.8800259640194187`*^9, {3.88002607528767*^9, 3.8800260824812803`*^9}, 
   3.880026378325574*^9, 3.880037072558784*^9, 3.880042976015869*^9, 
   3.880043853032878*^9, 3.880092204333074*^9, 3.880092322756654*^9, 
   3.880097898484466*^9, 3.8800981348142433`*^9, 3.880104370551697*^9, 
   3.880107463304791*^9, 3.880110498386654*^9, 3.880133788546818*^9, 
   3.880183008331695*^9, 3.884982984771037*^9, 3.885212462881534*^9, 
   3.885597048051162*^9, {3.8855970995361357`*^9, 3.885597123256616*^9}, 
   3.88565699027164*^9, 3.8856993858478117`*^9, 3.89404146618228*^9, 
   3.8940435635825443`*^9, 3.894046620840612*^9, 3.894047328027025*^9, 
   3.894047444543261*^9, 3.8940474764447107`*^9, 3.894048096383115*^9, 
   3.894048164613223*^9, 3.89404911471285*^9, 3.894061282071123*^9, 
   3.894063592435425*^9, 3.894063647293168*^9, 3.894066776635234*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"3833c56e-edda-4ae4-a801-933178d87258"]
}, Open  ]],

Cell[TextData[StyleBox["Linear world functions", "Section"]], "Text",
 CellChangeTimes->{{3.880036260323344*^9, 
  3.880036271019978*^9}},ExpressionUUID->"a133ddfb-69a3-40bc-802a-\
753c489a7957"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"p_", ",", "fp_", ",", "slope_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"p", "-", "fp"}], ")"}], "*", "slope"}], "+", "fp"}]}]], "Input",\

 CellChangeTimes->{{3.879699116980547*^9, 3.879699181955009*^9}, {
  3.8799382586803293`*^9, 3.879938259328598*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"beee79e7-dce5-4d16-bf34-31cd3a2f191c"],

Cell[TextData[StyleBox["Tests", "Subsection"]], "Text",
 CellChangeTimes->{{3.880104914171876*^9, 
  3.880104915273754*^9}},ExpressionUUID->"f9d1b64e-3e4a-4281-90cc-\
f138faed8ff1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"0.1", ",", "0.5", ",", "0.5"}], "]"}], "==", "0.3"}]], "Input",
 CellChangeTimes->{{3.879699184337899*^9, 3.879699194051929*^9}, {
  3.879700249290473*^9, 3.879700257871312*^9}, {3.879702072244451*^9, 
  3.879702113940576*^9}, {3.879938260666029*^9, 3.879938261281309*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"401d0c2c-4eb7-4b25-843f-ec9e6522cd7c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.879702101601962*^9, 3.879702114508803*^9}, {
   3.8797144687407513`*^9, 3.879714489579458*^9}, 3.879859599290159*^9, 
   3.879860905371044*^9, 3.8799243777305717`*^9, 3.879925499002696*^9, {
   3.879938263626587*^9, 3.87993828729478*^9}, 3.879946797580014*^9, 
   3.8800370726220207`*^9, 3.880042976166849*^9, 3.880043853068965*^9, 
   3.88009220434717*^9, 3.880092322772574*^9, 3.880097898501473*^9, 
   3.8800981348705893`*^9, 3.880104370593042*^9, 3.880107463354315*^9, 
   3.8801104984384747`*^9, 3.8801337885722446`*^9, 3.880183008335868*^9, 
   3.8849830136696367`*^9, 3.8852124629546213`*^9, 3.885597048196851*^9, {
   3.885597099665596*^9, 3.885597123349441*^9}, 3.8856569903275146`*^9, 
   3.885699385903927*^9, 3.894041466257492*^9, 3.894043563639792*^9, 
   3.894046622776401*^9, 3.894047328102813*^9, 3.89404744462501*^9, 
   3.894047476479392*^9, 3.89404809645325*^9, 3.894048164667794*^9, 
   3.894049114771093*^9, 3.894061282152165*^9, 3.894063592465783*^9, 
   3.894063647328229*^9, 3.894066776673255*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"2bd9edac-24ab-493c-9ab6-5ed9a2b94c7b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"fp", ",", "fp", ",", "slope"}], "]"}], "==", "fp"}]], "Input",
 CellChangeTimes->{{3.880104930477634*^9, 3.880104952582547*^9}, {
  3.8801059133861017`*^9, 3.880105913805221*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"28017b62-e3c2-4e78-8892-84616a1abb7f"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.880105467222364*^9, 3.880105914262783*^9, 3.880107463393537*^9, 
   3.8801104984830837`*^9, 3.8801337885753403`*^9, 3.8801830083505783`*^9, 
   3.884983014456901*^9, 3.885212463150524*^9, 3.8855970483176517`*^9, {
   3.885597099808173*^9, 3.88559712353533*^9}, 3.885656990372696*^9, 
   3.885699385950494*^9, 3.894041466310112*^9, 3.894043563682849*^9, 
   3.894046622989827*^9, 3.894047328168782*^9, 3.894047444682678*^9, 
   3.89404747652215*^9, 3.894048096499015*^9, 3.894048164705035*^9, 
   3.89404911482082*^9, 3.8940612822216*^9, 3.8940635924918327`*^9, 
   3.8940636473495283`*^9, 3.8940667767063713`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"91496de2-6d3e-4f08-b8da-a9dd30e76cea"]
}, Open  ]],

Cell[TextData[StyleBox["Optimal report functions", "Section"]], "Text",
 CellChangeTimes->{{3.880036457098516*^9, 
  3.880036464996162*^9}},ExpressionUUID->"24d566b2-c6b8-4bd0-9b94-\
0c03a538b60a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "ArgmaxScore", "]"}], ";", 
  RowBox[{
   RowBox[{"ArgmaxScore", "[", 
    RowBox[{"fp_", ",", "slope_", ",", "S_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"ArgmaxScore", "[", 
     RowBox[{"fp", ",", "slope", ",", "S"}], "]"}], "=", 
    RowBox[{"Last", "@", 
     RowBox[{"Last", "@", 
      RowBox[{"Last", "@", 
       RowBox[{"Maximize", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"S", "[", 
            RowBox[{"p", ",", 
             RowBox[{"f", "[", 
              RowBox[{"p", ",", "fp", ",", "slope"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"p", ">=", "0"}], ",", 
             RowBox[{"p", "<=", "1"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", "p", "}"}], ",", 
         RowBox[{"Method", "->", 
          RowBox[{"{", 
           RowBox[{"\"\<RandomSearch\>\"", ",", 
            RowBox[{"\"\<SearchPoints\>\"", "->", "500"}]}], "}"}]}]}], 
        "]"}]}]}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.880036526142702*^9, 3.880036531870706*^9}, {
   3.894043061959364*^9, 3.894043064766734*^9}, 3.894043107593898*^9, {
   3.894043200770381*^9, 3.8940432181940107`*^9}, {3.894043262209484*^9, 
   3.894043269902128*^9}, {3.8940433336117277`*^9, 3.894043357565811*^9}, {
   3.8940434274256697`*^9, 3.894043461509275*^9}, 3.894043526459982*^9, 
   3.89404728984984*^9, {3.8940474328709*^9, 3.89404743925287*^9}, 
   3.8940480718630047`*^9, 3.894048117800324*^9, {3.89404886244562*^9, 
   3.894048865137183*^9}, {3.894063573708259*^9, 3.8940635790762672`*^9}, {
   3.894063611785543*^9, 3.8940636144099913`*^9}, {3.894066659801937*^9, 
   3.894066664521042*^9}, {3.894066740475215*^9, 3.894066740785738*^9}, {
   3.894118349153544*^9, 3.8941183644670973`*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"c0e6d0b9-e799-4b1d-a691-223c2a1a00e1"],

Cell[TextData[StyleBox["Tests", "Subsection"]], "Text",
 CellChangeTimes->{{3.880104976910264*^9, 
  3.880104977594892*^9}},ExpressionUUID->"9b8b63ba-31a3-464f-9293-\
3db5ffab966a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"ArgmaxScore", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"1", "/", "3"}], ",", "brierscore"}], "]"}], "-", "0.5"}], 
   "]"}], "<=", "0.00001"}]], "Input",
 CellChangeTimes->{
  3.880036537720587*^9, {3.89404335048178*^9, 3.8940433828264837`*^9}, 
   3.894043472705421*^9, 3.89404354763587*^9},
 CellLabel->"In[16]:=",ExpressionUUID->"468858e9-d154-4785-8723-9c4e33592632"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "+", 
    RowBox[{"(", 
     RowBox[{"\<\"SearchPoints\"\>", "\[Rule]", "100"}], ")"}]}], "]"}], 
  "\[LessEqual]", "0.00001`"}]], "Output",
 CellChangeTimes->{
  3.880037072741768*^9, 3.8800429762349577`*^9, 3.880043853220044*^9, 
   3.880092204365157*^9, 3.880092322776904*^9, 3.880097898519836*^9, 
   3.8800981349436197`*^9, 3.880104370688644*^9, 3.880107463579452*^9, 
   3.8801104986285343`*^9, 3.880133788597992*^9, 3.88018300836718*^9, 
   3.884983016814642*^9, 3.88521246326307*^9, 3.8855970486470222`*^9, {
   3.885597100017254*^9, 3.8855971247274847`*^9}, 3.8856041519879227`*^9, 
   3.8856569909552717`*^9, 3.8856993862832403`*^9, 3.894041466782177*^9, {
   3.894043350750333*^9, 3.894043383326695*^9}, {3.894043468964157*^9, 
   3.894043472988512*^9}, {3.8940435479653587`*^9, 3.894043564129698*^9}, 
   3.894046623220168*^9, 3.89404732936413*^9, 3.8940474449840107`*^9, 
   3.894047477119688*^9, 3.894048097199976*^9, 3.8940481650931463`*^9, 
   3.89404911549577*^9, 3.894061282377324*^9, 3.8940635925727873`*^9, 
   3.8940636473878727`*^9, 3.894066778957541*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"a5313f52-c03f-4f33-81b6-c1a5f27a51ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"ArgmaxScore", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"1", "/", "3"}], ",", "logscore"}], "]"}], "-", "0.5"}], "]"}], 
  "<", "0.00001"}]], "Input",
 CellChangeTimes->{{3.880104986567774*^9, 3.8801049899568567`*^9}, 
   3.894043352310547*^9, {3.8940433863385057`*^9, 3.894043396585725*^9}, 
   3.894043549684538*^9},
 CellLabel->"In[17]:=",ExpressionUUID->"7fac92a9-11fe-4366-86e4-3ea4bf67bc89"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "+", 
    RowBox[{"(", 
     RowBox[{"\<\"SearchPoints\"\>", "\[Rule]", "100"}], ")"}]}], "]"}], "<", 
  "0.00001`"}]], "Output",
 CellChangeTimes->{
  3.88010546753126*^9, 3.8801074637133503`*^9, 3.880110498813047*^9, 
   3.8801337886699667`*^9, 3.88018300845035*^9, 3.884983019203589*^9, 
   3.885212463490004*^9, 3.8855970488280487`*^9, {3.885597100071432*^9, 
   3.885597125344247*^9}, 3.885604152042233*^9, 3.885656991197754*^9, 
   3.8856993865035353`*^9, 3.8940414670055037`*^9, 3.894043352726557*^9, 
   3.8940434008806067`*^9, 3.894043476059388*^9, {3.894043549966473*^9, 
   3.8940435641797237`*^9}, 3.894046623260847*^9, 3.894047329533802*^9, 
   3.8940474450519943`*^9, 3.894047477196122*^9, 3.894048097321246*^9, 
   3.894048165439171*^9, 3.894049115843392*^9, 3.894061282729177*^9, 
   3.894063592611041*^9, 3.894063647409039*^9, 3.89406677918848*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"637eb86e-fa41-45a1-b457-c007ee7c1ac0"]
}, Open  ]],

Cell[TextData[StyleBox["Measures of distance between probabilities", \
"Section"]], "Text",
 CellChangeTimes->{{3.8800366324102077`*^9, 3.8800366438911867`*^9}, {
   3.880036679131168*^9, 3.8800366887173567`*^9}, 
   3.8800368861066732`*^9},ExpressionUUID->"ab1d2bca-3247-4237-8fa1-\
b9255ab56d3c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AbsLogOddsRatio", "[", 
    RowBox[{"0", ",", "0"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AbsLogOddsRatio", "[", 
    RowBox[{"1", ",", "1"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AbsLogOddsRatio", "[", 
    RowBox[{"0", ",", "q_"}], "]"}], "=", "Infinity"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AbsLogOddsRatio", "[", 
    RowBox[{"p_", ",", "0"}], "]"}], "=", "Infinity"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AbsLogOddsRatio", "[", 
    RowBox[{"1", ",", "q_"}], "]"}], "=", "Infinity"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AbsLogOddsRatio", "[", 
    RowBox[{"p_", ",", "1"}], "]"}], "=", "Infinity"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AbsLogOddsRatio", "[", 
    RowBox[{"p_", ",", "q_"}], "]"}], ":=", 
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"Log", "[", "p", "]"}], "-", 
     RowBox[{"Log", "[", "q", "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "q"}], "]"}], "-", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "p"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.880036831173669*^9, 3.880036840846163*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"9c2e4e87-27a9-408c-bb0a-6ba96827f031"],

Cell[BoxData[
 RowBox[{
  RowBox[{"L1Distance", "[", 
   RowBox[{"p_", ",", "q_"}], "]"}], ":=", 
  RowBox[{"Abs", "[", 
   RowBox[{"p", "-", "q"}], "]"}]}]], "Input",
 CellLabel->"In[25]:=",ExpressionUUID->"14e896d5-7e0a-49db-a028-9fb5659234f7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"L2DistanceVect", "[", 
   RowBox[{"p_", ",", "q_"}], "]"}], ":=", 
  RowBox[{
   SqrtBox["2"], " ", 
   RowBox[{"Abs", "[", 
    RowBox[{"p", "-", "q"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.884988133982531*^9, 3.884988148617765*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"a3bc0f81-f410-4ef8-8202-e98e200a79b6"],

Cell[TextData[StyleBox["Tests", "Subsection"]], "Text",
 CellChangeTimes->{{3.884983135377104*^9, 
  3.884983136002779*^9}},ExpressionUUID->"c5799c33-45f8-4478-a93a-\
a3d9fe9e13da"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"1", "-", "p"}]}], "}"}], "-", 
     RowBox[{"{", 
      RowBox[{"q", ",", 
       RowBox[{"1", "-", "q"}]}], "}"}]}], "]"}], "==", 
   RowBox[{"L2DistanceVect", "[", 
    RowBox[{"p", ",", "q"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.884983130160019*^9, 3.884983183042742*^9}, 
   3.884988165326782*^9},
 CellLabel->"In[27]:=",ExpressionUUID->"9a221104-1420-4563-ab78-8b79ae1ffdbb"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.884983155187047*^9, 3.884983183476066*^9}, 
   3.88498516123659*^9, {3.884988228397884*^9, 3.8849882285196247`*^9}, 
   3.8852124636477213`*^9, 3.885597049005906*^9, {3.8855971001516037`*^9, 
   3.8855971256132517`*^9}, 3.885656991312278*^9, 3.885699386650529*^9, 
   3.894041467245431*^9, 3.8940435644206676`*^9, 3.894046623400427*^9, 
   3.89404732972721*^9, 3.8940474452302647`*^9, 3.894047477323971*^9, 
   3.8940480975109797`*^9, 3.894048165704895*^9, 3.894049116131744*^9, 
   3.894061282872695*^9, 3.894063592705862*^9, 3.8940636499369993`*^9, 
   3.894066779252946*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"f9c97511-babe-41d3-939c-3bc709c3b875"]
}, Open  ]],

Cell[TextData[StyleBox["Defining the accuracy bounds from our results", \
"Section"]], "Text",
 CellChangeTimes->{{3.880037002283009*^9, 3.880037032739725*^9}, 
   3.880092217805135*^9},ExpressionUUID->"830ec312-c3b9-4c5f-8a33-\
439236820b76"],

Cell["\<\
The following is the bound on the distance between the optimal report p and \
f(p) for the given scoring rule and bound on the Lipschitz constant (slope) \
of the function f, as obtained in the paper.\
\>", "Text",
 CellChangeTimes->{{3.8940443061822777`*^9, 
  3.8940444079947453`*^9}},ExpressionUUID->"c43bbf58-ee3e-4247-950c-\
3eca3d34f95c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Boundf", "[", 
   RowBox[{"slope_", ",", "S_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "*", "slope", " ", "*", 
   RowBox[{
    RowBox[{"Maximize", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"S", "[", 
               RowBox[{"#", ",", "#"}], "]"}], "&"}], "[", "x", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "1"}], "}"}]}], "]"}], "/", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"S", "[", 
               RowBox[{"#", ",", "#"}], "]"}], "&"}], "[", "x", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{"x", "->", "fp"}], "}"}]}], ",", 
        RowBox[{"fp", "<=", "1"}], ",", 
        RowBox[{"fp", ">=", "0"}]}], "}"}], ",", 
      RowBox[{"{", "fp", "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8800041891503973`*^9, 3.880004403765943*^9}, 
   3.8800044526200447`*^9, 3.880034251306088*^9, {3.8849833166108723`*^9, 
   3.884983320683981*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"8711fd73-344d-4343-b49c-ce2d7ef34bd8"],

Cell["\<\
The following is the bound on the distance between the optimal report and the \
fixed point of f for the given scoring rule and bound on the Lipschitz \
constant (slope) of the function f, as obtained in the paper.\
\>", "Text",
 CellChangeTimes->{{3.894044390627821*^9, 
  3.8940444254375277`*^9}},ExpressionUUID->"6aae9fc6-ff59-4ecf-893a-\
aa7be209137b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Boundfp", "[", 
   RowBox[{"slope_", ",", "S_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "*", 
   RowBox[{"slope", " ", "/", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "slope"}], ")"}]}], " ", "*", 
   RowBox[{
    RowBox[{"Maximize", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"S", "[", 
               RowBox[{"#", ",", "#"}], "]"}], "&"}], "[", "x", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "1"}], "}"}]}], "]"}], "/", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"S", "[", 
               RowBox[{"#", ",", "#"}], "]"}], "&"}], "[", "x", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{"x", "->", "fp"}], "}"}]}], ",", 
        RowBox[{"fp", "<=", "1"}], ",", 
        RowBox[{"fp", ">=", "0"}]}], "}"}], ",", 
      RowBox[{"{", "fp", "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.880034247670067*^9, 3.880034269554431*^9}, {
  3.884983326162442*^9, 3.884983327235084*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"c454bd1e-0fa5-4b16-b8bb-ffd45b9d8f1a"],

Cell["\<\
For the Brier scoring rule we can give these bounds explicitly as in the \
paper.\
\>", "Text",
 CellChangeTimes->{{3.8940444384170027`*^9, 
  3.8940444549776917`*^9}},ExpressionUUID->"85f132ba-f820-4dba-8ab8-\
e14dc4138916"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BrierBoundf", "[", "slope_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "/", "2"}], "]"}], "*", "slope"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BrierBoundfp", "[", "slope_", "]"}], ":=", 
   RowBox[{
    RowBox[{"slope", "/", 
     RowBox[{"(", 
      RowBox[{"1", "-", "slope"}], ")"}]}], "*", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "/", "2"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.884986176491695*^9, 3.884986223908177*^9}, {
  3.884986288294528*^9, 3.8849863456691227`*^9}, {3.884987587910022*^9, 
  3.884987634644413*^9}, {3.88498943331336*^9, 3.884989434876511*^9}, {
  3.88498972327789*^9, 3.884989773521215*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"0ba26bac-495a-44f6-a6b0-6cf891a6344b"],

Cell[TextData[StyleBox["Defining measured quantities", "Section"]], "Text",
 CellChangeTimes->{{3.8800369289450808`*^9, 
  3.880036949022305*^9}},ExpressionUUID->"de81d10c-a6f1-47b3-90dd-\
025b3d0634b6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ArgmaxScoreDistanceTof", "[", 
   RowBox[{"fp_", ",", "slope_", ",", "S_", ",", "d_"}], "]"}], ":=", 
  RowBox[{"d", "[", 
   RowBox[{
    RowBox[{"ArgmaxScore", "[", 
     RowBox[{"fp", ",", "slope", ",", "S"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"ArgmaxScore", "[", 
       RowBox[{"fp", ",", "slope", ",", "S"}], "]"}], ",", "fp", ",", 
      "slope"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.879936312511778*^9, 3.8799363822130737`*^9}, {
  3.8799383362627497`*^9, 3.879938349955921*^9}, {3.879949293527886*^9, 
  3.8799492941735086`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"8c33f018-1dc3-431a-9583-7ad9e7885b08"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ArgmaxScoreDistanceTofp", "[", 
   RowBox[{"fp_", ",", "slope_", ",", "S_", ",", "d_"}], "]"}], ":=", 
  RowBox[{"d", "[", 
   RowBox[{
    RowBox[{"ArgmaxScore", "[", 
     RowBox[{"fp", ",", "slope", ",", "S"}], "]"}], ",", "fp"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{3.880036772910718*^9},
 CellLabel->"In[33]:=",ExpressionUUID->"94681f00-dc3c-4f6b-873f-2a5b91bac68e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sigmoid", "[", "o_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Exp", "[", "o", "]"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Exp", "[", "o", "]"}], "+", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", "o"}], "]"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.879952837466667*^9, 3.879952837682088*^9}, 
   3.8799530249014063`*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"8869fb9c-679e-4ff3-8a99-71b1fa3ace61"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMaxArgmaxScoreDistanceTof", "[", 
   RowBox[{"slope_", ",", "S_", ",", "d_"}], "]"}], ":=", 
  RowBox[{"Max", "[", 
   RowBox[{"N", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"ArgmaxScoreDistanceTof", "[", 
       RowBox[{"fp", ",", "slope", ",", "S", ",", "d"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"fp", ",", "0", ",", "1", ",", 
        RowBox[{"2", "*", 
         RowBox[{"10", "^", 
          RowBox[{"(", 
           RowBox[{"-", "2"}], ")"}]}]}]}], "}"}]}], "]"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.879950084978726*^9, 3.879950105457643*^9}, 
   3.879950196629261*^9, {3.8799502789900618`*^9, 3.879950329534034*^9}, {
   3.879950379655924*^9, 3.87995037986683*^9}, {3.8799504262515717`*^9, 
   3.879950462651672*^9}, {3.8799505240936403`*^9, 3.8799505252053127`*^9}, 
   3.879950743544633*^9, {3.879950897713296*^9, 3.879950898871086*^9}, {
   3.879950933316283*^9, 3.879950937417383*^9}, {3.8799509680810423`*^9, 
   3.879950970736335*^9}, {3.879951047133706*^9, 3.8799511234308434`*^9}, 
   3.879951158806664*^9, {3.8799512096194553`*^9, 3.879951253605962*^9}, {
   3.879951340254573*^9, 3.879951340362916*^9}, {3.87995146539815*^9, 
   3.879951474536113*^9}, {3.8799519715854797`*^9, 3.879951975469569*^9}, {
   3.879952168419449*^9, 3.879952183280195*^9}, {3.87995246799049*^9, 
   3.879952468773184*^9}, {3.879952715941409*^9, 3.879952717228243*^9}, {
   3.879952762685265*^9, 3.879952810594173*^9}, {3.8799530891901083`*^9, 
   3.879953094015314*^9}, {3.880004148202437*^9, 3.880004155419692*^9}, {
   3.880006933324072*^9, 3.8800069334438143`*^9}, {3.880017900446851*^9, 
   3.880017900540607*^9}, {3.880095757115367*^9, 3.880095775418294*^9}, {
   3.880095830761979*^9, 3.88009585135991*^9}, {3.880095883560568*^9, 
   3.8800958881733303`*^9}, {3.880095934003686*^9, 3.880095962861793*^9}, {
   3.880096076273891*^9, 3.880096166424685*^9}, {3.8800970371080637`*^9, 
   3.880097062674333*^9}, {3.8800971346865683`*^9, 3.880097152516486*^9}, {
   3.8800974335699244`*^9, 3.880097434306567*^9}, {3.8800975549302673`*^9, 
   3.880097555095057*^9}, {3.880097878287101*^9, 3.8800978789282827`*^9}, {
   3.880097983319539*^9, 3.880097983404511*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"b8ec5997-12a1-4831-9d52-55e95fff16ea"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMaxArgmaxScoreDistanceTofp", "[", 
   RowBox[{"slope_", ",", "S_", ",", "d_"}], "]"}], ":=", 
  RowBox[{"Max", "[", 
   RowBox[{"N", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"ArgmaxScoreDistanceTofp", "[", 
       RowBox[{"fp", ",", "slope", ",", "S", ",", "d"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"fp", ",", "0", ",", "1", ",", 
        RowBox[{"2", "*", 
         RowBox[{"10", "^", 
          RowBox[{"(", 
           RowBox[{"-", "2"}], ")"}]}]}]}], "}"}]}], "]"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.879950526603403*^9, 3.879950570993373*^9}, {
   3.879950728615336*^9, 3.879950750415259*^9}, {3.879950900950602*^9, 
   3.8799509019136667`*^9}, {3.879950960720793*^9, 3.8799509614056597`*^9}, {
   3.879951054351438*^9, 3.879951125166889*^9}, {3.8799512141695023`*^9, 
   3.879951246483307*^9}, {3.879951341546781*^9, 3.879951357447816*^9}, {
   3.879951477854946*^9, 3.879951481901615*^9}, {3.879951973449561*^9, 
   3.879951977508412*^9}, {3.8799521746881027`*^9, 3.879952185375293*^9}, 
   3.879952471006526*^9, {3.8799527673140993`*^9, 3.87995280900105*^9}, 
   3.879952841120987*^9, {3.87995309511438*^9, 3.879953096813136*^9}, {
   3.8800041512398033`*^9, 3.880004159356641*^9}, {3.8800069346599007`*^9, 
   3.880006934750139*^9}, {3.880017901913773*^9, 3.880017902039583*^9}, {
   3.880095760353661*^9, 3.880095777006686*^9}, {3.880095839243291*^9, 
   3.8800958532228403`*^9}, {3.880095885882452*^9, 3.880095897011002*^9}, {
   3.880095928657771*^9, 3.880095961599305*^9}, {3.8800960778269987`*^9, 
   3.880096171672792*^9}, {3.880097043052785*^9, 3.88009706550385*^9}, {
   3.880097137472097*^9, 3.880097154399432*^9}, {3.88009743774677*^9, 
   3.880097443735388*^9}, {3.8800975566320677`*^9, 3.880097557569572*^9}, {
   3.880097880452324*^9, 3.88009788161828*^9}, {3.880097984381237*^9, 
   3.8800979844624767`*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"e62cd52c-73f4-46ab-be88-f081cc82cee5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MaxArgmaxScoreDistanceTof", "[", 
   RowBox[{"slope_", ",", "S_", ",", "d_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Maximize", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ArgmaxScoreDistanceTof", "[", 
        RowBox[{"fp", ",", "slope", ",", "S", ",", "d"}], "]"}], ",", 
       RowBox[{"fp", "<=", "1"}], ",", 
       RowBox[{"fp", ">=", "0"}]}], "}"}], ",", 
     RowBox[{"{", "fp", "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.880097158490336*^9, 3.8800971993726254`*^9}, {
   3.8800972479853983`*^9, 3.8800972484014673`*^9}, 3.880104253915414*^9},
 CellLabel->"In[37]:=",ExpressionUUID->"5f6ea1e5-37e0-4f96-b9da-95cf860c4435"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MaxArgmaxScoreDistanceTofp", "[", 
   RowBox[{"slope_", ",", "S_", ",", "d_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Maximize", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ArgmaxScoreDistanceTofp", "[", 
        RowBox[{"fp", ",", "slope", ",", "S", ",", "d"}], "]"}], ",", 
       RowBox[{"fp", "<=", "1"}], ",", 
       RowBox[{"fp", ">=", "0"}]}], "}"}], ",", 
     RowBox[{"{", "fp", "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.880097160624475*^9, 3.880097188596389*^9}, {
   3.880097249849852*^9, 3.88009725018639*^9}, 3.8801042593848658`*^9},
 CellLabel->"In[38]:=",ExpressionUUID->"5ab5835a-d668-405f-96a6-d11bb6d2a0cd"],

Cell[TextData[StyleBox["Tests", "Subsection"]], "Text",
 CellChangeTimes->{{3.880105040039444*^9, 
  3.880105041500415*^9}},ExpressionUUID->"0df795da-6edc-4b20-ab24-\
b87eed5898fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArgmaxScoreDistanceTof", "[", 
   RowBox[{
    RowBox[{"1", "/", "2"}], ",", 
    RowBox[{"1", "/", "3"}], ",", "brierscore", ",", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"#1", "-", "#2"}], "]"}], "&"}]}], "]"}], "==", "0"}]], "Input",\

 CellChangeTimes->{3.88003675768323*^9},
 CellLabel->"In[39]:=",ExpressionUUID->"07cc7bb6-484e-4143-b8ec-967222b20b00"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], "-", 
       RowBox[{"(", 
        RowBox[{"\<\"SearchPoints\"\>", "\[Rule]", "100"}], ")"}]}], ")"}]}], 
    "+", 
    RowBox[{"(", 
     RowBox[{"\<\"SearchPoints\"\>", "\[Rule]", "100"}], ")"}]}], "]"}], 
  "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{
  3.880037072805299*^9, 3.880042976297489*^9, 3.880043853280492*^9, 
   3.880092204394267*^9, 3.88009232280236*^9, 3.8800978985477953`*^9, 
   3.88009813500788*^9, 3.880104370783308*^9, 3.880105467580502*^9, 
   3.88010746378541*^9, 3.880110498983964*^9, 3.880133788744001*^9, 
   3.880183008554659*^9, 3.884983032802721*^9, 3.8852124639033957`*^9, 
   3.88559704924233*^9, {3.8855971004650497`*^9, 3.8855971259942217`*^9}, 
   3.885656991560725*^9, 3.885699386927403*^9, 3.894041467453764*^9, 
   3.8940435646236267`*^9, 3.894046623608738*^9, 3.894047330178926*^9, 
   3.894047445492457*^9, 3.894047477568877*^9, 3.894048097654912*^9, 
   3.894048165912573*^9, 3.8940491201833067`*^9, 3.894061283171022*^9, 
   3.894063592791483*^9, 3.894063650020095*^9, 3.894066779340787*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"1a58a14b-51b1-42c1-b1cb-b2690bedd9b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArgmaxScoreDistanceTofp", "[", 
   RowBox[{
    RowBox[{"1", "/", "2"}], ",", 
    RowBox[{"1", "/", "3"}], ",", "brierscore", ",", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"#1", "-", "#2"}], "]"}], "&"}]}], "]"}], "==", "0"}]], "Input",\

 CellChangeTimes->{{3.879938844553865*^9, 3.879938852012114*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"d2f62066-cafc-4b9e-84c8-87215e036bfb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", 
    RowBox[{"(", 
     RowBox[{"\<\"SearchPoints\"\>", "\[Rule]", "100"}], ")"}]}], "]"}], 
  "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{
  3.880036795789201*^9, 3.880037072855295*^9, 3.880042976331769*^9, 
   3.880043853316413*^9, 3.8800922043993607`*^9, 3.880092322806579*^9, 
   3.880097898552219*^9, 3.8800981350424013`*^9, 3.880104370826356*^9, 
   3.880105467627936*^9, 3.880107463804196*^9, 3.88011049901093*^9, 
   3.880133788766927*^9, 3.880183008557302*^9, 3.8849830335814734`*^9, 
   3.885212463942066*^9, 3.8855970493280773`*^9, {3.885597100567325*^9, 
   3.8855971260861464`*^9}, 3.885656991601235*^9, 3.885699386967247*^9, 
   3.894041467497718*^9, 3.894043564678282*^9, 3.894046623634405*^9, 
   3.894047330426549*^9, 3.894047445558091*^9, 3.894047477636981*^9, 
   3.89404809770544*^9, 3.8940481659531107`*^9, 3.8940491202267513`*^9, 
   3.894061283217787*^9, 3.894063592820263*^9, 3.894063650043672*^9, 
   3.894066779364952*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"cd96dd3a-f8aa-4aef-943b-6962982ce518"]
}, Open  ]],

Cell[TextData[StyleBox["Interactive widgets", "Section"]], "Text",
 CellChangeTimes->{{3.880036410465863*^9, 
  3.8800364134458857`*^9}},ExpressionUUID->"784c042d-7880-4a71-9d31-\
8b71a0f4a9bd"],

Cell[TextData[StyleBox["Brier scoring rule", "Subsection"]], "Text",
 CellChangeTimes->{{3.8800373944376*^9, 
  3.8800373965340776`*^9}},ExpressionUUID->"64fb8b80-51d0-4f71-b796-\
c602995b2803"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"brierscore", "[", 
        RowBox[{"p", ",", 
         RowBox[{"f", "[", 
          RowBox[{"p", ",", "fp", ",", "slope"}], "]"}]}], "]"}], ",", "p", 
       ",", 
       RowBox[{"f", "[", 
        RowBox[{"p", ",", "fp", ",", "slope"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ToExpression", "[", 
         RowBox[{
         "\"\<\\\\mathbf{Brierscore}(p,f(p))\>\"", ",", "TeXForm", ",", 
          "HoldForm"}], "]"}], ",", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<p\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}], ",", 
        RowBox[{"ToExpression", "[", 
         RowBox[{
         "\"\<f(p)=p^*+\\\\alpha(p-p^*)\>\"", ",", "TeXForm", ",", 
          "HoldForm"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "@", "Large"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ArgmaxScore", "[", 
            RowBox[{"fp", ",", "slope", ",", "brierscore"}], "]"}], ",", 
           "0"}], "}"}], "]"}], ",", "Blue", ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"fp", ",", "0"}], "}"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1.0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1.0"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fp", ",", 
       RowBox[{"1", "/", "4"}], ",", 
       RowBox[{"\"\<fixed point \>\"", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<p^*\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}]}]}], 
      "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"slope", ",", 
       RowBox[{"1", "/", "4"}], ",", 
       RowBox[{"\"\<slope \>\"", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<\\\\alpha\>\"", ",", "TeXForm", ",", "HoldForm"}], 
         "]"}]}]}], "}"}], ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.880037368383877*^9, {3.88003751276335*^9, 3.880037537927211*^9}, {
   3.880106999766079*^9, 3.880107025615591*^9}, {3.8849834696466722`*^9, 
   3.884983495595606*^9}, {3.884988407740683*^9, 3.8849884182337*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"eb5e251b-ce5f-40b7-9ffb-99d2eb37f9c6"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`fp$$ = 0.58, $CellContext`slope$$ = 0.368, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`fp$$], 
       Rational[1, 4], "fixed point " HoldForm[
         SuperStar[$CellContext`p]]}, 0, 1}, {{
       Hold[$CellContext`slope$$], 
       Rational[1, 4], "slope " HoldForm[$CellContext`\[Alpha]]}, 0, 1}}, 
    Typeset`size$$ = {513., {113., 118.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`fp$$ = 
        Rational[1, 4], $CellContext`slope$$ = Rational[1, 4]}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[{
         $CellContext`brierscore[$CellContext`p, 
          $CellContext`f[$CellContext`p, $CellContext`fp$$, \
$CellContext`slope$$]], $CellContext`p, 
         $CellContext`f[$CellContext`p, $CellContext`fp$$, \
$CellContext`slope$$]}, {$CellContext`p, 0, 1}, PlotLegends -> {
          ToExpression["\\mathbf{Brierscore}(p,f(p))", TeXForm, HoldForm], 
          ToExpression["p", TeXForm, HoldForm], 
          ToExpression["f(p)=p^*+\\alpha(p-p^*)", TeXForm, HoldForm]}, 
        Epilog -> {Red, 
          PointSize[Large], 
          Point[{
            $CellContext`ArgmaxScore[$CellContext`fp$$, $CellContext`slope$$, \
$CellContext`brierscore], 0}], Blue, 
          Point[{$CellContext`fp$$, 0}]}, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 1.}, {0, 1.}}], 
      "Specifications" :> {{{$CellContext`fp$$, 
          Rational[1, 4], "fixed point " HoldForm[
            SuperStar[$CellContext`p]]}, 0, 1}, {{$CellContext`slope$$, 
          Rational[1, 4], "slope " HoldForm[$CellContext`\[Alpha]]}, 0, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{559., {169.6875, 175.3125}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.880037370130117*^9, {3.8800375134321537`*^9, 3.880037538459505*^9}, 
   3.88004297639627*^9, 3.880043853399459*^9, 3.8800922044411697`*^9, 
   3.880092322827807*^9, 3.880097898583665*^9, 3.880098135204265*^9, 
   3.8801043710693293`*^9, {3.880107013338139*^9, 3.8801070258806133`*^9}, 
   3.8801074639498663`*^9, 3.880110499068425*^9, 3.880133788793232*^9, {
   3.880183008575768*^9, 3.880183020965494*^9}, {3.884983471753337*^9, 
   3.884983497012471*^9}, {3.884988295397645*^9, 3.884988298318763*^9}, 
   3.884988418939334*^9, 3.8852202921683817`*^9, 3.885597049473068*^9, {
   3.885597100764368*^9, 3.885597126300569*^9}, 3.8940414678193913`*^9, 
   3.894043564800613*^9, 3.894046623756728*^9, 3.894047330531502*^9, 
   3.894047445610724*^9, 3.8940474777775497`*^9, 3.894048097938448*^9, 
   3.894048166113452*^9, 3.894049120363267*^9, 3.8940612834010344`*^9, 
   3.8940635928999367`*^9, 3.894063650130888*^9, 3.89406677946028*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"10e1a671-62ec-4faa-bc2d-302abc89e9e5"]
}, Open  ]],

Cell[TextData[StyleBox["Log scoring rule", "Subsection"]], "Text",
 CellChangeTimes->{{3.8800375726306267`*^9, 
  3.8800375851144238`*^9}},ExpressionUUID->"48e7bc31-e9f9-4f52-b6ab-\
87f7c11875ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"logscore", "[", 
        RowBox[{"p", ",", 
         RowBox[{"f", "[", 
          RowBox[{"p", ",", "fp", ",", "slope"}], "]"}]}], "]"}], ",", "p", 
       ",", 
       RowBox[{"f", "[", 
        RowBox[{"p", ",", "fp", ",", "slope"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ToExpression", "[", 
         RowBox[{
         "\"\<\\\\text{Logscore}(p,f(p))\>\"", ",", "TeXForm", ",", 
          "HoldForm"}], "]"}], ",", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<p\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}], ",", 
        RowBox[{"ToExpression", "[", 
         RowBox[{
         "\"\<f(p)=p^*+\\\\alpha(p-p^*)\>\"", ",", "TeXForm", ",", 
          "HoldForm"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "@", "Large"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ArgmaxScore", "[", 
            RowBox[{"fp", ",", "slope", ",", "logscore"}], "]"}], ",", "0"}], 
          "}"}], "]"}], ",", "Blue", ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"fp", ",", "0"}], "}"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<\\\\hat{p}\>\"", ",", "TeXForm", ",", "HoldForm"}], 
             "]"}], ",", "Black", ",", "12"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ArgmaxScore", "[", 
             RowBox[{"fp", ",", "slope", ",", "logscore"}], "]"}], ",", 
            RowBox[{"-", "0.2"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<p^*\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}], 
            ",", "Black", ",", "12"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"fp", ",", 
            RowBox[{"-", "0.2"}]}], "}"}]}], "]"}]}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1.0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.7"}], ",", "1.0"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fp", ",", "0.675", ",", 
       RowBox[{"\"\<fixed point \>\"", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<p^*\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}]}]}], 
      "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"slope", ",", 
       RowBox[{"1", "/", "4"}], ",", 
       RowBox[{"\"\<slope \>\"", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<\\\\alpha\>\"", ",", "TeXForm", ",", "HoldForm"}], 
         "]"}]}]}], "}"}], ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8797019082388783`*^9, 3.879701925356812*^9}, {
   3.879715218963735*^9, 3.879715232014369*^9}, {3.879715270653398*^9, 
   3.8797152746602097`*^9}, {3.879939046399493*^9, 3.879939051329885*^9}, {
   3.880014769015217*^9, 3.880014775539488*^9}, {3.8800148376502533`*^9, 
   3.880015116601303*^9}, {3.8800152018791122`*^9, 3.880015202598628*^9}, {
   3.880015258466865*^9, 3.8800153464990387`*^9}, {3.880015428111053*^9, 
   3.880015688032303*^9}, 3.880015942145351*^9, {3.880016099417323*^9, 
   3.8800161183893557`*^9}, {3.880016409536677*^9, 3.880016441305052*^9}, {
   3.8801051598555517`*^9, 3.8801051613319063`*^9}, {3.880106797471122*^9, 
   3.8801069532964993`*^9}, {3.880183611278473*^9, 3.880183612204771*^9}, {
   3.880183716335432*^9, 3.8801837168442793`*^9}, 3.8849883974184237`*^9},
 CellLabel->"In[42]:=",ExpressionUUID->"e90d5ca6-00ae-4f47-b239-7de6c847be33"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`fp$$ = 0.675, $CellContext`slope$$ = 
    Rational[1, 4], Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`fp$$], 0.675, "fixed point " HoldForm[
         SuperStar[$CellContext`p]]}, 0, 1}, {{
       Hold[$CellContext`slope$$], 
       Rational[1, 4], "slope " HoldForm[$CellContext`\[Alpha]]}, 0, 1}}, 
    Typeset`size$$ = {513., {103., 109.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`fp$$ = 0.675, $CellContext`slope$$ = 
        Rational[1, 4]}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[{
         $CellContext`logscore[$CellContext`p, 
          $CellContext`f[$CellContext`p, $CellContext`fp$$, \
$CellContext`slope$$]], $CellContext`p, 
         $CellContext`f[$CellContext`p, $CellContext`fp$$, \
$CellContext`slope$$]}, {$CellContext`p, 0, 1}, PlotLegends -> {
          ToExpression["\\text{Logscore}(p,f(p))", TeXForm, HoldForm], 
          ToExpression["p", TeXForm, HoldForm], 
          ToExpression["f(p)=p^*+\\alpha(p-p^*)", TeXForm, HoldForm]}, 
        Epilog -> {Red, 
          PointSize[Large], 
          Point[{
            $CellContext`ArgmaxScore[$CellContext`fp$$, $CellContext`slope$$, \
$CellContext`logscore], 0}], Blue, 
          Point[{$CellContext`fp$$, 0}], 
          Text[
           Style[
            ToExpression["\\hat{p}", TeXForm, HoldForm], Black, 12], {
            $CellContext`ArgmaxScore[$CellContext`fp$$, $CellContext`slope$$, \
$CellContext`logscore], -0.2}], 
          Text[
           Style[
            ToExpression["p^*", TeXForm, HoldForm], Black, 
            12], {$CellContext`fp$$, -0.2}]}, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 1.}, {-1.7, 1.}}], 
      "Specifications" :> {{{$CellContext`fp$$, 0.675, "fixed point " HoldForm[
            SuperStar[$CellContext`p]]}, 0, 1}, {{$CellContext`slope$$, 
          Rational[1, 4], "slope " HoldForm[$CellContext`\[Alpha]]}, 0, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{559., {160.1875, 165.8125}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.880037598228531*^9, 3.880042976728652*^9, 3.880043858756184*^9, 
   3.880092204767468*^9, 3.880092322898747*^9, 3.880097898675234*^9, 
   3.880098135917513*^9, 3.880104371913657*^9, 3.8801054676840363`*^9, {
   3.88010681122257*^9, 3.880106888294441*^9}, {3.880106919148437*^9, 
   3.8801069538958817`*^9}, 3.880107467564981*^9, 3.8801105042519827`*^9, 
   3.880133789005436*^9, 3.880183008794353*^9, 3.880183083248415*^9, {
   3.8801836912180862`*^9, 3.880183721412716*^9}, {3.884988393662862*^9, 
   3.884988398224687*^9}, 3.885597050280293*^9, {3.885597101704197*^9, 
   3.8855971280814753`*^9}, 3.8940414692930517`*^9, 3.8940435658590517`*^9, 
   3.894046624921282*^9, 3.894047332287619*^9, 3.89404744637031*^9, 
   3.894047481814702*^9, 3.894048102859309*^9, 3.894048167438789*^9, 
   3.8940491215524397`*^9, 3.894061285733902*^9, 3.894063593750186*^9, 
   3.894063650953721*^9, 3.894066780337515*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"e47b57fb-fac7-4eb4-afda-b8548edeb328"]
}, Open  ]],

Cell[TextData[StyleBox["Plots", "Section"]], "Text",
 CellChangeTimes->{{3.880037183971216*^9, 3.8800371904771957`*^9}, 
   3.894046182341053*^9},ExpressionUUID->"d617e6a8-452b-4cf1-b1bb-\
8d9bc16631e6"],

Cell["\<\
We here give the plots that we created for the paper, \
\[OpenCurlyDoubleQuote]Incentivizing honest performative predictions with \
proper scoring rules\[CloseCurlyDoubleQuote], as well as the following blog \
post: https://www.alignmentforum.org/posts/Aufg88v7mQ2RuEXkS/proper-scoring-\
rules-don-t-guarantee-predicting-fixed-points \
\>", "Text",
 CellChangeTimes->{{3.894045970791978*^9, 3.894045972613483*^9}, {
  3.894046065404213*^9, 3.8940460730310163`*^9}, {3.894046187062435*^9, 
  3.894046269870528*^9}},ExpressionUUID->"7af22a2e-972f-45ad-b68f-\
7223b7a226aa"],

Cell[TextData[StyleBox["Plots of g(p)/g\[CloseCurlyQuote](p)", \
"Subsection"]], "Text",
 CellChangeTimes->{
  3.8801331576658916`*^9},ExpressionUUID->"c59b2030-6468-4ce7-ab55-\
e23cfdb63f82"],

Cell[CellGroupData[{

Cell["Log scoring rule", "Subsubsection",
 CellChangeTimes->{{3.880133084885915*^9, 3.880133086763216*^9}, {
  3.880133225959919*^9, 3.880133241666511*^9}, {3.880133290654881*^9, 
  3.880133292375018*^9}},ExpressionUUID->"1cd56f00-7ed6-497a-8c76-\
112901c831a1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}], " ", "p", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", "p"}], "]"}], "-", 
       RowBox[{"Log", "[", "p", "]"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"p", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<p\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}], "}"}]}],
     ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<g(p)/g'(p)\>\"", ",", "TeXForm", ",", "HoldForm"}], 
         "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"After", ",", "Top"}], "}"}]}], "]"}]}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.880133293704935*^9, 3.8801333950473824`*^9}, {
  3.880133500282277*^9, 3.880133532927165*^9}, {3.880133564073256*^9, 
  3.880133603210862*^9}, {3.880198085166902*^9, 3.880198086999127*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"ad6e303d-f72f-4a31-bd33-4b2a5ace365f"],

Cell[BoxData[
 FrameBox[
  TemplateBox[{
    GraphicsBox[{{{{}, {}, 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwV2Xc8Vf8fB3BK8VXIaBmJKIRURlTeGSGRlWRmRClKViiR0UAZGVnZhIwQ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           "]]}, Annotation[#, "Charting`Private`Tag$10185#1"]& ]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> 
      NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
      AxesLabel -> {
        FormBox[
         TagBox[
          TagBox[
           TagBox["p", HoldForm], HoldForm], HoldForm], TraditionalForm], 
        None}, AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
      Frame -> {{False, False}, {False, False}}, 
      FrameLabel -> {{None, None}, {None, None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{0, 1}, {-0.22387159632004233`, 0.22387153665230325`}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
    FormBox[
     FormBox[
      TemplateBox[{
        FractionBox[
         RowBox[{"g", "(", 
           TagBox["p", HoldForm], ")"}], 
         RowBox[{
           SuperscriptBox["g", "\[Prime]", MultilineFunction -> None], "(", 
           TagBox["p", HoldForm], ")"}]]}, "LineLegend", 
       DisplayFunction -> (FormBox[
         StyleBox[
          StyleBox[
           PaneBox[
            TagBox[
             GridBox[{{
                TagBox[
                 GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                  GridBoxAlignment -> {
                   "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                  AutoDelete -> False, 
                  GridBoxDividers -> {
                   "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
              AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
             "Grid"], Alignment -> Left, AppearanceElements -> None, 
            ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
            "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
          False], TraditionalForm]& ), 
       InterpretationFunction :> (RowBox[{"LineLegend", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{"Directive", "[", 
                RowBox[{
                  RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                  
                  TemplateBox[<|
                   "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                   "RGBColorSwatchTemplate"], ",", 
                  RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
              "}"}], ",", 
            RowBox[{"{", 
              TagBox[#, HoldForm], "}"}], ",", 
            RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
              RowBox[{"{", "}"}]}], ",", 
            RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
       Editable -> True], TraditionalForm], TraditionalForm]},
   "Legended",
   DisplayFunction->(GridBox[{{
       TagBox[
        ItemBox[
         PaneBox[
          TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
          BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
        "SkipImageSizeLevel"], 
       ItemBox[#2, Alignment -> {Inherited, Top}, DefaultBaseStyle -> 
        "LabeledLabel"]}}, 
     GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
     AutoDelete -> False, GridBoxItemSize -> Automatic, 
     BaselinePosition -> {1, 1}]& ),
   Editable->True,
   InterpretationFunction->(RowBox[{"Legended", "[", 
      RowBox[{#, ",", 
        RowBox[{"Placed", "[", 
          RowBox[{#2, ",", 
            RowBox[{"{", 
              RowBox[{"After", ",", "Top"}], "}"}]}], "]"}]}], "]"}]& )],
  StripOnInput->False]], "Output",
 CellChangeTimes->{{3.880133367418507*^9, 3.880133396026454*^9}, {
   3.8801335166373043`*^9, 3.880133603696124*^9}, 3.880133789326013*^9, 
   3.8801830093418493`*^9, 3.880198087517168*^9, 3.885597051444859*^9, {
   3.885597103047688*^9, 3.885597129074024*^9}, 3.894041470394618*^9, 
   3.894043567089815*^9, 3.8940466262181664`*^9, 3.894047334355661*^9, 
   3.894047447575431*^9, 3.8940474831946*^9, 3.8940481041203613`*^9, 
   3.894048168497849*^9, 3.894049122728657*^9, 3.894061286918564*^9, 
   3.894063594729972*^9, 3.89406365176233*^9, 3.894066782269758*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"f3280896-f124-4605-836d-069969fc1dcc"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.880198103682713*^9, 3.880198105571458*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"e02e07c4-230f-419f-8cd1-d25c5d4640c1"],

Cell[TextData[StyleBox["Quadratic scoring rule", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.880133245550479*^9, 
  3.880133248125462*^9}},ExpressionUUID->"2a8bde67-dc47-43b1-8c39-\
46b169494b03"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"p", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<p\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}], "}"}]}],
     ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<g(p)/g'(p)\>\"", ",", "TeXForm", ",", "HoldForm"}], 
         "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"After", ",", "Top"}], "}"}]}], "]"}]}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.880133300990796*^9, 3.880133304826342*^9}, {
  3.880133618431271*^9, 3.8801336250404587`*^9}, {3.8801980789537077`*^9, 
  3.8801980813290873`*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"f8f09b3e-110c-4f70-9715-b8ae31d132a0"],

Cell[BoxData[
 FrameBox[
  TemplateBox[{
    GraphicsBox[{{{{}, {}, 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJw11Xs0lVkfB3DXRZmEXNYpklOMW6gMUc1XMSm3QUQXl1QSGtKZiWbeUEdh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           "]]}, Annotation[#, "Charting`Private`Tag$10412#1"]& ]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> 
      NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
      AxesLabel -> {
        FormBox[
         TagBox[
          TagBox[
           TagBox["p", HoldForm], HoldForm], HoldForm], TraditionalForm], 
        None}, AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
      Frame -> {{False, False}, {False, False}}, 
      FrameLabel -> {{None, None}, {None, None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{0, 1}, {0., 0.49999997959183673`}}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
    FormBox[
     FormBox[
      TemplateBox[{
        FractionBox[
         RowBox[{"g", "(", 
           TagBox["p", HoldForm], ")"}], 
         RowBox[{
           SuperscriptBox["g", "\[Prime]", MultilineFunction -> None], "(", 
           TagBox["p", HoldForm], ")"}]]}, "LineLegend", 
       DisplayFunction -> (FormBox[
         StyleBox[
          StyleBox[
           PaneBox[
            TagBox[
             GridBox[{{
                TagBox[
                 GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                  GridBoxAlignment -> {
                   "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                  AutoDelete -> False, 
                  GridBoxDividers -> {
                   "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
              AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
             "Grid"], Alignment -> Left, AppearanceElements -> None, 
            ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
            "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
          False], TraditionalForm]& ), 
       InterpretationFunction :> (RowBox[{"LineLegend", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{"Directive", "[", 
                RowBox[{
                  RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                  
                  TemplateBox[<|
                   "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                   "RGBColorSwatchTemplate"], ",", 
                  RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
              "}"}], ",", 
            RowBox[{"{", 
              TagBox[#, HoldForm], "}"}], ",", 
            RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
              RowBox[{"{", "}"}]}], ",", 
            RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
       Editable -> True], TraditionalForm], TraditionalForm]},
   "Legended",
   DisplayFunction->(GridBox[{{
       TagBox[
        ItemBox[
         PaneBox[
          TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
          BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
        "SkipImageSizeLevel"], 
       ItemBox[#2, Alignment -> {Inherited, Top}, DefaultBaseStyle -> 
        "LabeledLabel"]}}, 
     GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
     AutoDelete -> False, GridBoxItemSize -> Automatic, 
     BaselinePosition -> {1, 1}]& ),
   Editable->True,
   InterpretationFunction->(RowBox[{"Legended", "[", 
      RowBox[{#, ",", 
        RowBox[{"Placed", "[", 
          RowBox[{#2, ",", 
            RowBox[{"{", 
              RowBox[{"After", ",", "Top"}], "}"}]}], "]"}]}], "]"}]& )],
  StripOnInput->False]], "Output",
 CellChangeTimes->{
  3.880133625398519*^9, 3.880133789417184*^9, 3.880183009452633*^9, 
   3.880198082401339*^9, 3.8855970522522907`*^9, {3.885597103544783*^9, 
   3.885597129404994*^9}, 3.8940414707971992`*^9, 3.894043567349577*^9, 
   3.894046626545879*^9, 3.894047334769957*^9, 3.8940474479243*^9, 
   3.8940474835344973`*^9, 3.894048104491877*^9, 3.894048168845825*^9, 
   3.894049123115183*^9, 3.894061287295854*^9, 3.8940635949947577`*^9, 
   3.89406365202078*^9, 3.894066782528942*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"9c27ce9e-4109-4fb4-ad1c-108a05e64ef0"]
}, Open  ]],

Cell[TextData[StyleBox["Indifference curves", "Subsection"]], "Text",
 CellChangeTimes->{{3.880039052311761*^9, 3.880039056508875*^9}, {
  3.8801332259599524`*^9, 
  3.880133228550776*^9}},ExpressionUUID->"b807a13f-5398-4dbc-90b7-\
a8ed17ddf69c"],

Cell[TextData[StyleBox["Log scoring rule", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.880039162713131*^9, 3.880039164333991*^9}, {
  3.8801332259599733`*^9, 
  3.8801332285508223`*^9}},ExpressionUUID->"ec4ff206-f667-4b0b-8904-\
163a80eba21f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IndifferenceTerm", "[", "probability_", "]"}], ":=", 
  RowBox[{"Last", "@", 
   RowBox[{"Last", "@", 
    RowBox[{"Last", "@", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"logscore", "[", 
        RowBox[{"p", ",", "q"}], "]"}], "==", 
       RowBox[{"logscore", "[", 
        RowBox[{"probability", ",", "probability"}], "]"}]}], 
      "]"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.880033503146843*^9, 3.880033503557777*^9}, {
  3.880133225960059*^9, 3.880133228550968*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"8ea62dc4-df3b-46f2-b371-0c98b10c9fa7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "p_", "]"}], ":=", 
  RowBox[{
   RowBox[{"0.5", "*", "p"}], "+", "0.31"}]}]], "Input",
 CellChangeTimes->{{3.880033503146843*^9, 3.880033503557777*^9}, {
  3.880133225960106*^9, 3.880133228551025*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"3e16d5a2-eb0e-4b0d-b64b-06cae95182ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", 
      RowBox[{"f", "[", "p", "]"}], ",", 
      RowBox[{"IndifferenceTerm", "[", 
       RowBox[{"1", "/", "2"}], "]"}], ",", 
      RowBox[{"IndifferenceTerm", "[", 
       RowBox[{"7", "/", "10"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"IndifferenceTerm", "[", 
       RowBox[{"9", "/", "10"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"IndifferenceTerm", "[", 
       RowBox[{"95", "/", "100"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"p", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"{", 
      RowBox[{"Black", ",", "Red", ",", 
       RowBox[{"Lighter", "[", 
        RowBox[{"Blue", ",", "0.7"}], "]"}], ",", 
       RowBox[{"Lighter", "[", 
        RowBox[{"Blue", ",", "0.4"}], "]"}], ",", "Blue", ",", 
       RowBox[{"Darker", "[", 
        RowBox[{"Blue", ",", "0.4"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ToExpression", "[", 
        RowBox[{"\"\<p\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}], ",", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"\"\<q\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}]}], 
      "}"}]}], ",", 
    RowBox[{"Exclusions", "\[Rule]", 
     RowBox[{"p", "==", 
      RowBox[{"1", "/", "2"}]}]}], ",", 
    RowBox[{"PlotLegends", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ToExpression", "[", 
        RowBox[{"\"\<q=p\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}], ",", 
       
       RowBox[{"ToExpression", "[", 
        RowBox[{"\"\<q=f(p)\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}]}], 
      "}"}]}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.880039114439024*^9, {3.880133225960162*^9, 3.880133228551077*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"1f911638-f534-4f61-95b8-28ab0086170f"],

Cell[BoxData[
 FrameBox[
  TemplateBox[{
    GraphicsBox[{{{{}, {}, 
        TagBox[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           GrayLevel[0]], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQ7ZX64uKBl6F2MJrFWargvqSJPYw2nj9jzmZJFzjt
ffb6prmSIXA6POX73kmSKXD6rn67c69kCZxeIOrf1iXZAqcbOTard0pOgdMR
kQvXf/i4BE5z/2+McZdbD6dVA9+9ONy9BU6Xn7O0n/FlJ5wW3yJ4j5FxP5ze
9sj5zHmbQ3D6UNZc6cg3R+D0VzVb/rW5x+E008/VAtKqp+C02f+EbcHrzsDp
My0m545pnYfT8hNe/1z57gKcfv39/r2rBpfg9JJXu0/x9V2G03yyy98/eXIF
Tvdkbk1boHINTn9zWP0ko/46nC4xOrJF7PANOH1/3ZHui4q34PTvrCuzNatu
w2ltR/Z/abvvwGn3RYrpG8Xvwely2XilhzH34bS9ybX2Y78QNABzQQHj
           "]], 
          LineBox[CompressedData["
1:eJxFxVkow3EcAPBtJleObV7I0ZhybST3HpTkHGVWHjAaSsj9QBGTv5ZoHpZz
zrEcMWIl/o4kRckxQs0wzDlHGVEMD37fh08fuqCYm0siEAisX3+fX9njUtJZ
xP8022fztU+YvNytcJeeowsCF44tErTo8ThB/9IbbLh3tNO1XaCVKTEmkqhL
dG0s1jerg+kn8Ucy7AodHtIgcQjQodNdtj+IKtiw2aItEV6jO8j8Ci7jBk3T
KAdJa7BpjZAXVnqLJozyFVrqHbqsS9FCXYUXfUTmlKJ7NCW+zLfe5gGtZu6o
qnB4qjeCccnXozMUwRTnb7gOGxCqxx7REzfO3TacJ7SoB8vSJME5XL3HZDLs
hONTialwkzhtvVkA5wV3vlhWwW4N9rFmcvg7tNr6cAQ+1l/sycfh1tSZjOhp
2OjNLcdwWL0r7jVRwXON79mqA1jCzvSSHcEJw6zZSA08X7m1IbyF25hB4uQH
uFQr5dGfYE9O4enKK0wm7g+1vsNnSnZ+1ieM58v8/L/gdlcrg9EI/wCBkISb

           "]]}, Annotation[#, "Charting`Private`Tag$10753#1"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[1, 0, 0]], 
          LineBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAASmXo0cDpVT5AhGVICtfTPwRDGnDf
GTQ/H6deeY3Z0z8zn5icsxlEP//JV6oQ3NM/S83Xsp0ZVD++D0oMF+HTP1dk
972SGWQ/O5su0CPr0z/dL4dDjRl0Pzey91c9/9M/oBVPhooZhD8u4IlncCfU
P4EIsyeJGZQ/GzyuhtZ31D9YWaGv8PGkP2y5akgpJtU/C/+BXEcerz/Iwziz
7sjVPyVR7ujDi7Q//G2OuoJo1j93zjk/mPS5P6bdV0WdFdc/F7QR3gEBvz9a
2jJ5KrfXP7biQ8zPPMI/hJyBMD5m2D/Cap0bWezEP4j+V4QgEtk/9SY9D61t
xz+U7T+BdbLZPwL5qxAbJco/GKKbAVFg2j82/2C2U67MP6TjCCufAts/zIQ0
zsYqzz8Kxf3wu6HbPx+Q6/mp7tA/5mtmOl9O3D/r99/e1TDSP8yf4Cx179w/
pOq7yg6O0z8pmc6iEZ7dPw4dp+/k5NQ/XjJEtXxJ3j+MabVmoCTWP51Yy3Ba
6d4/9kCr5Gh/1z9SRMavvpbfP3QyxLQWw9g/iF7py0oc4D/frsSL0SHaP6N9
qYH5c+A/+2rUmyl62z+qbK2FD8rgPytBB/5mu9w/NiI63l4a4T9HoiFnsRfe
P326gHhxceE/dx1fIuFc3z9JGVBnvcLhPz801ofG+t8/+96twDbq4T9GtgSN

           "]], 
          LineBox[CompressedData["
1:eJwVyn1MzHEAx/FTSWqiJ1uROmL0pIzyMPu0ZpVUmyuLRSUPteSnQotlnHXt
ND2RIikqeYguUx7P00nErDhy2vVwT7/7fevON/RAj/LHe+9/XvyEQ4J9Jjwe
z3u6/1fp7KXlJr1QNsuy5AYV7OYOWDSP9uLoDp8l+iQ1zF5cliwpV4HxzRku
eazGgdVPv8/eogbfcMHK0kaDus0JV58Pq/EqgzDa/RoM9TvNY0s0YN++Wfbn
gQZNkcGmxZu0aBmLcW2bo8XJEFFlI6uFx/BxpidWC35XqKJapEPWyy7L6Hot
1vtnFzuuYiE+OMoVmemwc1Hb3xlyFk6qygXm23QYep+nThXqsd9/qmDjHR0u
msUeEbhxWBul314/oYNdd1OVSTOHoQC71JxwFjNPCKPWpREw8/6+49ew4N2K
laht+5BSm5gxPMgivUySZyvrg5tL4b78MD2eeYgtbJh+vE8cr8qr0sMmNN3z
tLUBgxk/V7f80kPp1S4/JjWgM+mqhWwzh4YKuGljjdjEV/iMlHHYJfGzcZ40
ouxW5I3zfRxOia4Jlbd/4I79mbjfAQR3OefL1mEUgUHBKWeLCMRXRPHdERQN
rmMRg+cI9gqMS+u3Uiwaq/fdWUywUCptCI+mGJXMH/EoJcgtiGk5mzDtHVnh
h3KCJL9LPy2PUbgas0stbxIszrYPmVVLMX5eJhM/J5hcmzXn202KZCbj+sAL
gu9GzefaOgpFiLt4+yuCwuj7u4LuUTROFIUvbyaYchccFkkpDiTuVrxtJVB+
KqgwlVN0ruf9MP9K8ChnZI/8K0WIQ2M700FQvCFuRbWC4gFNvN/xjWDLde/G
wG6Kopq2zNpOgieZH1uFZNpbV5oG9RKUeK0p2GqY9pyAvasiSFOXR/Ephdtr
81YHDcHysJSel4MUvEwmX6cjMJvxpaZwhIIRLE4L1xP0Nm1Ijh+lUHp2RDZx
BNLk6pU+ExShs3L9nPsISl2shqamKB6qNjqK+gn+Ab/ojbE=
           "]]}, Annotation[#, "Charting`Private`Tag$10753#2"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0.7, 0.7, 1.]], 
          LineBox[CompressedData["
1:eJwdxX040wkAB3B01S49va/a0JqXUSc5b9WT7ntu3eMedUqWDBfy0lFeiolW
SufllLy1Nhcd7aaks168p2zsZ7QsL01imOumKHEcpwh3z/3xeT70IxEHgvR0
dHRc/vP/QYNt0qGDX21PaXEhlojwGZMaqaHYoWbAco3h+3LY5ufklVJ2IzJE
YFP8oRJaQ9OEUwxXuC4wpul5VWOPsvPBdQoLx2e4tv1hD2GaZlQ4T2PD/FWz
K41Vg08uAQJ/xmHEsPeL1QaP8DZRRfjz/THNPlSWpnyEQ4FTj7MpgeBM/jnK
CX8MgkmtlOUFo+TJ03QDvVpYm+y6N0ELwW6bqLCpi7Ugvbog9GCEI8pfPW7y
kwQP+9uVMlYkuFSpfGBCgsj9gS4+/BPQn/oUcMZait6tKczLlGjMCgs9Pa9K
wctfLzXz5sCErKwTE1K4LC92rM2LAWO5XLtzXIqKkWb7UVocNj4Jncz/rg7p
Jass3BjxMF6tjZ8eqMO3RiLR0NFzqGapDt5cUo94+bUVdazzoJzZnxBsVQ87
B8vLbH4CUp5bXPCNqkcBeV/yRUoiBFG09osT9eAqBYTHw0QcmA4qclwtg0dS
v56JdxIqNq596v2lDEsnT5yryUsGpbgibu6YDLEqXuwwLRVj78cV59UyuF3p
DnVlpCNBLzgm9xYByz0mt6mN6eDws4kCCQHSguNvXh/NwPSWLH3vTgK+1XP3
JaxM7LQlRX9Y2ADypkwrT34WDvvau5H9GpBAKjVPpfAgpq7Jjf1cjs3OWT8/
iOQhq2q67QRNjvakiCF1Iw/9Gd/729nLYbrA8o5VzFVQTq7gGPjJIZ8VWana
+WDo+sYKSuVY+jffnpb2CwZTsGfvgUbk9J5mls/9CjYn3loT3QQnQ7ao72A+
Kunj46TkJrz12raQVJIPzs2RmXWCJmwYjgso2VKAuI1rGt9UNSEixMFMp6cA
HcI6pddME1YF3i0q3C5E7Y77GOI+gSf7xt2/xkQIb3XPmA9TYFTNWiKkFoJN
BO3lcRVIPkwKcmcWQrPNrYuaqkBpQAS1gleILZeHyHO/KbAsfFcSd9tNWHcv
bqV3KdBwoctr0dlbEK7399J1egqb31cuMiQVw+OH2zlkUjP05xN8nDfcRWWS
xuJSnBJmbiODsktl+NgQ2DX2qQWnnu1AzkQ1yPTBd6Y2bVhXtrJPV1eCzFW2
sjqHdlS8Yja3ONaDaFUYWDs+R33odQP2MIFactIhkaUKk4xdy0vCGiGpOitO
1u2A3sc7KwzMFCgKdZfu6+uAw7xfhbu4Gdec6eU3RC/QnGj3TL65BZ3exrIx
v07QMt99vD3Sit3HjnDjzV/i3ZSmr8O6Hc8EV/Itel5C9LZGsSz9Ob6Jyzav
ze3CMqNbo1qtCteKrr+xZHUjLaQ8uMD0BcSjxvbHZ7vxz9d3tD+e64TWySOR
80CNaBuibK3sJXbQN9lHsXugEROX2ujdkKSajd5Y2ouZUFXuptNqlA9UVxnX
9OILp8VzwTU9WHRm4uQHnz44C+lH76/rQ/y90IJSfQ1OGfka/+GjQVHm660R
Yg1g9yJFPq3BMHWQGTCrwb+IHUEj
           "]], 
          LineBox[CompressedData["
1:eJwVkn0w1HkAxtfSESEvUxPKJIkrL9N1pYyeptTJui4vneqwqJz3wqUUh8Lp
pqJLupCTrSR1m8lLoUjYq8jLJpK0Fmt/+9v9fVcXW4Tb++OZ549n5vPMM/Ms
DznsfYjNYrF+UOt/Hxo1rS9ki8Ae1wvcpSGCiaFSp3lKhCZJoVlCsghaDQX8
FYVDeFIX5h75UoTIdXVv5nPEUD4oLcuyGUL5zpDix5NiaCp3CC8mD2GCNlso
yRuGkp979lDHEKp8vtPMdRtBNGex7qytGCnuGX9VSkawuKVNUJQsxvJ3Hn28
jFHY8b95VNElxqYN6blL1krQr+raGuowDP9lHZ81hBJcmJ+TkJk5jInn58RH
0sbAOn6ibZV0GH9qBf7ibS2FOXOiu2T7CEwGq0rYzVKEPQ8Y7+WNYF5ymu/G
WArmL5YgWn8UrLJAvthYhuHdLwIE8aOIy+efM26SwSVEs6FhbBSPVmfpGMXQ
aB+s26vkSmDkEbfmlIEc/g6Ksg29EgzYdwoT6+Xo2xnBaw4Zw70iWI8EKqBZ
1NZj8WEMAfz1RktnFaBGXEVhOVJU7/9k0MliINQbsOVclMLgq9oFpzUZRKa6
xTvmSdHo76pD6TBI7Cy1nC2QwkrXba7ShMGdf9r3VZZKITnopfC0Y2AmMC3N
apAixizqWZIvgwr22liVUorWFnuBox8Dk+LzTtYfpbCMJc3ifQy2LYi57aOS
olMQ1+jOZfCi/yxdOyPF2qOJNaYRDI6LU0+W61JQdWTeuJPCYF1wma7FSgqp
GdfSBm4zWGUp80/2p6B/TNsj+C6DjSnXfHu4FPLDoo0lfHWfxoMmpwMU7nM2
8kglA/OWUw4fwilIjLqa2Q0MUlZ/yio+RoFTxNKxEzK4y+7dUn2RwqIa7vmj
0wycl02ftu+gwLvV8uPUDINrm73WGAopOOWvtkxhEVhpBe2YfE1hZ7KKnzWP
ACWb1/QMUkjalt1VYEhwq3Uyoo+hIO54bNq0giASX+IXLJThrnRpgYEnwbK+
+7pme2XIupoRNLiLoFz/LTchQIaD3oqVf3sRXOU/Pfw+RAaL+vp73/up+3qv
27yJluH37J9az4YQ1M6Flx9NlyFs/ZVx3UQCW0Uc9bBSBjeaVdN/kkB1od59
UZ0MlsVhSbd/JbiSXpfy2xMZXs931vZIJ4iofH6p/KUM29+9tjiTTfCzq9TK
RCaDVbqpu/ZNAkMfrhvXhsasc5J+7y01z+LZuTMONN4ohrtvlhM47nbQHlxP
I8fvfsCOCgLjI9Pxhu405r72js+oJ/Bj+4VKo2j0v3/ovKeBIIXjFFKTQKM6
d/msdRNBaMm/f7Sl0oiZVWY1C9S87cXpoks0BrqyizSFBHbKg8FpzTQeZKoO
CHsIvgjaX3l30ch14drx+gg0o1hl1YM0jihbmbi3BNzJ/NAGOQ3ODYfKrYME
GZypotPTNGz25yUaD6n3NXZvstSTg204u1k8TOBidYJbZS5H7fH2Z2kUQXL3
0xu5W+TIs/8220tO0GnwmY7YI0esuNB3OSEIfxp8LzxKDs/LWmbj4wRlYpp2
zZTD1jPqfeNHdR5EKmZ4cmhpvLqeoyIoXVyvfUUgh6jKJSJoioC/ZduI9YQc
9RE8R6cZgi7WEm6qswKXLfUm5uYI9D561/mof/kf8Uua4Q==
           "]]}, Annotation[#, "Charting`Private`Tag$10753#3"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0.4, 0.4, 1.]], 
          LineBox[CompressedData["
1:eJwt13k0Ve3bB3BTkVTSYE4hDYRKlOkrNJOSsUGpEE9lyJg0CI+SoZIUoiKR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           "]], 
          LineBox[CompressedData["
1:eJwd13lYDt/7B/AktKiULUR2rbaSkN5KKiUqJZVSCUmLNgmptBES0oeKJEIi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           "]]}, Annotation[#, "Charting`Private`Tag$10753#4"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1]], 
          LineBox[CompressedData["
1:eJwt1nc4Vv//B3ApUbZQRBqkIStRomehhJaVjKSsIqPIKBJSyh7JTGVku923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           "]], 
          LineBox[CompressedData["
1:eJwd13k4VV3bAPBDiiQiqUSGJIQ0iIbHXRkiJEo0EELymiohhXhSikZFUZql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           "]]}, Annotation[#, "Charting`Private`Tag$10753#5"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0., 0., 0.6]], 
          LineBox[CompressedData["
1:eJwtlgk0lWv7xjUcIV/KoZCiwklH2imkcBUZUqkMsVPimELKlGM4yCxDmYfa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           "]], 
          LineBox[CompressedData["
1:eJwd1gk01dsXB3Cp3BRJJKQkMmVq8miwU/JSUrxKhQwRT8qUzEJlKtFAKEOJ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           "]]}, 
         Annotation[#, "Charting`Private`Tag$10753#6"]& ], {}}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{0, 0}, {0, 0}}, PlotRangeClipping -> True, 
      ImagePadding -> All, DisplayFunction -> Identity, AspectRatio -> 
      NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
      AxesLabel -> {
        FormBox[
         TagBox[
          TagBox[
           TagBox["p", HoldForm], HoldForm], HoldForm], TraditionalForm], 
        FormBox[
         TagBox[
          TagBox["q", HoldForm], HoldForm], TraditionalForm]}, 
      AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
      Frame -> {{False, False}, {False, False}}, 
      FrameLabel -> {{None, None}, {None, None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {{0., 1.}, {0., 1.}}, 
      PlotRangeClipping -> True, 
      PlotRangePadding -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      Ticks -> {Automatic, Automatic}}], 
    FormBox[
     FormBox[
      TemplateBox[{
        RowBox[{"q", "\[LongEqual]", 
          TagBox["p", HoldForm]}], 
        RowBox[{"q", "\[LongEqual]", 
          RowBox[{"f", "(", 
            TagBox["p", HoldForm], ")"}]}]}, "LineLegend", 
       DisplayFunction -> (FormBox[
         StyleBox[
          StyleBox[
           PaneBox[
            TagBox[
             GridBox[{{
                TagBox[
                 GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                  GridBoxAlignment -> {
                   "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                  AutoDelete -> False, 
                  GridBoxDividers -> {
                   "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
              AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
             "Grid"], Alignment -> Left, AppearanceElements -> None, 
            ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
            "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
          False], TraditionalForm]& ), 
       InterpretationFunction :> (RowBox[{"LineLegend", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{"Directive", "[", 
                  RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"]}], "]"}], ",", 
                RowBox[{"Directive", "[", 
                  RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    
                    TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
                RowBox[{"Directive", "[", 
                  RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    
                    TemplateBox[<|"color" -> RGBColor[0.7, 0.7, 1.]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
                RowBox[{"Directive", "[", 
                  RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    
                    TemplateBox[<|"color" -> RGBColor[0.4, 0.4, 1.]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
                RowBox[{"Directive", "[", 
                  RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    
                    TemplateBox[<|"color" -> RGBColor[0, 0, 1]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
                RowBox[{"Directive", "[", 
                  RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    
                    TemplateBox[<|"color" -> RGBColor[0., 0., 0.6]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[#, HoldForm], ",", 
                TagBox[#2, HoldForm]}], "}"}], ",", 
            RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
              RowBox[{"{", "}"}]}], ",", 
            RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
       Editable -> True], TraditionalForm], TraditionalForm]},
   "Legended",
   DisplayFunction->(GridBox[{{
       TagBox[
        ItemBox[
         PaneBox[
          TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
          BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
        "SkipImageSizeLevel"], 
       ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
     GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
     AutoDelete -> False, GridBoxItemSize -> Automatic, 
     BaselinePosition -> {1, 1}]& ),
   Editable->True,
   InterpretationFunction->(RowBox[{"Legended", "[", 
      RowBox[{#, ",", 
        RowBox[{"Placed", "[", 
          RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )],
  StripOnInput->False]], "Output",
 CellChangeTimes->{
  3.880039697405306*^9, 3.880042978275816*^9, 3.8800438602466173`*^9, 
   3.88009220546231*^9, 3.880092323353788*^9, 3.880097899222363*^9, 
   3.880098137538892*^9, 3.880104373631682*^9, 3.880107468630933*^9, 
   3.880110505195333*^9, {3.880133225960237*^9, 3.880133228551173*^9}, 
   3.880133789888616*^9, 3.8801830098336687`*^9, 3.88559705343079*^9, {
   3.88559710466483*^9, 3.885597130112644*^9}, 3.894041471706458*^9, 
   3.894043568118128*^9, 3.894046627122368*^9, 3.8940473358611603`*^9, 
   3.8940474488360853`*^9, 3.894047484464993*^9, 3.894048105683135*^9, 
   3.894048169713336*^9, 3.8940491240731583`*^9, 3.894061288142991*^9, 
   3.894063595577757*^9, 3.8940636527497187`*^9, 3.894066783135041*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"993df930-0a7d-47b0-be3a-15cb33793ef5"]
}, Open  ]],

Cell[TextData[StyleBox["Exponential scoring rule", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.880039205891036*^9, 3.88003920871487*^9}, {
  3.880133225960265*^9, 
  3.8801332285512123`*^9}},ExpressionUUID->"dd849bbb-f95f-4914-9e44-\
db7db9ce8124"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IndifferenceFunction", "[", 
   RowBox[{"K_", ",", "p_", ",", "probability_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "K"}], "*", " ", "p"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"probability", "*", "K"}]], "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"K", " ", "p"}]], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"K", " ", "p"}]], " ", "K", " ", "p"}]}], ")"}]}], 
   "K"]}]], "Input",
 CellChangeTimes->{{3.880033446737184*^9, 3.8800334828811207`*^9}, 
   3.880039234806074*^9, {3.880133225960483*^9, 3.8801332285513277`*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"05d73897-384d-409f-8078-b4a4be91bb42"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"IndifferenceFunction", "[", 
        RowBox[{"K", ",", "p", ",", 
         RowBox[{"1", "/", "10"}]}], "]"}], ",", 
       RowBox[{"IndifferenceFunction", "[", 
        RowBox[{"K", ",", "p", ",", 
         RowBox[{"3", "/", "10"}]}], "]"}], ",", 
       RowBox[{"IndifferenceFunction", "[", 
        RowBox[{"K", ",", "p", ",", 
         RowBox[{"1", "/", "2"}]}], "]"}], ",", 
       RowBox[{"IndifferenceFunction", "[", 
        RowBox[{"K", ",", "p", ",", 
         RowBox[{"7", "/", "10"}]}], "]"}], ",", 
       RowBox[{"IndifferenceFunction", "[", 
        RowBox[{"K", ",", "p", ",", 
         RowBox[{"9", "/", "10"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"Lighter", "[", 
         RowBox[{"Blue", ",", "0.7"}], "]"}], ",", 
        RowBox[{"Lighter", "[", 
         RowBox[{"Blue", ",", "0.35"}], "]"}], ",", "Blue", ",", 
        RowBox[{"Darker", "[", 
         RowBox[{"Blue", ",", "0.35"}], "]"}], ",", 
        RowBox[{"Darker", "[", 
         RowBox[{"Blue", ",", "0.7"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotLegends", "->", 
      RowBox[{"{", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"\"\<q=p\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}], 
       "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<p\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}], ",", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<q\>\"", ",", "TeXForm", ",", "HoldForm"}], "]"}]}], 
       "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"K", ",", "1", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8800334590050488`*^9, 3.880033465716267*^9}, 
   3.880040270273139*^9, 3.880107242110628*^9, {3.880133225960567*^9, 
   3.880133228551434*^9}, {3.8801996720568523`*^9, 3.88019970787177*^9}, {
   3.8801997781620197`*^9, 3.8801997785035543`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"88f9e28e-5067-406d-b577-d0ec3767c836"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{K$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[K$$], 1, 100}}, Typeset`size$$ = {434., {117., 122.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {K$$ = 1}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[{$CellContext`p, 
         $CellContext`IndifferenceFunction[K$$, $CellContext`p, 1/10], 
         $CellContext`IndifferenceFunction[K$$, $CellContext`p, 3/10], 
         $CellContext`IndifferenceFunction[K$$, $CellContext`p, 1/2], 
         $CellContext`IndifferenceFunction[K$$, $CellContext`p, 7/10], 
         $CellContext`IndifferenceFunction[
         K$$, $CellContext`p, 9/10]}, {$CellContext`p, 0, 1}, 
        PlotRange -> {{0, 1}, {0, 1}}, PlotStyle -> {Black, 
          Lighter[Blue, 0.7], 
          Lighter[Blue, 0.35], Blue, 
          Darker[Blue, 0.35], 
          Darker[Blue, 0.7]}, PlotLegends -> {
          ToExpression["q=p", TeXForm, HoldForm]}, AxesLabel -> {
          ToExpression["p", TeXForm, HoldForm], 
          ToExpression["q", TeXForm, HoldForm]}], 
      "Specifications" :> {{K$$, 1, 100}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{480., {161.1875, 166.8125}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.8800396978625727`*^9, 3.880040914588435*^9, 3.88004297837506*^9, 
   3.8800438603190937`*^9, 3.880092205496969*^9, 3.880092323378971*^9, 
   3.880097899249364*^9, 3.880098137640099*^9, 3.8801043737675343`*^9, 
   3.88010724258454*^9, 3.880107468774048*^9, 3.880110505292335*^9, {
   3.880132989993692*^9, 3.880132999433979*^9}, {3.880133225960683*^9, 
   3.880133228551496*^9}, 3.880133789921381*^9, 3.8801349783696136`*^9, 
   3.880183009875608*^9, 3.880183047615244*^9, {3.880199664337207*^9, 
   3.8801997082437563`*^9}, 3.880199779754034*^9, 3.884985384761635*^9, 
   3.884988470171076*^9, 3.8855970536324043`*^9, {3.885597104942306*^9, 
   3.885597130238048*^9}, 3.894041471887178*^9, 3.894043568202812*^9, 
   3.8940466272459583`*^9, 3.894047336009132*^9, 3.894047448912674*^9, 
   3.894047484633287*^9, 3.894048105792441*^9, 3.8940481698551188`*^9, 
   3.8940491242238913`*^9, 3.894061288286725*^9, 3.8940635956875467`*^9, 
   3.894063652858386*^9, 3.894066783226727*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"35a3f969-ed13-47f0-a154-a7504661d3fe"]
}, Open  ]],

Cell[TextData[StyleBox["Inaccuracy as a function of the slope", \
"Subsection"]], "Text",
 CellChangeTimes->{{3.880039415255146*^9, 3.880039433524014*^9}, {
  3.880133225960705*^9, 
  3.88013322855153*^9}},ExpressionUUID->"34809b54-5249-434e-b864-\
91857387e807"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", "2", "]"}], "*", 
       RowBox[{"MaxArgmaxScoreDistanceTof", "[", 
        RowBox[{"slope", ",", "brierscore", ",", "L1Distance"}], "]"}]}], ",", 
      RowBox[{"BrierBoundf", "[", "slope", "]"}], ",", 
      RowBox[{
       RowBox[{"Sqrt", "[", "2", "]"}], "*", 
       RowBox[{"MaxArgmaxScoreDistanceTofp", "[", 
        RowBox[{"slope", ",", "brierscore", ",", "L1Distance"}], "]"}]}], ",", 
      RowBox[{"BrierBoundfp", "[", "slope", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"slope", ",", "0", ",", "0.95"}], "}"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "2"}], ",", 
    RowBox[{"MaxRecursion", "\[Rule]", "8"}], ",", 
    RowBox[{"PlotLegends", "->", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Inaccuracy, empirical\>\"", ",", " ", "\"\<Inaccuracy, bound\>\"", 
       " ", ",", " ", "\"\<Distance to FP, empirical\>\"", " ", ",", 
       "\"\<Distance to FP, bound\>\""}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Slope of f\>\"", ",", "\"\<L2 Distance\>\""}], "}"}]}], 
    ",", 
    RowBox[{"PlotLabel", "->", "\"\<Quadratic Score\>\""}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.8"}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8800927270750837`*^9, 3.88009272853683*^9}, {
   3.8800958635103827`*^9, 3.880095863586343*^9}, {3.880097099168458*^9, 
   3.880097099310142*^9}, {3.880097268101241*^9, 3.8800972682632093`*^9}, {
   3.880133225960747*^9, 3.880133228551593*^9}, {3.880133857775721*^9, 
   3.880133963930002*^9}, {3.8801340103361588`*^9, 3.880134010812508*^9}, {
   3.880183421946733*^9, 3.8801834225100317`*^9}, {3.880183487213911*^9, 
   3.8801834904555273`*^9}, 3.884985719690777*^9, {3.8849857555814037`*^9, 
   3.8849857582601957`*^9}, {3.8849857997468033`*^9, 3.88498580338023*^9}, {
   3.884985836345984*^9, 3.884985841365329*^9}, {3.884985935919903*^9, 
   3.884985938225848*^9}, 3.884986081862337*^9, {3.884986379082592*^9, 
   3.884986383142823*^9}, {3.884987709266121*^9, 3.8849877125942287`*^9}, {
   3.884987775465023*^9, 3.884987839946474*^9}, {3.88498810219713*^9, 
   3.884988116601625*^9}, {3.884989390659676*^9, 3.8849893907600193`*^9}, {
   3.88559702825141*^9, 3.885597030165316*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"7e58d521-819f-4c32-96ca-4850f84fb715"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwdxQ040wkAx/H14jovJ5Wu1hCniDKxTh3Oj0jdimrnpZUut7Y/uacV0kXZ
qGfuKnXJeZlaXV4riUsvD81LPQozGnvRy+wFD9I4j0rlaruX7/N8nq8T6wCD
M5NEIm36139fbtO86KCuOsCbbW0Zdqo84ICWmRgbz4W7b8sNVgYHXKdn+3+M
48Fz3VvmTX4KuA8XG/TEWfy629Ungi/A+Pl1K4uJS8jts3F05eeBerSNfpy4
CXLN9hwbfhnCD5zbmUQ0Yr3RL9KMfwc/7DvESiC6sCzuZYWJ9wgGib1hlq4L
vmHE+b8Vj5C6qjVFxHyCmMW2R965P4bkXXZIvIsMoWEW9L9UjzFUr42+QO5G
4eTrEQ21DXZBAt4MkhwsjzSfRo0Ep8JkHZ1SFfL3hOwOWCrDdmPpuSLzXmQ1
srf402VYXJ0aGRfai68Di0N8U2Qot3HWkpp7sbGvycOnQ4YH8pRJWu1TrF7/
7pPHz914z6SQi4TPUVNZLbJ/0oMmi4k+QvUc/Z27cinTPci631JMW/ACxUX5
v5CXy2Frz13Vmf0CvNqlxMKjcnjqmkHKUKOOTff5wlWBqXN5szvFatzgrvG0
ZCggDkpoF35QI8D/0grzdAXoJQu+pyX3oWXaYY6ZXAHi/zSgU4p0H3lKeCzy
W0kr0WBrIl85fU2JN61zJ0xaDfr2f9vyXqFE/ZHB21I7LVStTQ1TJiUy3epS
hUwt2Eck5W/cVdj0/EwAka9FtAOpfDJSBevTrFk0uRai7xyLJjJUGBVRBk1z
dJj82BAQnqdC+JQglHDRIWpQRN+WoMKt8Imr0hAdwq+nRzGgwsKKnZa0vTpc
zdzNirBVQR3tKTNd1sHN3T5tR6MSCXVPmUKyHhXpF6/Fzleia16w2LRWj58Y
x+6whhXwSqhyIKL0yHGJecAWK/B+yfEB71w9nGSUZ/GEAoJjK/dLrfoR43zh
88R6Of4AL8Nk6seKdmFcJqsHswtH+jkOAxgUpSafWNuDuAnGBqn/AMKSmHyB
VQ+oV1wthKkDmGFHLjh5txvimd253q8HcJlb+DjHohu9j5wrOEODcHKjbg7h
PIH1lvbODukQLJpXtArMJEgqpa32fjWEtH0jmpPV7VB+FJ0vNB+Gev7VqTPM
dlysSormhA7jIcfVJb+qDe5z7fTGpmEctHQRlEe2YkMP941X7QjGopyDW8ta
cGyHLaVQOIqyF368edmN0NXw0o33RpFBvV9F1jUg2Pyllq0aRWymb5/TmgZY
1DeUei14hQ0u3/h7q++jkBJH7ch+hcQkn2nGqjrUauqCjHwDdpp7Hf5dWosv
1y4rZV8yIDSmpuyiYy3Sfjv7WYfYgIXVnsrSQ7cQGLi3o+CDAb0R1DV37P5E
1xWrSK/kMVwIjB6sfHYD3tOH7xXkjMFvKDJYnFmJPIaebKwew5XTEcVSt+uI
mXVXIzGMIbl3e+xYagWadzkGeVmOY376tqZPTuVwvn2qpMBtHPKvtjpYS0qR
ZfXWzLhxHJVtYekOSSUYZe+JZxPj2MzdoqYuKcY/6zw1EA==
          "]]}, Annotation[#, "Charting`Private`Tag$14661#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAJRDAF3Dgrz5IZA4LTYqmPm/fWXFg
aG4/IFXmtGKAZT9uIdltYWd+P6z8fWKuf3U/bsIY7OFmjj9z0Ek5VH+FP+6S
OCuiZp4/VrqvJCd/lT8ue8hKgmauP0ivYpoQf6U/Tm+QWnJmvj/AKTxVBX+1
P15pdGJqZs4//eaosv9+xT9mZmZmZmbeP5tFX+H8ftU/LRc7KzOj3j/kcH/V
+qnVP/THD/D/394/LJyfyfjU1T+BKbl5mVnfP73y37H0KtY/TvaFRmYm4D/e
n2CC7NbWP2q52FmZGeE/IvphI9wu2D+gP36A///iP6iuZGW73to/DkzJzcvM
5j/cC7X0PB/gP3KkMzAy6+Y/gCHF7rs04D/V/J2SmAnnPyQ31eg6SuA/nK1y
V2VG5z9tYvXcOHXgPyoPHOH+v+c//rg1xTTL4D9F0m70MbPoPx9mtpUsd+E/
fFgUG5iZ6j9jwLc2HM/iP+Cwfn3+t+o/CNbHMJvk4j9DCenfZNbqP6vr1yoa
+uI/Crq9pDET6z/0FvgeGCXjP5gbZy7LjOs/hW04BxR74z+z3rlB/n/sP6ca
udcLJ+Q/FjckpGSe7D9KMMnRijzkP3qPjgbLvOw/70XZywlS5D9AQGPLl/ns
Pzdx+b8HfeQ/zqEMVTFz7T/IxzmoA9PkPzL6dreXke0/bd1JooLo5D+VUuEZ
/q/tPxHzWZwB/uQ/XAO23srs7T9ZHnqQ/yjlP8BbIEExC+4//jOKin4+5T8j
tIqjlynuP6JJmoT9U+U/hgz1Bf5H7j9GX6p+fGnlP+pkX2hkZu4/6nS6ePt+
5T/NxDqA
          "]]}, Annotation[#, "Charting`Private`Tag$14661#2"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwtzntMUwcYBfCr4kQEB0pSOjQLA+sDX2vdgpFxRAw6wmMoG3YmDglcHpFX
AaWOsUqCWxhdfAy0aIEwQUaGDGSToqyFgkW4VPAi0FJ7L3jbMYIEZZu1UTs3
+iUnJ79/Tj6/xKxDyUsJgvjgTf7rDZ4aXjbbHNJUHiOJLq0PyWLEOQmpmeg0
8Bq4H5KR6WfIOJ5ShDCvastoQz4yu31mJ8nvEc/tjAl9UIK5C0GBtWQVhi+e
cP12YwW2f9kXUUzegBe/90y2sR6txK2gPMEvMJ0UzbUlNECvXRl5nd+CyKY1
C2tnfoJLRLPEg7gJhtPYDrzVBMlndrWB+g2xuXGu+tYWRGed+1xC/o4/KrLj
zie1I034OKNOrIbSP8o8v0+Fbnvl3hMCDc5Of7hkl38HzJ1PDlfzu6B67+Or
X/15G977L55eTmjRUnUh64FcjeJPzLph6i42U7Xvdiu1OJaWl5hO6jFRLozw
eJ/CbP/62WWsHjfunA5r7KUg3arLV4rvwzthRNh5dBD9z8v2pwqG4F5wf+fR
Mj2sHUz8Ff4wZNxSm7tsCOtCS4qWEDTWkPZyuS+Nx0/FYfpgGmny9msvJDQa
a7e7XpHSEBb/nBM3QCPIZfz8rgUauftsfZaiERzWbalLsY6gv04ZMP30IUqj
hgYGqVEIF7jA0FUGxL6+dq5y5Ri+qWl9dTnXAJ9m6acp4WM4EG46uemRAfWe
/gyhGYOfnHNzaTOii85/Jro5Du3yKkdMjgk2sS+/UmGE7aWjZ4rHQu02/4gc
NaIntlEUHM/i7O2eWtHaCQTc8thNXmLhvT5z62DZBGQBajL4nUnsYDUgZCZM
epb1pW2ZAvn/mfGKP/1wvoDDNt6eQNGPZgjay9MLdRz+0r0972DM+FvRFbWJ
Z0FHAddGrWPw4vmv9+wpFpzZrJIqxAzujksP2lUWHDTKQ8gKBkf2luZt87Bi
9XeJy0Q0A230qdeVx62YUfpyjhUsnu3+mqyqsSL6n5JwUsCi+KNFm+J3DDmq
WXTuWXS6alys4L/52+mSwsAMyn0KL52uQZHM4ZiCT/Cix3r9rydbOaxyenXk
vcEBygo3pwuPePteVszAy+mZpC9Sk8g5TDv3/gVuOK38
          "]]}, Annotation[#, "Charting`Private`Tag$14661#3"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwdxX0slAEAx/GnoqkbWWpcWDNzSV7S9Yfm5eeka+vFS16uY2tSPVIcDtMp
JpteVXTRjmSRl7TyOm+t7rzUlc515/HSibunnJdMdqpdRa/6bN99HWKTDp1Y
SRCE27+W72Qps06m6/2oomBh0JVqvyQdPyXmpACn53wb9LdOQOCgSTwal41M
T9+Z4dp0CLpt5t6T13FEvz2YM5CH+Zte2yrIuxDzcqwubSmG+9mX+3LJx4hf
unoxebQaTUSbVxqrAVWyaWNLTC2UPWsO1DAbwTYmL1nNPoDJvnqhOdEMG27G
z72rH0EYuSjVKFoham20VDY1IiipIEpIPkO9Y2p44fF2xO+YSKziS7H+zvys
IaAD3Ysl/gksGZgPvU13OnZC+/RTWDmzC7wabnnWxyfYECjONCV6kGErThq4
JkVuiFauVryAX13D5u6yHhyJT4s9RSpxwW7/YXNPBeb67OdW0UoMFI6H1j1X
QOQqTy/jv4G9UzueRvej71t+4EmWCgFqD7/ofCWmOnW8UqYaS7MBhHmOCnac
vOwVBIWsYtvia7YUJhb4u5U+FA55m1f9EFKoq3A3KxVRCLYwpoW/puBl8rZw
5xcKeQxW32T2IMLkLlVxU4OYkBR7zCwM4cpB1et+xTBiw1e7chgahP6+X1Cy
ZgSMxIS1klQNbOpFEXHcESCEleE8rkG1paOOkI2g3WjBMGkZRReV/pnd/BZq
hT8RkjKG73xbZolkFBE3ZxQfrGlI1xrGyeFR2D16wfbh0bjwpLeCbfUOq9ys
dpG3aWywF7j257/DgMNzgc+m9/CgZSByxvBqzz11vMsHkP9p0UtXDhvO6OFm
7b2NXanFp7aiU+fkenyVrzP80WnR+cs53Nl6Eue3dogkfB3mhyLDFjsmEWTM
45IsGmM6MynHYhpNQYZaRSANsklSeJmcxsaaKAb7GI00scp9q2waYzwP1Z9y
GjFiTvWNjBl43shN6FmiUSJZ9hF/AbSzY/M=
          "]]}, Annotation[#, "Charting`Private`Tag$14661#4"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, PlotRangeClipping -> True, ImagePadding -> 
     All, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox[
        TagBox["\"Slope of f\"", HoldForm], TraditionalForm], 
       FormBox[
        TagBox["\"L2 Distance\"", HoldForm], TraditionalForm]}, 
     AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
     Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"Quadratic Score\"", TraditionalForm], 
     PlotRange -> {{0., 0.94999905}, {0., 0.8}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {Automatic, Automatic}}, 
     Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Inaccuracy, empirical\"", "\"Inaccuracy, bound\"", 
       "\"Distance to FP, empirical\"", "\"Distance to FP, bound\""}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.922526, 0.385626, 0.209179]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.8800958622359343`*^9, 3.8800958797432957`*^9}, 
   3.880097092885227*^9, 3.880097124254138*^9, 3.8800972168418703`*^9, 
   3.880097261450523*^9, 3.880097327247704*^9, 3.880097904815529*^9, 
   3.880098264766448*^9, 3.880104487599887*^9, 3.8801075706643677`*^9, 
   3.8801106075830107`*^9, {3.8801332259607973`*^9, 3.880133228551649*^9}, 
   3.880133846215459*^9, 3.880134068683713*^9, 3.88018301601334*^9, 
   3.880183690873684*^9, 3.884985823265841*^9, 3.884985923476581*^9, 
   3.8849859914887743`*^9, 3.88498609662423*^9, {3.884986393552637*^9, 
   3.884986405340455*^9}, 3.8849877267278833`*^9, 3.884987797444319*^9, 
   3.884987845483241*^9, 3.884987961765325*^9, 3.884988227569735*^9, 
   3.884988581531598*^9, 3.884989496592759*^9, 3.885213621740121*^9, {
   3.885597033548967*^9, 3.885597054715571*^9}, 3.885597106053575*^9, 
   3.8855972339263353`*^9, 3.894041569357609*^9, 3.89404356900062*^9, 
   3.894046568544961*^9, 3.894046628265572*^9, 3.894047337034284*^9, 
   3.894047449863653*^9, 3.894047485587798*^9, 3.894048106733366*^9, 
   3.894048383699111*^9, 3.894049321622149*^9, 3.8940614009593573`*^9, 
   3.894063619196888*^9, 3.894063791161984*^9, 3.894066917978698*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"bc48fb3c-fd1b-4c82-b9b3-dc87a40ffc41"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"NMaxArgmaxScoreDistanceTof", "[", 
      RowBox[{"slope", ",", "logscore", ",", "L2DistanceVect"}], "]"}], ",", 
     RowBox[{"Boundf", "[", 
      RowBox[{"slope", ",", "logscore"}], "]"}], ",", 
     RowBox[{"NMaxArgmaxScoreDistanceTofp", "[", 
      RowBox[{"slope", ",", "logscore", ",", "L2DistanceVect"}], "]"}], ",", 
     RowBox[{"Boundfp", "[", 
      RowBox[{"slope", ",", "logscore"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"slope", ",", "0", ",", "0.95"}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "2"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "7"}], ",", 
   RowBox[{"PlotLegends", "->", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Inaccuracy, empirical\>\"", ",", " ", "\"\<Inaccuracy, bound\>\"", 
      " ", ",", " ", "\"\<Distance to FP, empirical\>\"", " ", ",", 
      "\"\<Distance to FP, bound\>\""}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Slope of f\>\"", ",", "\"\<L2 Distance\>\""}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "->", "\"\<Log Score\>\""}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0.8"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.880040477935319*^9, {3.880095795938262*^9, 3.880095796045643*^9}, {
   3.880097296467506*^9, 3.8800973010165567`*^9}, {3.8800974570003366`*^9, 
   3.880097465161107*^9}, {3.880097651141425*^9, 3.880097651557366*^9}, {
   3.88009770922515*^9, 3.880097709412438*^9}, {3.880097741215044*^9, 
   3.880097741915835*^9}, {3.880097891109769*^9, 3.880097911684022*^9}, {
   3.880132978759244*^9, 3.8801329791843567`*^9}, {3.8801332259608393`*^9, 
   3.880133228551703*^9}, {3.8801337454694023`*^9, 3.8801337709786263`*^9}, {
   3.880133972390683*^9, 3.8801340144394283`*^9}, {3.88018341913131*^9, 
   3.880183492990713*^9}, 3.880184512090844*^9, {3.8849856364567137`*^9, 
   3.8849856460295477`*^9}, {3.884994869962265*^9, 3.884994872074503*^9}, {
   3.8856034531742077`*^9, 3.885603457424199*^9}, {3.885603487800033*^9, 
   3.8856034928269167`*^9}, {3.885603543265861*^9, 3.885603545436286*^9}, {
   3.88569935908115*^9, 3.885699359207676*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"d0aa69a2-ab1f-4ab9-bb3f-568aa2eade3e"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwdhw0w2wcAR5VOTy+r3mhR2p5TzMd8ZFuPrvXjqKtUbdWqsl67SvJHWvSk
tVGj5eI2erRJTUIxpc25mzLpTAhFmuRfCUO/2G4iiUQQ6lQVU1m3d/fu3XNN
yohlWlpYWBx47391397jcGmiOaSCUkAcL7wdku46lnY+OQ/0H4/oKaF0pPc5
mjREKWj32GrXUDbmuUE+d4kauPxlqD2GQvhdJWkFxANYG8oqNgfxEJNxMzGT
6Eb0akCl8GA9zqZeTmIRg7i169B3jodEyPZVXKlO+ANuzXZh7Kci9L+9EZHi
MYT4sWcCftpDGDrU8VVOw/g4wr7hpPA3uIRx8jZZPIXlck5ktnU7io8NKQdU
L3AqgDAq1BIQ/zMOVpUxrhlSLClsF8zqcRypSo/+oESK617ibEGCGiN8I1k6
IkXMMieS8JhA7e7O1sTMx2CJRxMEThp4Xd9zde2uDIGspj3EKQ2eFCXHyZdk
WNlVoKPyNPDzPtk5dEAOTq5PmoqiRdLbR8WSUTmiP7GgCqK0eKmLc5W7K/DR
+LNlZpEWPH82i35ZgbHSxk6qVIteYYyTuUuBn5F3zWzWglVpw+3ZRiJ5Ifaw
6qAOtJb4TMlREn51nlsF2Tp0WRnMW74l8eb4+iCzTYfz6fs0BJeExHKYR32t
QxnbedOZWhKFonunzf6TqLNM6f78/dMYObtVFydBkQavOvBIbN/xpZbfOImE
Aft1y1wSL2VuQqZhEhxbye2xRBI1WSsXqG56fJWlpDMDSDA8BwLM5/TwvhDV
l/hOAZ/RujfKO3oUOLxq/7pPgcUfsjr4Y3oU91dcWctXQBx8NJ+504Dai0FR
nfsVuDazN4J6woB3i/98v3NKjm3RTwaUKgPCfWkRUfvleL5ezeXbTOFE8ujG
xHMZ7jRlxjMjp5DdEpxafkkGb1sXzcajKVgrudUc/mMcHklfChQZsdjavNYk
7gOlMFy88cqI4b3qAU5wH0Y+dcxT+k7DrqE462xbL74p793CvD8N+of6Womw
B7mn7Z35ghmYF6WbS/6UINxmWs14MQN54Urr/dZObO3oagi0m8XsQteOpaIO
8J2T/ZQ3ZuE5ai9b2tcO0bg4bCPfhDii3uPBFyLklJVaKyUmuCSudpSu/YrQ
ULqyYtUEftdrL6vfWzBYR4kLZM/h788ElUTsLyiP1ThtNM9hyJzam9TdiDNW
beP9pjm4w/+nmx5CuD0srq/wmodNTcaIb0kDZhjnUhjEPEJo3LRMUx3+Bdx/
2AA=
          "]]}, Annotation[#, "Charting`Private`Tag$4825087#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAAJRDAF3Dgrz4OTEzgOS+UPm4h2W1h
Z34/kAnUwXhAYz9uwhjs4WaOP1+I7AQoQHM/7pI4K6Jmnj/Hx3im/z+DPy57
yEqCZq4/e+c+d+s/kz9Ob5Bacma+P1T3oV/hP6M/Xml0Ympmzj9Cf9NT3D+z
P2ZmZmZmZt4/OEPszdk/wz/0xw/w/9/eP1VXDCvZjMM/gSm5eZlZ3z9yayyI
2NnDP072hUZmJuA/q5NsQtdzxD9qudhZmRnhPx/k7LbUp8U/oD9+gP//4j8D
he2fzw/IPw5Myc3LzOY/zsbuccXfzD/V/J2SmAnnP+zaDs/ELM0/nK1yV2VG
5z8I7y4sxHnNPyoPHOH+v+c/Qhdv5sITzj9F0m70MbPoP7Vn71rAR88/fFgU
G5iZ6j9OBPih3dfQP0MJ6d9k1uo/XA6IUF3+0D8Kur2kMRPrP2oYGP/cJNE/
mBtnLsuM6z+HLDhc3HHRP7PeuUH+f+w/wFR4FtsL0j96j44Gy7zsP85eCMVa
MtI/QEBjy5f57D/daJhz2ljSP86hDFUxc+0/+Xy40Nml0j+VUuEZ/q/tPwiH
SH9ZzNI/XAO23srs7T8Wkdgt2fLSPyO0iqOXKe4/JZto3FgZ0z/qZF9oZGbu
PzOl+IrYP9M/MGT3oA==
          "]]}, Annotation[#, "Charting`Private`Tag$4825087#2"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwdj3s8EwgAx9dLJUXP86juUztUROjTJ6dPP8v4fM6pFrdCXSqzlUMdUVxG
dquU64GaJSR5XKec5lyT8iiP2iw2MWHvzWsiIpXbrrvv5/P9fP/+rjly3D9s
JoFA8Pvif7W1qP3qhKJse3Dvyfv+rMztUWu6Ig8zmFggk9D7aKGIqrfUK+mX
ob73HZF2MQZv07c63KHngtZla27RwYLTL82+KfQH2LQitOhGVCZEz+b7FVuV
I/XbRjbTiYPZvmXRCwk89JhMbnz4kYvovZ9quoSVOBXzY99keR52Hb8aHE1/
Cl/iB6VXeyHqP930jLCrxcH0Xo+aQ8WQPRkOyLOqQ3rsuhH7iRIsI2ckzCE8
w7j1Dzm520uRQpE1tQkb4czd30K9Uo6Dx04eCaeLMPPEyT22HnzEOzbF5gS9
gtoxOrCeVIWXH9LIR+1a0VpbRyrxfwxdlXxftlUbvCcSm+PSnmAlic2cQZBg
iWjRN6XL63DvjtO87HgJYsjhNQOVddg6W3pt87gE3Z6BJEJwPQKaNhQydO1g
3irt+Xj3GS7ubBW0CDtwe3/zyKbIRliWxVMZPp3wq1/3Z6Z9E4osiHJCbSdS
C7jNUlUT6iSxY248KfQVnVriqReYCrKxusl9A2/KpZ7nr4Q49/j5Hbel3cid
bBdPVbZg2aoox5a0bqSarvfi54jgrKgFIbkHgyEeFGuvVtD/RwZSaGbKPKoY
75vMR41yGeZe273TRinG2fX8eG6QHPrl/+y9ECnBrkm2D91OAfZYhVxd0I7l
xcEL3EIV6JAfvqXe9ho9+5xbjXkKNIx1Kzn9rxHOlwZxrZRY60ldrPXohEv4
/dX0vUoYxv6qYE50Yso6Re2aocSYxk++oUQK9hmHSKGZCudXTPDdN7/BbTCT
jUYVFjf4XzNm94Ix6u8t3KbG32YhUSmxMjjl25ty49WIEJ+mlnrKMbFnWhRW
qcbPbTZH3xvkqJ7ZluE6rsbG53/whIEKsHiFgUZnDZIWCsgdpQr40hJWCSM0
oOwgBy+cVqCzgVgcptMgv/1TZeZvSuTGTf3kStTiobbL8mqrEjT7lk3GEC24
JbkNSyxUGLsQV5XVpcXuouuvitgq8N2/TwpboUOeo521bbUKyYNfk10DdDi0
556zyagKi/xetAiEOkjWXv39BkWN19M56Vnz+3D4c97UlUQ1bt2P3hfm04f8
X52fJpeoscF8pdJQ04fYSbPB6ik13tWMFgqm+2CasbVh22oNHp1oCM9y78eB
h0eOrdqhgbc46r0Lrx+zczhxVLYGZiwvvmGkH/azhGTJXQ3EbpZMgeMAsuKG
+g31Ghy6Xjc3rGgAMXaU87mfNTgTuMwmizuIYYn4bOKXT6/5A3JaxyBEsxK3
vIvVwrTqyV2XpUM4vVQ3ceqSFlk2DCdB2hDUM4LOqnhahAg9xjkvhuDASS7v
aNTCLtHiEc1ED1aqtNEg1YIn45MMSXowus+4z/msRcKVyyaCaj0i8hxYI6Y6
eHqGCjgf9RihJqXaWusgyjejusQMI4B1MOHcFh2u+yutDGXDsFgrqXnkpcOB
WZWyl/phVC9+QPKm6ECsuFjAWf8W2b0FbRsP6DBICzlKo7+Fq70PMYahw79g
aHVG
          "]]}, Annotation[#, "Charting`Private`Tag$4825087#3"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwdxQ1Q0wUAhvExsCCs8DDamuQZhfLRoAEBl8frukmGjuNDReguQcYWS6BD
Iaa2EBsph0qDzMENgjsc12Go80ZDsA2a/8gNx4Zs6NoHY8NxrBSkdqSs7Hf3
3LPlUFVeGZlEIqX817O/FaZ69TP7QIaqJuCN9xLaMiq3zFSU8IQoT7Zu2FtW
ispRyqKDew5EWl0xv+kI/hCnxfVwOxG0EH2amD4F+vFfsxq4P+JJ6ubUp7Vt
mBgL2SOjXoXii89Dh5K/Q1DWQPWLJDm0EeIdg08lqN6/+vOMVgHxV+X85mtd
yK5qKarm3kSmjfAumnoxutq+43C0Ckv1tH4HTwbriDe/i6qGlR5x8cpaHzay
Wo+tI40hXW+pamP2oyHHSkxqb4GteSJeaLmKj8uPHuJzJxBueLNPk6GEIJ6o
kRbegYP5dmhG1hB++7uZ9Um0HrZvn7Os++gG3EO2gg7qJLzHg/3bzo5gE1Mk
DCAZsabgj+RuUuOHHnpwh8CIAopXqlSqkRZk/iZ52Yj83AtfNxaNIp+I7eW5
p5DSIeKMXhpDE1t/W6edRvaw5p/EilugDAj28TJNCAw8mLIthsClsCgbSWUC
zc+IPe8hoDbWLCXJzTjfv7CWUzcOXyGN2i65h70xH5xrN2jReOOXnqTw+0j/
cDxkVaHDxsjKeF3zfRjEHia7ewIJdhVI9RZcvrlClLD04P7PirBAx+PEfQY8
Jl5+6LdZIX+ftss2a8DJGKVAUmhDrfbEo/6jRmT/JcrkRtuRElwSwumdwiuy
otCkUjsCyVda5Ky7sBQk6P1ddnQMuzb8+eAu+EpzoYTqQO76KjKNacI7/Muv
c/c7UGzOu352xQTfaw1ORqsDYeHEmUcDZohOxFVo18/iJ3YpZyz1Hr6HsN7v
n4UiMjWeLf0dvId5O7XbnRAe2N3nabKC3r31BYnAiRhLXMCZkzYMkydbGctO
PEimLPk0dpyS9x7wJ8xh1/a0qSM5DmRxjkVqD89hJmlFKLU7YNJEycrcc5gn
i65XhzvRWev7lBHlAq/u3QqvwgnOVl2i/6ALy7YLkYMlc1g6XTt0ccaF+efL
R1h3XFCm7/6yLMKNTkWznt7qRv3CZhYj341rTnX6YPE8XtozrrutdcMn6zZJ
aR6oKLGN04tutEue8eBf2ieqxQ==
          "]]}, Annotation[#, "Charting`Private`Tag$4825087#4"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, PlotRangeClipping -> True, ImagePadding -> 
     All, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox[
        TagBox["\"Slope of f\"", HoldForm], TraditionalForm], 
       FormBox[
        TagBox["\"L2 Distance\"", HoldForm], TraditionalForm]}, 
     AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
     Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"Log Score\"", TraditionalForm], 
     PlotRange -> {{0., 0.94999905}, {0., 0.8}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {Automatic, Automatic}}, 
     Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Inaccuracy, empirical\"", "\"Inaccuracy, bound\"", 
       "\"Distance to FP, empirical\"", "\"Distance to FP, bound\""}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.922526, 0.385626, 0.209179]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8855977281409483`*^9, 3.885603473919352*^9, {3.8856035066752653`*^9, 
   3.88560351967546*^9}, 3.885603867600295*^9, 3.88569936113305*^9, 
   3.885699706311709*^9, 3.894041882036421*^9, 3.894043655236885*^9, 
   3.894046568666697*^9, 3.894047193473877*^9, 3.8940474253313007`*^9, 
   3.894047464341007*^9, 3.894048078784482*^9, 3.894048113673008*^9, 
   3.894048879447475*^9, 3.894049834425511*^9, 3.894061794870336*^9, 
   3.894064537132764*^9, 3.894070655013248*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"3b117606-d342-422c-9388-31fecd12748c"]
}, Open  ]],

Cell[TextData[StyleBox["Redefining ArgmaxScore", "Subsection"]], "Text",
 CellChangeTimes->{{3.880038861764502*^9, 3.8800388634416847`*^9}, {
  3.88013322596097*^9, 3.880133228552018*^9}, {3.8940488131706657`*^9, 
  3.894048819031986*^9}},ExpressionUUID->"e1efc25c-0b12-43a9-86cb-\
e6c3e195a254"],

Cell["\<\
For the following plots it works better to compute the ArgmaxScore as follows:\
\>", "Text",
 CellChangeTimes->{{3.8940488202211123`*^9, 
  3.894048854089665*^9}},ExpressionUUID->"364e3f9f-dd46-4a82-91f1-\
20b360b52ff1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "ArgmaxScore", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.8940489912361813`*^9, 3.894048996027939*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"530e46c2-d178-4616-988a-23b3334889c3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ArgmaxScore", "[", 
   RowBox[{"fp_", ",", "slope_", ",", "S_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"ArgmaxScore", "[", 
    RowBox[{"fp", ",", "slope", ",", "S"}], "]"}], "=", 
   RowBox[{"Last", "@", 
    RowBox[{"Last", "@", 
     RowBox[{"Last", "@", 
      RowBox[{"NMaximize", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"S", "[", 
           RowBox[{"p", ",", 
            RowBox[{"f", "[", 
             RowBox[{"p", ",", "fp", ",", "slope"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"p", ">=", "0"}], ",", 
            RowBox[{"p", "<=", "1"}]}], "}"}]}], "}"}], ",", 
        RowBox[{"{", "p", "}"}], ",", 
        RowBox[{"Method", "->", 
         RowBox[{"{", "\"\<RandomSearch\>\"", "}"}]}]}], 
       "]"}]}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.880036526142702*^9, 3.880036531870706*^9}, 
   3.894048841936994*^9, {3.89404887374084*^9, 3.894048873975713*^9}, 
   3.894049029722548*^9},
 CellLabel->"In[54]:=",ExpressionUUID->"e673209d-4aa5-4186-beff-b2281868252d"],

Cell[TextData[StyleBox["Density plots", "Subsection"]], "Text",
 CellChangeTimes->{{3.880038861764502*^9, 3.8800388634416847`*^9}, {
  3.88013322596097*^9, 
  3.880133228552018*^9}},ExpressionUUID->"5b03bf31-a774-41c4-983f-\
591b24aa7ea8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"ArgmaxScoreDistanceTof", "[", 
    RowBox[{"fp", ",", "slope", ",", "brierscore", ",", "L2DistanceVect"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"fp", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"slope", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "2"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"ColorData", "[", "\"\<SunsetColors\>\"", "]"}]}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<Fixed point position\>\"", ",", "\"\<Slope of f\>\""}], 
     "}"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", 
    "\"\<Quadratic Score, Inaccuracy (L2 Distance)\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.87994602703195*^9, 3.879946029171504*^9}, {
   3.8799470527039423`*^9, 3.879947116466868*^9}, {3.879949819150744*^9, 
   3.8799498227680473`*^9}, {3.880008855212792*^9, 3.880008857078289*^9}, {
   3.880008933606444*^9, 3.880008937098506*^9}, {3.880018810966402*^9, 
   3.880018811201077*^9}, {3.880019564092782*^9, 3.880019571094605*^9}, {
   3.88002029576523*^9, 3.880020296486264*^9}, 3.8800923041266336`*^9, {
   3.88013322596101*^9, 3.8801332285521297`*^9}, {3.880133700116152*^9, 
   3.880133702291901*^9}, {3.884983521671433*^9, 3.884983526090221*^9}, {
   3.884985089913315*^9, 3.884985102293641*^9}, {3.8849851775470047`*^9, 
   3.884985177619371*^9}, {3.8849852124549007`*^9, 3.884985238835257*^9}, {
   3.8849853017350817`*^9, 3.884985306757111*^9}, {3.884990251568585*^9, 
   3.884990251834557*^9}, {3.8852124149845448`*^9, 3.885212415817855*^9}, {
   3.885212540900305*^9, 3.885212559729127*^9}, {3.885212603603134*^9, 
   3.8852126040418*^9}, {3.885603471817957*^9, 3.885603500808153*^9}, {
   3.885604275413534*^9, 3.885604275597555*^9}, {3.885604721009096*^9, 
   3.88560472963258*^9}, {3.885604882287117*^9, 3.885604911817791*^9}, {
   3.894043685069296*^9, 3.894043713776121*^9}, {3.894043761323792*^9, 
   3.894043761656604*^9}, {3.89404384101867*^9, 3.8940438410988083`*^9}, {
   3.894043980388795*^9, 3.894043980428417*^9}, {3.894044507164089*^9, 
   3.894044507462305*^9}, {3.89404888735922*^9, 3.894048887963731*^9}, {
   3.894049016076055*^9, 3.894049016400755*^9}, {3.894049048541239*^9, 
   3.894049048817803*^9}, {3.8940490911133966`*^9, 3.8940490943669786`*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"86ed7af6-99d3-4858-ae44-b16140d78dec"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJyNncuuJEd63xN+grPxvvwG9QbKRzjwEyQMGPDOtfQyF7PwYhYFYyAIxsBI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      "], {{{
         EdgeForm[], 
         GrayLevel[0.8], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxMnXeYVEXTxWdndtLOzuzM7o6YBXPC9JojijmimBVBjJizIopEMWPAACgi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            "]]}]}, {}, {}, {}, {}}}, VertexColors -> CompressedData["
1:eJy0vXc8V////y8No4UUGSlpK22Uzl2U2bCKhESEMrOTkRESqcxky957j5C9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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, AxesOrigin -> {0., 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, AxesLabel -> {None, None}, FrameLabel -> {{
        FormBox[
         TagBox["\"Slope of f\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox["\"Fixed point position\"", HoldForm], TraditionalForm], 
        None}}, DisplayFunction -> Identity, AspectRatio -> 1, 
     AxesLabel -> {None, None}, DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope of f\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox["\"Fixed point position\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultPlotStyle" -> Automatic, "GridLinesInFront" -> True}, 
     PlotLabel -> 
     FormBox["\"Quadratic Score, Inaccuracy (L2 Distance)\"", 
       TraditionalForm], PlotRange -> {{0, 1}, {0, 1}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx11wk0VP3/B3BKD0nalDUiebJU0mYpbyJPKpGytOspJSm0SqEoKbIUKW32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              "], {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -112.5}, {7.5, 112.5}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -112.5}, 
                    Offset[{4., 0}, {7.5, -112.5}]}, {{
                    7.5, -48.579545454545446`}, 
                    Offset[{4., 0}, {7.5, -48.579545454545446`}]}, {{7.5, 
                    15.34090909090911}, 
                    Offset[{4., 0}, {7.5, 15.34090909090911}]}, {{7.5, 
                    79.26136363636367}, 
                    Offset[{4., 0}, {7.5, 79.26136363636367}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -99.7159090909091}, 
                    Offset[{2.5, 0.}, {7.5, -99.7159090909091}]}, {{
                    7.5, -86.93181818181817}, 
                    Offset[{2.5, 0.}, {7.5, -86.93181818181817}]}, {{
                    7.5, -74.14772727272727}, 
                    Offset[{2.5, 0.}, {7.5, -74.14772727272727}]}, {{
                    7.5, -61.36363636363635}, 
                    Offset[{2.5, 0.}, {7.5, -61.36363636363635}]}, {{
                    7.5, -35.79545454545453}, 
                    Offset[{2.5, 0.}, {7.5, -35.79545454545453}]}, {{
                    7.5, -23.011363636363612`}, 
                    Offset[{2.5, 0.}, {7.5, -23.011363636363612`}]}, {{
                    7.5, -10.227272727272712`}, 
                    Offset[{2.5, 0.}, {7.5, -10.227272727272712`}]}, {{7.5, 
                    2.556818181818198}, 
                    Offset[{2.5, 0.}, {7.5, 2.556818181818198}]}, {{7.5, 
                    28.12500000000002}, 
                    Offset[{2.5, 0.}, {7.5, 28.12500000000002}]}, {{7.5, 
                    40.90909090909093}, 
                    Offset[{2.5, 0.}, {7.5, 40.90909090909093}]}, {{7.5, 
                    53.69318181818184}, 
                    Offset[{2.5, 0.}, {7.5, 53.69318181818184}]}, {{7.5, 
                    66.47727272727278}, 
                    Offset[{2.5, 0.}, {7.5, 66.47727272727278}]}, {{7.5, 
                    92.04545454545458}, 
                    Offset[{2.5, 0.}, {7.5, 92.04545454545458}]}, {{7.5, 
                    104.82954545454548`}, 
                    Offset[{2.5, 0.}, {7.5, 104.82954545454548`}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0.`", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -112.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.1\"", ShowStringCharacters -> False], 0.1, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -48.579545454545446`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.2\"", ShowStringCharacters -> False], 0.2, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 15.34090909090911}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.3\"", ShowStringCharacters -> False], 0.3, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 79.26136363636367}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Blend", "[", 
                   RowBox[{"\"SunsetColors\"", ",", "#1"}], "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.`", ",", "0.3521723226612688`"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "225"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.880039134792343*^9, 3.880040263426198*^9, 3.88004564059665*^9, 
   3.880092841805999*^9, 3.880098659427001*^9, 3.880104838795102*^9, 
   3.880107890817625*^9, 3.8801109657188597`*^9, {3.88013322596111*^9, 
   3.880133228552268*^9}, 3.880134203847369*^9, 3.88498374408834*^9, {
   3.884985092079342*^9, 3.884985103872425*^9}, {3.884985168975466*^9, 
   3.884985185467821*^9}, {3.884985227742906*^9, 3.884985240627842*^9}, 
   3.8849853105631247`*^9, 3.884990915366952*^9, 3.885212418501259*^9, {
   3.885212538392613*^9, 3.885212555183626*^9}, 3.8852125923879766`*^9, 
   3.8852127008148603`*^9, 3.88559705676583*^9, 3.8855980618102694`*^9, 
   3.885603475333424*^9, 3.88560371268756*^9, 3.885604722580282*^9, {
   3.88560487978034*^9, 3.8856049126516*^9}, 3.894042271404097*^9, {
   3.894043682679689*^9, 3.894043706875976*^9}, 3.894043755058935*^9, 
   3.894043835481419*^9, 3.894043972085134*^9, 3.894044231743182*^9, 
   3.89404497645*^9, 3.894047304279368*^9, {3.894049001687622*^9, 
   3.894049043089813*^9}, 3.894049085002472*^9, 3.8940501169339333`*^9, 
   3.8940620970031424`*^9, 3.894064888867219*^9, 
   3.894070982589163*^9},ExpressionUUID->"286d541d-442e-4149-a179-\
ec0d06272dde"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"ArgmaxScoreDistanceTofp", "[", 
    RowBox[{"fp", ",", "slope", ",", "brierscore", ",", "L2DistanceVect"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"fp", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"slope", ",", "0", ",", "0.95"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "2"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"ColorData", "[", "\"\<SunsetColors\>\"", "]"}]}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<Fixed point position\>\"", ",", "\"\<Slope of f\>\""}], 
     "}"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", 
    "\"\<Quadratic Score, L2 Distance to fixed point\>\""}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.885219513455282*^9, 3.885219578775043*^9}, {
  3.885219621257769*^9, 3.885219644073971*^9}, {3.885219731826544*^9, 
  3.8852197362510443`*^9}, {3.885603466424802*^9, 3.88560346857018*^9}, {
  3.885603505438322*^9, 3.88560350575524*^9}, {3.885603884387578*^9, 
  3.885603885391697*^9}, {3.8856042606054077`*^9, 3.8856042607351103`*^9}, {
  3.885604917243292*^9, 3.885604917928417*^9}, {3.894044536040084*^9, 
  3.894044537009163*^9}, {3.894045608170075*^9, 3.8940456101808367`*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"2c77e4f0-e626-4012-a70e-e0724732e0d7"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJx1vXuUZVdd7zvF3AjCyCkOmNvych0BAQ2y9cT4gEEWJ5gLIrHlIYpRNhh5
KAMKcXASGWRMhJOTgSglRojYNy6SnJCQGCuvTqeTdFb63Z3uTvX7VV21qna9
967H5SGIiHdn7fmbs76fFeqfPb4153rNx2/+3r//9r6Pvu2Pn+Gcu/2Fzj31
+/R/a5fyP++v/1YutXbFVcATaJ9A+8qler/Urk9buPRA/TcX/j8GvNZo5/s8
ffuhS+3+T4/T++n19r6pv77vGPDaD7n/BN6H42P9Z8JvJ/z2gMsGHly/LeBT
wGUYjxPxftreQ/sM2u37t+F97K/8Id+f+v9D/bcU30fxqcbzFZ/C957C9TPA
FfBa4/lcL3r/GayfU8AzuL7XWD/8vqffL9vwPlwv1j7WGE+uF11PC43x4/rT
9uqH9Of9DU9f+pWnPu8npwIeDe13Bzwe7rc74BW0T6Pd1tfdsb+Tv/GAj4bf
Y2E+zwQ8BzyN/qM/ZH3ieb6n/SMex/eOo30auGq014+bm4nXK96L8VgCNnrT
id+r73MK33cM32f0zOa3xHrYi/HroX0N62MF4zuD50/j+XPAY/ie6Ut/8b/3
/+5biOOjeK0xP9xPOh7TuP9443l6/Upj/+rzxp9+/3I+4/eNYnyWML7H8L5V
4/u5nnm9ro+9jecpnkP/Cu17G+/P/cv1qf2rxvsovSjxvBL950DfloD3Ah/7
If3teT3cv4fnT2N9z2B8l7Dex9H/FPrvbdBTbR9H+zTw1OD+P2PzUoTn3RTw
KrDRy9Tu5G8irM9jev+Iix9CD9P9nlqO//3jy7G/4gm87wTap4Ar4FHM10pj
vXA96nyfwvyOo30FuIf7TaN9BvebuvTgU/A50/H7FBsfkM4jxWONdv2+U2if
Q/sM2mdALzoY/3FcPxHW3358b2of3O9wwGeAj2F9jjXoj+6H0M+P43sSP8Lz
mutfn98BPoXvX2usz8HzVnC/KXzvVGxn//p+3+zE/opX0d+5p90PsX0a/OI4
cJif07Px+Yor4C3h+s1xvga/O8LvMto7aD+D/d8BngZ/PA4cvu+2RR2/iKsG
1v1i59pR/d64Po+E88/2xSzW0zzaz2D9Tw2+//Pd+L6KqwbW+Z269D+f+nts
Pl6vuAI2ejoTsZ7fc2ifAe5gfhcw3nON++n66QEvof8C8ATGcwr4APbbInAF
vKWx/hSfaMyn4qKxnnU9rDbWs7bvBO4CV43zietHv7/TGB/tvxPffwD7ZxG4
2xg/bd+C911uvL/ivY3xJz+m7cuN80zp8TS+dxb0eQL9x9H/BPpX2u4DLmz8
R8L9/ia0ryp2xs+kdid/k7jfFpzfo1gvyw1+QNvnMR+zGL8TwEfQ/xjWxxzw
CN5/rfH99ev0lmN/xZOKfYV24jHM9wGsnwW027zafp0CLnF9D7jT4J8H7zke
n6fjdabBP2v/MfSvMJ4TDX5BsZ3/xt+tKrbx+/BMxDc+9Tm/avTxCL5/Hnhv
g/5wvBTvxHgvNuiV9u+ifwff38F+O4P2Uw36pv2nlR76cP7+3mTc30ovj2D9
jzX2B/cP8eAX/G9snwNea+wH4ad81cD1b3s24vr6ixYjvvip8fg7W9eTwPON
/a3raV6xb/J/3K/aPtXg9xRPDubr7XPxfQU74kXw76bPsfVi8tyOiJX+rWF9
raL/KvpPNfg/xWHdZEs6H1nSvypOcovdT3EYv+um4/0EuybW97fzwOTXUeDb
w/ffhvPB2lcU+xX0PwJ6dQT762jgf0/H9a79jwf+86zSl3XykmA/2+gvz/Nz
eJ7xcz0d34jD+J7f0/E9v6fje366frA/Z+L1Qj8d6GnkrxZif6WvpLdLjfNl
8GvzOQN6dk7plQ/86L+l71PM9lHcfwXY9v3RiJUensD5dTLIn+d0P7ST/KZ4
UumTqxpY6dNCg9/U8Rhr8Nf6vrN430X0X1Ds54N8c1Lp0fO68f0Vo93m45qO
zkfEaLf1d/l87K8Y7Z7y8HyDvxHsIY96yqO3gx+jfHhY91d/P+p8F3h+Afpq
8pH93Q9+d1q/x0+B3hN38P7Tiv0U6OeUrj9P/cIM9msH8vs08F7oT/ZifR0A
PVtC/wXgeaxXo3+9+H6KO5ifpcb61vtN6nz5qrFflf/ZifO1C3x7+L0vng+C
HeWds0q//TTo+QTOjynQ9wrvN6LnkckP8Xw6ifsf1v3cp2u6v2cwPjN43zlc
P4n2Cs+7P8zv4wE/Es6PnXEeFS+j//HGftPz7fYwPlvj+At228P/wzp0uxX7
LvASMPUFkw3M8dD3O431dRrjcxbj3QGebrRzvEmf9fm7w/uOxe8T3J+PwX7f
G+dDsIM84KEf8NQPkD+ZwHo9q9f351evP4HruT992H/XDnC5qtiZviC1u/V/
PpwPp4/H/aD4GMbvaEOe1/VI+Z77BfKvpz7pFL73NNpPAnN+7bwy+bYAPaB9
HfTBdxrrVfERrG/wA/35kPGN+ow0/vX4vmol9hfsJxXnFfoTkz5BHuuPp66X
ww37m76/0QXj7xaBH9Hz2y9i/2A/edgX/QzWC+X108AnMf4nG/o0XS8mzxn/
YPKxySu0D94P+jgK+rmsOA/P2zSr8/OhxYjr37GpiOvx/S07j/cHfsT0KIcU
98dT8QL6j2N/TYM/nWrMp873IezvQ0G/n+Zb+vefr+2Ten3kN4/H8dTzC/px
v6ztDthPYb0C+ynQE+rneR6ew/3OYb2cQP/toPcl8Hbwz12cF9Cv+2mcFwsY
P+r/zjbOB+XfDml/P439RP+Hs/g+vg/13WsN+jRoT/RIcJ8u6PwfwffNNbCu
R5w/dv8L5yKu56+T9le9nt48rftvXzfOr37PuH5v2dRPkf5Ku6d/5KRiH/id
L6T3FeyIzV5g/PKU4shfjcXnKUa7p//epGIf3vfKJaVfVyb9k2DTT63TNwn2
QV7YMa3zsyPpmxTPQJ/awfqjfhz7w/zrIn95GvvjNK4fw/Wm/zN7htkb7otY
+QHT/22O54X09019+eC3p+Nl2Mbrsp6O12U9Ha/LoG9ap08SbPzBHTO6/u9I
+ibBnv5Sk4r79/vjp+7/iYV4P8GOeCfoldFxOx9247zai/77cZ500b4E+rbY
6C/P6/Pv+rwJvM8U+leN80wx2yeUf4n66t0Y370Y373xfooPYP/vx/7ei/0N
fys774pkn5D9kQd9yFHbHzeG9/1S6G/8r/FHsC/mq9rfndPnGX2N+/mcPs/T
f2lSsdHXS5aV3l+S7HWKKb+ewPlxHPzOMeBZ8DOzaG/K7wP6MRvfV/g9B/4v
yreLsb/wgw78Yb+/6qPCuI0l/0bBfh7nO/w78vmgLz4V7z/gb7rx/sp/gh/1
9O+YVGzztbmj87W5o/O1Oekr1f9jUrEP++Mz8/F+gh3xJPjhCvud+Bzmcwv0
wyXwduy/ZbT3wL92G+exnje2D5K+RLAj3ov3343n72/4Mwzoo9HdUeU3+/y3
0pstwKCXnv4QEw1+edBvXJ8fz8v7w+998X0UL+O8XEb7ccgv8H8xeWo00Q/B
Du0O+hpP/1VbV3YezCu99/R3OKL9+/Kzng9jwIdxfYHvBT9h/L7R9zLs+yqd
Y0q/JpU/duCXjd/oJPoj2E8q/+zAT0d+w+SxCusN2OjdvkRfBNv8tRL/Itih
3fjT7yd6IdixfVzHKw/04JHEfwl2aDd+7KWzOn4vndXxe2mS92v6spr4J8GO
7fC371//gafG73eSvV3a+/eT9r58qPQMuAzr9fKTSp9PJP5fsEO7jdfrOjpe
r+voeL0u0f96fp+V5kewQ3tO+/yk0psc9u+c9mujN8YvPQL6uaztke+29jMq
L+Sw3+awz+a0v05iP08qvS3Bb+Wwp5Y4n3PY93La7xZxngCbfSCeP6ug/yuK
+/RW6SH8Xz38PUrIq74pzyr9n9D7Rfk2+Udo+xTaR8DfjeD9Zhr8nOr350B/
Qc9jPJKdb+cwfhPAsA+WkGc95dtxrI9zDfmB76PzdQ7n8wTma0r3hwMuKc+f
gf3zDOyJgY8skpyv9Gca7cRdzGcP82V09r74feTPZD5KnD8l9/8prLczeL7x
JfZn6++mSxUjni7yx1NKDxyxnZvjEas8tgD92jjG/xz8FSaAz2A/dMCPT4Mf
n4I/SQf89jT47SnQsw7ks2nIZ1NKvwxf09Hxiv4HJzAfp4DPYD7GgTv666fh
D9GBvm0azy9B70n/z0F+mlJcVg15efB7S6DPq4rNv4b6bps/D39af0Tpfzmn
2If98G9hfeVTin3wh7oovG8+q9jR/k16z3jzSWCv8n5J+f92zCfs+Z7+wo/g
/Gn6w6p8QfvCGbTDvmv733AOftmfUxzlkx1xfgQ78GM5+CkfzrfeOaW3hv0E
9B+TWE+3Bnp3T8B3hfMivFe+orhcQf9zDf2P4Ly5fgftX4/rV7A/GfyRzH5y
Avgwvv8o1usR8Jszen1JPIf+WP9ua9hPu0L/nmJ/TNe7D/sus++fVVxyfzwe
1ssTob2r2J/GfIbz5nzbf2e0Pe9gPUwDd/R6t2fwWwT+Il9S7LYFer0n4gF9
2hf697Q972m7I/9Jf2WuT/gHuuFADz4S9s2qYmf+A6ndrf8rgz7q7Sfi/hFc
BjrdNv51TNv9GNoPox329hL6uny+gQf0yK7H+3jub9rD8fxyRteXP9HAsh8d
9ld/P+p5N6L0NYc92pP+7gv8gvFLi4oj/5jsv2offlLHt48H/EPgV/MFxf39
outrm54nZRfrcwHzR/0F6TH6l/Q/4XqgPWePfn9/P+n4UF8OepTTn6fC+TWs
6zv6b2D9v2lF+78p2Q+VXuC8KCe1f1bhfsST6v8V9QmPx/GT9Wvy/HgV30ew
s3PY9F3077g3/D/I2eWy4igv2vorIL/dGsZ3S3yf+jz/oyriejh/Jr2ftPfp
sfI/Z8AfdRSX04rNPhXluQMN/wbBJdc/9Lsl6LXpr+L6nNTzxO3F+OyB/LnU
WL+Uh+rfuF+4n3De+Qm0gz5F+32w75SMJyux33G+5DM4z4BLzEcOfwZ/Eufp
Kcwv45uehDx9I/ihAvhW5W/iegy4XGnwQ3p9B+fFtJ4nUd608wDnaxHksRdZ
nEfY7xfPRVw/70eWdL9/cFrxQjfi+vuvmIm43k8vXIi4Xj9ne4p/v6P3e2Wy
n8j4RnuEzVeF/YP9avaRqH8zva/JV/QXpT/wOPh5+G/m4J/MPzNevyuMdzjH
PPJXlJB/PP0rSX87OA/gn1hC3sjBz+XwV/Ro953G+lZ+ANjD39HDP9mfxv4D
fXRs3wp+8hHFZa+BB+vb7NloN/3x+Wm96PPuUnrf51fq9utM33NA9T/lItrh
75az/Sz241nwO/B/c7ZujN4fDPoEO+8QX58vh/NgR9zfen43sazfEvunhH+u
H8f63qHnRU55BLgkv0T6Sv6L59lB4EPg/+D/5fG9lk9oHb8z6J/4F8H+HK4H
zoJ+/WPJXlX/2vlq93t9opf19bdOK35Zon/1/P9Vopc/eGq9vMvsL4g3t/P6
wwnLeWf0c4P5J6zo+i6XG1j4nzLwa/dM6f1u7Oj7X2X0eR/0o7t0PNxmrE/6
h5I/mQD9of/jjapv6J+fgkvqI7g+kN+navrT1X+2Xkr40+Xwp/Pwp7P+d6fz
U7AjntTzIOq7DsXn6fkxqdihPYc/nYc/XRn0O59M61OwA86Tnt3uJ9jWy1Ra
34LdD8FRHkD+unxB5VdHPAl+B/nsoj3qZHxfwQ7t9n3r/N0E2/e9t6ff996e
fs97YZ8dh7ywzv9NsMlTe9P+F+yAc/jDefjDlWF8bkj8lmBHvBvyxV7gfTh/
ltAOXC5q/+h/mfzXBEd74tH4PXp91bifnvfIR2b27XXnv/ITaHfw58+hL8mZ
L+wU9PEntb+nf/8k5Pnq6fWfkZ+aBL+Fdmf+oBYPZvEat0Q8oB+mrzF/0NC/
hD2ghP4mh/+bh/+bra93LOv6egfyVbwj+cfVn7vOH02w0aOHZ+P9BDtg20/r
/NUE2366flH30/XJn0RwXjX82QQbPV9J56FgB5wjvtTDn83u9xHISx/p6v0+
0tX5+Cb8l7/Z0fk4hvP5WEfn41iy19OfTXAZ4rm/Oh/vJ9gBe+QLyivoD4gf
QTzgFuDNYfy3x/6DX7N3bFV+wvdwniC+vC8fSH+HeMQ+/yzP86vQBwGX4Kc8
4gft/DZ+zc6XqL8E9sj/E9fPEzp/Ed8Pf97Nam+wfEPR/oD8QPky+hMjfrWE
Pc/4qfMTHjzH5Cnoc/w45L1xyIfjkD/5O9mQ7xWbftriBUeArw/ff134fsQX
euBiFf2Rf8cjX4/t50OJHgp2wGUzXlC+P/pfm3yI/Dj2PtGeNKnYod3Bfuag
P/LIT2L05OI5vd/FkHeyxE+KfshBX+SR78Po8wcTP6jY+IUd8fsFR3q4I95f
93ezfTC+PX3+QlefvwB6/eHEn9XXX5H4McEe+S/sPHth4rcE+3HYsxjfM676
OI98F+Wk6s8c9GmR3qTzVrDN1xvSeSvYAcf1tqjjc9Gijs8F6bwV7IBz5pNA
vglbf9+C/PyttL4Ee+SfsPH5/Y6Oz++n83PA/6fzrv59ZTrfBHvkF3CkR7fj
/BoFvjecD+bnsYJ24HJZ+8d4YPOvuSvc55F4P2nPV7S9v28G738wtHcVm36+
CN9dQn9aNvPrSX8/AfsH8sX6s9BfLkF+hX3LI1460pvELwt2xDZexv/eGn6N
Py4Ue+QDKlfQ/zDo8WG1/xu/+uykLxDs0B7pRaLn6k9AvBXn/cnG9+v5MYLv
o/+P8Q9mL7wX+s9R4HvBD90F/ITqO8sFyGthPtb5+yu+t8GfCc4RX1siv4RD
PG0O/iQHf+KRb6icwXkJ/4sS8qHbDn0n4jWNf/5YOj8F2/otUvyFYKOnr0/0
TrDRx1vT+Sk4R/yh9X9ZT/u/LJ0non900Ef220Uf6aCfdPth394P+9cT0Ncu
AleKXdVoH4z/Ph0Pwx7yutHzDYiv2JDisdS+i/gsO7+undX5uHZWn38t5NW3
LOp4vmVRx/Mt6fwT/0k7f+9J8iT1r/X6+YV0Pgp2zfb698aOfv+NkBevQjzC
Vem8k/1s43/dEf1+w5F/TPo31dcBx/P0YOyv5xGx0T2jJ3vwPnuB9zTikeqf
uN+2gN5sBT3ZrNj001FftYTnAeeMT2I80oTSK6Mf5yd99+B3XNfH3yZ5Q7BD
u+WPMP23R35dk3+i/hw4D3Qk2uOBq2A/umUivl/9+920XwQ7tBs/tzPtF8EO
7VnYLz+X5AfBDu1Rv7Qrri+Vb4Ft/96Z9o9gh3abj+fO6Hw8d0bn47lJnzs4
HhK/Kdih3Z/F+DM+aLwx/gP2paf3v6mn97+pp+N/3qyO/3mzOv7npfmq6cvh
JN8Idmi39bAlnVeCHdrt/V/S0fd/SUff/yUdna/unM5Xd07nq5vsLxoPgnwE
Nh5XpvepxzfGRxyC/fYQ/O2eBL0bQ3zHWMMeIe0Z4uczxL9njF/f17D/DehZ
0p8z34fStxJ4G/RFXbSD38p7T68vivZS2IvzIN++aiK+n9A/m/9LoE/eNKvj
8SHoc8emdH5/C/rUzVgvMR53s8pXOfWDBzC+4Cfd9YHf+4i+z7r4zgF/kvIv
0R9H1wfiFTPE62WIx7Pvi/FvK/o9ZTOfqcoTdh6Y/WQF8018Eu9/EvLQCfDP
2yGvPA57y26sz53AO8DfLaEd+Wpy+HNaPuzIjwY+Iupft4M/2Inzuot24BL+
bx75nMuufm8b9t4cOPr7mDwM+24b9tMcuIR91NNe+iToz0TDnqb2twnMF+xn
ZVf3fzWF/X0S+knkv7J4g2jPor3LQ1/psZ53wZ6wHf6JYR9Hfm+n4nK5oR8X
bPGQz0v6b6FXMb7G/m5QemD+NdH/bOrp9SmRnpC+7MD478F82f+PxvFQ/hPx
4tm08gse5127ae9Xf4AJ0KsJ2NNpX59ozLfSB+qrj6D/Yawf6F/KZr4ZwW3a
482fz+KZutC/7cB62tHI96XrD/Q1h76oDXm9zfxEE4hHwfg6xMeVzXw4gh3i
40rwC578A+LjSpy/nvlLkF+2xPnsgR3i7Uqcxx7YIR6vxHnteX5bvn3TX5XA
j6g8b/lAo/1wHPgc9EuMpyc+0li/ul6nVD/ugEvwM/3+Gk851Yhnrn9jPhWj
T93YX/XnzNdneuD79P16y/p+0Z7FfBTncL6BHynBj8T8i6meguLdjfGuf1tp
vXP91/j7aX1oPKjlDzF9aAm8s0E/NH+B1ROx89LykxyL91NseoFxnQ/zv8mn
dHw86lP12zU/AvLvm/4yjucixm9Jccx/YvTsDPivs+DnxoF3Kn2M82V/1n4T
+ls88m48f4uOd6xfk+Qjvf4A9u8BvI/9deJ8aTz4qJ53sT5fog/a/wC+5wDe
x+jJnN4/5jOz/DCd+DxtLxWb/SLK8834MR2fbbDXs77hvRgfq1+a4l20HfYg
O7/PT/Z0sUfafo7+kqwPdH34/bvBb7GquM/vD9az5ZdAPknTf0d9RpAvfivw
V+0ZxZ7xoYhPLUN9xn2hf9FR7B4N9CKs63ZPsRtWe38F+38R4u0utPiJMcWO
8aWMD70R/APsMTnz9zKfN+JZ7XyL/Cvk8ZL2E/Czlu8s8tuQ3zzziZbgRx9/
ev1ClNcojx0E/Qx+revi+VRee0L53Zz+hLshf0Eec4wPgLwY7YHhPIz2voAL
6DdL6NuKsD++hDpVzzR+/4ZAb74a8Kbw/eG52ari9ir63w95PvAX3w/zX8wp
dtxPjCdB/vuc+5vx9NeH/fqVuL8FR3ue6Zfhb+2a8W31+EX9N+LhPOLlM4x/
m/pmxCuV5zBf57Q9R7uzcyHZFwWXEzqfpr80nANnmP82cAn6lgd5+ITZq04o
bs8ozkAPC7S7h8J1po97OJwvZvfoKa562j8H/SxDvu3LxiM9FVyBvvqQL3Pc
4l6XFLvHQG8fDfRsT2wf0J99kT5LewZ6nfW0v2uH9fuHA7y2qthZ/Hdqd+v/
2iH++guBnlchHnWT5fMdAz6M/sF+fKX5J5wAZr6C8B1jgV5Vi4r9k0HeMP/A
kO/6jkA/2wuKfaATmeWreFxxn5+Q8au62l4AZwv6/ALxmyXsEX5P4GfD+2dL
itvN+GVdD/uhfyK9vyfoXx4Oz11WnIf8LJdYnPa04v55MjgP03kiuKqUXjjG
Q+L78wn0N32wxaN68A+IVy3BX1Qd3d8l9le709iPwr/196/yS9jP+Wm9vqS/
4d3hvH4oznd9/avSfAvOVrS/uzmMZzg/qxXFBeJvSt6/ed7q+YTz1+N9+vRv
IC/ujPRNsJtonBcyn/3vl/WUrSju0xcnf2sNelO/37tWYn/B1aTioQr9gcvT
Ib+f2X87iqsK5xnGL59o2AcPPXX9n5s+YRJ4QvmZfFJxG/xOzHdm+tkbAn9l
dXMe1vOlwHnjkA/Iox5Mjvz3nvlQTO4NeoYc8bsO/mae9qldav8rUe+hwvfm
HB/E5xp/MMp6JpZ/xOINg39xBX/jCvG6bcy3x/7PEW+bY73krDfC/W/5NW28
wV+2Qz6LZxm/ifPRA+eHtX+OfCTlmPY3e3PkX82v3ej9gQb/r+08Hx4GP/GI
4gL8RInzuUT+k3IS8uP14M9HgG8AfzyiuL3a4Kf1+v2qv/eIHy7C977Z7FEH
G/kfBGfLoH/EjyG/VpDnnhfmoegCk98gPqh4KJynPtnn6/f7o7HYXvd/61LE
9e/9Fj+4oPyWA64gj/snG/yatOfIv2LPu7gXcd3/KzMR19//geTvUP+2jun6
Nf6zAP9n9P0Vy/q9fz2rz3v3YsT1/rU4Chs/o2t2v691Iq7308dNP75X14dn
PuYHcT5iPdnzC7O/I7+Mfb/Rbxu/58/q+1YL+r57UD/U5Osc/s2eGPXh+/Lv
wH5h+pR7NV6nZPwOsEO+pCzkU/qM0Z9bof+7ObxP0KuVrLd0I/Cm8Nzgl52j
voJDvrES9LI8rO9THlf6nM0q9qDX+RG9vppTnIGe5036rvpIvh/1laCfbfDL
eVP+HryX8SPN/Encz9LusZ9L7LcYX2n2ngoY9drK0yof5MjnVyzofnfwV63Q
7sO5YvKbg3znke+pLy+LfOSa8pNcn0G/1aZ8hfw7Odor6IeqGV1PFeNdT2i7
A86ZP6yEPA7skZ+n6mp7BX1hG/JnG/kicrT7Q4od5Of+fh7Qg3vjfhV+1fyN
3pj0PYrBD3rwg8YvvCrx24Jz8HPuLtgnbm/kHxn8mjy8L/ijpfwj2g59bzvE
N15jfHLQz54f+ON2V3GBfBv+INb3AWDm41hryD8D+pfkHcG+6X8t4+H3gd8B
9juVn3D3N/JLSP9iCf1vxfjfFviDByK9l3bjB/4J/oZHn4zt9Xn8p0v6vUcY
TxzOo7zC+TWp9Nquf1viT+rX2ZL4k1p/8r8Sf1L333w0YtGvlJOqHzB+5NeX
9f3vxHl+deJP6vGbnNLxeE9X77cr8Sf1ef3F5G+n9sH7MR6Mx0X8qH2f0Wt7
n8eSP3T9/A/Zebmq+7taaWChB7bfjT+y8f/FWf3e/1zQ7501/gb+d1XwJ/q9
x+L6Hqx/8z+BvGb6I7MHmD/ROvuAtn9d9S8Z9nvGfECQv9vQ3+TAfhf2y4N6
/z6W+7utev9sGvQP+px2+O43JX9yaXe4fq2Zn0XoTYX8LEbP1+VjEVyF9fLo
nM7no8l/WLBHfpZoPzkUnze47FB8nmCH9gz5WUrkZ7Hv+RzoyeeS/7Rge/66
fCyCq0B/1qbj/QQ74kms10qxfX/k1ycVu2b7YPxTfIhgG4/Ib04qdmi37/WI
5zVs3zvc0+8dRn6W4RQvy/oVgi3e4N+TvUewqxrtg/2K+GHDpg88mei5YAec
Id9LiXwvVaDvtyT6JNgBmz/CuvwrgjOrl5HOE8EO7R75WOL87tbxiPqXScUO
7R75UnLkS4n+z2f0ficQD3ki9R/w9+m8EFyF8bgqnYeCHXCGfCYl8pnY/t0P
eX//rL7f/ln9nnX5SwTbevkyzuMvp3gZwRnymZTIZ1KF9f0f6TwX7ICNnn4e
8dmGjZ5+CvzAp1L8jOAM+UxK5DOx+Zjp6HwYdsAZ8pmUyGdShfcdnY/3E+yA
fbO+i+CsUvmqnIQ8h/b++aj6iC3ADwZ9n/GDPbRDn5Eta39/Ru053uQy0wef
UX6jnNb+Jep/V9PQP6N+jNF/wzFeIcWbqvyFdo/6Mznynxi9M/2j0bvnpXwo
imHvMPq2Lj+oYNsfjyR9uPJjaHeWb8nyWVt+5b+LeHA+mv3P8i2F/hX8oyrY
A21/rcsnItj21znoE88l+iTYI39IjvwhMZ7kVHyeYId2818xfZjFF0Z8c3ju
XbFdcLWiOFtF/9VGu9y/WsHz0G7r5e2Qz96e+L36ey5L/J5gB2z8xbr8JoKN
vxhK/JlgB2z0fV3+E8FG3/9n4s8EO+B4fqd8KIKzSvl1i0+M/Dva7f3OR/zg
+T19v+9AH/2drr7fdxJ9H8hTif8RbOv5DxL/I9gBZ1Ujv4rgKtR//dnE/wh2
wDY+6/KpCK4CPV9K/KNgB2zrZV1+FcG2XjYmfkCwA7bxuwjxsRct6vi9eFHH
78WLOn7rsNh7M+RfKZF/xfbLj6b5FuyA43pDPshrOjqef9LR8fyTjo7nn6Tz
fMAPIl728nSe1+vtl9N5LtgR34V82bcD36b6gBz1SzxwAf2B7T/zA7T9WVQ6
Hp+udLw+neQHwSXrnQC3od/wR9W+0MfiP5ofhb0V/UvYD3LUO/HAxVyjvzyv
Tf/Ee6H/Mb8Q82+E/sfsUNbujc84E/GAP7b8HMdU/+NYXwX2lJL554Hbs43+
8rxiFs97HPkKLA+d5RN/XPWtbrv29yF+7d9Ce4n8PB643W30l+cV0O/6s/C3
PKv2jjzoBUdTPnPNhw//zfa09nd7EL+4R/0p/G7ok3Zrf79L9ak58gN54GKp
0V+e14a+t4I/bI781ka/4/cQXx34uU+E56O+TAk8tqr928j3ZvyzrSfjn6O9
Bdhzfzbryag9E/UaK+zHCvs12itS/iLBJs++APr8FyT/JcFt1PNw8JfMq8bz
lV4Ae/hvmH5hXfx4/b7RXwPYw//C0//iCfiPP4F44P1qT8hRvyZHPus2/TWe
hL/KIfg7HlT9fY78SR64WND+fb5v8H3m/7kd8hFwjniMNvw9PLCD/6nJC19I
/HU9H35O589w1BemfAtKD4CN37ky8dv189+6pPP71sSf19fvSPx0/Xt/4p8F
V816PfXzNkF+vayn97u4p/e7OPGPg/FJ/G39vV9J/KzgclLjMatJ9Tdx8D8x
evXNpJ+rf1vH9H1aST4X/43IT+7T+VnnvzJYD9CnXZLkz/r5r0jypmCbr02J
361v99eJvxVcor68jde7F3W83p3438E0TcX+4i/j4D9Tol68rc+8q9+fd/V7
N3f0e7/W0e/9WuJvJR7V+OWPJ/5T/XNQ/z1HvXfjB41eGL8Y6QfaTX9i69f0
J4aNf77whH5fjFdCe9SXHIj3ExzlpQP6foYd2t0uxE/vQjwA4gUsPnCdfxLz
Lcj9CsQXeGBbL6Np/Yp/k6O/E+qPx/FK9K2e/x9L+gPBDjie52n9CjZ6cizJ
b4IdcFwf0zr+b070rpaffi3pDwQ74Ki/S/lG6t/onwscz9e0XwTb/t2a5EXB
DjjSL+S/byX6Wc9PlvQDgh1wxvhg1Fs3erSc5EXBDjhDffUS9ddNf/7PST8g
2AGXqMdu8//8WR3v5yf6ONC/pfOh/p4qnQ+Co/0jnZf18/ak81JwhnroJeql
2/e9uqPf9+qOft+rk7xej9+z0vgLtvXxvbR/BDviB1S/bevlVxJ9F+zQnsHf
r4L8nlG+Pgp/9GOI5zyKeGa2H4F/3BHYO4/Avjmn/cs57d/nz7X/LOJJEV+a
z+n753PQ986p/2T/+/g9ev0x6H9x//77yPXVLPqH+OWYr7xUbPHMsR24Iv9p
fIqdF3sVmz9UbEc9mYznA+SnIuRH+qrpL4ALyEtjc9o+ClxS/wH/ygz+8xnr
H6LdYX2VkKc8cPRPNXvEDeHX7BUjinPYI9qwV7RZvw/+lWZP+5UkLwp2aHfQ
R5SI38o6ij30EQXiu/xu8Bt7wF8Qw78yZ7wi9D+xvkYYj5Lx7ohH9IfUPhbz
BVk9+U3wRyyAzT/N4sVvRnxNAQz/xYz6mV3QT+2AvmYn8C71b/HGl6X6RAOc
4qHr578o6T0H90v5BKTdIR9CyfgsxNd4xtvBv9IhHi5DvExG/Qva3dfD/n4w
vP8i/C2DvL2u3pvgDP0t3v26hAe/Js8fgP8E9HU54jna9DcGbrNe2pN6vT+k
/R2wRz219oqOh9sP/+V9un8863+hvX+eqz8q9CcF4l8L8v+Mj4V+rwC9bwMX
K+rfafL2PyX+Q7DZR44+qe2GTd7708RfCTZ+50jiv4nVnl9Bfwds93tbT+/3
tmR/qvG2ZG8Q7NBu9HlL4qcFV5PqX+rgb2rP23xU77856Sc0vhc4s/xEZ3X8
DBu//uuwb//6so7/nbN6/Z2z+n1XL+r3XQ1/msnEPwq29fGers7He7r6frs6
+n67Ev+s/q/wh436jORPItgRPxD2S7ArtJcVR/1Lkv8FO+Bo3z2g83n+AZ1P
tl9yTttjvPWk+uM6+OeafPCh0zpeEcOeldv5Gs7LPr8u56PJby+HP+fL4b/5
csgb34C+6RvQN30jyeP18343ydeCHdptvGN8HbDxR6egjzoFfdQp2Ncvhb/g
pfAPvDTJx/X6fzb8AZ8N/79nJ/t4/XsA+s0D0G+ua6/H5xfhv/aLab+Jf7SD
v7TNzyz0t7NL+j6/Cf+v34S/1292dDw3wL9rA/y5NiT7b/2+0T91FPge9de2
/jF/0t2Bf3o0zPeKYstXuq6+sPBbPtRL7QVcLmm76eMj/9VttMv9S9jrHK4v
UV+4snPJ3g/+YiXjg1l/oxk/XH/Plcm/UrADtvX576Df/57oheCoH0/+Shr/
Bxz19cm/S/k74lAfyvzpS+RfKuBv7+l/H9ZHzH9wQPk9/0SDfxz0s3wTC/Cv
Rb2yqgd/Hfj3V8hX7IEL5D8omQ8B8UDmL/O+RE8FO7Sbvmg82XNUfgI2evYa
6KdeA/3UaxI9qNfz3yf6K9ih3fr/RE/7/0RP+/9E0tfV6+2Tib4Kdmjv93/i
qe95U6Jngh3aoz0o+UcKdsDGD2TJ/1GwA7bz6ZnQbz8T+u1nLuv4f3RWx/+j
szr+H53V8Xntoo7Paxd1fF6b9NOSr9L0zzfDf/7vEn8l7bb+fjqdj4Id2u37
r0d8w/Ud/f7r03lRj/c7oQ9+J/S/70z8mexfoyc7juh47Uj2GtXnVIodsNFP
Ow+Mfhp2xPCf8Khn4Vlv2eryGP14CPRkC/BDSj+MX/rLtL4EO7TbebwA/nth
Vr9nYVbn4wH4sz0A/7UHYB95Eey7L4J990XJPiL5rky+MuyAbb3/I/zf/hH+
bv8I+8YzYO99Buy9z0j0o37ek2n9CXZot/36BfhffiHRM8E2nt+Gf+W34U/5
7fQ+9X7aDv/J7fCX3J74xXr+bk/0W7BDu73/f4E99b/AnvpfOjr+Z+Gvexb+
uYZL1K+vAh0xfihDvhfLHxT9nca1vwP2IV9qzFd0VvVNJfLL5Kh34JgvKdT7
e3bAZsdeF/8m169NaX9bb3en81f4vSHk6x5Cfnhv8QxJXqzvZ/aRIeTLjud5
pftvb1o/9fvekM478U8pmS8e+d3t+ncs6/s/PKvPu35Rv39lSvFHunq/Y2k9
SX3aeP6YPP2gys8F4h3sPG4nebm+/+eTPUL1zXsRD7Ko7dWituezyIc2i/im
WeWf/XHkjzsOf43j2r9EfUIbr1iPdJv6/7gg9xh/YfU9YjxGT9vLeegboX/M
mB9mDP2B/ZMNfqhuN3uTze/FSZ6X+qK2Xj6Y6D/Ps8Frgn5fAfr8wkTvpJ6m
Pe8NiOe6YFHf71tLev3vd/T5sb7kbY34hcH5bvklkS+kHeyJVyX/PWkfm9N2
+55YfxD+axn80/xBlUfaXV3vRi+uS/yO2qNQz8u+97uzOj47F3V8fm5a3/fO
ro73c2d0vCfmFd/UU/ySjt4v1gOah78w7Zmwlzqzwxh/dJ/aowvEo5TAbcSz
5MDlUcivwV97NeH6/b4Pf89o7yvh37tH+cN8XulXDn+3NvOtHNb+lv/ldMp3
Kf3dCdAv5C+1/MExHu2E+muWJ1Tf2zb52+KrQj22mD/4EeBH1d5m+WPM3lbN
I94M41Egv6fll4nxbWOIX8P4lPAXdKDnFfKzWv3IqG+Z0fEokN/V6lvGfMrA
beY/3aL2WMtvG+u/3q841r+w8yjsuyg/APudKo/kHZxHwAXyWebN/Hb160b/
3NPIRw1cMr/lab1ffhr+v1uR7/lh5MNAfqsC+UirBch/qJeddXU8qiXFbbRb
vuk4H7cDfz18z8ORnuh8AbeRn9L8dWL9yG3Iz/CI4hbyG2TAOfIXeOBWM/+A
4BbyCWTAOeL7PXCOeHMPnCN+3APniAf3wOVxxTniPz3jQYfVfzzmi7f4znnl
X3LEU3rGV8KfIYM/Q0V/FfonmNxrf5Y/w+oZGA75xzLmrz/cwFovyvTc+yM9
0/3XA71ZVmz5tON6hf3fA1fT0M/CPm/+FJuTPXuwno1foX0YuL+/BvyJ6esf
0vPc8mfH8/5h1Y8UkC9L4BzyUwv5JTLmm0D8tQcuMB4e/GEb8WI548k2I5/U
ZszXOcRjTSiO9bstPgvyoAduI/9FG/JiDtxCfos25MkcuIX8FW3IjzlwC/ka
2pAvc2CjZ5aPoQ15Mge2+1v+gTbkzRy4xXwDj8C+tBX2qK06H23IHzlwC/Gj
MX+V8VPgrzL4Lxl/Ye9j9oh4/pgd5kzEIn9afciYTxf2KA/cgv9CC/vHoz5S
G/qAHNijPlIb+oIc2KM+Uhv6hBy4vz9Yz1f1CdAvWP1cs5+1Sd8mlL/2lhfp
eLyfYPu+0WV930PL+r6GPfzF25CPc2Cr1xbrHU+Af4A8be/TmtH3uWJG38ew
0Xvzx25D3s6BbX5WF/T+Fyzq/S9I8z84z1FvzeTxHLjPDw/2g/nXjQJbfXvz
D17Q9W3xWMY/lwtYD4fhDzUG/CTshUuqbymXoG+CPG70OfqXQT63+orxPIe8
3ob8nQO3IX/nwG3I4zmwO474quPq32rxu+vq2cj4Rvpo9upt8F+0OLcDEWv/
faA/cyrflXPYb5APLR44+gvO6vmcn1L+0ezpMV+5xXVa+1r4tXozkCc8sDuH
75tQbP6QUT+D+BUP3Ib+rER8igduQ79WIv7DA7ehXysRP+GB29CvlYhH8MBt
6NNKxBt44Db1bZZn5Ba93uJbPXAb+rNYv/2g3v+74Bd2Lur1d+J8uamn+CUd
7R/1VSav2/xvAd4Kf/pZlYcdzmvLFx/9M7A+PewSDvF2OeXL7eAfS+Bt6t9o
3/eWND483+X+7eZ5XvNTv5DGU85vq5cU5R/T34X5dsdw3h4DfdyL8d0HerMV
2P7sfBzB9xfIZzmp/IfVm4z+1ef0/rY+LZ9YgfVm+93ygxVYfyXydRWsb4/8
eQXrxyOfYIH1ave3fIoF1q+fx3m3AHxa9a2mz7ko0U+hpzn9r+cxfvM4n+ew
H4BL0PPoD7QzYplf0x+a/47pG+N5O6/8gM3vdeCvDFv9ZePP+u+n9qQ5nIf4
vvhn/rcFnj+K+01ofHT//srP4vmW3ynGLxT6/S6c37He4SngM5rPrY9lPbuQ
j9/yXTqLR1qIWNaX2RduSfEn9U+stwb7m9+D71lq5NfWdtjbHPKbO9RXcrCH
VYinz5Cv2j+J8bwtjI/lQUG9nPys6oParGd0dfj9TKCTq4rdw2H8Uv0vwQ71
x9zdqh+oepAHUF/GoZ6aZ72yFegbHtL7FYhHy4+rP3Ab+VXM/hTrz3xd/fnb
8O83fWTMz414tgLxar5EvrlQn3Zb2G8blxS7dhjPkN9jDfk+PPRtbcR/laiP
4qCPy6GPGwvj+3rLT3NCcY76JR72mBL2Gne96gM89AEF7TGPQp++DfYH5GOv
mvYWOX9L2F8c7C35mF5fon6Hh/2lYv4CrMcC9cfa0P/ntKfcA33hfYqrZWDE
o/i9Kg9WjHdB/aYM+YdK5DMskc/IPab2oAz2oRz2dwf7ursZ8sYmyLs7kV+H
9Qdhz/HNemVyvpaoV+RRD9HBfpOfxvn8SKN+oPiX+F6jvqu0txGf5Q+oPnkM
/jZt+OsUkL9z1qdEPk6HeIX++qm/z/zLC+QHr5DPKMZrWj151Iu1+gFm//H7
9fsq5Ifxj0N/APqds94Z/DfN3hD13ZOI1wPu89/yfX2s+2kUzzM5ONUv1utp
74J9wYHem7/f0fR+gt1nw/r/24A/H86nMO4jq4pHV9Ef9ZJKxCtn3N+wd7RP
BnkmrPeNM4o9vqeN73E4D3N8XxHOtQWzRwOPdhSPAPtgX//+njjOgjf2FA8D
9/mTAT35XNhfq4pHAv2/OJxvphf/rp0XY4qrMe3v4B/hGW8d4p+jv/6Njfgi
Yunvn1B7Y7aI/NemJ7R43luVf+tj2f8F6guXrD8A/m8k+AN+diLiev09bv6C
49rex9I+Evjiqy0PCnAV/IsmwniNzCl2WL9txPOa/fb30n57/+AGcb8Jdqxf
CPtnSf4W+YrzZr1g6T+M8RkK9s8f2PicU5yd0/5us9LvHPS8Cutuy5mI6/H/
VsAjM9o+MqPt7VNB/k77sW5/2Xjcf4LHOtq/DPWu/z3xo4L9tsBPmx7jkRA/
avv3scDv7o14wF/vi9dL+3BPr2/19P5DPe3fAh7q6f3dxrAergj7elWxs/q8
qd2t/9sY+Om7wzwMh/x2HzP+OPDXDwd6sRb6X2t805ji9pj2zw7r/dqH9Xlj
gX/8ZJjPNfDjGfjx9gntn4f6bPeYvWBv0AcFPLaoeG0R/UP+uDcYfxzq3Z1n
+NDgeX9l+u2gF9kb8MYFxcML2j8vg/43zNdaV3FrQZ83tKDvU+4J+WXN/hXW
za8E3FpSPLSk/cfC+fbaQE/WKuzXCcXtCe2/MdQbf2/YP8PYTwXOt+y0trdP
6/Ulzkv3z+G6IM+Own+7QD2T1or2H0O92zb8w33w37pjZ8SD+wS81tP2MeC1
nvbvv++AH3k4vo/gIvDXN4X3bnUUFxN6XjjI5yXzxaB+q0e+1Tbyp+asZwd5
v2C9V+QHLckvXx3oSainGv1zgjw+xnqrkNfdEw35QPzZ88UGf635GLHfPep5
tpEvYjTIgz+HfBGxfhP496FlzC/wGuL7+vRc5XXQ//LxIH8FfnWkq3gU9M4/
qM9rQX7OQP+LoL/oWj6j48GeZPGgs4pb89q/Df3bGOr9jYTxucLk2a8G+drk
2ZvCersj4K+rP0x5UK9vsx7ZPszPA6jH8MXArwV5bHhV8VDgHzbviOMneCis
v8/fGeYv0ItiNM7PQB5O8yM4R/5ej3jgNvL15pTfwG/lIX/OpwM/Mbyk2IEe
eeTra4EfaeG8LnCe5nu0f4l8gBvh7zYU3veQ1WdE/plRnB8F+N0S9cQKnB8t
nB/9+ZfzeBTnc3UW74PzIxvX9hz6hAr6hj5/5OTP6osnfqge7z9cif0Fr00q
fmaF/sSjkMcRz17hfBjC+VDBv2VtWtt9qfrwoerSH3nq97Mp/lMxzptsUvEw
5ncY8+utDkqqbyjYo953gXzRvll/mvKftkMe9A8H+3Pge0Z6is1fJsqL0Adk
kK9KyFfOw//0s4FeWV6p21X/7aEPb0E+2ghcQB5qE1vckNGzybjOBteH9/3/
7H1DPd1Yr+MWpW9jK0qvc9hzWqtKv8ujyH8Xxvt0qi8v2FPfj/OnhfOnZP46
q18Z8nmvIb/3xvmGvCC41cznJvTPgx568A/ZSZUf/aMqf5U4n4chb26EvJYD
O+gLPfWj0K8V0HcXkN9HAz3YYOfRTuyvA+qvWyG/VYX96HA+5DhfhrB++/yf
6uc88GdV/xT3U8Cjqw19lVyfl5Bngde6ii3+6R1VHI/Bfn4ynleyvwvkOxul
/A/cQj6zEejbi6a+QdqHwU94YIfzr8T5NwL+wC81+Ie6f7SXhXi3ueDXYvFT
hkeh7yqb8pW0F6gn6SF/2fl3W4onrrt/6cnYXu/Xjy8p3TmT4gclPtTinS2+
zvq/G/GBBxMdq59XzkRcz8dfp3jr+vfGo3p/059a/i3TB9v1b13W979vVp9n
fu/2/XNTit/f1fsd7ET8g6fo3z+k+HTRP7jNOh4+nCtjKR+V8Mc23qZvsXh0
W18VzpcK9cFtfIye2PvvTvkIBv5EFh+K82IN54t976vndP6+t6jjZ3Ut7PnG
71p71dX3uXxG5+N5CxHX33e0p8/7tVm9/vxFfb/lJb3+7R19fmb+ls34I6Ev
BfL32Pv9aOD/xkK+mJfu0vV365GI5Tyz8Rg1/6Rdut9z2Mtz5qd4SJ9n/gkx
H81Wxfa9a7M6Po8u6vi8dFq/75aujvePz+h4n5hX/KWe4gs7er+OxRtPIx4f
+QXWppTfX0M8f4b8AH35Qe5X4nzNER+ag/9pw3+ioH0o1A+O/nBfDOdr8OOx
esLWXh5BvZCQb/aFdn/kG7Z6xfH+nw/zvCn05/2tPmzKP1h/7/+NeqnW7hDv
52B/tvo65n/T5480vq+r7WNhv1wZ8EbYix3sCQ75Z9fA36xBHsnAj6yF6z+S
7G0D+mf6x1PaXpzS9oLnIc6//n6q+5v+L4M8mzGfKu0dIS4s2k//JfAHAWeI
NyxPK7/Xlw8H/rspv6racyZ0PVbhfe43eY32S9g7N1boH+jDpkA/RnuKS+gn
PXAG/aLfofUKMtRTyoGHoR/IKO8jP5rfD3sh7Il9ebP+3s1J3hTcbxf9Yhvy
ZhvyaL7YkFflfhbvv05fWf9uSf5Bgvv0YnCe3xz3t8ibHvkDCug3/eMq/+eh
/tWJgAv4yxXIZ+mB3c2BnoR1674azrt/CXgT2m8K9DTo7S3eMcYbMB879NdF
iFfYmdaPtLt5vX4onCuvtPshP28BecfqZUZ9wC1h/O6N3zOQH83O/JXgz/K1
MJ6hfthltj67iv1BPO+gvo/VJ12nTxqMX9IfCfb7dH7LIOd8MOCREK/yxhSv
Wj/f/KFG0d7/bpnfDPn3KtjLq6BPjfFyN2B8vhTk//8Tzzdpz5E/L4M+owV9
bQa8MfifXBTiRPv8j37PLv1e96Dev88/a/7jzXp/41c2o57Si5K8UuO/TPxh
PX6LSV6pf61envFrrzyp/T+U5JX6t5fklfr9nkz8Uv1+m5K8Moi/SPKK2Ift
fU3/YNdfuazvv31Wn/eFRf3+f51S/Imu3m888Wf18+9I8orYE0vk8xmb1vPK
5Js3JPlE7B/2vWfH9X1OIB/aBUYPblJ9vtWvNXpk9WsN2/e8bk7n51ng/z86
rc9bt17q9lXwu78DfvenkzxSj890T5/35lm9/kLIQ99f0uvf19Hnvwb5WP7M
9B3wz2mTfwz5VCzetVhW7FgvEed1G/lR7Xv/a6AbI6t6Xg03sZxvo/DfGIU/
aYH2tbA+Hkr67Pr3g0l+qt/n4iQ/DfjJgzp+/wn5/cCijvcvTuv33dvV+fvJ
GZ2/uXnFt0H+/JmO3u8bKd5oQN/NvvWA0q++vF+P947QPgZ71Rjqq1RoryCP
t2D/aqEeS7b69PvJ5Psc9VWyI2o/zI4o/VubU+yoH4Y/VAnsWQ8E9UNG4T81
inohJeqDDMHemQFvbNb/EFxA3+yBC9QDabNeiPHVgb83/XuUBxB/4JvxBzU2
/0j3WcWj8J+0/IS/lOQ/wRnslaY/tvieEchbI9Sfoj1HvEgJ+5LtV9MX2nkY
Mfj9IehbM8oDsI9ZPpcDIQ/PMOo7WP4Way9hby7hLzQCf4ECeAz+QiPgv9rQ
x8Z8Xqn+gO7/+8F/3wP+C/mAKuSbLmE/dHc2+Cd5Pw/9UYv2XthbXTOforSP
Qf/ioL/57tRgP/y72ctRX3UM9VRL1n+C/m0E/krRv8342L6Et57fXpvU9iHE
09n5YXgt8Fu7Er8g2AFH/8tDOr+GLT/nLYfi8wQ7tNv+tXgt27+G18J++iL0
6YYdsO03iy+0/WjYxue76fwT7IBNn2Dr0/QJhqN99bE4PoJds13Pl0pxzC+X
znfBDu32vRZvad9r2L736p5+r2EHnAX+4SdTfmXBll/5x5GP2bCrGu0Deo18
tobNv2AC/KVhB2zjc9+Cjo/htaBfvjPxp4IdsMk3pu/IKsUx/99RfX/DDu1x
flN+YMG23p+V5BvBDu22nmL+zkqxzX/0H55U7NBu+/PjqL9qeC3M958m+Uqw
Ax5CPLF9j2Hbv0cgDxh2wDbeFn9s423Y1stNsEcZdsCWz/s5qLdh2Pjt/yvR
A8EOeAjxz0ZPDRs9/V+whxl2wDYf3+zofHyzo/PRhXxk2AFbvuPHUD/WsNGD
LYmfF+yA4/5P9WQE2/oz/1tbf4Yd2vMzqs/MzQ/B+J0zer7beWPxrXbeGLb5
OO+4zodhh/a4n1I+fMG2/kyfaOvPsEO7Az9QoX5YhfgFN6H98wntn09of6NP
cXwqxTFf6bi+b+SP0G7j1VvW8eql/V+vz9m0/wU7YIt/ivUgK8WWL/nwqfg8
wQ7t7quqX3WF4rUVxUOr6A9s58XbE/8j2M6LtyT+R7ADtvWeJX5FsO2vDYlf
EeyAbf6ugz7mukSf6vm5FvL6tYk+CY7n2Y44H4KNHr5uR3yeYId2e7/zUa/n
/J6+3w9gv/5BV9/vB4ne1fjDiR8QbOvvj+Hf8MeJHxBs6+tXEz8guH+/2v/g
FxI/INgBm7/Fv6Ee77+l761/vwH9xzcSPyXY1ksb9Xnb6Xysx/N3oa/53XQ+
Crbxu2hRx++iRR2/l8P+//JFHb91WPwlbb88L51vgm2/PDvNt2AHbON5Der/
XtPR8fyzjo7nn3V0PP8snW/1eFyO+r+Xp/OtHo/Xwx7/+nS+Cbb9YX695aRi
2x8W92b7x7ADzo+qfJcfVX1NdlT1OQ79K9aLhbzogUfmGv3lecOMvwv6N9Pn
u/uQX+Z+bff3BX/ppE/V/IHL6A88sqzXl8c0PqM8pvavKpzr15v+G/EeGexn
RTPeQ/DwbKO/PG9kVp/nH1d9sOUjivbb7UH/H3ABe66nfber/UvTA5v+AP71
Wahf+7emn4B/vQcentb+fjfiV4DLYNd+ZtLfSLsHHlnS/pYvxfRpFo9s2Pa7
vY/td8MO7S7oLw5cF3A7/H4m4gE/dG18vsyf8YOGYz740/H5gh3azV5pz19D
vpM1xPcMIZ+XyTuvSvqX+venk71TsAMuJ0EfKsUxPz3qda6LpxVs8qflQzD5
03DMh5/qYQp2aLf4dfPvsXxGEX8xrJtNsV3w8KriEWDfbJf7DwN7YJN3voD6
Ll9I/F3d//rE3wl2wNGfKNUfE2zry+yztr6ivRbt1v9K1Le5MvGL9Xi/M/GL
gh2wyYs7Er8o2OTFhxO/KNgB2/0uQz2gy3p6v9f29H6v7en9Xpv4nXo/3IF6
QXck/q7+vRn2pZsTfyfY6gl9AvWEPpH4u3o8P5L4O8EO2OjXN5O+R3CsD3Es
Pk+wQ3uUf1L9WcG2Pi1+zdanYYd22++XwB58ybJ+78/D/v3zy/q9P5/0MzXe
hPpZmxL/Wb/v38Mf8u8T/yl4CPn1bH4/lPjP+vd9sL+/L/Gbgo0/HoO907Dt
373Jfi/YAQ8hf1+0v3f1fm+C/f9NXb3fm7o6H5s7Oh+bOzofd8P+eXdH5+Pu
xL8O+DfU6/pM4l9rfu6TiX8V7IBL02elenKCYz2UZD/W+EO0m37E8iGZfsRw
rL9yXOfru0nfIjjqL1K9X8HGTxt/ZPy2YYd2e/7osj5/NO2Pen5uT/tDsAO2
+b0Q/vwXpvOjnr8L0vkh2AEPId+p0dNO2h81/TgLf+OzaX8INnr05kTvBdt+
+x+J3gt2wFGftjPOh2B7/3X+24Id2oeQrzX643f1/bbDn2R7V99ve9pv9W8r
nR+CbX5fCX+iV6bzQ7DRv++n/SbY6N+3034T7ICHkG82rtd0Xtb76QH4wzyQ
zkvBcbxRP/OliT7X8/1C+De9MNFnwUPIbx3PmwUdv4UFHb+FBR2/haQPqfGJ
xL8Itv1xKPEvgh3wEPLvRv1TR8fvlzo6fr/U0fH7pURP6/X2rDS/gm39PQP+
K89I8/u0OPpPbgry7lcDvhH4S+rvE+u5hPYceCP8gyw/TLR/PwD74f2Kc/gr
tpHPyjP/l/m/hPjOEngU/ksl/BcL5KvxwFmw9/1OshcKtvPm/0nns2AHbPVj
Yrxn8POw+lbuRuCvqD9PifyTfTzQX5n/O/JjefRvMz4S8RLF0YG+8F2m70Y+
wBx4I+InM+QLbCE/V4Z8UzniMTL4u7Xm9H3cQ0G/vTviwflt8asPqX+71TOy
/j7Ui7gw4Kqn7SXwaK/RX543Bn/6/Jj6y+fI99EO+iDzf6zgX18hf8fYLPrD
H6ZCfr0x5KOwfIdW38dtU+wfVX9Uy4cY6wEBb0R+o5g/5A8DHgb+YNA/vD+8
36q2V8ALq9rfId9hhvWdYf075nNC/Msw1uMw1qsz+7bVAasU5yb/WF7xScUO
7dE/KulTBNt5lcN/PE/6FMEl8nuVyO9VhH1o8TZDyBNQIl63ZH4+5J8yedLq
59j7W3yunScxXtf4KvOHAS53qn+26XN6Sd8mONZjTPGNmv8B7R7xu+7uoG96
MGKdr39W/yp3F/rfGehR6J+taHsOvHGl0V+e14I//HDgG2L9uJs1/4C7Fdj8
9AOukK+gBB5d0f6jVt8qjWcN74Y8cBv4f8PRHyjVz62vt/hgB2zz9cnET0n8
sEM8sfH/U+D/z4DfN5ybvf7x+H7qfwds8sC6+r319111Ur/3qpP6Pu+Ffezd
sIcZNnl1vNLrD6b9Itj2017w/yX4/RL2xBsSvyvx0bYfDJs/wzVJ/1P/3nhU
3//GpC8arOc9Oj4xPyWw6YPW1ScW+uqA7f3fAXv8W2F/f2uSf2v8cJIXJH7b
IZ7bxvP6RR1Pv6jj6eF/s5L0MfX7zU3p985Naf+PdLX/+2EPfj/8Z4519HsP
dvR7DyZ5QepfmX33HxL/Ljiu9+SvovHnwBniw3LgjWHcx9J+qX/bST9Sf/+1
x3U8r036FOFHovz8ROwv2NbnunrL9e+GZE8RbON/CPrC3dAPGrb3WVcPWeLf
HfAQ/OnX6J9v8QnwL331nN7v1UnfMsiXAn/P70Ff+L20HuvfDyb6V39vG/6b
hqN+F/WaY74zYLv/AvSFFfSDVVfH+wr4M14O/8XLE30axD/DX/F58E98XpLf
pZ6N6QOOQv9+tKfj+YZZHc9fm9Xv/bVZff8L4F93Pvzpzoe/wbdgv1iGvWJ5
Sd//9+HP9nb4r729o+P/ynkd/wz+aRGHdRft2cGf3OJ9/D3BnmnyMOzTFeKD
xpa1v9+u/th+B+q17ND2PKwzy2eQIZ6o1dX2wsbJ+D/gsaUGPzi4b/IHFWz0
5/XJH1Swa7YP+MPEb0s+B4f8DuWkyp9ZpXioUnm0moR8inbTR56f/NsE2/n6
suTfJtih3eo3xPoQFudj+C7FBepRjCJ/RQls6yHma98O+g1s5/3HEr0TbOfX
h5J+WbADjv4pyT4p2OZ/W7JPCnZoj+sF+r3XQ793CfR7l0C/d8mSztet0zpf
tyZ6Xa+3/zfpqwU74Dj/Pb3fy3p6vxf39H4v7un9Xpz0rTX+K9Djv0r0u56f
zyD/ymcSPRcc13ui14L797vqqfHcmPStgh2wyXsfTv6uguP7H8P7H9Pv/atk
n6znM9ZzqBRHe8W+eD/BDu2R/4D9ZQPsL0OwvwzB/mK4jXouG5HfNgeO/BXO
r2vTeVeP1yeQD+cT6fwTHPmdRR3Pt6TzsJ7vy5K9RrADHkI9Mdvvv5D4iXp9
vCrZQwQ74CiP4Hy8saPjPdLR8R7p6HiPJH35QH6DPeQq2EP+APaQP4A95A8S
f13f/7ojev9bj+h435rskwP94Qkdr4+d0PH8WIqPkfMz2v8Oxv6KkW/UPaz0
3W+FPWtrw5418E9K61uw8VOfS+tbsAOO9lH4e67N6vyszep87FzU+XgU/puP
pvUq9TWNv3op/D1emux/A/3Hrji+gqM9dHe8v2DXbB/ok+Afektaz4KjPwX8
QX4c/h8/PqPPn0jrsx6fE2k9Crb+N/W0/5d62v9L6Tyo8XkY//Nmdfz/A/7I
/zGj8/Ef6TwY+LPDH/kw/JH3wR95H/yR9yX7W/27Bf7mW9L5XH/vKPzNR5d0
vkZxvr8E/gsXwl/hwkRvBvFm8JfvJP5EcHUW+krkz8uQn7wV8u29wPIbIT/f
GvKbL0xpfw99aIH4i4LxF9Cnloi/GA7+tZafagT5goZhzxthf9jXYn1Qsyd+
HfU8bgf+eqBX9+v5Z9e3Uc/DA7eR/7DN/PDQbw4jH1R+DvEo57R/dk77G/9g
+bbKk5pvqjyp/odVsLdZfqo8tFv+7fwk4t2CntHi19rI191GPoVsBvmwZuD/
OKPPt3wqbTsPtgA/CnvaI7CXPRz8DQNuwz7mgUd62t/yxcTnAa9B/nDI55VR
n4/vX0N+Txfq71g8on9E4w3bqOc3jHzDbdiTctibyjLMj8VHPab6Ur8N+lLg
frvkT9vI+mq0l6IeVwv1gnLgFvKzZbAHrSF/cj6luIX6Ly3YjzK0x3x2Vj/g
s+HX/Ju94gL+xqOsvxj0G7eZPWYUOOStMn7ZY/+PgL467PcK9Nr0I/H+K4qH
wJ+PgL4UiI8bRX7yEnh0qvE+cj9/TuejQP2dAvk+S7QPhfe3fHTmT/NbSf8h
2KF9qKP5e9qTej7krC+JeAE3rPNZYX7Ljtpjx5Dvbwz18Sq0V9jvwx3kj0P+
wzbyBeagJznave3rlK+8bo/55h7Gfn8Y9nDWD3oY9vZHFBeoP9nfT4Nfq1f3
efjTjABbPi+rN/lF9Xfp9xc8Evhqy7czGvwJYrznvMbfrM2pPWxtTu1nDvkf
siPaPzui/atgh7B8Mi3ErwwhP9zogvojZ/B/yIE3Ip9bfhD+zbfBvnub2vfd
18J5Zvb/wGeYPaS1Gq4P+eTGwn6z/HNWv3Vd/T3BayY3Bf+mjauaf621rPGJ
JfxLRq0OevI/EZzDvrwR9KwFnCMfm9+MeEnU33DIJ+kf0uf7rYpN/tmc+GnB
Jp+8KNmPBRv//pfQx/1lkg8kn5tDfreoPyz1+YZN/njlSW2P+Y8mNf+bQz44
k1csH5xdb9jo7ZNJnhJs8s0m+CduSvKR5I9zwNHfOtlnBdv4fuuMjp9he/6V
0F9dCfvaduiXts/q930B/r1fSPJ9/fuvUzo+/zql7Z+Av+wnYJ8ah75nHPbU
O6C/MTxUaX47B+zhT9M+o+ef6UvecFy/7w3JHqr+VsA2f2fHdf4M2/efgH7F
sOkrLjit3x/xzWqvdF9Vf0FXKB6yeKQgt5n/yDp7p/RfM/r1Lzofr5vT93ld
kp8lH59Dfj5bLx+F/uaj0/q9kd4A2/WrXb1+tavj+TvQt/wO7Jc/nfab4LVJ
zffnkP/Pvu/Ns/p9b57V518I++6F8Hf/4+RPINih3cb7+9B3fH9J3/d9HX3f
98Ee+Zp5vf9roE/6s0rvb7h9VOX/HP6bG6EfcFa30+yToX7tH1l8LOyTo8va
7uE/WRxT+3x+HPI06ju3Ua+kjfr0Fpce60WDnx2dxfNQT8pvV31tn/+tx8vy
E27sKi7Bn4yyXsQ48j8zfxxwfhb6C+ij2sj31Z6GfgT51/0u9efKd6n/VoH8
+KNLDf8ueZ7t30PJf0Nw9IdI9lzBDtj2639N8org6G+Q7LO6HoELyNMj8Gcd
hr/rCHD0n0j+ToIdsIf/eYF61CPwlzf96zXwL7kG/iXXwL/k02M6np8e0/E0
bPr8y+GPcvmSvv/l0LfeBX+Uu+CPcte09r8I+bku6mn/i5I9s57PL4I+fxH+
JV+EvfI98C95D/xL3pP00/Xzrkj2RcEOOMb7JXugYAds8vVPIb/UTy3r+P8U
7CnX4by4blbH/zrY994G/5W3wX/lbThf7knxhJJv1QHbevtV5Hf61XS+Crbv
/SecL/8Ef5d/gr3uw/B3+fC8jv+HE79W/37wiI7HB2F/u/iEfv/Fyd4m9NcB
23j8Q5ovwa7ZLvlm7fv+E/auA/AvPJDmS/LROuSnjfGqu/T7YvwCsM3/vV1t
v7er3/OTM/o9Pwl71Ny8ju/cvLbfBv/Wdflw6+97Dr7/ObD3PSet33r9nIa/
6mn4q55O9qJ6fB8Dv/jYko7/Y6BfP9PR9/0Z2H++AX9mw335fhBvuD2Of02P
X5n4M8GO7SEfieWHrQJ/ZPkO1wJ/FPMdzmq8i2vGvwzi2RIenB92voX732D8
2DHUOzmm/bNjyD+F+1ez2n9tVvtn4Xx8nvErwGvQH1WLWn/SsR4l6pFVyAdc
Ij/MaNAnjaZ8MNK/QP6XAvlibp/T6x3yAw+hvtwQ6s9laM/m1b7fQj27HLiF
51WoX2fr1Sd9bX3/X0j6WsEO7eUZzU9SnQn+1Sm/irSPTGu734v5Avamp7T6
RHvgbwXcb9f7+WCvC3FusX5w0FeOId9xCeyQ/7jFfDCW58viTXYqzndqPtY8
1VUZ9Ld6Aen/9fi+NuEB/5vqoUq7zV+0N9wO/eIdgX8MuEB9zRHWnwAegfxQ
IN7EAw+v6PM88iO3US9wGPUlPPAw8iEXyL88sqL6UuPPvgx7+pdhT/9y4l8H
1yX+VbADtvPnKvgHXAX5+Cr48+1Hvrn96Twmrq+3+M/oj5/iRQQ7YHveb8A/
4zfgn/EbyT+jHt9/SfEggh3ajT7cg3xy98Bf457EL9f+Fp+Cf8an4I/xqcQv
1+93LOkXBTvgalLj7WI+k5T/Q3CMn0jyk2AHbPzy6+Gf9Hroy14Pf7xbwZ/c
Cv7kVvAnH4M/0sfgj/Sx5B9X05+TST8j2KHd9sO74D/0LvgPvaur37sN+eO2
gb/Zlvjrej4+B/+hzyX+TnCMdzms479yWMcn4gc0vqrPLw3in1N+NGkfXtb2
GL+T9KWCHbCtf6N/MX9PypchOMYTJf2DYAds8/cg+PsHIa89CP+261P8iGAH
bPP3kkT/BDu02/wtQb5bgny3lNZfTc9/G/l9fxv2j99O8kV9flm9s5i/KMWH
CLb9cBjy4GHIg4chD/7yjI7nL8Pe8cuJHtXr6zzkazgP9o/zFrT/TugTdkKf
sBP6hJ+Fv+zPwn7xs2n/1/vvO9AnfAf6hO+k96l/JyB/TEB/MgH9yRvhz/pG
2DPe2NHxfy78VZ8L+0bEd8PeOIp8CVZHJNgb+/xS/bxYb2BH0A8aPqv8YoF8
fZn5ORq/Bby2hHz4yIdcof5bhXqbJdstfjTpCwU7YBvvb8Ff+1uwb30r7W+R
p4x+3JD0h4JjPCjsQ+9N9h3Fd6k91v0z/E3uVOyNzlo+xcdB/1C/rES9n3y7
YtsP70Z877shD7878WNaL7pS7IBt/78C8vorIK+/Iu2H+vdvEN/7N4l+Cbb+
FyD+9gLoJy6AfuLPYV/980SPBNt+ewP0E2+AfuINiT+qf/cmfaJgB2zry/zF
Yr68lG9bsNH3H4F+6kegn/qRxO/U4/sB2GM/AH3VB2Z1fC5GfOzF0F9dnM6b
+v1egHjXF0D/9IKuvv+nke/m0x19/08nelf/XgH90xXQT12R+JdBfHjSBwp2
wDG+HfrBdfK3YDsvjR7GfJipvodgq79i8lS+W+UnB9xvF3mqLz8LLuHf74Ft
Pv4C9vm/WNb5+Iu0Pur1OwV/76m0PgTbfNwN+/3dsGfendZH/f3Ph33g+ZCn
np/4EfEPjfktk/+9YLv/DfAHuKGr97+hq+PzPej/vtfR8fleWn/1+b4H+en2
pPUn2Pbb/0a86v9O9EiwjecK9K8rsE+vzOj7b0X+x62wV29N/Eg9f19FvOpX
E/0VbO//Y9Df/xj09z8G/f0x5Bs9Bvu/4Rz2xhbqB7Vof4Q9s0B95wL2zaHx
wfqw+kM5/M0q+Ks56Eero3qemz9ZrO/T1f1t/vGmH3pm2P+PQn9h/I+N1+fS
eNf6sLUUnzKgF2W8vr7fs05q/+GkHxict0n+r+nFybRe6vG4JZ1PUs/W6N86
+2WNTyR+qf69CvLz/ll93pch//7HlI7HpyC/zkA+HU30eyAfpnoa9f1fmuQ/
0S+XrDcxqf469vxziZ8T/baNz2VzOr5DS/p9/xP5B63eqLV/p6vP+4M0/vX6
+tm0H+vvW+rp8zbO6vUvXtT3+9GuXv8nHX3+Lyf72OA8ML3xfeo/kcMfIYM/
QAn7vq3f0XM6H50kz9b9X5Ds7fV8mv+HQ3xDdUL5cVvf0Z8/+FvHfIzLKn/6
EvXFgf1jqk+y9eXn9P3/aEzH+63gP+8Hf3kx+MevgD/8APi/Fvi7i4I92CN+
Y2SmIZ/U7/eKZX2/vwZ/9u60Pur1U07p9+Zdvd/X0nqp19PHwS+9GfzQhSe0
PeaDf1Dnxz+o85PPajx8DvtRe7ax/+r3L2x/djG/iFcY6jXmt/6+H5vT+TqW
xqfeL782rfNj/qc2nlu7+j7ZjI7/Ms73f8b5/XzY46sFfb89OF9fjfPze3Ze
finQ/5Dfu438DEXw/31OskfWv79i+sWvoP4L8uOtIV/cGvLB+UdRj+uD4fy7
IrRb/aCt+r2/YvYm2FMiv2z2j/+j9oA15JvIoW+I8lGiF3peT6r+wOjt+9J+
F3uTzcdrlnR+/35a8U+k+a3H55NpPTzx1P3etKDfd0fa7/VvluS1+vnPXNbn
f3RW7//aRX3/n8Z6vL6j7/dO1K/6S+RDevtu7f9tnEfbkS/89jAe32V8IeID
XYhfs/wUOeLdcsS7+Rnt30Z8VhvxaR727mGs343If98GHkU+/QI4C+dYjO85
qfEeG1GP2G9R/4phxK+5M8p/Wj2v0YQH+9H0zR3tX6GeRQV7rMVTfWky4nr8
zN44NKX2xlGzn4Z6DhXiXyxexuZjLKwr80cr0X80vK/lF8lPoX7ZKczvKb2f
R//ilN6vHNfv72MZnwL1SC2eycajPKfjUZ3T8Sg6yg8WqDdbnkK+xFPaXp1S
fV15AvVbzO5v9axPDN7P8ssUM9rf6l1b/9EZ7V+i/9iM+jt6PL99Au1lOG/D
+ZiX4by18/TecH6HuBWLn4v4buQLXEY74msz5BN0X1P7srtPzysf4nTHkn2o
nu8PG/8A3Ap0LearekDb3WbFfrP2b6EeWga8Fs4t83cfntXxHEa93BHEP2fH
VF4s4e+QwT5uddLMX6KF+sF9/kfmz85nm7+sA34Z+3mkad8Xecrs/ZYPLt+n
+d+KRe1v9ZBjf3zPxiX4l3b1/C9PIx76tL5vcVrpgQc9aI9DPjmi8rAHbqM+
eRvxZcWc9i+Bx1DPfAzxbG2r3zsR8WDeLJ48nMcWb7kB9YOHgAvUBy6BN4T7
s76v4Q3hed9FfIThAvVzS2C7/uqeXm+4QL3XErhA/dYSuEA91hK4svwlqX6k
0n/UcyyBC9RTLIFbqE+WsX7ZA8pf+/tVXnZtzYfbx3K+uhPqb+aPq/zTx+o/
14X/w9Xh1/7+XPntDPkCMuQ7tvrr8fxEfU339UB/74148Gv5E7YhHnWb+r97
8DMbEd+dA6+Bn6iWVV6w+EaLlx5lvXf492WIHx3BeZnBX6oF/6gs0EPLF2/x
2tHeuVnl15L0AvrDAvRgFPrEfI/Swxz+cUOg90Pgr0ZQb758HPXTYP/Ljc9P
9oPBek72gvr+b0xY6Tf0rzmw1W+P9behn8xR79sD59BPtlAfO2vi+v1Mf7mh
Wf9acAb95gbUtx4CzqDP3NCs5yw4g77T6PG6es2CM+g37f7r6hMLzqD/NHq8
JenzBGfQF1r/dfUxBReQtzywm1B+ugr7/GqL5z+F/BOnNP9EG/H0bnfY72a/
DPHDli/Q7VRcLqu/oNEL4ydb0C9nwLY+rN51C/rnDHgD6lm3oJ/OgO38tnrV
OfTTHtjOu1jvGfprD1ygXnML+uoM2N7H6g+3oJ/OgG18rD5uDv21By5QD7cF
fXYGbO9j9Whb0HdnwBtQb7YFfXcGbPd/eZpf0YdnwLb/n53mq/6N9SOBC9Rn
zKEP9cAF6kfl0Jd6YFsP303zK/rIDNjoy/9I61P0kRmw7f9Xzuh4Ls/reC7P
63haPZ+yp/TcQd+YoZ5KDn2eB86CvGT5SobCd0T/Z+A29BUeeAT5QSze0eQH
b3QtxUeKPO/26Xno9+r55wMfFv3XTW+QzjcZjxbi91s434zeP5nmh+dZfb9N
aT/w/Krbr0z7vf5dd17Vw7Md9H8/8HhHr193Hkn8+wacP+bvHvO7wt7mgXOL
r5rT/Wn2tAw4t/jNJV3fZm/LgHOLl+wqvftO2v+Cjd+wfNEt2Nsy4A2Iz96A
89XuZ/mbW7C/ZcD2vpa/uQX7XAZs/LXJj30s+6c8A/3rHuRf3qP2aW95CQ/F
9xnwcyvxferuZq/LgB3yG+ew53na95C/OIc9zwPnyLfbgv0tA7b3f8uivv+7
F/X9Ddv6svjGFuxjGXCOfKUt2M8yYDep45/DPuaBbT1Y/ssW7FUZsO2nnel7
699j6XsF2/jc2dXx2drV8dna1fG/Ke0PsWdlwNb/JR3t/+qO9n91R9+nO6fv
8705fZ9o77pV430sH0XEmzSfoLd1GviTfAX6RdTjasM+lgO7xzX/pyuBH0P+
u3HlVy1/WMy3PQG8W9eLD/yw5Us3/iCejzcGfcGWOB6Kb9Z4ntzqD1g9hpXG
+SX2FA+cw37mgXPkB28jn5AHbsG+lgGXyHdcMP8Q7GEZcAv2sQx4CP5Fpa1T
8weG/j2DPd5tVv2H6ZctH6B7UNdDTvoc/Ccsv7TbpfJQOavylOWXsPxeBfJR
uLXwG/IBVNA/l8D99Sv8jq1vy8/gHm+cF7Ie/QTGC/n2c/h/tJHfPQduwf/C
7h/rGSGfew7/jDbyqefARh/NX8P6v6yn/V/W0/7mz9FGPvQcuAV/jzbynefA
LfiD+KCPs/zlxl8ZzuEv4iewfpC/PIc/idE3yz+eA7fgT9JG/vAcuAV/E7v/
jeBvbuzo/c2/xMbf8mnnwC34n7SRbzoHbsE/xOzRkT4jn3MO/w57n/Nm9X3O
S99b/z4/fa/kK86BW/DvsPHZAn51y5KOj/l/OKsT/3fh1/4s/60P+znU9XAj
iv2c0ovcztWEB+vF4iZ6ut/zHviXsA9Mn2jfY/XncuAW/D1MPjJ+tc3zbDvy
x8CfowV/jRz+Gi34Z7Tgn9GCf0YL/hk5/DNy+Ge04J9RsB4b/DVa8MdowR+j
BX+MHP4YLfhjtOCP0YI/Rgvycgacz2h+oDzc1+ThbEbPc4f+FezjeTgPrR6S
1fO09dSGfdrdi/14P/ADuh9z5BPzwAXssa6D+Grz45qIWNZfvozzG7hCvp5y
GufxtPqjVNOQZ45qfL8DLkO+Aovnt/0R428gX9t6eDnOy4vBP38D+s118nPd
/1Ti/+vfBeADab9QPq5/f7Oj7evk3fr+G+a1v8m3PvAvVh/dB/7F8iOUs2ov
sXqFxv+VHaVnVQf8zxbM54M6fxnX4wPg1xeVH8rDOBYJD+irxbM+ru3GL0X9
0YS+r9nbYv4wq+8Q5m8j6Fv/enle/3qhd3Y+Xzcdrxf6Z+3n97T9JxI/M+Av
ZmK70Ec73351IbYLvTT+Y+5YfD+hn/H798f2wTzsj/cf0Jf0fkJf7XyxPGsb
QV/t+ms6ev31Hf3+y+f1+9+Z+InB+bYc24UeGz9m/Lzla7D1Yvefm9H7f3tG
5/e+BZ3f7YkfGIzPUmwXeh7zXdwf8eDXzv+bVR7KzX55d7g/6KP5y9j3mP90
zCcc1rud735R+YFyEfLB7eHX/m4N/S1/t+G/CXhE7auxPvUjEct+z1chzwJX
kAfLBexH7N8oH5k9Y1XlYQfsl3U8HHAJ/sh3YN/vqD2/7Oh52R8/8d9xo8D3
gp7dD3vZveD/C50vm5/4/rfH6/9/MhXPlg==
      "], {{{
         EdgeForm[], 
         GrayLevel[0.8], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxMnXm81dP3/889994z33Or263uuaFCZYwMKVJI+SBRmccGUwiFhEQiiowh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            "]]}]}, {}, {}, {}, {}}}, VertexColors -> CompressedData["
1:eJzsvXVUVd0a9o2IgYABGKAiIgoGJooCrhuUBkUBKekOlTQwCFERRES6BEEa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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, AxesOrigin -> {0., 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, AxesLabel -> {None, None}, FrameLabel -> {{
        FormBox[
         TagBox["\"Slope of f\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox["\"Fixed point position\"", HoldForm], TraditionalForm], 
        None}}, DisplayFunction -> Identity, AspectRatio -> 1, 
     AxesLabel -> {None, None}, DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope of f\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox["\"Fixed point position\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultPlotStyle" -> Automatic, "GridLinesInFront" -> True}, 
     PlotLabel -> 
     FormBox["\"Quadratic Score, L2 Distance to fixed point\"", 
       TraditionalForm], PlotRange -> {{0, 1}, {0, 0.95}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx11wk0VP3/B3BKD0nalDUiebJU0mYpbyJPKpGytOspJSm0SqEoKbIUKW32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              "], {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                
                LineBox[{{7.499999999999999, -112.49999999999999`}, {
                 7.499999999999999, 112.49999999999999`}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.499999999999999, -112.49999999999999`}, 
                    
                    Offset[{4., 0}, {
                    7.499999999999999, -112.49999999999999`}]}, {{
                    7.499999999999999, -48.85077793493634}, 
                    
                    Offset[{4., 0}, {
                    7.499999999999999, -48.85077793493634}]}, {{
                    7.499999999999999, 14.798444130127306`}, 
                    
                    Offset[{4., 0}, {7.499999999999999, 
                    14.798444130127306`}]}, {{7.499999999999999, 
                    78.44766619519096}, 
                    
                    Offset[{4., 0}, {7.499999999999999, 
                    78.44766619519096}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.499999999999999, -96.58769448373408}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -96.58769448373408}]}, {{
                    7.499999999999999, -80.67538896746817}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -80.67538896746817}]}, {{
                    7.499999999999999, -64.76308345120225}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -64.76308345120225}]}, {{
                    7.499999999999999, -32.93847241867043}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -32.93847241867043}]}, {{
                    7.499999999999999, -17.02616690240452}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -17.02616690240452}]}, {{
                    7.499999999999999, -1.1138613861386057`}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -1.1138613861386057`}]}, {{
                    7.499999999999999, 30.710749646393218`}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    30.710749646393218`}]}, {{7.499999999999999, 
                    46.62305516265913}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    46.62305516265913}]}, {{7.499999999999999, 
                    62.535360678925066`}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    62.535360678925066`}]}, {{7.499999999999999, 
                    94.35997171145686}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    94.35997171145686}]}, {{7.499999999999999, 
                    110.27227722772278`}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    110.27227722772278`}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0.`", TraditionalForm], 
                    
                    Offset[{7., 0.}, {
                    7.499999999999999, -112.49999999999999`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.2\"", ShowStringCharacters -> False], 0.2, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, -48.85077793493634}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.4\"", ShowStringCharacters -> False], 0.4, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    
                    Offset[{7., 0.}, {7.499999999999999, 
                    14.798444130127306`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.6\"", ShowStringCharacters -> False], 0.6, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, 78.44766619519096}], 
                    
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Blend", "[", 
                   RowBox[{"\"SunsetColors\"", ",", "#1"}], "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.`", ",", "0.7071067811865476`"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "225"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.88521952102642*^9, 3.885219572769462*^9}, {
   3.885219613180532*^9, 3.885219634272341*^9}, {3.885219710109791*^9, 
   3.885219737482883*^9}, 3.885597057465117*^9, 3.885598278978518*^9, 
   3.8856034742978287`*^9, 3.885603853833736*^9, 3.885604151191375*^9, 
   3.885604714082036*^9, 3.885604918743272*^9, 3.8940428409470367`*^9, 
   3.894045410475749*^9, 3.89404608068472*^9, 3.894050486880262*^9, 
   3.894062535008553*^9, 3.894065414015472*^9, 
   3.894071373538988*^9},ExpressionUUID->"c7566919-dce8-4598-a8d3-\
f8e06b8e65bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"ArgmaxScoreDistanceTof", "[", 
    RowBox[{"fp", ",", "slope", ",", "logscore", ",", "L2DistanceVect"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"fp", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"slope", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "2"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "9"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"ColorData", "[", "\"\<SunsetColors\>\"", "]"}]}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<Fixed point position\>\"", ",", "\"\<Slope of f\>\""}], 
     "}"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", "\"\<Log Score, Inaccuracy (L2 Distance)\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.880097377120878*^9, 3.8800973887532663`*^9}, 
   3.880097818463387*^9, {3.880133225961153*^9, 3.8801332285523233`*^9}, {
   3.880133695318523*^9, 3.880133696468699*^9}, {3.880185002460396*^9, 
   3.88018500361873*^9}, 3.884985194410718*^9, {3.884985322485621*^9, 
   3.88498532261657*^9}, {3.884985495174603*^9, 3.8849855583045588`*^9}, {
   3.884990036641227*^9, 3.884990036702044*^9}, {3.884990242095236*^9, 
   3.884990244606378*^9}, {3.885212673884796*^9, 3.885212677808182*^9}, {
   3.885212727215603*^9, 3.885212742311245*^9}, {3.885212866636422*^9, 
   3.885212894271187*^9}, {3.885603520559477*^9, 3.885603522451804*^9}, {
   3.885604266136791*^9, 3.885604266274371*^9}, {3.885605129101041*^9, 
   3.885605129789062*^9}, {3.8940461259328423`*^9, 3.894046126022924*^9}, {
   3.894118378294898*^9, 3.894118389945153*^9}, {3.894118696015897*^9, 
   3.894118707254259*^9}, {3.89411876925209*^9, 3.8941187696799507`*^9}, {
   3.8941190476811323`*^9, 3.894119047988117*^9}, {3.89411942233606*^9, 
   3.894119422402199*^9}, {3.894119974185524*^9, 3.894119974305538*^9}, {
   3.8941222695177927`*^9, 3.8941222700431128`*^9}, 
   3.894140118278246*^9},ExpressionUUID->"137ac90c-f41a-445b-aa1c-\
e0ec5ba29299"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJyN209uXLkRBvBGkG2AOYJyg7mB3hGCnMAIkHVyhHeEOUIfwYssZpEFZ0aW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      "], {{{
         EdgeForm[], 
         GrayLevel[0.8], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNnAXUVlXWgG8AShlgocLYgT0WBtgwKCqKhd0d2Ali6wii2IGNqKgY2DUm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            "]]}]}, {}, {}, {}, {}}}, VertexColors -> CompressedData["
1:eJy023k0Vt8bMPyKUhlCSURKGkUqpcK5SMiQMo8hc8hQVGYihGQeSsYyRZnn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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, AxesOrigin -> {0., 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, AxesLabel -> {None, None}, FrameLabel -> {{
        FormBox[
         TagBox["\"Slope of f\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox["\"Fixed point position\"", HoldForm], TraditionalForm], 
        None}}, DisplayFunction -> Identity, AspectRatio -> 1, 
     AxesLabel -> {None, None}, DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope of f\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox["\"Fixed point position\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultPlotStyle" -> Automatic, "GridLinesInFront" -> True}, 
     PlotLabel -> 
     FormBox["\"Log Score, Inaccuracy (L2 Distance)\"", TraditionalForm], 
     PlotRange -> {{0, 1}, {0, 1}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx11wk0VP3/B3BKD0nalDUiebJU0mYpbyJPKpGytOspJSm0SqEoKbIUKW32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              "], {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                
                LineBox[{{7.499999999999999, -112.5}, {7.499999999999999, 
                 112.5}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.499999999999999, -112.5}, 
                    Offset[{4., 0}, {7.499999999999999, -112.5}]}, {{
                    7.499999999999999, -53.90625000000001}, 
                    
                    Offset[{4., 0}, {
                    7.499999999999999, -53.90625000000001}]}, {{
                    7.499999999999999, 4.687499999999992}, 
                    
                    Offset[{4., 0}, {7.499999999999999, 
                    4.687499999999992}]}, {{7.499999999999999, 
                    63.281249999999986`}, 
                    
                    Offset[{4., 0}, {7.499999999999999, 
                    63.281249999999986`}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.499999999999999, -100.78125}, 
                    Offset[{2.5, 0.}, {7.499999999999999, -100.78125}]}, {{
                    7.499999999999999, -89.0625}, 
                    Offset[{2.5, 0.}, {7.499999999999999, -89.0625}]}, {{
                    7.499999999999999, -77.34375}, 
                    Offset[{2.5, 0.}, {7.499999999999999, -77.34375}]}, {{
                    7.499999999999999, -65.625}, 
                    Offset[{2.5, 0.}, {7.499999999999999, -65.625}]}, {{
                    7.499999999999999, -42.18750000000001}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -42.18750000000001}]}, {{
                    7.499999999999999, -30.468749999999996`}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -30.468749999999996`}]}, {{
                    7.499999999999999, -18.750000000000007`}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -18.750000000000007`}]}, {{
                    7.499999999999999, -7.031250000000007}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -7.031250000000007}]}, {{
                    7.499999999999999, 16.406249999999993`}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    16.406249999999993`}]}, {{7.499999999999999, 
                    28.12499999999999}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    28.12499999999999}]}, {{7.499999999999999, 
                    39.84374999999999}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    39.84374999999999}]}, {{7.499999999999999, 
                    51.56250000000001}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    51.56250000000001}]}, {{7.499999999999999, 
                    74.99999999999999}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    74.99999999999999}]}, {{7.499999999999999, 
                    86.71874999999999}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    86.71874999999999}]}, {{7.499999999999999, 
                    98.43749999999999}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    98.43749999999999}]}, {{7.499999999999999, 
                    110.15624999999999`}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    110.15624999999999`}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0.`", TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, -112.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.05\"", ShowStringCharacters -> False], 0.05,
                     AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 2}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, -53.90625000000001}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.10\"", ShowStringCharacters -> False], 0.1, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 2}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, 4.687499999999992}], 
                    
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.15\"", ShowStringCharacters -> False], 0.15,
                     AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 2}]& ], TraditionalForm], 
                    
                    Offset[{7., 0.}, {7.499999999999999, 
                    63.281249999999986`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Blend", "[", 
                   RowBox[{"\"SunsetColors\"", ",", "#1"}], "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.`", ",", "0.19239431002043073`"}], "}"}]}], "}"}],
            ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "225"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.880098721984057*^9, 3.880104902731605*^9, 3.880107951930748*^9, 
   3.8801110339032516`*^9, {3.8801332259611998`*^9, 3.880133228552372*^9}, 
   3.880133697525837*^9, 3.880134230546941*^9, 3.884985225350854*^9, 
   3.884985384391724*^9, {3.88498550129039*^9, 3.8849855513322153`*^9}, 
   3.884990027927861*^9, 3.8849901463395*^9, 3.8849902458752527`*^9, {
   3.885212722305395*^9, 3.885212757531448*^9}, 3.885212889176958*^9, 
   3.885212936563908*^9, 3.885597059722508*^9, 3.885598459769803*^9, 
   3.885603854038266*^9, {3.8856051233467503`*^9, 3.8856051304784927`*^9}, 
   3.894042960204723*^9, 3.894045710956233*^9, 3.8940465679715567`*^9, 
   3.8940507040212717`*^9, 3.8940628199471188`*^9, 3.894065762231587*^9, 
   3.894071617522449*^9, {3.8941186916926823`*^9, 3.8941187033879633`*^9}, 
   3.8941187656393423`*^9, 3.894119030172802*^9, 3.89411939131443*^9, 
   3.8941199253004007`*^9, 3.894120750483251*^9, 3.8941243770096397`*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"61d7dccf-235b-40a3-851a-ae5778a25c9c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"ArgmaxScoreDistanceTofp", "[", 
    RowBox[{"fp", ",", "slope", ",", "logscore", ",", "L2DistanceVect"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"fp", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"slope", ",", "0", ",", "0.95"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "2"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "7"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"ColorData", "[", "\"\<SunsetColors\>\"", "]"}]}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<Fixed point position\>\"", ",", "\"\<Slope of f\>\""}], 
     "}"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", 
    "\"\<Log Score, Distance to fixed point (L2 Distance)\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8856569520886908`*^9, 3.885656961937557*^9}, {
   3.885657041718816*^9, 3.885657079835997*^9}, {3.8856571114936867`*^9, 
   3.88565711182485*^9}, {3.885657189775708*^9, 3.885657212059742*^9}, {
   3.885657247131674*^9, 3.885657261180973*^9}, {3.88565740260821*^9, 
   3.885657405282393*^9}, 3.8856574986156197`*^9, 3.894119986596764*^9, {
   3.8941222610039787`*^9, 3.8941222617885113`*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"0f33ae8d-a81b-43e1-8a7f-f3f29c12dfa5"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJx1mk2IZFcVxx8uBgbcCYK7yEBAcDGYMCAEqiAguBLMSsgiCBEEIQshkI08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      "], {{{
         EdgeForm[], 
         GrayLevel[0.8], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNmwfcl2P3wO/7tknZoh7VEymVvbWkFBkJhURmtqLMehtKyKrIyCqFhKSh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            "]]}]}, {}, {}, {}, {}}}, VertexColors -> CompressedData["
1:eJyVm3c0l/8b/43sPVJRGQ0jIlu4L4REKAoNUkYZFUKlRSJpEElJRLL3juy9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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, AxesOrigin -> {0., 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, AxesLabel -> {None, None}, FrameLabel -> {{
        FormBox[
         TagBox["\"Slope of f\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox["\"Fixed point position\"", HoldForm], TraditionalForm], 
        None}}, DisplayFunction -> Identity, AspectRatio -> 1, 
     AxesLabel -> {None, None}, DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope of f\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox["\"Fixed point position\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultPlotStyle" -> Automatic, "GridLinesInFront" -> True}, 
     PlotLabel -> 
     FormBox["\"Log Score, Distance to fixed point (L2 Distance)\"", 
       TraditionalForm], PlotRange -> {{0, 1}, {0, 0.95}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx11wk0VP3/B3BKD0nalDUiebJU0mYpbyJPKpGytOspJSm0SqEoKbIUKW32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              "], {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -112.5}, {7.5, 112.5}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -112.5}, 
                    Offset[{4., 0}, {7.5, -112.5}]}, {{
                    7.5, -48.214285714285715`}, 
                    Offset[{4., 0}, {7.5, -48.214285714285715`}]}, {{7.5, 
                    16.071428571428573`}, 
                    Offset[{4., 0}, {7.5, 16.071428571428573`}]}, {{7.5, 
                    80.35714285714286}, 
                    Offset[{4., 0}, {7.5, 80.35714285714286}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -96.42857142857143}, 
                    Offset[{2.5, 0.}, {7.5, -96.42857142857143}]}, {{
                    7.5, -80.35714285714286}, 
                    Offset[{2.5, 0.}, {7.5, -80.35714285714286}]}, {{
                    7.5, -64.28571428571429}, 
                    Offset[{2.5, 0.}, {7.5, -64.28571428571429}]}, {{
                    7.5, -32.142857142857146`}, 
                    Offset[{2.5, 0.}, {7.5, -32.142857142857146`}]}, {{
                    7.5, -16.071428571428573`}, 
                    Offset[{2.5, 0.}, {7.5, -16.071428571428573`}]}, {{7.5, 
                    0.}, 
                    Offset[{2.5, 0.}, {7.5, 0.}]}, {{7.5, 
                    32.142857142857146`}, 
                    Offset[{2.5, 0.}, {7.5, 32.142857142857146`}]}, {{7.5, 
                    48.214285714285715`}, 
                    Offset[{2.5, 0.}, {7.5, 48.214285714285715`}]}, {{7.5, 
                    64.2857142857143}, 
                    Offset[{2.5, 0.}, {7.5, 64.2857142857143}]}, {{7.5, 
                    96.42857142857143}, 
                    Offset[{2.5, 0.}, {7.5, 96.42857142857143}]}, {{7.5, 
                    112.5}, 
                    Offset[{2.5, 0.}, {7.5, 112.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0.`", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -112.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.2\"", ShowStringCharacters -> False], 0.2, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -48.214285714285715`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.4\"", ShowStringCharacters -> False], 0.4, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 16.071428571428573`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.6\"", ShowStringCharacters -> False], 0.6, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 80.35714285714286}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Blend", "[", 
                   RowBox[{"\"SunsetColors\"", ",", "#1"}], "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.`", ",", "0.7001283176329618`"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "225"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.885656964047111*^9, {3.88565703821307*^9, 3.88565706897727*^9}, {
   3.8856571054925833`*^9, 3.885657124264448*^9}, 3.885657207112658*^9, 
   3.8856572374713373`*^9, 3.885657293409749*^9, {3.885657487746067*^9, 
   3.8856575009296827`*^9}, 3.894043090109679*^9, 3.89404656820936*^9, 
   3.894061216145199*^9, 3.894062987990094*^9, 3.8940659787426243`*^9, 
   3.8940717689296703`*^9, 3.894122231464424*^9, 3.894123127366782*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"e9381a3b-b3ab-48f9-87e1-28b7f4f56686"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"ArgmaxScoreDistanceTof", "[", 
    RowBox[{"fp", ",", "slope", ",", "logscore", ",", "AbsLogOddsRatio"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"fp", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"slope", ",", "0", ",", "0.95"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "2"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "8"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"ColorData", "[", "\"\<SunsetColors\>\"", "]"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<Fixed point position\>\"", ",", "\"\<Slope of f\>\""}], 
     "}"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", 
    "\"\<Log Score, Inaccuracy (Logit Distance)\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.879946898653883*^9, 3.8799470058862*^9}, 
   3.8799470640624228`*^9, {3.880007993486939*^9, 3.880008008633127*^9}, {
   3.8800086404952183`*^9, 3.880008640684217*^9}, {3.880008867618395*^9, 
   3.880008867828517*^9}, {3.8800089802630167`*^9, 3.88000899475076*^9}, {
   3.8800187465426607`*^9, 3.880018749972186*^9}, {3.880018780834051*^9, 
   3.880018798974208*^9}, {3.8800194908289013`*^9, 3.880019514313109*^9}, {
   3.880020350061304*^9, 3.880020351108276*^9}, 3.8800923063792*^9, {
   3.88013322596124*^9, 3.880133228552423*^9}, {3.880133692219152*^9, 
   3.880133693495989*^9}, {3.880185023432127*^9, 3.880185024420596*^9}, {
   3.8801883601250134`*^9, 3.8801883614214582`*^9}, {3.8856035294297247`*^9, 
   3.8856035315193768`*^9}, {3.894123516138361*^9, 3.894123518459998*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"b4bbb044-fadd-408f-af6e-ab02d86ba893"],

Cell[BoxData[
 TemplateBox[{
  "Visualization`Core`DensityPlot", "exclul", 
   "\"\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{RowBox[{RowBox[{\\\"Im\\\", \\\"[\\\
\", RowBox[{\\\"fp\\\", \\\"+\\\", RowBox[{\\\"slope\\\", \\\" \\\", RowBox[{\
\\\"(\\\", RowBox[{RowBox[{\\\"-\\\", \\\"fp\\\"}], \\\"+\\\", \
RowBox[{\\\"(\\\", RowBox[{\\\"\\\\\\\"SearchPoints\\\\\\\"\\\", \
\\\"\[Rule]\\\", \\\"500\\\"}], \\\")\\\"}]}], \\\")\\\"}]}]}], \\\"]\\\"}], \
\\\"-\\\", \\\"0\\\"}], \\\",\\\", RowBox[{RowBox[{\\\"Im\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"-\\\", \\\"fp\\\"}], \\\"-\\\", RowBox[{\\\"slope\\\", \\\
\" \\\", RowBox[{\\\"(\\\", RowBox[{RowBox[{\\\"-\\\", \\\"fp\\\"}], \
\\\"+\\\", RowBox[{\\\"(\\\", RowBox[{\\\"\\\\\\\"SearchPoints\\\\\\\"\\\", \
\\\"\[Rule]\\\", \\\"500\\\"}], \\\")\\\"}]}], \\\")\\\"}]}]}], \\\"]\\\"}], \
\\\"-\\\", \\\"0\\\"}]}], \\\"}\\\"}]\\) must be a list of equalities or \
real-valued functions.\"", 2, 73, 2, 31821824797390173531, "TwoOutcomes", 
   "Visualization`Core`DensityPlot"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.89406121630866*^9, 3.894062988138751*^9, 
  3.894065978901416*^9, 3.894071769064398*^9, 3.894124378320684*^9},
 CellLabel->
  "During evaluation of \
In[73]:=",ExpressionUUID->"d8dd6e79-cc2e-40bb-9fae-886d726b2fea"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJx1XXmcTeUbvyERSpQlfkyUiELWiPdaki3KTtTYSmOMiShZOijNIG5II0s3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      "], {{{
         EdgeForm[], 
         GrayLevel[0.8], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxN3WW4PrXRBvDzyDmP/PFCcXd3d3cvvDgUt6KFAsXd3aG4U4prcSlS3KVQ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            "]], 
           PolygonBox[CompressedData["
1:eJw1l3m0jlUUxl/33vdzv/2iK5FEES4VEg1utRqktXJVppBI3KR5kEaVylys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            "]]}]}, {}, {}, {}, {}}}, VertexColors -> CompressedData["
1:eJx8u3c819///y+rSERUSkgoKmkg5Hk3siLJiCLZo6xKViorkVU2UVZkZpa9
t+wZsvd6RkhW38fp/cqzz++P3+uf1+Vyvdwut3M/98f9nHM/x7OjuhZKBsRE
RESCu4mISLD/dw9M0bzp8MOdV5WqCbv/GFdAJZb+KygU12Q+/2XSmRJsF3A0
0Yo/cGee+fkGEdPBrul4502tFFg3cTDdMgiENS/HD9M/MuGhWHCU/50UuFvl
Un/PMBCoYn7HKC5lAu8CjckkmwXuy7ysp8jHG7hhDaugGc5HuPgxi+/EB5Rx
zg+lLCabhXGOe3WYuvA3caa4N8/2x0/DPTppyZ4nbfB6X+Sn+INfgOjPf9/h
ct+SHOPKHEQ0c4jF804AvvkU0WjcNLxOdV6zwvQRA3YjvoxfoHu3FBfDFh7y
G/mvM5SPQdTyhRcHnpUAbtxUqehKF2RttM3wrJbAxMzyvNH7AZhKnGBE/MTt
uDLElX9zRyN+3d2NG/kcoRC9g3ykT18NQz6ktRKXA1Sv486GcgOFuCBupnYp
mc9bDcfu5GrxRawbLhZnyZW9LQXK6ospNw8OwsVa3lD/6RmwTmn5lEfeCcJi
nLfVZKu258VctDzNJ4aHPUHGPs+rZ8GVhpf7eDAetF0cblOLDYH409rTinlZ
2/pU5RMqPV0TcFyQI9FgXxOQPD/1HvkLnehtRP7nYvdwIn9h9+s0OJY7uKXN
gInXyVI400ByNnN2A9xfn9nSDkmfbxPw4SFjXealpm1/66nO7yiex7ta4lE8
uMJI073XuqHv+Ip3SlwpyL0PUAuiH9zWHxKyyzzXOAsDLxX4F88Ow8yBMCpx
5nn4ycUxbni/B17mN1DdUc6BR0KKjxdTbuNIJ7ySXd9J4pS+Nu/24dLHyXNf
24H0CqpPm5Ce9Ph7K6TfGDHcx9+CB/38fN2t+hGQV7Q30XmfD9WaTN8ZDrXA
Q+rq3+ozOUDJ1p6kfakLRCRJOMi+ZoI3h5BT6Ew4NE05HbP4mQedWoPpLUXT
EBIRrGqV0gYXVnVCPJPq4cVZxVbkU7eu0Y58BFfUXJDPwfd3s5DeZ/3jLaQv
5snyQnrj9IdqpJg/6bdM1RDMX7xOgMoc8/+bhzSyxHSUh5ZuBx6UB86NbkYU
/zsJoiQUP++jQzy6WPxT2in2yaJSuF3JTNI3+Hlxp97xxUwIK+CMvCPkpB/V
QQlbT3mmVCYUPTpJqvKrBVyayfZyPsHDqB6IOh4ZhH5qbYE9Uekg3knmUpU0
DcbsQ2piL9rAUmL9ziGSL+DUyKK9KjoM1Y63ncbna2DSIbjsochXqK58QYt8
dqZwXkc+Np9uGyAfNo/TcjeM8NDTpio1eb0fiH8yB2vTpELkL5FryGf4DZ8Z
8lm5VdyBfGTM6gqM26RxhVb7zEs0zuLa+N7Ze55RxI2X3buE4qfhr8lB8Sdt
dP9SxuK3snQ5HynYDbLklkpDoaWgTmF4OunQICQoxtEgvu/KThHEFc39BBD/
m8/d6/lv7U5OwRmuSddwtfZtPn512hrxR9FZS2/+4bePzIHK6ATYNv/6WGbW
BHueEP2Z145sPXE0r8fRul5oXuoHA9vv5Y6CkkcN5dZQPegr2Ce3WXRu++yk
tj36rnoaVoOZeLhP9cCVwyUrSP/pk/95pCdSyH7+rx53Q9iJ33UeuLKl+WqD
pra51tXGqbeYT4Squz4X5vOXP9hs8UZ6UcbUe0j/1Z5Hsb1TB/d8zzU2rS1Z
nHfYzvstl4xxTf0KH++p4aGs8nQv0Vwf7Gm/GaV4ORGOq7b94X17asYRf3tr
pgTx7fU7WzfR6j0JDJHBI2lMrXDD5kPWE8kJuHTSZNppthE4u2urv3u2AV+g
ay3iJY2KJM4Yl/dhTkP8r0+SOdMS8jGtPb83HfP5y+32PRU7pDEFGzmHDx8g
7djmVj/jjHXyZiFZwf6RQt8QxKQ9xBuW6ePSh6YiE0ABd97ceYfbBVMcKX1e
ZAFXDez5Jm/0PiwdnizXfea92wwLGgXKiL8U5zuD+OcHT1z+8K/O9Ld5p0BR
t8BP5k0zfMEFjCxrtQCNbejrL/p4kN77lvH3wX6QueTb526VAvtqfJ9blFeB
42HppLDANNB+w3Lh9VwjXDrljZc7MwRX5HfpnvhQDbotqfbrD3uA4+kWsZhk
Gpzn4nwhlB0MnlJ3g/gOfwJu2ueXJLSw9XuOeNnU7Rvocsi0FY0lwZrtrmMd
ldOg7p5S9jwfW3f6TdHynlhd9I3RneCbgUDZrz9bw9rhTZD0WWvPWmDjW+NC
8UzmeRujeDJq0z6/wuI52jI2gOK50ad2DcWT1nvfC8XD6cEjhMZt/RlQgsZV
KYy5jMZttWOjR/5sOipryH+lP/gk8qeiMiZB8fiyi7igeIgCLl64isVTzMXw
TBSb1+Tr71WC2LyK+3lHLmDz+vu9TrNdv4e+F5vQliP6XkakhX4onyyRx8+j
fA6HULJ5YPms66U1dBZQwtGqC2aJeArh4jP9E06VqOO+VqeYsj7tBG8z2d7D
eiXQGvH0lKFv/7a/s2fnveFRrB7Ux3PX/YdBTXaBE+m/T9l/QPqKH0UNBpje
/5cc2UuqMhhb9liKlE8EqojuirrnNUDhn+5EOTMGJdakUoMKDRC2mKNMxdAB
5m/5bRCnBydBxHsEI+4gTheES/DAfO6/MzZHPg93VEsjH9py5oOGX07hQE3j
w9l1elxnkuiSyqvz2+fg/vMcrrpeeDhrwiKpQzW/Hb+n7nEXxPn9O0URv/2K
jg3VYUV3exiqQ+EN3nZUh3/1R4vzyEXCZsBglEtwjPPbNg9OG9yBeM1I8PF/
+Ql+uotc9DOg2aP+VF2sF6xLZ3VphvDgVeXLmfZkFKrIwrK/uhdCb9hFV6OI
CvgxrltYQpEKdxN/WosRfwE9aj0WxJlLHnEjrun1c04U4zRpRWTcZjVwnXT1
cmV9Otxrr9jaCm7eHtd1fZcqWr/j14d00PpVUbfVR+M67R4RQOO62BeOonH/
6htq2Dgt3s2BsmrZ1LG8sW3u/VXbBH3f2NOSH9H3bTz3WUDUbAQ8Bpp6jFXr
wPJDv1L+ZBe0Z+6Xgq94CD35UOYA5ygURmmKuYYVbPuEMI7vKC6dhL2t/Iy5
3a3gLchB21+bC7fMAsdbaqPBQ0FoYci1FNanzmSemDqPu/LYJeoIyRGcEJ7m
leYeYZz2tbMeOteTocH+fMTrqABQENVeKLuUCfoS8le+YT679D+pIh/Kcva7
yEd+dUfmS/x13ENjWi1tNiGcKx3ljL6WOk6i2HdF7KIfHEjx7VDxsgd1KRs8
b2kIEIc+nLiD+Vu/7TF9hfk/XgrqKMX888xID6P5Zlh75aD5JnaZP0Tz/Tsv
UhqlP/MKzWQ+gOZlvKCgMRFQAiaNpx/Lcn2A4vRDGmYvCH1g2c+fv3zuzAOZ
rfhpvdVJeJy3LpiUPgiXfjJKnqSrBsWYdzoviHvBa76CJNBlBPa5xAnQWdaB
t6FopH5TF9BuJZGz97cDefFUGr1xEcThGffw3+qDs+S5Qh7XemC1R48orLsM
uh+58JqTD8CQ7Ln+Y5j+WQT+EdIb1x3u5MP0phaVswGYv+LNs0zIX71WPQ/5
x7Ed53tgOAFlRTR3erC+8ybV4cNehoTzwurYQRtUJ/xb4dIc/9TJSM7VNTQv
XapsHjSvv/zLqXcfFi/OQ+mP3bs8rk9CpZ5P0SiWn+il/GRJLD/HHJ40mvyT
H1vytn6kb2eVXkR6XBTfRVTnFicLTFCd72Tdc/T3P3Uux3gsgrEEDxFEAdV9
M/Nw1+mYhH8NHq5TmfGcvDcC0j9fuH2PyIMZZ77LiA9wmAkh7ufKE484rGZb
eetg/adJr/e55m+g8XA4zjo1GUavKP7hd+//cEV8kiXeB3HOjwIbjHbzIBOH
v/7ueC+kaj5aI9ubDRdMHT5exuqq9w51gzpWV891NaIvYHU1euyRPFoXA4q9
vmhdiHG+J3mOrQv2zefSKM/znltWKM93u8XJUZ61riwdQd9RzkwAH4p9R8ei
DlH0Hf/Ot1fH7s98L/XvqkXz/R7aTz+3hgfbYm/Z9HdjUMW0KLuoUAKsLzoY
EBcV0VJBXFDzgzri1xJ3BFpP4OGJz6KDfeUoyO/dqXdavgi6TxyufRU9C3f0
At/X2nRBQW9AtfF6GSQxUWq8fosHugNmTrwBQzDK3eTkGJ4N1+Nuxz92xMPT
HXjPYfFByAkfI6sgzwARm9cJy6c6oG2HbtZcTxFkn3Rtka/sg4MCMqaI29Iw
aCDuFAtPEe/1oHTXOKmEa+sfbHe3E8JpFT0hTfyojvOlPPBwPBwP35U9mJ86
DYHO8lx+lEk2DHTy/eHyUcMsiJtbhRYj/jc/jUvQTD8xDc+TGCcOvO2BPOJ9
Tum/x2G/3lbrqdBG4Hrvf+tYbxtI4qtfIU5KXjyGeBxfqQzif336snjPMWA+
tE9qZBkxnx/8+93pe3RxKlbsvSy2crgTBezE1BEm2+eLM1dMTPHeeTCVWtBs
iZnY9pm3lg9H/FKCkAjin/RaKQMitXE6KkpK8kIyOG719S3ZYEOcheeNcwUi
Q2AfrGBokFsNVunHzEP1emB4dMyFjm8IzslPpOz5WA2MN3FVZmY9INRoo4n0
NyTehCB9zoIqDul/OwUGIP29S22lSH/M+lom0vPcUOENf2OAa2Hr9TjhcA3H
G9ONi9EwwyUOqB70pR2CuKu1CvGu1dBMIfA6N7AHYtStzS8kFcAwaf174pFY
SLaq462xKwceCg7mxdJ2qK18Z/IbVwSqixRXJs73Qf5Oj6CF9glo51XeWx3c
BPpDldwnp1qxehQNzMDut5v+Ck9Yi6phhajL/NCdHuDKEm8dihuCtbjGnHn+
Gqhcc/p8ZfYrRKTZKW3snoBj0o97vsY3guNu4SLehjawYv0dcx6LR/y4LB2K
pzoJ4quxeLxi96UtYPHswOFqt7B4XNmfZo1j8TyTdSJB8dgG1mhXYfGoZ4S1
oHiKep0/oXEppFKC0bg8bludaNz6/+IkDvhfnN//i9OHkgpQPGEnZctRPFQu
Uu0oHoVd/YYK5jdxxdRU7UwvxHEhWlueqVI6OAdfdUN77i9QHqjUJfg8C/hU
xG+qsrWBiPv1Q4i7Zc+/Q1zPKJwD8b91cuneh+VNeuw+nShRf/wToX7oZqa1
rAbxwBhpOJ9ig9/mizEgjfitnczu/3LpITKe4uBx8Kt6+3SWlLCvvrk2SFeC
8XIJ7tVFjLt60i3z1WvhTG2juW9aSOGOP/p5Tn1GH/cpxY8F1cNTfTM1VA95
2UQeqB7++mi8WH9cWTULlN8CZHpoh7e5T/8X0/zWaRgy0vIyVOmByQO8A6sB
WF8lTjMWdmIIRjr0H9TaEN43ho7xJg1fHwdWh1XKecoKQn/1+dJjF+lxGJqp
/9VYXA5mHlxqw+kx8EOcldQ/wwsC9vgNiZclQlaYl72kVTScJpHjrB55CXWy
4WN5dAkgfoeGcVW8BMpIknHj6fFwzLlr6NDBKrhL3uknr5EJAmmm9CYXwmEh
gm78rXwecB322P/2fBE8+nH5+QRRHNwjl4rRdK2Ah0eWOS5j/mquJPyVmH9j
ce/+XMyfkePIt0Esnsa0y99eYfEM3ZwbEMXiCb1Vth6B+VCMlt1HPko3GV4j
H0Z8/udXNBmwO3mukuJ6GHw9Xqk84ZEDREnfXvzE4jyfffjeGBbnIpMfE4rz
bx78EjjWUT08k9sY/rcejh9vcSvA8kxBm+RxV4XwXVh4n+7Nfj8LZbT5B1ad
h2BnS/Qgyv+HfLlllH/j4tdvUf6Pbwk+LmjGg4ZTzYGkqhHI1eE7NRqUv+0z
dedWBvouJO7fcP9+F/HIM6silXgoqpSUZSDGg9aJDyM23VNwXpPf3nCgBc7Q
R41GNzaBSPuIgBJpPRgX/oydTs2E9g/2Xo63WuGY676J6xg3OX3gLuIztwJU
ETdm6HQcdW+FS9SGEm078oElNvxWMc/X7XFHPxe5ycrOwTy/8OVvkqPbnNY6
oqr65TxY73ycwJ1JuI/z8cieFEieBsfzJXbTNV/BlvaBykZzCfQVLQp3OH6A
Pq5bFDRfq6Aq9JcBl0om6CUXfCTmDod0IUutWfE88NyMxBF55sBLetWjzkNR
EHiPYkoiuQS0dJstTTlj4exYsJeupjfcGewMC9VOgpjwXe7OdEWQZ50dUTP5
HsynpEb7zSrgyY3fHtxFoUA2/fWpXKkzWFqq/Zp3iAL30UN3d4vMQbH2vsPx
Kd2QzfGE7ARfCfA/UCDfYJwD/1u3IpWNuoFScOjBrc4S6EmnOplGNweKdBcX
09S7gZg67ub4zxKIoyeTLirHA1vI3ltbF0aANTT3ykvKPLB+OVGQuHseFGim
VZjke6C+OOCI8lYOWAVePIbyEEcsuNSO5SF91LaKGssD5dWDZ5C/8m3VNeSf
F0EljfxPnLb+sucGHmb5+va2DfdBucV7nheiiWCqvjCzjsUp4WZ7D8UZVnlg
FsWpeJ1BA81r8f3CRhw2LypanytoXpevxPyJU9F4SxvFaV3tfxvFGZHBceD3
yxzwa6W+4oTlmURUgRXluVLsCXBieUsUeqElg+WNa+d+mlksb14nztxDecaV
pbmjPLN/SmlGeT7ddHPEB6sfP8lLLjew+tl1Y2Wn3D/1M3iaA4fq4Z0uVRGq
h+19NVeqEtUP5Ux6DKqffK+K48vYfGysOr54ZJcC19WQULc9g/BY+Q1NK0sD
GMyYxa4KZEM2aVkLUW0bHKqtp+D51QyRdQWPDPNzoEfn+O0kmi6Yr67NasH0
bJoSukgvWE0TgPSfhLuJkD81b2g28u/ui45F/q/rqZgeGfZB5wONC3MHKsD3
8s6TPzq/wXdFm85QklSw5zZZnPkWCLu3Xu0r0suCcnsZ4tZnn4B+jqFYTT8S
Bv2yJTNfFwFNA5F3CKan2qNDjPQ1R0vOF2L61BRrtxZMf+jWoD7SR6bbR2Rg
+o4+rLGPmoCHq+GiIzebIO52cvvGMWxeTyqjOpbxIJzy5vIbwzEYbt66K7uj
ZDtvw4Vj08QfJ+CGqMZU0EwDXJXm/52O7TPl1nrijhxDkOgGxmoWWVAqtkCv
BAPA5CpSRV5fCVJ5ffqWgn3bPldN3nBM2k5CvMTQ/oVmwv360od6roT2Kdja
zH51taAT7E19VTdf6eCisz67hIXI4rRKdtbPfTPCHRz9Fbfukwkddl/O5zwL
h7xpz4Auvzwo9LE8aPBUHWdChP+l1C2G+3FrLjgzRht38/OMxgOf+6AisvvX
WMBNONVJomrXYwP58juvvA56CccEjByXtB5C7Kfd1xZo/ED3ucEJAVkvCO6e
+PD2jRU831gb4BfwB/7Eiq01bNxHAZm4z9i4XUM70jqxcfsFiSWfvtLFqZZO
Wo1TyeEmWHyJ9wma4KyfM+RTig7A6KId0SMsD5SuVdE7/8nDY8PacLH5GdCi
os87oUZ4VynntjqG8qCdUGSH8vCXH1ISEZ3C8tZbYrx/GctbOGs7z5Oqz0B7
VDrjhlIUxFQKvqzgLIHpd4920/6uBj5t+zWfx+ng6Nf2/fxVwr2pQOTcM3SO
nz5me+Pfczy5npgYh+3zDF15D9E+3884bcT5bA52au6xEj33FcZDLyjdpywC
hds7fiqn6+GmOc/6lqfL4yaEnls6ld7FtSmQHhPC8jZxyLU9Essbjod6/CKW
N2FPFeUgLM+zDXknV7E8K5NO5y1hee7dek6F6rBy5fIZVIcVe0+MoTpUNl37
U1eioWtXUF1pz7x9hupqe59Pa/xIitUhU1xWbgxWh/e4viY4YHkI+6V/HeWh
5PTIGZSHv/px1tP1YfvnoVkWWlgKJ0DzQwXvr494eF9D8+CG2jC0ql+qe/Tx
M7iN859FvCFurw3i3MpfuxA//44/TfoxWhcXm712DcJaZaURlXE6CCTPpSIu
/6q5FHGG0/6iiDdSrG+6m+LhyMskFZuqfpCoqXVzlv+4HU/tvVRA53VpfNwI
Oq9zz1y3R+eyu3LQHnQu072z2YvO5RNS82LXNN+Dge4t3lkWX8DNf9oXTZYC
mxTGnq+xvsImVmONEusrNpc0H05ifUU1PBuUx/T+jmo5k5heoTe96y2mfzv9
1F0O63/E7W68MsL6n1P8Fxwi5Al/1wgds7NDfZdeDuUc6ruwIu1E90HR7tFi
dB8UkZLyRPfBmkjrFXTu17zGv0Pnvrsllw869xPjayqYcRPgfEZzX/ZII8TG
POy8GtAGwTqU++J9umHx3OiFmC+lwPoqJcyLeBCEL1Dou4m0wM8ISu8N5lz4
ZXmI84VpF+AGOuNjRpqgVGOxP174M1A9uufwNaED9LsVV+Mwn76D39mRz9Ur
4tHIJzqs5xLyqfi+qIx8zp3o/+6G+dz+1GaKfBRXf2Qin/pIFRXk83e+V3qN
P5c6TkL6vgY/rTnC/lPxKKsecR9n+b5/eeKnHq2TeePwdms1VWSL0Kc5B+Vp
Im6x4f/uXz7cSrX/oOE4sK/zXZSPqIDuq0ui1VifnjndqxJQNgDHdQY/CG2m
wRqZeyc6Zw0paTjQOcvy0OqRG3bOsmY0qZ3A+pMfOHrOHVh/cmnlDn4a609E
mrx4kE+G4MkcP8yH65yVzUXMp8jLFJ+AnfsUAsU5h7BzP8OT9tkt7Nzn5M8j
vof1LanXuG20sb5lPedBQjDWt/yN81OK5p/+ytXTXxz1VxdShyTQeRTrxSaP
ziOF8+b06DySNqX9cRo77z41vFVB5505uxQOnXfb60tB1K0hewoMcdSZ3vKE
/cpOY84Pcfmp5cF/ec5xIxynxRRUlfFwpckTvksIs3EU2g/ZuZvq0H4orxtl
/Fg9EpzdD/zGtbyAImNFJ1W+OMgKlrphj3H6emULEYyfvu9DpYLx7fO9OJ7o
Dbbef/6+mcOKrfea0noLtI+9d+1zQftYgVI+BdrHXubxOmunzoL3s5pue98u
CLHscDlUWQayPuc/OmPnRcpWdtkmdl5YnZZx8cXOi8sMd4LR+fjx2o7mMOx8
vGut9UUGOx/DjinNl9ThwesAcXywywhYkXzk1x/Mg451me+IE43sLET8olzY
A8S/F67JDhbj4cso9ZdoCqwP73b/6BeQC9o3ws+PMOPhORv7D26rPijUNKzd
L5AK01ppFjV7quC0cHiMOG0aMIsFNJetNABL3Bujwwt48OkJtgw7OwZPati6
NR8Uw7wb3vAM+vvy9M2cu9i9NkOc65FcfhZkcjX/NvbAQ7HVU71fcYNwuXWn
8/4DmXCh4Fp/Q0UL6Gcm6B4azQXjxc05ZfZu+HY9o/R7TQsUC5FdPTqdC7X+
QuGLXN3beVYk2XH+ouQEJHNq3dOYq9vmxJoelFlm4yDFEjlr3E64R5iPrX1/
ehe7z3D0fFNbr4cMrSNZ2dg9VilqJrbMbhToS0fnuZ4WgpgP9SeOYTz4fT+Z
POgxCmS/yYhJEwthwiouMe4nHpyCD3P8sh+Daz7emltMJRBcLOO1OdAMjJCk
kBGUAxEJgxv35zrhhRO7LuJ8YRK0iHdsvi1H/G88NmSPWbWTZiHDsD3H+s3Q
Nk8QevCH0xmn/uHM1x4SkU9p4rqdflhQ7ZXEJT4roKmO0dt+/2HVl39UcBYP
plJhj+NcZ0HNcq/l8cBeEFNqE1sPKwfLl86kGVf7gcqQlrj0Kh7kUoD4dGsf
dKWL7D71NRFWha11kB5XdVgQ6T0066mQ/q8/0X/+45L/8/cj+RSBfIp6Hwjx
YD4Rd1v7WDGfs3O9+B/cOrj3CqL1sySyOLVwbhM5ZSPcSsJQnWkOHvKudCsd
/DQMTEfonkil58Cu+349eKMZ6N77uDeVqAPGLasyN6JqgMe9oQbpz7C9FEZ6
I9MEEaQvqml4j/R7LaLvI31/uF7cJqa/3672Y2/YKNDlNcf4FNTD4NNwXyP/
TtC6mkpcIlQCkbaXNGffx8Pp+FTm71RVwBtVI0OL6UNXWil8MX0jcSIP0v+d
70nzGrKW8knI3VvreHGwFSimy7Law4LAVaTLnszWEVLnftAafnoL4dJ8bTrj
uXCEluxUSH80jGKXENGQUvCjfnIP8Rhlq8FgjLPzVMchzjDQqdGC+ZCWu1GS
YD7RrinPdTCfv+OeSPOlQOPST9r4oHHvi0uaovjpnh9YQfFvtrGnovhl/EeP
cewugxla8oWQK4nwZKV8eMylBvYZLEazY1wzlo0P8YrN1+cRbxFKdLx3Sgen
Lpi1ay+5LO4bXjFVVtUIZx4tIzP6BA/mpIeW2zkGwYVJbODz53To7vSRRVxK
U4+kA+O2myzkORi/MHundrfjFGQqVWlS8LTAFTuahqCMZvj24Wwx4o+f3pJB
nGjWehTxwzQrgbdyb6L3xh+1heK4xhrHvYl2OricmwXvZPdr43ZYOLHXW0rj
QvdllRn0GuCWjm1YXb7QDRFrXA9Tg0phjkhYnpdpEHbUP0xAPP6ggx/i9/rV
Rf7w5bjYzzHGuAeH92y4/LiOuxLGcoO60BKXqd76WeVmOpCJROU5SocCs91M
uILfZ4iW4vnIod8HwqunOb32V8C+zNdZ4t3fgEzKRMf/VQeUx/I70JsWQ+/J
QvH38t8gmFx1fmdbL5jW8d2cwfoS6+gmlmDufhC/+T//zv/8h/7zl3zwQg/5
FzeS/vLE/J35nwwg//zqowzI32d57x7kT1rA2BuL+cOcWTPy7ybXlEb+EF/F
i/yJ/n//+w66IidH3k7OwXrrcrTxyjh2D74i7hmChxvMvq1xikPgbBPUUTSa
BZPc10UQp8+pDkOc50SbCOJ/faoujE4hH9UW4hLk85d/uHd00CRwHNZ6HiiR
L1Vuc20KIiqb4Wk4nmF1Sdub8P6T/JBtB+IFpocZ/uXvljIlkc+HgqUfOzAf
ResbS9G5xrilTe2jDiRKOInQV/KL9Za4n2Nj+591YXHKnFSxphsFTX81PSaD
AnjE4cuK+MOvDiWIi++kfnkE44U1J0nmSKfB2fCxl//FVugwueAtTNwEk4dN
m2cxXlTxkRPxihh360vEhN8dkd4oqeRdnwG2QP6m388J+5vkXFlope4caHNP
W2xlEt55atpDqU76zMH48+h+N4sxKFrlNukQ1Mb9Ojv+PChWGvfaUVY7fbch
jmEm8/fAkQL4XWwnvNshFupIpF5WMpZD/o+A7n6Mt5da61NiPOtVbWkFxuU9
hiJvM4/CQFtyUP+JepgUvxRVztIFW903tK4UzwL+u8GmUXoXaM1NrN+wKYOY
gK1wpM/A7/JD+j38798jvUpeQhjT+VHYdfOJRYxYPQRVchgL7uqC/Tnt15CP
6qDcIPKJeRKOU8N8/s6LoTw0/iyWB6r7h3eQuBHykGP2af3W9CwcYNdhiUwi
3MsePPL8k59TNmvmKD+9qzof22VqIWSXq0zTvQzIfDx9VvA0oV+1YsmecKme
h0SZXRaRudOEOuG9+Ycr7nhs9i/nYpyzbYnAgwPdQ5fPavPg4JkVoJqPB0Un
7aJPncPAeLBAgpwyF0KLnn/LWMHDrK5VupzlGOyPoqyxoSbcs161Ex/YOzIG
Xi0CX8QnCbzk1b0vpth91tgjevlBPmGflz3+sb38/DSI7yD//ome0Ff0zVjp
9aRMQF1u7fnzIw3bXCrAfQz5jH0IUHz4jw9R0LMopLfl4Fi+8I++TGkoMvzY
FEiFWMayCbfD4e9ktjGrc6DksfPsAkcPXKfk+SifkgvjZEl/5htQvFyI5usY
FSqO5nuYLHTTZwQPOfLnL2eGjsL9MNmuvR2FwLH3zBTKAwvv+QvyWB6K+Cft
bLE8PH0QItbfjfVvX0Nedh0dhVjG6fwlnwLse51680F6CC68+mGGq6wG4Tds
YzfUe0C0/cTaecZe2NTxWdhQLIfNtGRL0oB+YDN/XYb06h7r4Uh/itIyB+n/
zovj1a61TMNpiP2VnM3T0A1hPNluSQPTcCJYSvsmvg0ii45YOdHXw4Ly4QAJ
xSl4Rf6J5WxjM3gw3SWyYCXUSWZcV7730jyQnsp7JuYwAw7PaHJ0+8bAm/f+
irZIA1DY2OmkcBD685rHO6d2GmDrPnfFkbW6Gw5d9bdA/pE0Fp28mH80l4HK
v/72XIz8JZi/NzlF9OEnMzDAQ9tzknUYLJlKqgura0Au6wVdku5X2N8p/hqN
W/aAuQaN21L3zBuNW3PF6eZlxlJwtT/15vj0B1gLHJyUEK4G39ANsekn7SDG
Ffmmv7cQznD9+mbb1Qv+AT2mvzma4OKASdeT9E9gVV34g5SrA4wvXZlB6wVu
cFmh9WL+I/wWWi9+1wuVkN5KTq8C6e/hiIaRfu0//2//+Zf+5x//POfuTYtK
YA5P1UoU/ghyD0KsHFkI9bahKumWOjoPj1tu5CYKzIBIPDWRLKYf8ll44Ifp
O2l8Oe/+o89YsX2O9G9jR7KR/m5NeLAENt+mlDhHTmy+xROWQ+LYfM2uvSAO
VeuAEvctb2rGYvA+vMQj/JvwjlTzMTZyeS+23k8eScqLJfy9wC65QAaS5gGK
lGhsgbDeUxQ4+ZZlZsFW3t5VaXQABPS4QnCJTbDutXaqi/YzBHGt/ex1Jnz3
trywu0z887CmMB4rJUn4+z6VhVMDtTQeGB/vuFA3OAsjmYMTFv54kDlnT2Fw
YAjspD1IVmSyIMrjQ+gza+yeW5t6Yuj9AERrnw8605kGCjE1T3Zj49bvLF1I
x8alsooXzf1n3G9JQz8XxvAQM+ez39iX8Heu2Jt769G4uSJWXGjcv5z9ktif
ON++0otBcV656Kcm8HIKVpyjyyzEW2DhVL0/3xvCO9irQ9YnU7rHYXFiOudc
bzWhD7RSN3dcm4AlIOY8vbMZ8F2OMQ6VeLB1/vztpcwITFl0euZBHjDcOsN+
x24MhouPsXNXf4FOy6dh5EGE+FPKrJ5ybIzDYbrsJca+GsK+9GjtixLDFLCa
9h/V39kOtixn03Y/HoIdI47WIcQ1EENy5dQuZsJ6l0xsVncRnAFRsvaZ8Jre
bc44SUbeLToLazxtjWffEn4nQGm8qKlLOwlxyb0cu281A+XXB7rCWb2QHCgW
4Z6CnX8trNf3XiKcO1JD5DOUNnPwoYgqMHg34XcdY0eGXYP6ZmHhUuPjo5aE
82iUcjl8QXwGsgdK1sqne6HqdkIAip/dLloVxR847Sb3b/zh0fdeoHhk2JOL
UTx/+SDV0SMoftp4t6BzWPwnKkLIj53LhNmGN7nmq2/AwqC9M50+D1R+nDb8
bN4BxdzdV4qEiiFJKFI5lvkbHKYaz0Lc+qdnIeJzcgFFiKvo4H+SYN/FemlU
trDqC/SzUlOb//NdpOUaRXdyTwMNyXdpqwXCO8bt9zV/vstdcu4/3+Uv99A7
Jo++o4qjhPtB7Du6p5mP2GjhgXJHSxiF5zfQ2r3OIreYBK7kkl0hv/FQXpI1
QdM+Bg9rL0TwBpXAo6rzp0is54FIWWCP2VHs+12x+mZ2Khve6kTsVsHOneFa
lhfvsXOHx8vJtIsiF5zcdJteP5qH9/M8CR6svcBaKynryJsNZZJ1D9xC8SBR
PHQ4XgNbX4mDWinE2eDcI0yFfK547fVBPu+K9J4hnxkV9km0HgMsLanQeky9
GrIbrcdXK/WiF7H95Crnl9dOB4vhGg9l7uctwn7iPDVxAe0PxjvvOKP9YXvd
tdw5jvaTXzjOZzbYftJjymuE6qqAYn8kqiuna5YK/9bVizTqCFQnESVH1lGd
bJ8L5SdeoLpSORD7HNUV7lrzbx5snXbpBJDfwdbpnZ7wUvT7O630sQS07p68
NOLwxNad68thhXwgvFtu8UyqoXW6+q24/RS2TsMlvVNLz2ZCULze8ODPN0Aa
kRZwmp6g9/a3smKKmYUsoujdJTaE+37AxssQE6U5SPpWqyVvNgqlE/RxiTF4
EGX+fFajYQj0z2o5UF78BBlCn+MRT5ehuIz4g5MCqYg3fmH9suKOh28hlWur
UYNw0fJctT1FJjiF+NYhHn/n/BTidhl6wYizrSXsYXPGw/Hf14x1VQfBrS1K
mVEwA8RF25yWimfAYlXT5lJ6B+iPsURe3VMN5vukXiJec/2aO+LHmqTtEB+p
cHjwVngaunyJo2TiWuE2rj6ngrwR9OkY9BBfJ2ZyRtzo6rvfiNMdoteS8JqC
ZA7lkZdSLaDk0zblGERYj+mvgjqpzk6CV0bpnpwvBH5Cl6QB8e4f9DOf/+Hs
DBaLtPITcN4s3uUXcz3hntKo14f4ZfatkdV/eAH+h5YMO8YN9Y82bNVuc26H
2j99b+uTzD99b6Z3SCnqqysHVyNQX72WsiqM+mpuMhKHc7uw/o1HqOm9RDf4
FRYZsp0oBc2EadtYc6yPuZDpF0vXC6douBfPWWYD64PxSzeN8NAQ7iTHrdQP
wnb5AvR7U8G9ILXe78M0aKjsZexwbIO+mEC+NtovsDgmndZCOgtWYSxqWsKd
oLkZoP+xuRLMxK9UXrs8C4uZuxdy8zqhfFXxWXlyBezcK/IYxfP4UEoDisdy
TP4uisee9f5KDBZPMMmGVwwWT2bI9ygBLB4yDbLTKJ70aIuJE1g8brjv5nux
eDb4NMpRPIrlmrtQPPyt3zRQPGq/LsageExY5y+heBh630aieKr8YopRPAc7
s8dQPEQP5ENRPH/zGRzn+ufeZLol9efe9Jf/XFp0RH1+UyRzHOrz//IHl0Jj
PVVnQJ3/usRRHsI+IK3/PAlxylldzX85y8dnjJ1aWN3NXY1MTyP07Tc0yYkQ
L3bZc/lffkhC6i1OZBpczS+o7RboBgsXsg3UV7+TeHEO9dVE0RfiUV/9V895
ICD2Dda3BwqU0LEIE/bh/GMMi+i+wJ3jcOszdl8okn9TcIxsHBR2kO+nMG+A
g69pFS1+toN2kNUXxB9TL55AvKmfAYf4A49zj9SnB4GW+R5lp2o1vJ7UZ79Y
1gNUxf5aiGeamOA7MO77igaH+IO40ZoOt24I5hl5vlpdCiQaLxQqSAfh6cfX
ouidluMa256TVn3Aepmhl0EgFcy5mlzR/WLnhZQr6H5x8NIbQXS/cNk5a6QT
it1vWz2Hvhl+hZxD9+tFGAnzXeNMZUb3poLWchIJ7N4U2NPw5123o7DuAXrX
3SHL3I/edbVaNSTQ/eKa3+23f+4XMpkL6H4h40xvWtGGh1CSqtq4yREICBIS
u/UjH+I6GPgvYPeLU1dVGDax+wXR6RQFdL94q7E0hfpwr5+fe1AfTlbnSIT6
8CALWR10j/D/ys+A7hHLndysztg94mFJqzHXwxaIYtw4xm6WC5SfghmMsrsg
ouqhxbnRT2BJRrFlmxIJZy2VxekPFUPKdeGXxaNlwMTpK5z0Igmkjeu9vJJq
IbMre6PqWiW8ivusl7DnIxTUTB54s/QFjBgPupzFfBSHO64jH9F7Z3fsw3xk
cfQWyCc5eWsf8unlmTBCPmI99VdRPKnOYRvHsHhELwx8N8wmnOPH/usbn0z/
375x+mmjGDr36dp85f49912vyqmh/sp47fo46q9G5ePjJ5jtcHevZn6UuKqL
o1ZY+1a41wknKbY5is79Dqm8QnTu+7n9fIrOfXmZ3jv21/BQzyqmGt3RB+WG
iZPWuYlAntNz3/LVOJjPXhlTp2+E1muHqLVvtkPYs8FgxN0E0uhuYjw4bnn4
Dsa3ntz6OXtxFHraVUwCZOqByelgWOSOLtibeLkb9RUDs+OLqK+wnLFIRn1F
4Hqc8p51PGx1ezYfihqDRRtqpn7FEkiievWnT7i1osKI+oQwv+9qqE8IraAy
Vi+chyFcc6FzWi9ome/VexKeAZFE1ONqGG9WpMl1wrgvlTm1M8aT7pf7o779
h82z2EGsb6+w1h7mwfr2v3mjvKwSg+4d/vY5n/69d3gZh2cN1k9CeKLoksnm
P/+uxGJvHeKufgtid//h0y+vZj6Kn4QTtsJPXtgReMx/falwyf/tSwP8ev3Q
ef3Y/KIUOq+397H9KnNs5PPQeurYzeVHEyBdL/rS+twsDNZ+jZsN6oSJ3/TB
bVsVQMuBC0Dc1mkkD/Hzm5wmiLtttuwOz56BC0J6W4/DO+BT+RWP/kuEe0Hd
sdsH0H2Bs/nWcXRfiOMcVfBIxwPrRQ2HPuNhME+h1j028Bk2eH5cQ9x/XdAd
8TMvbjkjriVSEZWZhIdk8vLU+8eHwerevSrO05/B8l1jE5EVHryivwvMmQ1A
u+C7G7Qv08BcTiLTYt8U7OO0GyJ52QxsRrH+Nc8I92syWQHzHt9xePOzwruk
HjsXdlL3TLnOwS87JuJmka/AdAOm7/+zrxozcK8z+k2BlsGZSIn6DuhLZmoL
8OqFxa0F7m+B5cBtxXXIFzuXxDReeB2krgWGvsQYUrEMGFvQiFAiI4xrIde3
W3r/LBSPy6YdmCT0e2PX6u98zpqFY4s2ku3lQ2AbuatTJggPG7+bP1wXGAIh
nd8Ure+ywICpbTMJW5cjI4dbT88NguC70S+MnZlw0Kl860XPDNYH5el5jnfA
RYsE0iP+VcBlrFqfeWAOurwvFRTrdoPLKE9g92AJ1FS2zSJ9WlsxID3POqsa
0ifz8vaGjM1AwNLnosKNDsjSoZe9pE34+2yS2NW3ZXsnQLE5TcLoPqEP8fgo
wBAaMQHEX37725gR7unTIiTODlYT8NaCYThT4gv4+mQvl98ph1w5AeYZoWR4
T6qrm6ZUBz8PnXcJNC6GsVrWbqLhOOgSj1sRvVEJ7mxPJ/HMpXCNXevj3cUP
0OLyhnFVnFBXsQY+Nw/yjEM7VzA+a2f5Nj8iT/WDaWwcSjp2y0nx1YBRy3PD
32x1MCjA4FdKifWRy12vzEtbwGTsh3DxbAUE0g6x3H6SClaOHkbU5oR/V5uV
Zk9VGzIL42TlzaxyhL6X+neIRfgZ7P5o37DaIUHo8xm8GsI46edgizLMTUR7
BNJac14sfJsF+z2meqPzXbDSE99tNF0KydLHj7ti/f1mLxffu+x28OWqCaJQ
qIUlZ52Fm6MzUNFasBu31gEO9OyvVgwI+W+M0u6rweIZXR8l+jceE2e1Kyie
Itnh+//GE84r5q9wdRroZTos+e93A+m5Phkmlkn4sifvpfL3JtAWemVDEkjY
N1LKg38X9cyD+5mqI/lUM9v8Hmmgdcm9ORgs5in90jMKbnerAkkkpqFi/AIZ
c3YriBhrBVaMNoCsXoH7jtxpWMm5J1Uf1Qa5NGulklX1kKo/FJ/9ogYYHrKJ
Mw2kA62pi/POxGasDwZWxHdoXB84jHFN5TuciP8d99Gg2O5j2L70YMC2B+1L
f7lnF9sR0oo54CVVzhVUJ7z///6Ps5P/j0tqqEhGnRmE6gQW/JR1FWQ9/P2G
PqgXuBmCZk9i94v5okKj/aGDwPyF/KjCQgbU+JUsRGJ694UbnkifkdK+hvT8
Fw6RnsL0fccNLQ5g+pA43XlFTM8eQ3aG/l0zDNpY/Ga6mANT9TqPRAOxfrMt
/ixDwgS08RipmOg1gWHaxTz8oTYIFPee24fptyopIpH+07IZE9IrfBDkQ3qb
i4nqSO9Se/IT0v+d11QjQ/7tjGmI786O4B0g/B5PXbMnF/EZewhF3NqIbT/z
wRpg6n0m1OSdDhGnDntd1GqGgz+0rh3B+N4naQmNGDcQoSdDvIb5xWzv1W6w
+hytv/y+FPaMhvbM0Q/CWtb9QNRvWChBwwes3/hQFeYZhvUbJ/7TM/ynF/pP
/zeefiYug8HVeTjYP9qO98H6X/kECRMuPKw0l4xKefSBPx84eD1K2daXHv6f
Xurr//R/+bmiBMd890lImDyRJ0pJqM9jTWT3Z3xmYWPQMvYpK6H+2SPNLRAn
kXodgTg+QJcmENuf923MKqD9Wc3x508fJcJ+Syl2JgT5F8up0Yhh/gyyRr+N
sDjT9FVvXcbitNp6Xx2Dxfmmc5Mv1acIqK0mkkAiDkr93usJllVA3PLK9RSM
z5+qIkN87EFhzUWMa1hcawSmNOioylqytwuG7uaZG89GssGWlI4G8S4Hqn47
jB/9sl/5KcbFytePigFWD/UVgQ7Jn0FeSLeDel8nPNZpdke8Nyrs5BOMa+Uc
1KHBOD/rCsn3+Hu4p152ecycKjjrg4LU8bUPcP50abF12rHgF3Txp3m6N3Aq
kbFPfEyChaFd1oUYfzC+XqqB8VMqa0IdGNd2m2EtORCBkxlyenbg3HOcf/ln
jeflMTjjG8PqTYZz4FmELzbb8RXUv76pEZ8ugvBOrdZGjLP4MGeYYryT2y1C
GuNZ8ssh8y3NEDYehON3zgGBmy3n1Hs6oWDc4+pqQh10TraLHDDLhHcW1f4s
R1rh5veXYtKHpkGEOemosV4rmEmvCNNENoJzCkUfkI7CaJapRhpFPfAtyNcb
iHSBX8coJ9Lz9/DPGmH6BXuHT0ivRD0Wi/QOKUGMSB+f0U9hiOkFpBS56Jea
wWY1I/5nZg5wzOocLsTuv8p5x37NYnFyyGQMnsfirDXp3VTF4nT2lClaweLE
t/04tB+LE357uTJjcXKFu7MhH96Zlgjk05F7kg75/K2fC3v0Fzdvz4NevgL3
2wXCu66V0Xv734F4EP2avn+Wbx5SKioEn+jjYTiTc2E3XT+wTOsfi9Qh1L+G
8f/0XN/+p//LayfXSJ/fnYCXaekjLuuEd4ATS899dCOngPgHPnRzi/Aud2zi
ukhQ8QwIvUy5wZlK+HeUYcNslfNcc3DRp8ZAq2iE8N4uZCaM9HvVWq8hvVCL
97NzL2vgAF2Q8OxgOry9k30sJ6kZHliRyzaMtcKuqSnpCx75IGTsvns9mbD/
HLzO8ieeo+IOISie1XvPw/wS8WA18PJ47aFheFTWvJJN+Rnb7+6FIq66n+8w
4ht0Yh2IB/24KoTyo93NvYnyI2Wz//K/+Umj+l+euXL/b57T/ptX2P9nXu7y
P/7k7cNr+z95M8rnqevV7AGtXsdl78EyeL30TXRgqx948ddCN+QdcJLSEhRa
b/VxLDGf86sEXXBDSV6PzmN5UEttnP+TB9PWOpQH7d+Ss2ddb+JMiCzkaYLF
cUl2cQLeqjq4zehT507TGuAs7+ykfZChgLOlFrnu/c4U5/clvU2AvBtUjxhx
nH1cCqoFsxqiXIPABgk3mISxe7dfzrRtagOMvtRaP5vXDu59KaPT9ybhPDej
IwlnM1CkdLf1ibTCmf47icgnz7OACvmc1HxvhHyM0sfbnv/qgu5BI4qIh6Xw
RPy7dM+pQUif0sEfxvz9ZO9aIH95bx/Lc5j/wnCIhOlKIbwo0Dmi1P4eZH/V
yNbdIrx7ZBq5Php6gX0fD5n709g9fLuvUE+wRdyNeODpv/zOM5Y5wbVZiBQU
KOb7TnjfFj5KVZ8RMge9X/Ikd0UQ7h3uRlpKBeMY970pJTFPOK+zNyfpnb7N
g4/Lfb24g4T939sgwdaOAw/hDA3vE64R/k7xOrO1TERwHn5dFw9oUCLUA93W
/3zYnv9fn7H/9PrK/1e/un/wpk/7PJjH3uVfX5iGvHdtwSXjeHimL7nXuXAU
3iSkND3hLyLEfyWuzpd8HHYGHbW5M1VK+PtsHe9lksBxMCwSY2dZIPzeQHHX
QNGy4CQQfz3EvTFL6GcGhuWeWNVOgjqecixmiXCuXaIQM/3GNgEn+tk03ZcI
fbX9VHJwivwUTB6gu9/TRHjPcXizmT2kMQ28IiNmW+8J70XUZ6uSGKanYczi
qNjqB8LfEQKoE+zCNWfBxWu38QFpwnlNc5L590vjGVDyUXg894DwTlW9wlMi
rT0LTAFeBos3CHr5mlY/FE9z27M7/8Zzsl113UBvGsqPLBILlBLiGZn1+RNn
n4mSKYrTjlLrFNpPqpeOM6P9xDc6ZHQN2094lK4SnzF2xPX7T2yyTBrhyl6k
tCRecdv+nZgbxfH5FSyfz+1NrIjmCPmkLakJRXmr55t47/FP3kaeOty1xU2C
x3GlrOubzXDTPvKCuQEe7rD4BRw/3g+K7OXK1G9SgPlQ6T674XEQsZjqlLVu
hAtctOfkNgh91520htHPTOMgVVfw4qtHGeApQ69QGuGhsyN5p6hcP+R/bE2T
2EwByZMvbp58jgdZ1Wl5M5tBeB3BV5YTmAHEB0nqpLC+kcGLPlwibBBm3Vdi
nZYygHT/qCzyOc3W9hMwnyiXjOfIJzTEswLpO+NrtZBepfvcliOmf1u6R2sS
OycuFmjRHTw/BKvik+LKAYTfwxy5PTiL1uOSAWfRv+txKKPL3xJbj7aMmazT
bwjr8bJTRx1ap9ZFjZf/XadqsqfFtJmmgIih02yelfB9A7q7/tSPYlHH/6kf
tzsTeIPUWdDUdEhy+0Dox4qu2H5FdTXd9HNxFqurM1G1kWh9ZaoUWqH15a28
a+jpP+tr5P2tERLScYjJIuua6ySsL0spymq07hIPbmqidfdVgMlsrWMGqjZM
jU2+dQBvadjm7g9VQOWRnJmxjgcv8/if6h/GILbp7tOcWyXwquxcKGkfHh5m
CR84ITkK+mMVfJT4AjixWJ7I/gsPsWm/qLM8x0DVWait5HwJXNUWk2ipmwPw
9pjYWfcVtGIa1d8r5QO98MvqM50zwK7y2KwdG7dntOXj/vgqUCwQ+ONv/uTh
H/8dKZr8yH/Xs33rP1fxQFdoubvYYwyUjlyHA2dLYMFhIFzz9ixcsnGW/jXb
CVHWr38FCVaAVpdiBhrX8N61ql3YuKlnfDSisHGLE21SdA8OgZSvZGWDVzU8
b8+PWvPuAaFulRXEr3VLMDVi/OMr6muIx/KO74hfGIbYCd+1rtJaiIoNK/9l
1Q0PAsYurcklAPNF5lOHzP1A4YKjheaZdHC5SNm1inFKDcPjjBi/qmngoIFx
ej2fktYfX6Gjf1mzJ6oMqBJx+tZCA6AgO3x7WaAdfm6BEf5RIQSRrvmb2vbC
gf1Sc0gvGB9vg/QdKwNXkH5c4+HRVzeGIDCAt5OiqxqyypSem0ljcVYx3CIS
7YelTzMx4eewe/7OMscrdX3QWmsmuQXYukpdNHiDcWvqpVQ5jLO5NV8IPZUF
+2dDxnQMIsCaU1190zgfTH4Fax+SKYBrP1x4msJiwaawy+QRfzkkL9TbyJoX
QNAafX/kp1gg+Rm1ZqBYDjuCic7cx84zFfv1rMlXg9CnKv5mTy+2Hv/jVv/x
czf+x32i2lmDP+Ch6NWMpS/pMNBWu5qKNH6C1i8fmO9i52nQnYfeith5qiEx
0F6Dnacel2fUg7A4S25w5N/G4pw0+/7oFxYn0YmQDFSfarleM6g+LW/8MEP1
CRoytxvi8MADcgwu34dg6+J11fTgT3BW8Okfrng2/gDi2hYFGojnu3hFUNfg
YehXzKqGwQjY7/5xlM0nD+weREqjunoNruGrWF31zTs5hWB15XaB0ZEvYQo0
v39KCHNsAYOcBpIV5WZouEMkgXiDJdcZxEeGxV4hflrvpt7c52lQqXmlGfWu
DajNOYyE6+uhUpglnNgoG/qaL+a6nHkHhzO8lk7SF0Lpx30lOzBO9DbY1hnj
ngkBtdwYn267v3JqfRpCuSaCn3O2w6h4QytlUB3cWo413ckwC1q8904Pa3TC
ivAl8hNulUDqd+g70vccOeOJ9EO+S3ik/7sPhFQc3aNBPwW1AZ1zwyTt8OaB
nXt05AwQx8RZmjzogDreRiaFiGrYnyZiwjw2AzaMVWw16x1w1+qamIUu4f2E
t84klq11BsKtyiWVFr4B88CG+I+ScbiorT4qodCI3a8nS1TY2uEdHWtKDN0M
PKxlvBKk2g5XF/f7cXET4tngdCvJHpyDAP13FwTbx4FsTNNJS2MK2OqeJtmM
NsOhwI6nE+QtIP5FdOOH7wTsYz0VbSzZBHWTdtcfCrTBwfvmy3x7xuDhMO/7
nVJf4P3TpzUlewm/y7L3HXcXwOL0lOuZj8DivGW9XHBSaBqsuPN36cS0AqOI
A7vZnkYoE5H9E2f4bdM/cZ5OvPkaxWk1x+exgM3rTsV4uxg2L/tknk83sHlF
y6qkZdmPgIpRkJidAXY/07z6y/prF5g9K2N96j0GWU0Bv84MfAHN2UfTZ591
wKUDNaJH6AegT7oSL5xeCSdXMt/8uE7oEwqnPW5OYHmQfeTnQdMxDtFPMsre
Y/uPibH1k05s/3GWqj+9ju0/1B/VbqP5XmYPx5Nj8+3O2/uoFJuv37LcGspP
HXfnO5SfkHMZyig/19wiIhcdaiCSdplWsisdEm4PzHyObgZNyjw/YfFyuOGd
0TRMkwxy00EKr7D5aoaLWhQkYfeSJ2bzLdZlQBrBcEFTbwDshYg5xoU6QHIH
zx0RfBEESTDyi3T3AdPGZdd8TG9/6rgu0pcdNsxFeuAqi+mdqIaquDtqcXfT
4WxLU76FCKHfsBAzOWVRj4ezMdYhXUx4ELROO5ewWQb6q3WnVpOSID1XIM2g
oRZ2/FpkbdsoAxHLNNGSxCSQ40rrFP9SC4YZtLKCWPzxkSr2A1j8qjED57yx
+HvIjjl8x+ard0fTWQKbb5+7pM0nbL4eOxYGGmo74cYLZVtcWAlspDFdv7hC
eMe4616ZTD45DxX5l54xSxH63p952T90zuOhZyVlrtyT0D//sn2hqnVlDjpm
qW08rozCQpTK15zZNmhmEMxX2FUIN948GzhPR/i9wbQ9HDbC7qXd95SOCogT
+mfnl1OktU/x4NErcS28ZQ5Yd98sDj/ZAjKfZyuGSXMh7UB9Ba8K4b48lVQs
He46D25fTcicQqZg2nZZfdIBD1P8lxW/HBqEOo+6kIzQdMhc4jINo2gAYXrl
kZrj2TAmdXnHVC6hH9vXdulmnA0eKFceuFVlzMHL1FcXXmDj+nPK6pRj456t
IHXc98+42sn/jdv7v3Eznnkr++2fhnYFlcxVjVaQSJE7cSi9cVs/GqfV33t5
HLjouT4EJBPek12N48/sGZ2EPp/aHcsqbcAxJ2ugtIyHc9QOA73aY2CvsmGL
XywGOSWrsIqSSZhS/GiaqN4MbE1V1YHfCO//MgobarfYJ+Cc1vDVa78J/er4
ZWPOYSssPoFaaiudDlAdDdsh4jEOOXkCm8W7G4Fu3KbUU4fQj11kVicKejUN
4i5xYb36hPt4ycO3w5mHZyDfweDSB03Cdyzy4oJjGRPQr0fsK0zcCI6pLt/N
7g8DqV5VSumJWiD+tueZDTnBhzVzb4y48yy0ObQ01U4R+j2tjTv3+ppnIS/A
76yVCKHPrKBlJW7qnQL1VomzvJ2dUJ/jcq/y5SAoL2455Y1UQYCjjkgiDyGe
4IQj0psWMxDA9Gx61Juwn3xvnlKoYJ4D5sQzbUd8RiCpz/Yy+eZXiGyhdVKP
L4Mz+g/IcHyE9+22O4/uBofPw73XZz6zERF+p+eXd2pyVXEeUkReFt/KJdTt
xBKxn/7GLND9P77OPJCr7nn8liIqlDVUyFIohaTIqGwhURFCVCRbicpOlFR2
ZUkiyS77vu9Zs+/7vr29Jfv6u5f6XM/3j9/z5+uZ5p4755yZOTPnvun89PVe
HoDENPI2+mfdwBmvQmSTWQLUWk5v9C9i9RMmNevKi/OT8I3g1nPzJ9i+Y979
JebA7mkQ8fppp2o6ClYaNrro+wYrVFuh7/soTVhi5/u6hNtZ7DPCgVhamhBt
F9Z3m//7vkJ/3/d/8qH0W/Z5J/Noyz62y0LZ6tMJMAOcmiEx/jCu23VggSAd
HhFfMyl7PARBle9Tqd5VQWo9OcuD4pYd856tfeDkFHxQcREOuYDZbekJJ9vx
75PA/Xvo+WMF7H17+tSS+W+Ow+c+ueXno01gcXnR6BayDpeUTvzpRNZhGX3i
KdMd65CgUlMSXVeCOb+z0XX1jx/+uw6NrbbXYfEBU/OyEhyo+ncLjue2A8PN
iHnBd9mQauR8qRbxpxp6jyXvewxCjlXJsjVBNqhE/Jwt78NDyupbAQ+rITCg
T7JVcUD8k2FiwH0kL4qwZJPun+yHzhQhAvr3afBk5mazwCkkrwsoFRn07gK6
a975JofjoPKTJw9nHh5UyfjbJRcGoAAW2gbvZsK+kCdLob/w4HHiXLtK1iCI
xov+UH2WDQFJlE4nzPGw/vRkt61pL7R8oBqZcE8AlhqXrXFW7323Nc4XK/tW
0HEeI5x8jr7XCl/zefS98jb7e9D3cq+Md0fHqVKRXdWHjJNq5nkCLTJO1vg9
f9D3Eu6/LYS+F8vtm6/R92IMzIjSRPxwfDx5dwVpLrjyn1tNP4Ctn70cZ+5r
VeJheaKmTJQB68s/d932wyuD2374Hzf/bcCI+m3bhezDqN+OfDm9chhZ53Pe
9LH2yDo/fkJ2n+6OdU68HM9XmYEDdU8FpTQurD5z4+86P+a9vc7/8Yfnlrf2
xUwDkwW6L7yMNC2LEb9Xc5+5IArxe7ssqin9dvg9nsNLhfHEE5CQMHPtkx7m
n/kWv9Kjfq8WJ91upoPVM99tLmz5yQO47C0/ydN6I5fAGg8DqbZqprv74JlI
JLP/3URwfxjYxK86Ds9e4t2YeupAiOeC8RkK7LnMFTRdN9tHIC5dl3SiF+sb
vgxzbJQfGQc6cXz4qbUWkCqcW0TrhANETVTufUVAOjTMidYJNSbpJdH8h0hY
dRbNf+gyLgWg+Y9+j9uLOfNecM8eFN47WQpvKs3CiJi64M1h04NoHnUqymYM
zaOe4FNW0Dwq6935Z2i+ujlIJovmq7Ta15+h+eq/8RwKd37zjmAccswjz7Pm
NCJ5TpMGmsd+5ugjQ/PYI0Y6VmgeK60lfDRsqhzqaGxN2UwSQbFfyyteHMtP
rjh5FJgg65QgT7esGclPlKgNGGqReMoo3egyjcRTkah4pn1ZWDz1Is99hsZT
jd7PhOVIPJU8s0KeYD4Epdb2p6c9qsDw1mOO+lzMn0x4eW75h9MzB1ZQ//CP
y5pu+xPF2W1/Qiz7lIYZiS+B78hm7yLxZe+Sqk7TjvhScLBythaJF5Enspb5
WjD9VbPX2ND4wn22dv4pEl+C/nxUcDj/REx93vIVY9htMa8F2/yLe5+Lhcia
HRDOqgVb0YNkS/fS4Oifq9w1vU2w143z6HmERxB51qA8x/plP8pHgvdFof6h
69HcwADiH4YFh3GmiH8oipx3RPd7mfdwB7rfL0kvDKD7nfXtn9+of2hSf+GJ
+ocTbNfGbiP+4YPDF6q5uGmIOMI6FerVCRMbYd9JuJNBX3qasO8eHpJj+Bg7
cMi54qNrIsdmLOC6y66OI3lOBrlkVwuS5zzp/S37C8lzNI+umB78hDyXsTjz
p04/4N38l+9QpwJdKZ3rQyTfexgpPPknoABUmr2uxs1jcYfUONQczd80qK3W
0fztH7+avZ3vXVzazvf0+1WJSJG4GZ9qMIvGTU7pzICLO+Lmy+WErTj4XScj
AI2D/3jK37gpLvbfuLmgcawbzYvW7S4Go3lRL2fwJR0kj8qzSJX0RfKo8aDY
klUkjzp7S9EIzYt+3odTXUheNBMkc30GyYv+6XH/m0dt/M2jLM1836JxjVm7
hQaNa1msj2vnkbj2T96ormHlgNIYTKY0y8eJ7/g9yZLryygP3ashjXJ1dh7e
p0F40D6gHf35TT9c8V9flbZKhS8jyidR/ijxWTrKn4j6HZVB+J8oHeVNDzyQ
1nKJNs30wcqGGOeevmQg2H34Fspxc/iTKC9K99gkRXiRReDNVFc8sHi31v+p
6oMNWZOMJOtkGCjLYJ5OnAK9AXrdQN9WCDizqFeSUgRufYtb/KO57xbXoW7W
RfmYDA/DQHgk8MpcMW2Y94LKKv9RwfwEaHcfae1F+GUbw5o6hBPtPqItgHDR
O+dW6yAQjkMk7ZUOJ1j/7ak66RgKMjz+co0Ip48WLZVA+B6N9YkphL/n5xlW
kNMS43lDR8V9UEpMoYUlzvzDAzGaxylqfGKTcIYvgB4f2wSJX9w9/+hUQJ7Y
oDbKbT4RcqK89LLLY5SfLtWdIH86AT02lHfNqBsh6/Pp1Xf7amDz3dd2lGc1
GV9E+c0j0jLvEf7KOqaQ7ugEJKns1qQwboDdHSosv9/uyAee9u5XIx+DspdR
XR47/NXE5TBalB9urlrayZ9z+y1p+I1C9sUwoevi2H2SYP9hPMq5G2IXFXZw
GzUaB4JXSB6mxaNKk1INhs9uPAmO9AGKsXB1mu82EB/DEhiX+gkk8ATXghB+
Sozz4gGE/3JwSI5GeHHxQO7qZ2dwZXox42v5BLyE9uTfyHSHHEPTAIIgZ5AY
fm71CeEca0Gqagg/MaI/Ma+lI7bJup6acv2q2KOn45lzAQ//V6/2W7rq9EJw
EirrfSNU0rA4Pu27IFydPgFiptEnumbbYcl9gnmjfRDKZfxGRFsroVZR9aGq
cSuUflaSQfnXKX3GiwgfGWYQQjnFqM3xzLo+cI+2qhE7Vw4c+CO1sr0dwH81
jBzlDcZtUSjHv13Do1zbtKj8hGQ3POB7cr33cwnED5lWBKh2g+AuWfrhmmmY
onRfS6nvhEeuWYev70oCM5JHrCjfLddJlYrwHJKoAgWEswW2NJIKT0PAwPCZ
Q987QOGHq4mOXjqIX3lXgXK6jIuHUc5LDTUob2ImPvSafBqCnQpu/rraAUl1
bZK9ezKB197FW2IKD3JU74dVV4fAtrhGPK8nDzQOifug3N3nIw7laW4/VFB+
VXFkmRHJlxo9d/WuPh2CGHvcUqZhLqzdCVhC+WXXx3Uod8kUr0d5bK6Zamg3
HnwPLs9I3R6ChCR3r9ssuZBprPTY4EwrLPgZU2QPF4D+7fnnG469IGOyeKjw
Vx10VFuOk9lnAJVWXN691hZo61OMb8qpgYZahSCN6FQgEiwxixZognMn+3hQ
Pe0Tst1ZiJ7y9zeZUD09bG9aC1A9XdEuqB75RP0HqB5nrlQJVA/ZtW/XUT3p
i7d5UD2XvErE6044gockb4/MCwNo0epY8IxzARraum+/EN6Bs1iWRri34idW
lIsRCcpKM70AZUoPkU/N2pB7k+jHxAN7UEr8KqSI8Juxg9khCF+MrKpZQPgH
mraTKy5KYmatB4twrufFepmKZ8kbb4uFVH3tTJRPAk5GZSnm6E/wfs+vO/Nd
GTAcDlQo96JcPcyE8LfSVtJzCK+lKXnkeScMDC+U7KqPcoOQnmO46sgYkGSt
DfRG+Dh5xrkmhP8SLhn7hfD66uS5my73xMQsVcMICOXESsh4F1ZOPhLLe3Nm
1FEqBLgTyT0o099Apsyn6QnmcDhJEaGJ8gP8X8soEM7dkiWA8jPedjmenN6A
c5m45PbUCvKLpgS5ovyB4U+tlRfCI03O33ZHeFCG/bnjCG+jLDzGh78rprjG
wHhAQlrMKUxaPDFRV6zvQF2A8zLif6dc7dE+6QuGakq0T3qJ731M7PlRqH+U
IaPXg8StXSJn1QIaodosk75VYRyunqYhVqmqg/nmptGUY/VwiSrvs13gOGh8
T5Zk0K0H6wtE1LZmdSCGC+p+pDgIp0V8F1b4K4FgV3e/GVkbsC1F2qH6VenY
qFH9bpHH9VH9ZGdLqVH9ooUcq8qI/tH2yRlUv77txqgtoj//F3snHaK/WM05
yQ7RLyL31HncEInDkiTxRJx1cIIQdHouNsDcXEAI+twA5dw49LmeHxi4zMmw
vtuI5fRW3yf6DS3rzr6P1d++59XQ7b6nyqGIzwG/8aDjes6M9dwwxP5srtJ7
mQ/ken+2+DlCj+co36OAa0L5Pz3if/uzN2n+25+VZjfb6uMQMKf/p4/jMvFh
qx+n4he91Y/7x6V+u2z1DdWEY4h39g2No6P70b4SG+OC8c6+kk5LXQ7a34y6
12a3s785YMW+1Vf1vGAzhPZVxT8erEfvhb5dV7yF3gu1CD1vi94LbXS7IIT2
ATNf2magfUCRIdtUtA/Y1LXL3loHeR+zPc3Btd1QlxqMOxUdC1zUgS3oPdI3
Mt4L6D1SN5Z3hug90gc/CrjQvuGl0opptG8oy6zNhPYNl3+FTKr+ROz9eN7I
nKMGykP7SAxEsXNNxK0wK/Te6eGcklH03uk/bnolYhrtM6odpfmF9hn/cYcH
1nIapCPgnZn9/Ti+EJLlh/XRPuCKD+492gfcJxrmdutDCuxdXVJC+4/q/oJL
Ri/6QOtUdmf6x6T/6TnO06KI9t8vu2XBzv47295vLIze4xBoNcglUYWNk3DQ
4hbaBxw1TEve2QdU/WLN85V8HI613iGL7sPOESy2flv94jJJxYdov/jTant2
DCMOLKTcqVP024AW1/KRv7EANCyEtriQrNRBlH9OK/NH+ZHfS8sSj6eg0s1n
aoiqFVj7R69dGi2Gb/meCyiv25s3jHL5dS9NlC9MG74dFpgC4dtN1dUBLaA+
NSgquoTdZ/jRzL7Vl/9wbPIY2pdv6Im4oFSKR/LUaO4wqUEYq7yh4n4hC2Y1
XEVQbmESK4jyxAVXU5Qf5+okCM/AA+FiUFFAxgCUEUWm0GdkgBAHxeZ3hHNe
NP6BcrWlDFuUL376aN6Uiocj1lfHNv0H4GwFaz/zvQxYtqP/5R8YAkzMv7nJ
BVygPeX73dee4VBq4/XZD+GzRdeM9iCcrvJUvhPCPwTbJO6m0BTzN/GmIeSR
FBsqMn41nnNfTC6S6lctuRuw9DzxjDr+DO6vJTpkZflAK+7seDnCR19Mvg1D
uM0LuvpUhF+oMhJ1NL8r9lDi0WTChJQY/ZJBhbqWrpjfQS7CaST/GFE7FBAa
3AgGeYFewlVV4KvQ/GEPHQ4uTNHU6N1tg7QLU5WvxgqgdzZkq9/0gObtMtpv
srh/jx3tN+lpU6uvTOKhSpKngGFpCEq047hGmvPg8IDKK6YmByhU/5Kj81of
nts87JHvdgbHgilGeoSvXplRuIPwt5UjvVIIVzSSfJbMeE9MeKno8xUdWbEM
LZ/3ewL0xeL0rZdnSnXEPjaReRQNXxV77WD+tJdDX6wqUbiK4JYvHAhdfmAo
4QApxcUl3CpfIEhPgmn9pi8oloun6iNcu/FiEQfCH50VLHa0vCv2a/Fmh/K0
lFg275fEAh1dMe5buS5oH3NwM/E72ses3y9Yi/YxNW/xzLmr9IOnpo3JntZy
qBg42Wki3QEpKyFsaB+QeoTmNdoHvJVy9xvaB2wut9BeGMZDvO1kR3jKEHC3
7RfUPZIHkjeNHp07MAkyD08EZ99oAvLsGxoppyuhbsZ9YF3wvhj5cki035qc
mM9FxhZvBgMx9gMC59G+2CL1hbL+Oy0w2V48i/bFeCNLG4Xkp+CI2MS0T2UL
CCdTkZq4lMDM67fsp1QnwGHJ7o93bwOYUZg4mTkh+crp4a0+Ed7501afiGZ/
+VafaA0PzX/Me4HzHEEb+WQppPi5EBAzdUEc47OtvlWLWvxW3+o1Lmirb+Uv
RvbRQbgUbBLOquZP/oDZfasfVpuqYapPZAztp9wYCLMWw+eBpqkqiLV1AcFG
+TN7RN5y9HtqLiIvxpJEsdKE3aPuPbZdv5oc3q5frRzq2Dr/StFrZKDn39cF
5fPo+TeK6LT4xCsc6M8t16L38MOX6cCkGZmf2nA/9Nztm7y28g05d5M/n68i
RM7dWU9z1nqRczf3wZTv7ci5m/9jsDk7cu7+X3y5RuLS8mkMHlNdpWuQw+7b
pA3tc96N+OGZP8Yvs0oxP0z9t06l9n/qVNYR2/Vb1az/1m+XlrbrZtz/p252
NFiGF63PqxOWne960A4b0eW4C+OI3yBRZpZtHwLRA1EXaBzz4Dnf99aAYuTc
rn+vXVdgEDSVaVr5SbJg9ZjLFmcqZm5D+YrSl0aUny8nnEb1vHvfdwTV05Px
8RKqx0dvfqs+5n/tszZaH6tkJT2N1seyq8TbH71Azq35Nzp0s3qhy+acyqHZ
BNhj/64brZudOdIZjNbNhswSVNG6mZ3EWEHUlzHYK9JirSBRB2PpnqYyuzC7
7YrQ3aqn7TOKJ9tZT9tMUXcnKR2B03Oi7T3yGF8rMuhG62yhvr8q0TrbP77S
VLhyuXkcziUSBljltQAre37PHclGKGzXmn5CkwMfxmO//zrVAVGXZVf3qeHg
7F5+labhNkh9PeDxUz8fXvBP7NqPcON7Do9QbmCjcw7lzA3WJcYcOChztVSU
sWsDK0En6ZyvBdDB9GnQuhqxm8U40YbvIPzaXRzBS5sNeh6jW/xg6zUSlMvG
rSegnOo6PWFHBbJOq6+7WlkOgkQfRVVvSRYoNZP9SLUahJMedk+sdCuhvcWo
/Vl7K5C/1Y1B9+nd67ggdJ9OPUwuQPfpHoJ70SeRfZpy3WLDC9mnDYxUqc+c
sHPr3Pvt+nzOzf/W50/97b9Q2W73X6RPaR36sx8PkdZzMmdudIFQlEu6n0k8
mOuvH0e5qqGsPsrdT4r4+yK8LEJASX14GvaxrSYVEXTB3lthVz/xJsIXF09f
jd1DwCRtLL9rbxVc0LyTwSbaCsPVzdEod60LeYDynIt3vqK8bupGTsrbASB4
vxmYK1kBfd9eZE9OtAH3ekiA/x/EqViYuTpeG4Zi0zY72bx8wCczf0I5vOnx
QvmQiq8bylNmNmevIPlkmZjMLh2BYTBm8Yk48yIfmrSebdXnmRMJ2tD6/H6L
9Ga0Pv/PDtf+9jdl/09/k1dNUH3m9hiIHnNncFPD6kJ3GzeeoPw7P73hTv5D
I+G9keQYGBjGyjrQ7fge52//KMfjv/2jLBEuYY9LOJBcZhWwYMf2O1XngXj3
EBwwbv56sZGH5dXu1Ye8qTZw8PX+r5/UN0ehTCbu/WuLSSg4aMfzh7UZ8j/f
4cpR/gn7XUM9UK7laiKAcorR47QoLyGLuEUtMAmhZz6oh/s2wf0THJ9IP2L9
wZcXbJ+i/uqYXMGfzB3+qs+H9BXq31ju1JOi/i3gQlePUxgetBPUwnpa+iHf
IbJlSikN1LuMe1FObpMVjXJiQuIxlMvl1vVZfcUD4/uLx1tT+kHYeC5OZT4V
GH6ITJJfngT+enrS2JQmEPTxWxdSrIDDaSe010UmoWuhqvVNZBPYnwm8u9cI
GyeDhUFPbfYovDMvp5KSqYVdo3ltnkheyoELutJr3QczMfZTdV+xvNRGg+Ha
+x8jENlV+po8GrunoZd5tKA/fgSMvPc3ZiWXQUmv/eZdSxyUdK/PRXO2w8zl
9oX3kAeEw1KSWdRfIMyXNydm/DWoV9ZGJ5mEgeWX2dZfo+MQfnnz6cmNehAg
uX+O3gX7PSU73rqFQ8Kj8EuSVV7VvRLw5Xd643Lewr4jhceFCp5C4a6Yu1PW
Xth9uUtOu9Hvtt7Mywfs/G4Lx2D6EK3zpAjlXd5Z5xHe9+V3FZJnJS/KcnXO
InHs3Z9dn5h7IP+oR73V4VLIfP55+G5PFwiKUJGVVeDAHqz68eXt4Bp5OERM
Ixtk+Bz+KLbg4RTRk7oLyL7k2iUXyXQpBxTXtI29RMvBI3voYCcuAYgCUp9x
eP8CJ55ysxgJG0i+calFwf8B6Oky3GIRdAKJzdVCjrBwuHPjx5Ffdp7QHrDb
m6L4B3yo8z5y6MQHuB2uLSCjbQsNyl87RR4EArEhBdnpZ1MQ20U1U8zcCvd6
/C32VhfDhPZcp5rdFBjJ4+5w8LWCrcpRwomvWH+c+roL7+bUMBz98WHy7OlC
GIu4xhM7Pwl1T8tc1phboMSUhu8mXRnUmRk1BP/Ag23i6EUhmQEQiO9SUnBO
B42iVQ/JyAFIq6MtFzGoAH+7ZaaLP9uA4/fJVrf8ATjjMN1M6lwBzn7dxxri
2mDqW1jE+TQ8rP1memsSNAAUA6eXeEwygITiDlldLpKnpQSyOcwOgO9Bttsh
ypkQ41E2bZI6BkXi/uIjSnVQpP7pwtMJ5BynqGzFUzsO/MxpvHmV9XCK5srD
tfVfMFn8RzxRfBIkmeaiFxKbYMKbXsJIpQIou3wHaV9EAU1kvpijmzfsmTqr
+l0+EcxiS1QO4GLBVD4kZ+PgR2i1YnjoHJ4MBCIzKefupoNR3xn3Q6Rf4WzJ
YfHzhfnQ4W3BSoPo0T5St+CA6DEYNeYMQ/RYPOGzo0L0sBg3H0H1UHstNL5G
9AgOn18XQvQ8TVfbg+r5tctJShjRU6SkcgkdJ0NVZgw6zsGnNy6j47xbtyJt
74sHif2KdCnnkXw2mntQITwFuER9tS774MFTR9ROj7YfZMdLcS5XsHuk8hqf
33rmjYKBhTnjRQ2sfvujhON7f/QoqLKEScTV1ADV83d0WkKNINSn1e2/kQ00
NDKapowd8JJ3+kK+QANcDBC+UvQ6C2x/vN9Dld0G7w4v1qL2d138dBK1v/vL
JC3U/udlC6iF1saApiYsgNOmDiS86ybYPmH++c9v2hPoumrtCWpA19VXN9ES
wtfB4KrQvJ664Ayvq2hWPR59h9pO23XKc8PghleV2nxRDaX5Ip1X+psh0SAv
TvHDMDToJAkqj1bD02fJnOYvmsFAtPOb6cdBaKn79lb3dSUstL46zZLdChGH
WwZcePuhIIj4QldYOWTBVP7hFx1wwHDuuAh1NzjpsHyjsi9BzjFnWnDm3cj4
nQLFSqJAnpnmZGapN6hZEx6gepkIzjx/FqqWQ6B9yMBHPscFKDwO4F9SRcAV
4uh0omBfaFL1Iz9g7QB4Y9Ju6pwv4F+LM+JIHYQvhQO0EFMJZQr6Rlx+rXCj
QWXA9NEASBwqET9/tAKG0oaanCnbwSbwq1HUnc9QMuBGRxn1ChL9ivvyrnwD
+kekik0aXpCqL5gaIG8Jv8V1TSj9/EDT8bG+1dE3IMJZ6hTV9gTuTSg+Cjbw
gObekSOaq0g86bon1UqcAMcPJInndNeA3ayXduLxPMgdHF34vfQd2Gq/Z8/Y
lIAGn97Xissp0FucPZT2OgiquvbzHnuTDUu8x5TZmVOQ88Vv6YfXgsDpTcRj
9P7q/VNxr+MFYyDvjuAhrgYf+PLLOvCOdRIQXTxjepkjFI54u3GFP3kHQ0r1
RDoRkVB8PyS4P1BFbH9fkF6FhbgYJWXBk8Z0LbGzNEf3a7IEgmZYdJ1qsROU
5hncczMOhW8P2AbR33dlnk1fRH/f9aepiXHxQg2wsgastpXmwiBro/J0AjJ+
oQ8eledLIJkexuTVU4CfOjh0OSIIkubv3aeNyIYHWce90O805fepP0e/07Tm
lYhDv9N87tJxBv1Ok8AsRBb9TlOl7qMu+p2m2fF+NfQ7yvNDe4PR7yi97MUf
oN9R6pc99Xm1OAGnwh/e4DvaBIrJ7dRd4ZXgf4RvgfT2JPiaqEaV9jSBUPp7
vnT8TyDn8p9vqp+Ar66spn6NjXCLn+g8660q0Nqsm79d8R1GhlTJqvM8QI9/
RbwsIA5qq0Ip7RW/QVudjHEMuyuojwpa/b4YDc+peoaimvHI+HRrxtcHwam1
yEfgZA7sIoiiYRvEg/Drb6enPwyBgRbZe7qfuWC3qO6x1o0HnS/P9S/cGYKH
ARUe9Dy5EKqmnXgE8Z/qmsRV2RMDQKt2x8JOPBPKuPZJqaTjYcNwLXg4agDC
5Wwl6DwRfzvXBHW908D3KlU0fL4TGF97U79Dzh1MSsPVJ89Nw+1Xsl33v3XA
832ZskIm6dCcoSQ8HTENJXO/T7q/7oTK+DfB+jrJoGLTFL9vP3K+ur3PUeda
G4S/LqJrPFAIz2g3KG1ejsOXwz7UU6frgW5IgE8mvg5ODnz8fffJBOwl+j7J
SNUIgp+u0QrR1ADziYGnBI9wIMx1Gxp3t0O0BR0/U0seEC8/vt5ajYM5ZN/R
17ZDht1aJJk49vc7km42WGSTjAHh5NzvFwJYfVKvuEniZtE0HP/+sZP/2wSI
klhyK9DhQM5iTnv2LpIH7/nUJTGK/V7fg6Jt+bqQbXkFQXZct8EAlBjeGJxk
qYB5tQvF4/vbgVmRlaML4a3iA0XjCLfrCf85ifBQ3KHNd3sbYTJQ6il/QTZc
fvGK9XJfO3SYjjt9rBqHToVODffSeujZPbOA31UHXqoRva6IvJqQ3amziPw6
rckPiT6sz16mwXrKMGICRk6LG75Pbwd/mHuN6jm59kcb1TPGLTaL6vknX58p
wxOnPgUZRq1rWWI77vlnbfOyx9vczeV+UH15MVivUdO+bYiFd4/7T1P1VQJj
Ib30+EonZP7SHsxsLYY7xfFrC9Q90GcyblaHyHPxBN9/g8gbUad+pkDkn/L7
vJhE5AUvLpzJRuRDVVLy5qmx/MpNlCNCagYPPTWlrfty8NDFcu/10DIe3gho
0jEhfj323XEaPiiA+yZV6kPW07Cg3icufLITFPqtd2supIDgy9QteRqCXYyo
vOZFlkOovFOwHhsqP7RU+OscIm+3uW/f3QUsDpr+fe6Dv8/9xxP6Xndoyk6A
le5hZ089rF6dnqBsYO2NA3/LzzI8jti5oH9IzQTl0UWLaih3HF98I+rWAnMp
QauHTZBxK2pG4r71QEh5egHK4/YtsB9BeNzoi3mU/9NztX/7ud8fbj+X8Wur
6ylSxP78n6JaM2MAH/8YlDsqQCd7+AHKrf7oPkZ5LwU3Gcrfv5jUC7SZhIkS
UhIO7mbgkNH0/XP5J8SVHxxI8xyB/QuCG7E0tWCoaMRKpdYEPl2iD1H5m2Qx
W/LU+0c/oPK8OAn2ZEReojfGORKR1685p02DyEvN3tfzas4E9bfzJ1QbQkHY
Tai8ybUQlAJMdbWYauCFS6hylmAqPCKp+7RS2giz4dYn3RF5I6alOmVEXoGo
0bfBFesXbGRZrRxQwwNfj89CyCkcKIjVLsrH4kGLU7bz+KkBGGoTkTMC7J4A
7sz5vCzeceD9IvuESwOrV9+NjpT/qj0JuKu//CRVsHuGd5+JPxpenIKmNp+F
YyPY/Yc9VzsGKXmmgWhE4vEbWuz+g4CpCCEqH3rgwFm2HfLnY7b1E1zb1j/d
P8om3oaH+9JvsicYh+AU/9Grh21yoIWX5RjKQw03clFO/rDpOsr/6YHM7ff9
3rL9vv84bfdgEzqeRvrPp3aOJ+/v+zoEbb+vhGJ4hzZi54aEvSw5iJ1TOS5J
rSF2znk2tWW3p9Ofu1C7cXxqVkDt9mVqfIG0Nw2uPaF2SI0Kgff8beaU1PmQ
ffICIcq9ntPUpCCc9AMZFwU11vdx8HFR0D6Gg0/BmdRkoTvuK/IXXUM5t5o2
1U4ec3FxVBE5X3JMZO1t1psG6i+yU26GiB3Ie80tE3pA9kpXVSxVPKT4Bh/X
tscD3fwVCguhPvA0yCJYG0rE7r381aM9+v/Xw0lZzYXq8b1FsBvVs57yenR1
h56CSHb5b37jkEVbpKjYi/U7yhwOK6L8iT373Z3cWO66FU5jGgrMpdN34cbg
hyPbR7VGHKh/C9Di6GyHNDO9V3y7sDiS91ee7fm2/D/O06yFNzEchfcK/ofY
iLC6qGStiFJC0iQclM1PfWKP3cezJWiURjk/cazPTm4h1kn4GNFDq24TjOop
+zse17/jqX26PR6bWdPwFl0/UGhcfTS19yW4eIwcEa4MBp/KZvZ2hMeN0YpM
I/zeuSuOIggn+P/+NwOi84173PJxcLEwh3haAqtzMv/5+KpvbRru6J63Ph+C
1WcOMhN7ofyp1VTCTi4V6yGWJT8CIm32j72HsfNjn7L9yNFXY+CiSDviuYzl
/5ctihrbwieAi3XzkWUqFtecox4raLyZArWpt8eaNrE4tXDsMHE7Ik+iakNr
hchvkns3rObVQXDeoWOf9DJAvcLGL6AAq0NGs08Po8/VdyIdQp97iPTlJW83
PLgK1TSHNPfBUq4PD4lvMvhrf9vijsoKrShP8onhQ/k/PXs4iklR++jXs27i
dthnn1Xv1jidjxhz7Bznp6cK91E79Dh8s/RB7NDy9E/kWnoxeOqp27zIjoWr
lewebpWV8FFGhPY6UQE8tSFJ/nEzAszP3/gpXoDVf2iITj+jXED2Te9Vgn3N
WJyK/8tT+//LabPpje+Z4kAtOpqS/Q9W19qIqJUmppiGtlbRpg0/7J5na3T0
h3sKeHAhVBQwJ8D8koXyZSGr2GnQOxe0/lMCq5tp/pW33rz+H/njf+WphLbl
Ox7fLMWt4eGzkcIzjrRhEPAOorUzxvIoEesrQgNdI8C4tugWs4zVk2/WSH6y
pBiHmCxVar9prP9okpYbZbU0CgNneM6kbGJ1HkGtZOnMoxMgbKJJd6waq+cT
9ye8YDmJ5OMP1ToKA7G6jdPyu6CHzVPAW1LZTKeE+fmQCieJ6HNTsL+SPINA
B6vTNqyJ3Eb1Ext+Udipn2oyeEt/wCrTlv4Dvc2f0XXI+bKmKQBZh2firBR2
rkPtYIat9/I9nHpw53vR/SGLRN8rmqyVHX2vsPofosk2eNjsetluwdAHJFyS
z7V8EuGofMGBU1/w8Jyu7marRz+43hAoj/FMhd+3e86g8pFXLmuj8kcqtHk1
EXkyw1piVD5c4UV6CyJfeLTucLQn9vdAb2ceNELXSXX+5b0710nWz1lJdJ2w
6AtW71wnOWUTHqjditrGPu20G98tGknUbhEidFmo3VSY7oWh8/7Hb56YHZl3
Ze7jR212zPti0NAFdN4vZtjHo/OuMtCjivYZBV9FJqF9RqibIEL7jP/kh3Cn
+NnYR+GgyHBoxjpWh3T8epV0/O0IhMd6y6eGlILvXsIqUiRvNyK5KKyL5O2y
G30GLmMF4LlQIZEjMg0mH4y+v4ntAFOdOGpFiXToEW/DhV3sA0LVgavf35TB
wd9/Kk46d8LY57mZcISHVvYnRCCc3dDiJQ/CpTZDTq8j+zduYd9lC2T/Phe3
kXb//+xf/cDZTF4kL39Fd7eTxK4R+r8vOl1iqIa2T5+ald+PwdFKmsoS4TpI
HZNNF2JsAN/1XVlb8gtOW/JHWb5tye9tL/3J7zwEXDR8/C1hVaCg2ZM0G9UC
JTOFW3pMJHm39IRKHdnSwyvHFNT1qATulSrfCs+LA/vlk/jzOVXQcWpWXV67
FSguDzANkhbCcu7E0cSiXqh2E+NE+ZFem/kBhI9TKLYlIJyO++R6J6Ln8ld5
w++IHlWGQVpUzz/7zzm5ZKbsx4OAssX67Bjm/9U2atzfh+EhM735doX5NPA2
s5wW/YaHFYKhrFc/+0HvMkd/H3caPHp1Ki0ah4d4LVuZPXuHwYPwppwhGZaH
SLqzF77JGQe+l3GBEw+wfbQqI0ml0TIB7gVvXd7qYPdDiO7RzoZHTYGE6TT/
rg/YfRIz/vVcK0kcXKbkaNI/u+P38z8fT/v1fBpGSefv9GpgfyfxQ+1jzdUe
HPB8zbcorMb8vNTgVDaqR2f3haqdeu5enBOSH5+ECj62NAFJLJ+fu7o9TuqS
7XHuORVehy/Dw0kaEqNq1UG4b5knM2+I/f7qYYLaLbtp5G/b7R/3+zse4f8z
ng23bfucdti2j0tnc/g5ZJ28I+kj7ELWSWbgBi8uCrPbg7/j7Pw/41Syg3zU
bsyc4reJEbtVZJlvjfN8ROcjdJxEm+2X0XHmT3w8i84jSwv1EjqPlTeD3/Qj
8/hPz67X2+vhp9p/10NS4Lad+Yn/a2c7PROxC9yj8FE8rarzRCUQfX1wdJNi
CmZdvr38eb0FZO/gFIa+lsKsb1kAeVY3jJni88MGSsBPWC9Qlq4bpnskr+l0
Ivm08cBFQrEhGM4Pb/vQmQNrhte2eBzdOTGUF9G7taP833MJBoMGpJ+Mwpnb
83RiHNWQlJVtz9uJgxODxgstE+0gWBFSdjEHm5dHYW/21oiMwKspl7plg2Ig
m/EPctO9J3bX33zhVq2s2JrNo8/ZG/r/uxea4qM4hPZH9MYcRND+yD8uXahn
j9YfqKd/klnsqD/oUroFoP2mvEsNjGi/yaE7eAPtg7i4iP5B+yCyLMMbaB+E
YfeurboEexnZVl0iYi25B61LzObwGUmm4uHJcwvxHO8BaCr8GHVAKQMc35Fs
8TqvaDGUO5HHhaG8OldYpn88FUZ9N4sFp4OBNiyUcrU0F6hCKo9bB3vA3Lu5
hE2yF+B/NojR1fojFCr1OClpWkMEmcyrQvx9gLNl+xZ8HYFCivyxXgseRLL5
YnlIhmBXaeVq9JUcmOmgqw9G1k/iHrCXU0bWz1lfvNG9LDC4+PRwVtkkiI6a
dNXnNUO6lP0C93QZzIx+YGi1mAKvlRBXevZWKBFRVRTPLgafp/uGwnAmELSq
dvOxiwrsW521yyF6BmS9+gbz837A88by8pT5S6iUd1gllg6BZDrZ20QXXgNe
a/zxb+TfXclyTCZtdQV2dvUbZl7GYjY6SQWF75TFINaMj5/OXCz3rcdhK40O
qH/bEH6zrwgE+Mai6TZ7wNLzEYslVTc49hlzG9qWQOKSoK7d827gNf2saonI
czuJn0HluyvCGOkReeeio2YvbyaCfdxgBTEEgFanssWDd+mgUZzpFihbA8VK
8Z3st1OhwlZu4sBIIwSF8p2QQ/z2+oFZgzzEb/+pTmy8jPjtz6RW0eZx47Ar
Kkj76Nt6WFW3K+GXrYMLi62S3anod4NrF9YD6sHIvkioR6gOcgLJGdhKRiBA
XzSb6kYtONzQ5ss40gTP5gxFyn8PgcZp18PSyPpOIayT6edrAQftzba7b0aA
SfjdNWeyWiA8WcEbdb8J/gwuk6Pj+XFnXBUdjxT18jw6HscVMnwn8txDixrv
V5Dnel9rkO1HnksmV/JYim4C3r+Ot9S+0wDhtKQ0L5JqwcLTd9n2RD/QnT0q
deFrOexRF/bwsuoAo7/jPP93nB1/x7lCktYS9GIUWJf5tNWP/wLLOBIHqpuN
8Kpx70YZMv5TVySbpJDxX2A3d0fHL0POt+qH2LOK+8ElNsSeN0OIbSkRe558
LJf4gagGblvUs8ewpUK4nFTesVQsvzJY5SaymcDBEvEDi+cbmP98+9Zl1Pzc
NAjxkyjRy2HnuDSFmdg6j2nQ6BZ4PfUT81cbU8+VCRum4Q37t8vzI1g+vKAN
tInH8dAqW1TrqYndk/yhWcPz8dU0OJbEy9/zx/REMT1vHTiKhzw2CiWnc5h8
YZMip6EJHgpHz/ANvMPy6lfGLzr2FePh2ES35eclLC4YHKPc05SLhweR5c57
BzAuv7nYhurnzfC6vVN/cHvXe7HPeBBWeaUwoYjJl/19bvv/eW7+sDlv06Ux
aLOTFrMmw85rp0XYlvV7xmCgrG7cWRyzM5urnEdO0iiYE79a8SLB/J5gZ1n3
+V9j4BgZR/eODJO3iGtoI7szDoKX8350EmPn8WeUx/lxi+NQn0BRRyyK5dsC
Wt4/aRYmILDGgcSgCYv7qa0xQnE2k/Auy52sNXvHd6bSGyHdDFNwXD+Z98Vv
LN75728im3k4BSmNIv5kFth5bWltQOxd8RQUV3KZDRLv+O71sb/6ZaIpUDbL
3h8QjOk5Sq535V0QDk7pvnSeS8TqgaMX7RodFXFwV1WilUYXyxMown6T7KvH
QVBRv/tbT2wd2hnzZVSnTkGD1p9Kx59Y3nLnx0JWwDkc7Lk51GCyjNVbnOyZ
PeWIcaDiTmCtR49x58XWPeh71T1b8dn5XpLNlqro+FWfUZDsHL9IqmrM589T
YJ59gSv6DvbcYLuop+omE0DXKMYxOIbVPws/ctprD49DQhJlbcsSllc0uVtT
dpRNQAtV7UvtE9i85KVd3Zp3oRdjNDvn/UnzM5WTSePAIf5LzQgwPQlHQrbW
w24e0q31kBWvJTboiZwz+UNf/Vrpg9jCb66nV5OB4t0iDV0oHsbUJSW/ZfeD
hLA/TzNpGti9Pyd3MREPzKnKF1x0B2DgyGtPmhasfsgQbHYY3b/fznxUnNux
f7MtzRnQfVqtRLOss2Ofnvuo4XQP/TuvDRZhJBlYPnPXnzMLna++ItPGnfP1
Je/G1rywrUz8Z16iP4hY0GjhQNB/sSs9GFsP0U8fbO2vwqm9/9lfa2mulug+
6tDdpblzHz04o1M47YvsI8Ix67iLDfArI0TezQ4PVxTP/xY52QfqwVY5nVWJ
cI2XxijLdBwo78QzKx1A4sUbylWHRizfuHXFLyYI8YPV45rJa7ifMET8ZM3a
sx2sW3pk3fSKII9lmL/haS/Y3jyyumyB5M2BAzd6ONohy38PpdCVPKhjzDVi
rkP81Mspr8j8QZjtoPte75QNwrdO3bVD/L+QqEE+6v8l98wyof7fd7RKsDZs
AMyON6sx6FWAhRPhEk81tq5m2Lb92O3w//oxLfoYM3Qd3k4YPL5zHf4sLKdj
3DsJ3vImC+jff/jHCRXkt9bnqpz/f9Zn/EDaGOo3ymNHrXb6jd9Uy9L9zZMQ
R5gx0r+B1d9O2x0+i/qTuGNTxKg/4Tu9h1ODoRB0rntcaR6LhIWIIqM9F8ph
NS5bRBPhs+oCbS0IT/enGiFDOLOU2xV03XKEZueh69ZGKZ37DLJuoy/dafOJ
xIN0UcJXg10DkHm4XbK9Jg2ET52mRdfzwMMCaXQ9j1Cq8qPr+d942P/Gr0qi
/8Yvd6sW1vhH01C03jjNzo6tW/6/cS379H/j2qO//spI77/+qkJrXk98EQcF
h3WcQ89i533Dv35MSmXbj3nuvvQ003cSehQjtFy0mqEl69lcT2U5FHZKkzEg
7zU4VOy4sdEPfutS1gz5acDfy1aVutkHXUTxc7cfl4ND3guRlagOsInwJJV6
1AWp5uSegYdKILBw7IR6czfkV/eTu91qg2kLyv1zUYUQdMVymJS6D8p78grs
CpFz+VqKg1lqMbQozm6+FewBUiNiCVLdHtgnGMKeLlMKlsW6JTKpXSD6ebLW
GpFnSUzJM0Xk+1y+xLxH5EfPfPlBbt8EfM++9Tp250JocUQuQXsnPJy5topy
kn06150QvtTaxkGIcJ/kFxwy91ugV+0Qqdv1AoBqQyKcQQ+wqQjUE8fgYdQq
yDrv6AC8fJ/6XoAhHZ7zlDxBf1+IMVbRd9KzD3633zel7UwCcbPXWi3RePjI
MIQrODwAZGNpXBUH0+G+TaDcZelMMCNuOhJtEAoLrzRbuHgL4c6QK9clhDtb
7ZONQvjy5DwlysUL9FR5BWKhgELW0+P9B9Ac53a6eDwZTvG0tA/tLYAbXVeY
wnUi4Mbm1e9SNaWw7sJ9H+WUxmom3xFeepBiF8qT7hfRf4UIUK5V2EU34wl2
jlSCCr7x0PW7REjAKhUcnp2dspQLBjlXKS+xU7mwzmiaVWaZCpH8o22dssEQ
9b6BJ+ZkLiycz+aI4moC+3ZbktNauZC1Fj8qfa8TmnwpTt+JqYeTCpcrdudn
ghD9/eACwjZYCfeMR3mw6n4nEoQbj4fIFyK8N/NeM09UMbQzJk31fY+Fcj3B
O0ZplUDoqpLhmpQBg+6hGjc2vkJ9qmwja3kB+Dzn4nNE8u3ibz2du5B8O/Jx
7QtdJN9m9xEwC0Xey/7cE0J65L0+5R3dp4i8V1xavDGTcyLk59hw5LsEwLWA
tSj2X+nAdczlAiPCQxZxurkIP8wdvecYwv1FwuxIXrVCU2q11wRrIWRPt6WL
/OmFkPnZg09MfoKdRFNdUnUimCfcsevyr4Nfn25fRbkY67MllJecuf4N5ZyJ
FLDRUw0eNWQJuXtSgd0wNXHhcyP0BVeWoVzTE3cwD+F5kxP7FxHucHnFKbcb
D19Z/3i+UB2CGK+p+x+O5cKD8cP9w9p4MCxWGnhV2A16EwM1zs6xIMVOlNbV
hQeuvAOMwQpD4Njmn1m5Jxf232cql1qehrOFBl6Zx7ugusKWX/dZAoiNXdJN
nxmEDC8iUa3ZSqhIokzwuNkKWRMKxp0lA/CY6XKchmsFMMvuy6yJaINC8nFh
9i99EPG8a7BjpQz2XVD7Es/QCZ3D681fpzsg5wn7eZ9zxZD3hOYOT2wP/Ilp
pNzv0w/RljKOl47+BBFSpVNVRB3woEM7k/JOH9A6vdcviS6DoNTcquoHnZDi
0EeFyqc/fuuEynNsHD2Jyveca/iK6v8Tu3kI1e8XGGeB6ldVbA3ze4Wc7zsj
yPvLwkDnwRdGt7vFQJQ9HtFHmQ4UAkrtcjUhYD5ldc5YOR8MORNCP1bkQaaB
VccJk3A4tWirfXGiBD6/vpViyZAFzPh1Knrib9D73D5MJgvZX5aP8Qv0WaCr
KF6VTvQNGIbMa/GZheD1V//zv/rP4bb1c4p8+I6OZ8ruzF50PLNZR5jQ8eg5
98m/2pyEiaMbftmnW4Bzr5s81ThWz49spI35nDUOrW/tTi1ptoBWEHnVW9sJ
YGzqfOjI3QiGe5mMElqroa/eM+T34AQYpHgQTC02ArOx0sFOAqz+drA1Nmz/
oUkIoDUkp7rZCb5c01oOrlOQ6LkQ/kauFWyrkmM6tItB1P7thVHmKQi9eTY4
zrAFfuylHfmjUwr1UW4tRchzletDmuaQ56o8pOOIbsH6VuXaBKyU2jhQJ+69
LRk5BPkR/Rd3F09A+kOZvH7kfPVEjfX1Bf8q0LhooN4gNwFd7T+qfpY1wJrt
6RLJnBqYe5vpFfFgDHKqHnnGsdaBA4O/G6MUds9ctoOzSPXhNJAoEhzZyzgO
ZmRXUrp8hsGfaVde5Ug1lPN75S2+aAZG93gRj4ZxaL/vIePaWA9LH+riasax
+v9ofZV3rskUFDnIWD7+2Ac0Jnjl88KTEE4qybgS0gR0lyhK79hWgNp9CU6H
mEnon1AjPOvSDGNvTqyrGpZDyys6nOSVccjZXyvLllIHwUthF+TFsHzseD59
5BDjJJSTPCvLVOuEhkrto6jd3uYK6P5B7NYrKP04DrEbyxPxS6id+a/FxaJ2
lq8/W47aubLcirGebhj80kbD7ZWqoe3MpnnH7hbwIVe58+DcCPL/zyjvia4B
g1P+PAZ5TcB6iLDr1rd+uHEbb5/Ij+wjenv6GzNYX0wm7ZXEx1fo75doq0Uj
eUG1bv3N0BujEOTcscq/Vgva2v57SG2xfFvCsaLqHWpn9a9qg4idg46HBJ+4
PQ4uJsofSbvq4L0PBaMPVT2w96wBamdl69NKqJ1nyMk+oXaeGjkvg87Lz17S
i+i8RBNznV9C5kXC/YHAL3EkPz2nMe1EngbRms5NN9yagCHWjkHpfA/Y2DAy
BJ8qBcPfzhq0tV1AtJ6XyhLfCUO2ax9toosh/yh/2LxYD+wu9Uj2KmmDx/cD
yxumCqH0aKyF40gvrBowrY1/bAFu6VqTJ+YFcCGroT89vgcC0r840dC3g1k7
y2maI0Vgxa2fmZTeCy2NzGHDXsj6Mwo+NEuRDREmVNKrF9phWfPDIWkkjt/2
xl1xReK40n4z30kkjleUbD9X7u9zx/4+tx539gEbMs7al3O+tsg42YVX4ueQ
cfYp01IZsFeA1b1qMWmlJFhlbSO0oakHaRbWDrqvZTBzej3rg00CfHy50DmS
VwtiM0/rqYRKYKlqU+OkWRycin8k2vGsClLO4mM9ywvhw7FSaZaxKHhZ9QJo
jv8EHXt3nXTBEng6d4hEyDQOCoh8RnaZV8H1NL8WtX0V8I46ni8fksDxwzzH
sV31IBp+bQ21vwBJjsMrxP7vE4g0byL2/2CbVKDwuhUydPgy29kK4eEJy7Tl
OayfZZNleoAVybd99ohzkfRi+TYpcysR9wAeFoCC64A91k/MpqXIcL8yDTHD
aRfu2Y/BvKgtSwllC5xUm3+VcrAAWNsfBpgvY/mzo4Xj+ELqNDD9Crr/03gC
CsY+bV7+2gRXgisD71Lmwb3BJBZ7UuycfoDWfB9n1zS0fatJrzw4CUcE0nQm
2uuh57O7WjdRFmyymw0QXcLyf2UjvbsBz/DQbHhyaDwKB7HTUj1l9nUgd9Um
04E8A5Jv7CbINMDy/zVPDbW9E3gYslYePPIVDyXNXxnmcqvgBr/75HGhFAgk
vdEW2NYAyupuR2VUa4HtPFtREFMafGWyGZUIaoKGppVAS0Q/qbA6JxWin3Oi
gVRxh/47f/XzWG7r/8e/GYik8K4Mw0b1yYYIj0KImH/gMftrHCIW+oiu1yL7
Sy+bom4e82NaXaL2Layj4PjEfA8DDutzJRV4zLiTjEHfvqHYFv46uBYcEuVw
axyu5ZREJbbUgbTDwXcJO753cOV5rXdzYgKOcRvVtEZh5x2pjPaEE/yTwDvE
Fb0Rh52bSD64R60pjAH5+5941vP1sEv0h1QozSgcN/x89GRSLZI39oZoF2P+
JHyOqdyCZAp0fc5YdvzA6gmcXZVMMpJTwNedWuZagq23kurTPruMxoGmUG9N
9VIzvG9W6JAmGAEiW/yGiH4NWF8mTJ9dw+7zeCblnZe+OAGfHw04cp/D5t1h
PXyWG/HzM+L32ua9+0CFON7n4fQAvO17e2MxtwLGdF25oywwef/V08yUyLn7
1lB9csiOc/enhUNW51/j4FIERXKfDHYO0pzH4wK8J8H43ijhxb3dYCUlKaAy
3w9PteZyAj78BMtZq5eSPpgfznFRXFJWmAIahfBaPTKs3jJ1+YfxqVgc7JNb
7D7/exgy/VpCWXb1Q5nUR9ov5uVwTOU+w2IYNi929O4RL5dx4Nq1QqUD2PlL
91hdydDRaei34SCWGMa4DlnzLtdnU/D5p9PV9qQ+CLXu/jHO3g4tsQvMKpxF
wGvyKKE9fsfvwPg11+31x0OAQ+l8qRi233vVTzaMPMUDxZ7GnEtfsLpfn7ac
m8HhaUi1arzm0TEKVvaDXk9bO2DfKB1LzoliwKcZhd/IxOZdm9IlsTIaBx1H
PP2EJzF7Dq2Nt/24hge6th57w/UpiCzpmzL26YI1+fHOUv4SeB3zyPlxLuY3
BOvtYpeJ8BCeYdXjk4XVW9xXkz89754Gy9W3zJY7fvf7J83dM5avcODrQFb8
VXIY7l1ajM+g6YOWBfCoUCkD8tbhkc8p2DqX4b6gzG00DfW+H4e6T2HnZecH
FETMUtPg2il859E77Lz8Wv2m4u0JJG8SH7viGTMArx6ZewsQ9UONkru+0tNy
IHja6sEZgc1j/995Karcnpd/fC/H9jwSvNqex2RF9oGMz/Gwn/8F6zqpH7y8
BwqxyPnqhjN3YyJuEMKD70UWTVfCzBrNk3UVrP55MvLeXKwQDhKIM748nsfq
SxkeRt+pKHHQFX9K9IosxnVPpT8hvj4J50+ccrak64KBwsFslz9DwC3B+fMu
VzWQs7PD4EnMj/Wy2seB4wTIEt5txZ/G1vktP7bGc6NToKWgonbgywCYG2TW
XUH279r6FO85ZP9yTf6UW9yxfwNkhfzKfafA4vqzuWeXsfqY1ub2/iW8ur1/
/ze/BGVB6H4no2bF8SD7feXb3XJ35mlQlTWqWTdGzgFNuzwJ72dAMDf+yVoS
HtrglPthywEwSJSs1tiL+OOQgwM3ivAw/mZ4Lw3HIMiRdv0W7c2E2EbKVCJV
PLQMU94UWemCuuZvTgr60fBJ3ytuEIlzXw5Rvef3HoJHJKmz4QW5MB60YNkx
iQc93k9ayQtDMPVau+pQQx6QHLp0tTkYD9wxhWraof3w43wOEWNxKkhutmeL
1E8DzUNF2YdtnRC+2CH9eTgRYjjb2Boy8ZASyFSZVzoApg+PX+7szAAh+Ya5
9Dk8rOgZ32JQH4b9fEnyLn35MHsioBp93/zTo63o++Ljl++i7/vPPkqMUbJC
NCPgRTb25qJ8ETys2LbDQcGzW3bYH6S6ZYc0QvLTAecb4c/qApkCcQ7U53Ye
ad7xd2a7Hin30F3Hg+4REnl7Yhy09E+TDCP58ZGcgB8tFHlAcznAbJMEi8vk
NNtxWT94Oy67hKYMSKv1wAXi8e7kS6VgVd69MLuj3u58RqD1gPc0HHOWiY9u
2NE3CZ682pw+DZxqm987n2F118HThWdJDuDA6SVNUtaNQXi+90nKPOIfZD72
jNMJlEBYG5kd2w7/0P93v+96ub3f/3G/v/7hy1//0NDwfW6SbwxZ9y/7+Inq
4Oz7FMGZl9i546l3nrhwwSQEemtTmCZg+l3zqpzNLSdBQZPgJW8C9l4SMwxE
jznGIetxoX/2pSbgPSHfECw5DhXvZoPaM+rA+JOV25Dwjt/BqxSOROPp3orZ
CTSe/uNkzqyeaPz9IRQtsDP+WpjnyRG+xcP+IrVrZes4SP5p8TZNfwwcG5//
PMReBznPV6PsLzVAlmbAIJrnl1O9ihBA8vwb6ma6JDvyfONRBm9N5FwpW9gU
R42cK82V6J+orUxBSUDuSA9XG0y5XPeueVgI/BV3ts6bP7/b6aPnTeXW7wbo
eTPsbUyHT2wZ0CQefvTnVQKMT39Ic6ythc+9g/atSF60Sid2joQ5DeamyRXC
kbyojuc+NepPWEaXNrQQf8JLo7Kx059IsU0eZcmfAtfiY7m/ZjA/4PrXn9y4
vu1P/vGDBxzjUf+TURXRg/ofQZN2OjT+Xv62OxCNv1ERWV93xt/OmUPqMw04
qD0T8zrNH6uLWl3ajr/VEtvx9x8XeLsdr2kVt+N15NDRZ5W3myCe6vArpbBc
4CxLdIz91glnvWivCCL72s7A9Zoqsq+lboSu9SH7OozUu9ZmHQ/zN4M4H+UM
Q9+Za3nEzwtA5u++rnm4va/lzmzvawuddG7UDxxZ1GTLR/wAJaEcfxfiBzQF
sqj3ueAhzM/+dqJfH2gTb3x1xCXBAdcVLu1yPBjc/L2YrjkIR6LVxFUts+AI
Y9JHbSTf7qC6s2mI5Nt9a7HquCVs3WbZdE2h+bb+90NP0Xy7UHz12BwSrx1u
CVqScReDGX/dMbId8bor4EiV9nE88KqTtZ3VwPqDH1a347V+w3a8/sebI7sK
0fgewsfWg8b3rhohwSIkj6U920w8XVMP+HO9934sYHmsrclAGO7rBDi9Gb4f
9Q2bL+/SeAM0v42RDDSjR/Lbn+7zeg9vT0BDRuC1XT0NkFndKrH7Dfbd9O1e
wgP8peMQKb24R/4Vtq4mpw0AvTdyQKGzAb038nCyW5lGawI8/E8I6k82AJ93
8f5bSFyKl1VlOYrsq07n9mO53/rAKOw18VUK7D6nEq6U081sDL5LeHK45tbD
fIn0GO78NBz6Znh2LLIDbkltJk/eSodPWcWM6L0UmnJ1C/ReiszZsw/Qeyn/
9LT8siR0R/QkBvhc9ED0yAVfVmIOc4XdHi8cW7vNoT7jy5MFcx+wMznEu0GE
zI+Sy0KSYAMUHrRNPLIXs1uJxadv7ZqjIM5HGFYQXAUUvksmi5z/r703j6by
/f7/KQkNKkKRigyRlAilsylzImVKiEgZUpkjY2TInCmZU4oMmefMc2Se53k8
MlSG8r2vvF7v4/VZ6/fn7z9/7bUe615Xp+Pc+9p738/ndVtCeJV9ZmSwFqz8
HsLLPrAHw/yO+emJGWBfZCI3IusEtb05r4J4c6D/80znUgcetm13vEVzehiY
nx8aE0vOA0G5ynfEH/RgVwjvM9bPN2CZ3o5r4OETuM5zwny3TQBkvqBwipSz
g5HXy3eO8ITBbIbR5w/Mz0Ffqu2s0pAB2N4/xkZK7A5TXt42IUYz0DwiVEi5
vwMGb9I4B0cTdHoiWa4XOyjGgJrv+/5A8SoQzhG6GWQ5Az8Sm43oWDqg2v4F
rki8ABgVxDSfUk/Dq2I2KFNtBcGl1qPprmXgeHKH2XlsX/MTYat98ngQcotI
rpYtZMKpveR/55lDq2J/55lkt1nPoXkmtbPzCtKNPG1skT90og2+xLqKCOWW
AMfTuWWkM3lcmxHYVNACDEk5RGyz5eAmFXUZ6QCjV2mjkA4w1MaFDekA//38
J4QT/+oJyYwN5JCekE8nvxrpWIpj9wogHcszgxEupGO5FU76EOleJmVDApDu
JT9NpQDpXv5dJ8Lj9nmkV6Ted7wI6RUrrWaqSO/1gt98QVeGZBkUi30kl0rv
BumTsqbM4f0QmXt8uWOlHKaVjGyS6bpgLvLSYzSP1dcpTkbz2H1WWeloHluz
YpHgWlUAizvS9I4ZvYdnhWt+vJOl4FvrJNViGgtU7XP7O2h8wWDpo09QbxJU
HotOacQ469E/p9swfuT6jt3+GO/TPLq4rWEGJqlKgk1bO2CfQxt38qFcsOzk
Xnb9NAUHyET4JN1boOSEum6QbgXcOauk3S05Bfu2LZ2/VdwMAutkNT1nqiBZ
6Yupve4MzD6hdqgn6gDLDD1BuhnC74F1bI4ezeUSTT9aPAzoB1+hz1VozvZD
sm47mrN1vt3ugeZsShxK8nbxWJ2qd0npnGsLTPSwf1MzIOiB/Rp1pIQ1Z8Bb
mKn80Mdh4KzB2X7QGYcVmjdHEo9/A3YLAYdD4o3g92SPNZpDcsuz7qkqbwTh
58dPoznkuqREG5oLHZTl0kFzoalpfw80F5p/bXWPNL4RpF/jbnqfy8Xyhr74
UfUO0Ih9J0JF2wHHYqYfUTEWA/fsgcepmX2gyFd8K6KiCIRF+j7yjX+EeZMi
bnb2Sjixw/9ZCFZ3ySQ5zsphdVeFXvxg66a6a1l/o+7iZ96ouyRVv9LX++Ah
OOpt6cxyP/joOChU/0qFDoU/1GhfqE38fA/tC1cjwyrRvkD9z77g8c++8PSf
fYGahv3a+Y4GGDi4c7GVOAfsgn6e3ytM6H9vGGzMSczvb8xJ/uUhsYn3tSgn
Yb4nz33Bh9Bf2N7Y+fKs6Rgcvntgxl+EMAdO5Mlvjsofg+iV22efKRKeR/sn
qxcvqEyCVTHzy7tv2uHRobSeSazuCo9eE0R1l/9l/iffN9VdwtmU21EdVcoC
oaiO+pfHFG7UXX06G3XXUNwrWx2sjztRrEZxD+vjXoYvGq1t6uOk9TyEUV8m
rZKz7h1PqB8oxObYUR/3JRi262N93HDzIqB6tc6p6BmqV/m4z91c2FSvBokc
5Uf1Z5TE70xUf/7LZcM36tVe+Y16VZxYxfgy9RgEDhzJyPlcBwEDlOpfN81D
JiwpfNF8Q6Q6bBHNN/7l5FRyimge4m7xLdNr0zzk4fbTOlbZo2Au+Kzz4jLW
p0YNLh9qwoMCZV0F98AQKEtk11D05YJskd2fL9VYPtQ5xer5fAiMKyajJfoJ
usQ7tqqU4vdHIbBMSr3tHeFcrIN2GzyveoPzMJ8kLsTWGZ7cLorW6VdlWETr
TET5/0b/rpu50Hf07y4xmgjt6iP4XLT/+Zxn//mcIT3tcjsut0DXmbbpsOUC
yMtOuzo50A3zx47rIH5uUIciHOOa167cRzzVYV0XzbFplS4tJvNUgm/05VA0
x+YXOKCI5t4xixnX0Ny79E8qD5p7u56JN0f5ZJIM74Tyif9kARvKJ8036YY7
sfwTxy94XgnLP6TFVAnDWP658ehahQuWr+z1kuvFsHx1ZC1vOBTLVwfNF5dR
fovYZh6D8tuvSb6VJCy/aRd8v/aCuwqCx5iM7txKgUw3z3NkDA3gvtdhD3tB
Dbwk/Vkmez4NeLZRnfjS3gjqIcUnirF+nNX2wIlWrB8ncu6fmtzUjws1Mpmh
/lpH5kwg6q//5Wo+G/14VMpGP141/aJHd3YQgrkpn/7Ir4LmQKHlzXOqe4M5
f+dO2qfZ/s6d/uWvfm3MqWqTNuZUtDnRPwfVsP7RzfGb7/0eKGCeHqj2jYeQ
iLGrqD9l5XhqgfrT+x8Cb6L+dO2fflaQa6OfPem60c9+fW+xpOTcBj0j6al9
TEWg9zynm2SJ8Pske9WsiOa93+dxfpp2hHlIJv3GfDgStzEfnnyk/WDyRAe8
cMp4ieZOzersEpvnThwO/l/RHIn9XpS2TydhfnXk9sbciZ78v3Mni8C4VJRP
dmwbV0T55F9+wNq5CeWfgivu7JvzD195hTvKVzlHxKc256teeKyG8hv5L5K7
KL9RPbnG3zE3CakX81/V7W+GAC9myhdlhPe8JIhOMmpZTcCOIRbJ22aE+7fw
vO3cxOkJmDQSdN6nQ8hXNzU4NPUvj8GJo0EquzuqIaYRX3ctahaU5a7cu2LZ
Bdyn708oh6fCO3mFl6d34oFvRzRRuGg3aP7mJKKcSvrfOnLLR+1rL46Cg3BH
75J+CVyeMybrKZ8G3m/xqcGFbXCoouCFswLhnMDTtvfuPLg9BuFzd79TehGe
A4pn25pwxY/BM3lb+cb6ryDZLbHWja0zon7lDVrHfv/ngs3r4KgfE6Pr81zv
0dZj18uoSuSheRSPysAONI96E/qCF82jnu4xTT31sQTqS8TODL77BAozU64P
M6qBwki7zTMlC1avlnLd/BMF4cFXA5kqCP6O8qMTbeicnK9Rz35Q3xyDh5oF
inIhWN9klfXARGcAop546YcdTgffOHJlxG1bLlggnvOIzA9xsCLW9X6FB50w
82PldAMgutCYkiGTBs2jTdqIX+beRYb4frq7jxHnkhY7P++LB4riJu8E0gEQ
ukP1xIoeu49xtImHE4PhYmCX0MFVB2D1Hc5gKI0EQZyyLg3Gt914yXgA44qN
jnWHMD60nXXf2+9uoEzuJVczagxhSWvCoxG+cFzgFVc8xo8UHBBswPjnRJHS
KYxHFpkLpcZo4MLsWT2lb4rj7p7d1ni6QQdHE3PH1eTnJMgwv2Xac7QZ+vbR
PeaIrQYS5n3eiAtz7z2DuI+lkjziTwfsnGy9JmGF31DZWaYJfllZzOW41cLA
+LoF4q3PbuEQp6KZO5mL8SoXMhZWXWxfqvy4ELTaCNZutSQXrhD6pm3FHWUi
P8fgh4Dmasemvuz8+YFKxOtSr+/v3MRp0qqD0f2lOs9pZ7Xp/sqq4PRCnEcY
eDZz0hhyU+q0MfCo8s2X2VcHt8ssX91+/xw6PisZVUQZQuPSw5LXKe7AaHyZ
6SbG81/xH8/FeH78nqteGI8/j48VZzADr3C6u+HFGtBCzzITlfgM2so605Ux
zhWVeTET4yLqf+iyMU6dQl+sfEQLt+h18yftnCSOQXvd66vwfZwGGevPzEef
oCjFfiA+0x8OqJ1c1JBPBQXijrR0jAe0cAnFYbz76DUDdYwfWdDknFMKh6j3
CpxvD78AmrfOuNuhMUDTmnh0AePL40o33mF8SE9WWB3jZzh+8+pNaOKOOhvc
NoyRxLkIOL7Freji3paxMzy2GITMvexHZ7H9xEm25dT79XaYHrcQQpzjYK4Y
4ryip8gQlyR3ur1c1A8vhhwbo1kqgFeZjn7nXCd4aMecRXzc0ykS8eK3b6QR
905XczDU6YM/K4+nTw2UgdiL74HaJ7rB4UlaP2nMLJhk+Edm23SBbtAdclnn
VPCxpZhGPLNTPhNxteHjUdcwPuOacEtNZRZm1vhb50c6oVzRYpXmUgYwCjqK
I77dszQJ8QuKefG0GA9qLfQ6cnkW2ny0v93M7oSY3CMX35FnwnXJ+dDuCTxU
TYwPaPQPw2svnwcqAQVQ6XMlHPFp88Q5xE21inwQv9o1PFo6hN3vrG/SKUOH
IXR54b5NVz5IFWgNI3778+PXiJ+pladHXOA1qZ0ntq/Ynzknbeg1DPjgD7+0
MvLh/fIhl3z1aHhYNhk2X+wODeS3WBkXP0Dfie6OXIyPs1icmsO4423WPnqM
65yJIfK/9Qqcp2MZx84+g8XXhbKS0iFQfPlOeQDGHzyvTp3A+MIRwUxpjI/W
4lT8xNVwOQZuPp9fi+JkjtjTGvBp405wZob1iPsAx76qvFeZFlB7UOO07pFA
EC7m5e7CuGhC1lkfjMuTBPTfxfhRoaXhTh4H+HY/wPwxpR40+ad/36nhAk+P
XmEaxrjPBM2MDcZPH9Gyo8Y4ddK8eriwJi5/iNrsaaIEzr1u/uYEtS7ORy/O
kuvcJzjCL3vX56U/vJn6I45jT4WAELHcuPc6ODv9vC6glcXZDmlztO01xDEv
BaZcfYyHd5peH6oP98Fi3pOQX3TJwJVAloZ4Y91cJeKnSezLEW/nSmD++QAP
xM0CZgbmvUCt+Eo1yzgRai61MyF+c933LuL9601siK9RelOT3cdDnh6Fyd6r
vTB2obw6by0BrINHyRLPj4MqZdeHi6TfgGvK67iYVSPQjjqcRdznDV0R4ssx
1guiGOej2WZARjkG3eyWAjbxdcAz9zUwt6oJNOXY5REfPPzmEOLHFpnSEE/8
pFRy/AVWHw54uFGQ1YE8QxfdgXuE/dd1WdJ23GoUogp6l3bzEuYwtyOFvRDv
GXPS27OJWwacthUSGQWc/rUWZT+CH/mCzjc9xIMnKkQ2czujPe3p50eB7VzF
wmFxAjeW8iN2s58AqAT+9y8JdQJPWMs2xPckNV7czCljrxpZiE3A0d6k7Lx0
wuf3DefXQ/zD+NXYzXw5+mdzmtAEyI7fVdke2AxK5D3C0SPTwFA8pyP/pw1O
SdZz78b6T3ZmFyXEhV7c80H88ddztbswHhzy7py71zQMD5dphsu1gcG2XCNr
5RIozqE8g/jLIv9biFOx8tshPr2ubhj4ZBroRrSvvTzYBmTWYTXB3SXY/fT6
6Oti7HfFye/Lxj4E9utWkW/GsoH7Xf0xxFX21oUj7qNgWob4Q5oSC8jDwzeq
RPKl/kHIExhYG2bJhpCdrH95y6mv2xDn4OSYRJzEe6a+OwcPRm/80w0bBsHU
nYM/ejULPm3zPZ1JFQ78goeefZxwhrqH732TjWJg4We7m1mENxifeRO8Sm4B
CTE0Uq7WASDOemz+d7oa7izHR+/eSVHcD1ZdbgYHbdwRnieOcXluIPDRJf1c
oTEQczTQTFr7wqoOFZmEujX8If3Tn43XhlZ2/5nZQEdQvzaqWtGmiWtVmj6d
6y6Jo3WKq5Ua1MXt4w7SjhV9Bg9JDfuvBusAuYuZ7xHe5zB+V/fhyxkj6OE7
Wa7mqgS1Ia954reZwSyOm0p4Wgv3m87Ez/+ING5Xxsf907ce4GS6s+aYY96D
lVRGzVdbH9A5N3hod0ki3Hp43/H7UhAIuU3qTZg6QPyTkwrEEpHw4fAOuu51
LRyNh7QU2wVpXKuZZoSP6QOcTjbny4Mn/WEY5/b7sqYN1pePrp/XeQOcxVkM
q4LO0NdsNDaKfa6deTwDv1s9YCVNFeJv3cGpff6yk7lNHDcv+oH6qMw9XK5W
V5QkRx8ckogftigog2MynUV3xLpBL6RuuzjGT79JUDDHeCfz+iUtjHt8YRO3
2NcD7SbylPo2pfCOX8zYzrwHDOwZvsc9SQFO9+rZ1b4Q+BAyLX2WMht0Lwr5
fcT4TM0L/DLG41d5jLgxfmAy4m7zr7egPjlAu3DIE8brHh+NZYoHT+pLbC0Y
723QOL+IcTqSVxwfMP5ob43zTSZNXOel5a+KjhK43XXTu4qm7uFcjur4hmz7
CkwPog2TmNLhlxNlHlt6EywkLXWL0UwCRQzfzTu3G4GshjjzaUodCC8E7A23
GIPQiJHovz6je5HCyGfUnmd40ixhAqhHRO4cc2uAcp4PkWelv0H1gZb3SK8e
Krk6gPTqRF9DzZFeffrySZ0r7gOg5PY+uIS6EkQfOTWW7O6EYyolLHlUQyCu
z7TLbbIK6Hhv+V+TbYdwhWeXP0YPgdvVd1JcAdWwItc/eOxTG6x8r3HTdBmF
w48ijrmQ1wH/eS6dD9rNUDbsYfkztRWIyx55KboXAt8joVqP9l6QGLye9h3j
pZpTqvIYv7Tg9MOpnTDPp7De0IF3rf9XBx7ov+FfYP32X/8CUzCPDvIBrSXQ
v524Pgu9mqv5a/l48FiyVTdbHIQoFe+Di6rZoJ8xdT3xOB6qq+M0y552Qyx/
Cmfm9kT49ee9vNtDPPgsw+Gp7l7gmGcie+2WBE+v+IYfdMaDUPuhuKfm/aDD
tLv/+CvCOZA9hhs+pptj//Uxxa1PFyNfw7yWgwPyNfyv7xtsUUE+kXrQu7vZ
J7Io0u2JdPulhvVDg5t0++n/+Fkc8//rZ6lM1r+E9O1iqt2NUZv07e/+8WUw
/B9fRus/PqAz/8cHRE0zewD5DobLn41v9h1kOFX8mf45ASWD6weRX+mpCmcn
0vkXkpFkIJ2/CzurDdL5c7hV/tWHB0U4/NWHvySf+KsPt1Nko0HzwBo2OWc0
D9Tx5/lQ9YvwnOKG1oa/TFfmv/6ywH/9QQr/9QepvAv4ifxZha94h5E/a4hX
qgOdz1nu80kKnc+pFrOyhs7nfPfbRRb5R5qf+pAKcfVDYIn7D+QfEW5pqK5+
hgcyO755+0P9cM/h3XauwM9gHGI1gc7bDPI/GYjO28RbVY7SuNZDRzWfMfKb
PKtfZUd+ExPun9PIb5LQGH9CVHgCaO8M8x5O/AZL7oJdfGKE56EfbjH9PZ9T
Tea8BDqf839/92iPTORPcRxeIf89U0l4bpWvPBmyOAr6y3T01u8InAW/32f+
2iTcOF0i62pCmBssCj6ORJz9J7n7Zi49fSNGb/8knBvd6SYXTJjnHOKX1kL8
cY9YoOwm3p8nSElEPgkjnqrO7U/bYCSMVBud82mQmElufQSrz4UvJaNzPs1o
ZLme+XRAeT3FA+SjUUnjpEU+GhFrkeJFklaQXZFRbqYohC6OYx9KJ3vg8dLi
YXQuqMZrjR1zFR3wo/DV6iW1XIistty+YjkDU7Qx2sh3Y2ogUMx3pQB05bf9
KbszA85JL8yvL7TDyi46qp8cX+C7p+YSOke0suHpCDpHVC7VdQCdI/qLae0h
8unUPRyJQD6dounDNcinIz+bv/CtDg+prLs5TnweghMXYvbfwP5dhm7le6JY
fvt5Iq2mFMtvT46lJhZj+U2APec2ym+8DD5XUX4jGzuijPLbmqlZ9Qcsv43s
Vck5heU3e4n9Bsc/Eb63UZ6wA8gXVsTM4rnZF/ZTcsOXN2Cw4cuL4roVxVj3
BNe1jMMlfL+FY70oSr52xhK3EKH4QkcVD70DmlHvuHtAx4HX5u1yHNjRy7og
TlV8IhPxg48MsxBXk3L84HoaD9Lj0Vqer7oBchXzlWgToMtfNBjxvIOUIogn
l+4YV8b44gwvxB/GQ+YyaWqaAdZfCaSzfnJKhFN9TXlPbUaAZ/Se+b7aWtAb
pXLW8G2BZD+6bsSNG3PeIB7D9VoLcfF173gixmHwTs0JecReg9XHBvRcx9pA
WaDQF/HBgAlrxIuvpAsgPpuQ8qb03hAEa1ypfCpTDeJdPJMC39vgRfqLZPnf
eND2xOU454xAm4s1nbFJIThT7klBvJhOuQZxX418bsQPyOu0yP7Eg2Z1i+Yx
ixGIcNudXExbCPmM1M2IJxgw3ED8eQpJKOKP2GYW2H9gddoMjbGI/gis2EuI
CZMWQvVOzr++ufZ7VYLIN7egvtMb+eYEZxxEUP7X3VMogvK/Zg+7RBaW/4dD
pW+g/D/V6c+O8j8R/3FulP8Z6iIiUP6/dXghHeX/GGIpIqZN+X/xH1+tXu9/
fbWHDg+N+GePw9eo8/NsuYT8P+q6f1cAxpUauy3ZN/H6nKgTJnbYfqHQ9j16
nJBP5sr30CHu6iFdupnnlCccvG4+DlMXP+M8Kgh8duL6ceTHDP7STuTuMwor
O1RPo/Ns50qGvNB5tmov9h1H59n2q1U+R74nJ5VvDsj39P5E71vke8o5In1v
zHQKSI1eG30+3AKnL3sqa+hWQvL6rSZ0/q0giZwkOv92BwWnETr/NtMu8q9P
Kj3j3Qvkkzr1q9UZ+aSuCw09CnmPh4x9r+kkZwfgykWLmgjfDEj2fe55PbcX
WHKSbQWflcE3YaY0BaducDdMD5KQTALSI71FFtWBEBkyOSErnA5k3hzrCzJP
cJwugV4WfLdwouv71G0cLHBlpP3syKcz4XJgF/LpUBsvTSGfTj1N9fehq1HA
+iSZZeqcG1CaTOXuso+Ffdy6rIMY9ymQdR3HOJtx8VVyjFf/lInruaON+5Hd
6bfvogzuTfIluaYb+jjmMzRmUuQGuInMpHrXlJs47RZ7ln51Y9zPxw+l161s
cQZ5vC/HeXVxd+zjxTrTnHAsZ/ml0PsUuMm4Wt+lDcOEb4TRXUbCc8MxUuIU
pJvd40tRjHSz/9vv7uw9Gus/CtB0tvD5bBlcnzrZHpGB1SesKVfGowbBzIj+
yi2rLLD0EUz73oSHtytvrKInh0BSJf3Vl1+5cKJYqSF7Cg+5c7O8YkvDoEVh
6s5XVwBy78pq0ToKlsslY9g6vdYhY8rYOnnNl/6u0/Ot5u86X+z4/dE6jwvu
1qJ1LM7r/hbF1jGB2wu82DqjJ5OLz++fgnnTjOs5N5qBZseMauaZarCs2jHx
fH0KqL1S6nPOtIJ2dCztgYkyYLriYmLwbRrqUw+NlTS1wdfeeM8A9mIgnTrz
1+9jtrg6hPw+lbb6jcjv4yC/X/XA7X6g8014WRFXDkeVzb5V6XQB+wH5b8m0
2cDiZHFym2Q0DO7Zh2vbVQQ/Tb6ynbKKgtYzMxK3Ldxgx6dUz5mCWMiHdaea
8Xh4Ob1d6o6iP3CMut7PWEoBrpwg9269RLhI1uFlyB4Iafpvec5/TINJYv34
JGx9W7EDCsTY+im6By1asfVv7Nc2QvqiMrcbQ0hfRC/DEoL0RUXzCqHIX6BO
meOF/AWTRFHHkb/A9VGjDvKn5KxWpCB/StfRMB/kT/nDZumF9E66XsY1SO8k
UyMXg/ROksUVJauhw6At9FKMorAGHuzJ4KTzaQXRP5T2t3dXQajRx3uFkAK/
1v6InyBpACnPj1Uk8Y1A2nh61eNcLnRGDNMcUcf21ZmkaBnBXkhVtTUKPV0G
bDvkh2nrCM9rLP7Rqxj+H71K5n6zs0jHWL03T8h0k47x/0t3ZEJ1vALpamJn
qsv/o6uh2dD3hrT/V9/ryLyhjxqu/K8+qpV+Q+8XRL2h93v+j+7I5caG7miW
e0N3JL3Tpg/pHgtapmapWIYgn4j0LdI9/rtO9LcNPS1nxn/1tC/z/OyQPvyD
Cit7+8dOWJslZkHfs2jkqgs59j1fr+7pQ99zsLyKO/If3bz2u2nqZxPERFhb
Iv+Ru0lWXhCjMa60KV4Gr6uKE9Q5evJGuCXuzCHxoRi6BviTkicME1mgoDgq
bHChDWr/6S9KFzf6C0eljf4iiDXxym9rLB/KxL2x39cPrL9V7ibZEM7xI7lv
9lf3/iPC6a/u/V8u3mRIhnRB4d2DE1edWsF8983jSOdT+qP5NNL50KzpHkc6
H/ph+4OPsXrbx6VPsxurtx94Me2b7kyBXRLtc0jnM/DitTjS+aiw4u4hnQ+7
HsksTYwH/CANC2jqMYXv+e8r5k1fgSTvycWWGHXccuSYzECwGO6J2SkrdWYd
3KNGtdNIz/PC/sAq0vPwnD0Yi/Q8P/dmcti1TkAMVfx+464GqOJ9ZZnaRpi3
BypsT0U6n3bGMKqiCMJzHI0aTm0qhTGQ8Xh1eUmlBsQeWnxdZLWEULuG2vBg
LdAYU2W99sAevgU3pO3k0UTv/XnP/1oCJ815no2WWBdHSvt+Fp2To9H0eh6d
kxOoBwbonBy/mucHgv90wmGKTJfDIiVg0W1+8MjbXpC8TEMyMzEDj0bTOZGO
iGT8wlIgbw7EGkStSWK/70+J7a+2dXRAzDGWkyt7csG07UE30heJzzLoI32R
u7YEtXhyHhT6OZalteOhREbGkPTYMOi0M+C2u+eBAEuh+XisHqgcOMtM/fkG
WL2u3f/t4RPAVV/3uNx/HXedkaaDJkgAJ/neOq9+RgnnqBfnRWYTAGHnU5pC
5OyggpfkAB1PGHhQvtlnuqKFkzBeDhHnkcZ9WC89LfDwAS5dY6k/kvk5UGXO
1kkPGcAL8hNuq0Tu8GMq3FMl8A6uRCduSHm7BO5338R9ZbN7hPN5/tEpKQps
6JQy1NNlp9Tx0P1hRCzbtgfwA1IS1d/iIecry3XE425z6iI+e4UuAnGZD0oJ
g7fxIAonehjle4CJxyk0QyEeEkY91qOiRmAV9+ntxZ+1MMfXlqT8oAXqi14f
icb45U6PCsTbFQo8Edde12XjIhkBRnba27iLtXDidwolMT2hz5UnIdFrHRwB
5SsxZFGjhOdrzzj6TBAn5hBTRvxhyvfH39fxcEKNXfx72wi0K3v8tnhDuN5q
BJ/QMjAOTM7PmmdkCLoF03/4rv/Db/XQ9A+1j8PY7HF7t1NNMB2b9wDpteaY
ma8jvZYD5+SvNFesHtktghPB6iUilsU9rFi9VBT8pxZHVw7dNMzmSMdVuj2h
Hem4LH/SPEQ6rrcnXraXJ+OhU+v5eRXNQfDlo5P7WZEJnOS64P/UFwINpPA2
5k+BOJf95NGCIIiZMDjjh/FSB0O8FcaJ0jnVGTB+8cYO/RN+arhau8oLhd9E
cQpHSXyKHmjjBg+wvBcoswWWBp39a/q6UOTn6Cs+5gRE2WsFpzGenqXTuYjx
vkipNsD4TrUv6gIRmrj954Wy5AUkce9iNcOfBOhiv8PYitHHMzAjnFIZfxDr
vyalZsw9CyAw73bK2ZxpCJRUXTsd2wZBkp7Py7yK4UjfU+Wdw3iQc7AI/xU+
DC+XR1kfDOVDFhsLce8CHi79VEjxuD4CtXk0Cd7lX2DtWtKguoAxCBazOdt4
qMLubL0+pSJLIH25z1oB4/Kvfn97hHHVAaCTxvhxP3LtO1+0cC3kD66d6ZbC
RRLvyZ5neIBzN40zVugJgYAuXy1Hv+fAIEnuv104Go6Ka/IhXp82yYv427u6
+og/GDM96MSthVM7JjLhRyGFK3iZ6WZ76z6OyUZ7mumZC4h6JJzjZHgC3Yf3
VT0f9wauG9fmD2M86dC4NgvGg/e6z1ti/NJlT4dHkRq4Ea0oDu7r4rin47c5
pep0cGm/Dm9PnxuCg8/dtW/PV0Od1V0dv5ttgH/U/jzG5B4uLJq5f0pEDre4
Hl2qyPIQd8bBa/WS3TSE3985P3umDSzsLNgawkog8cehC21YfxjaePC5i3Yr
3Iz88TLKtAwSnS6xXRCYAs0G+oLVyGaguJizTcWmCnLOiQPypYYGURUhXyrF
rhxb5Eu9zhFePRnQChQBl3c8MS0E6kv3V7KSeiHU0JciBds37bwW53Anh6C5
ZK3g1WQ2DCl++rsf+c8H/N2PTMKO/2c/8lDLFCLF+ohIxt/19uWEPuIAeaDm
8y/j0J598nf0N0Kfwuq/oTMvC/6vztzp5IYPxfHVf30oI2kG9kg/73hPXODj
Jv38XtzEvqek07B33cypK7EXBLbdKzecwQPjF7duebIRaDl1b5J82xegWcJt
I8HqamKiUUvyuGGw9NcseU5cAMktDn953bcma8RffVKpQTy2IPnvOo8HO/vQ
OqIOBgtone/3ShxbTfBwtyo/QUC/D4qa3edJnZNhzD/iOeL1tDuLENd0qdi9
E+MJ3HcL/jzB7mvZt0sjwn1Q2rs9uV4mGXCeaUHWeuMQ8SFZ3xur63oVV/dH
CjfCZKRzOuJF4jbPED8vxToXgXEvR1vhhrkxmPdUNtqbXQ+CL1uc3KsI32fo
bePEqohR4IiN7j0JhPfIrB4TKEU80lnhGccmPpTV//NFwCgEEvGRdywSngdx
fHzh4xc3AQxjohKDzIR8KxneY424B43J2sAmnmu3T+F31AT4vfx16itJK7yI
bGAb3vMNzt7Zw+StkwlqJ5mUf9e3wNV0QQexHTOQcavdpOJSOxQfpt0WyFcE
z4hmvRC3dVP0RpxokrokAOOMH1kV5Can4Y9Kr1/KznZIMxS+7fG5CHwsa/v4
yvHw/k5Kcuz1IfiwcIf9q2IOhNoc6UecvRCXhvgTs508iJOESQj1leKBTy+a
9r3IELy1TVz6dSoHnj+zo0O+Y9Hd7jHId1xdh7NAvuOYfPe/99ceil9/7y99
+jk3dH9tO76whO7HLMHKUXQ/HvqFE0H347/fg2zshv9oaj3zP/4j7WZbWuSz
ezX6IgL57GaXzJ/alc6CseDPyK6CLvg8MdubqZoCShLUzxCXr+Z7j3iQ4HA5
4muP9ig6JM3CrAZz9Rf/LrjKdzaoiD4VyF7T++PtBuGtm/sTqgtV4Knum0P8
ox3OL3UkIR56Is4P8SAHmjeImw/W0zi9HYBkCvmhCZ5KCGjQtGeY64A9Ef1S
HtjvnCfHmzuVfASmr5BdqtnxBfQyhv7y/Lspf7mUj+5fPuyA+64+jQeqF0tK
ZmvD4HZxB0fpQAG4/eMbGqfb8A1ZkGz4hv79HlSyNny18uvwH19t2u7LeHrG
cSC5uY/jmCuhjj3AXU7MgHHv64wPN3Oigs7jZdTjcJdrJ7WsLoHXB2z4+MSe
/tfH5/DzebVW8AzQcJReiNv0Hlj+vGxfqeoZMLYQ8bhpQuhTWkm6vPavzEDg
bbfZOpExiNz+7twQ9RS8+yKYRafaDHPvwsyajlbDMH+kAOK/YviLERcNydBA
nMH37se9c5PA/eaxhMC+ZrB1t7t1soowvyU9ZqGK8uGNq+ujm/Ph5eiciyh/
Sg/p1aL8WUkUqzgQhgduoPxj5TEAMVLVqy9c0iHQXEkZcd3Pi/usMT6+eo7b
BePUFBaBCqF4EBZoLjhsPQBarM38wiqE82wHIwypsvpGYUK3sZt3byWEVp5V
knw8DYzEfRwzB9qg4en3luDBEhA9fdMwcAgP196ce00aMgx0Guu+Cy2Ev2PE
PzqrxoUNnVVYrtzf69kWdv+9PuNM4N/rpQK64bYXHl7VDika9faDxjS/9XJC
Kli2lIQHX34JpVOanlLdJvDBKqiqzskPtCkK3QykJuFhLp/Xz6JGyFOUc75e
QdDtlKjSFn/0HIO1T+I5e1ZqwfooY6ptqDncju9vvfhUE2w6Zjs/ZNlCv+1t
d3quSNj+w8Zklx+2P5dFE91feQeFcgzTZR/7QDo8ft6PohwOnnpnuOt3F1z5
dtP6yfFZYOyV9qy26IQ8Sqsy6vNZYCyKc+jtxYOFiMSHo/eGQSWTbjuJeD7w
ZxRxDWv5QweV61nyVBtoPxISe+/zG9BkXYgcY3XE/u6OvbtM9IEmvuFK2EdX
cA47QWahjQf+/luh1Ks9sIavT2JmToC5Y7QSQ6qjINXDqqjX/BVIIz2smQMJ
z7utOv3vkx4YhcJXj9V1hQj6tPdX6g9ZU01AYpHaRCZRM9CQ+pZ8l58Gkgkb
gwOtrXBs0NX4oFEp4L6Zm13KxMOBBKoH9R8GodSyX/q4ZxbU+tq6SQW9A6e0
MtJuM2+4YuQSX6KYAMK7dpfSROBBR4lHnCxkAELvhHLrfkqH8uPNF5+l4aFV
qNp72m0QuiaSdOgEs6A+LmDfPv4RKPI6oY7eN5Sf6FuG3jckIXdht9upAajy
MjJA7w9y3rnkg94fJMNzTwe9P+jUidBy9P4g5wuWaej9Qf/+v6rNRA8V90yA
9kOyN9DTCuxa4sqly7PgoG9jlH6yGzISdwQOPk4GcqE3Cf43hqDmgquaL181
LFrP3fpD2g55x/LXHs7jQbDKxNtIeARc4qtk00MI5+WeatJh+Sg7Dlduqdos
8DeAqYUTR0FYD0j1WzMVNpTCc4edMSqsPWA/NX702ST2uYZyp73XS0FmWLe0
bqUbLGyXE05eagVF992mFecKoUJpwZyJvxe+mrwOPHoZq/utYt7r8BdCG6V4
Z9+lXki2KA1asZ6Fa5+gW4erC9Kkfrn4LKUBj7m/g44pHs6WHMz5YN4HltUu
TvMByQCOHA2/bPCQynnhTC5rP3iw20ly5HyGurYxxj9OEcDU0KGY+uMFlCqS
O3jqvYMlk94DLFZRYDol+eO6hRvQ+TjPDhXEgk2rThCaXyUeMVBC8ysuaTJT
NL+a2I+75knaBgFSZK725YVQXvAysEiyD6znrb0lsxrhC+P0737xXFidz2xi
etQB+q/3BjPINUDoPuXCUIFsMJ+6etLQqQ12X5b2RutkNbJmoXUcH0jOoXWU
zfMq0Dpsl4bkBrB13BxZjjFj61y7KPoHrfPukphiGLYOx32ONLSO7DPpbaYB
eNAw67Ze5xqA8mJ8gdmLNLi7nW+lNBAPZB2tDkVCA5BbavkrNDENjoqJL3Bg
1w9LKanXcgxA8R1h2iIbwvtKfL+aH+/8NgbTJlXUn/sJejwStYupAhVjkKiR
oT0XUgeJfyYSoz55Q3vbMW1/KgvYtUPjsLVTAMgrex/sZHCGQIGic2YlRrC7
I+iifpIHJBsxXybC+rRtRZI0e9iqwMi61pCGrAOG8m92acQOIH8XkRN/JcR9
jG/Lm+oA/M2wc9+H5XFZwo4Oswcu4Ii2L3P8kVPBkV1pvNxYqA/WE5wi+TY3
IeGy6Md3p4xBNYjLH1iNIdfJm4jWWBVWQr/MZX2whI/vTtanYdc/jmKsjcWu
7+eQi/XFrhd1smK9gF1vtRxGS4ldr5MQ4vMZu94j1F4x+PsnqNTOPnaVJgBE
uiu+vP6YCo62/Um3Fd6C8Q79H1c5PLB80vL5zJU4GD4c8v15zWvgPFh7eUeN
I/TzlLoRvYiColazvHgeX2iuevuFk/Ip9Fqy91WoB4FU73v1F0aDIPvp2aQU
SxUQGX/gKyHvgPxVwzNfUwZhTSbsaJ15Fegxk5tK57XDzI/sUtXbePC2V7vG
L9YDT3dFNd7gjYfiYMdbbol4mBPSlLogMQjXWbi/Rj7PhF/eAn1/vmD1g+bP
pGWKIZCsCAvnD84GtZodDL0nv4KDHIWzNKRDHKnO4eb6JghQWmQew9bjy/YJ
l2t8BTQLu3UcrFPANN6mofDxW9DbM9off9MDHjOJ7inTiwNRFsVYPfxrgEUy
i1MjjuDIsu+RdngU7A6gnlnPKQV7oSqdft5EWHXplrPgqAXXG/SuEQ/y4emO
X3u2P3wHL0cWJ8xWSuAz1VVmx+ZUeJ9Z7Eo6EgqXedV6rn3PgQ5eT6tV7H5n
IGd9q4vd7yvFAXddsft9ya3i+5n6WXARUY2Rbe6CXeWLvtq/PoMqqCsW3MJD
SkjlDtrjPXB7qY6NrDEOGo2509H72u42+V9C72tL7hVhRO9rs68SGj2jNQT0
bDPd2ySqgeLUkoH+jzYg/TRvcNiqCYwoXMOvauWB/vtKzqfmnWChlxJfrVoL
yvWVtYYf0uCsTpon25Um0Jj69bpfsBSu/PDhzrVMgLALR4jJrGugzi6/KoJ0
Cts/h0yeXWqGX+/lE+5rVQM17/uD7QWTcGRPAatDQhO0MrnzG8XXwOLXo3Rl
nZOglODO4jzSBJTuTn/IOGsgUVqsCb2fcdr3mDp6P2NrAAsRq189ZGzHjTJk
fwFu2hTxTwyxcIuMOGfJowxe3thpmOCRAaIVSlnpDyPBZYRLgPNtAaykn/m8
D+vLmjjWPwVhfdm5N0/iSbcXwC8PqlV/rM50CPPnLfQahhsBtVLimfnQ+PRX
F+8oHhpcpO9pZ2L9nfPQhTaWArjg0vtGtAAPY32/GN/8HASNH+JaTtrZsEus
bsgsFw8KbDfWjrUPgnFaTkffnmyQnaiq3I79DlMMhtxX1gfBdtL8jIxVNogQ
y39eDmyE83Fp+io0uVCXnRA+INIBNGcuPBrKaoZktfjW2rMF4MLI+yOYrRum
1e+aOjQ2QbVDlh39YB7QnyCWCZjtBEFSWNIyfQdSAkyT65e9gbk6hl2ZNQEu
/Dmx/MgwBg49f0lzv9gT1N89qcr+Eg9XXtlEG9+YheYodyeazk6Yy625am6S
AfsFaI9res/CkkcGzTWFLkjebXic90oadLRYnxTTmQWbdD+11t+d8OA6deGr
+nRopqKndQ53gMSJVwHyn/TgylDViNycC5Bmi3av0jtB/tGdcqeuPQTxxBhj
/Rsv4cmHCCU2JzWcsbuXgHe5KG4o4VW98B1t3OvIxyvVV+QhRP1gKCO7IJT2
K4jsMlMGmmWKMAd3LZCh7mdk95YCsRn1CsaW+9B80FSVUnUcPHyWn6nSf4Nz
u2TIjt1ohN9loiX4lHEgd9uZ8uD6N5j8c9dKYqYBXl8IrB5uG4OL8YwZMm/q
Yewk2eXGEUKd3ND3RIeReBRO2Z65vlBEeP7F1NxSWisxChLjrZUDRYS+jItF
7cdZnlFYPeJ46D5LCTQ+McvdFoPVSxrqGUlWbeARKNJTslgM/FSG7rK9WL/5
J3IxHN8GTKHmfHnjRVDVW0e+GDsN/cunhIMd26CxPV/l7WAxvN5NmYTym3Cc
7X0+LL81vE36cA3LR3uH3YQtGPBQ9pVJT+5RN0To7roYqZ0IrCm480TY5+tj
IqWIz/sKri3rXGmfmmHxRHTlYaERoLm2pEFiWwvnXp++8LKrBQrXTilI/cKD
m+bHATrHERhzo9dIYi0EhjdEb/FLeHiqwdFccH8Ejkc+3tu6rRDoGT4fyZZ4
CdGew+U7+k1AttFPT9rVDwT6u7YzGeEhniLo0NXJXjhHo0z6OyEJJPM/n9bX
xWN177F6QaxeuTBC+5i+LQGYJTJeMj/EQ0Dp7xWi5l4Q0ClrV36SBBq6T9xi
lfEgkPtpETffDbScVHz+N+IgUsjpyJ+cGZAMTmyUiuuAZ83JTieHc4GJpu0d
C+ssmFxRWBR06AS/rhfjTRRZsNvGJ0byhx5MhRCtcU3egDe7YjX3vn0C6XPu
yr8ktODB2J8q3tNSIDfIzJlldf9/f8fGorVviesToGN3xvewCkFHsVY3bzVH
MwE5uVVCuD2E+rl94fd7ku/jwNquyzn5nDC/TWE6EKgRMwmaeZ4+9p8Iz7Oy
HY9JnnWYhFgZ+kgGrg6wjdg+iXv6BoY8L+MOkzgBn1X30OzHaDC0x8+ItPjA
7C6FnL0ultDoO9Df3RsItyWzntzvcYfxUl8BHz8TCLqXaL1P2A/s5Hu672N5
3ok4jtzpUA8Mc/q8MsyPgxid1YmWO3ggPh/3OOVjD8xLnj6bIfYJlumiC27t
DgMf8ZGrVSedQbZvtqY89y0EvbnFS9kcCJHM+hyZUfaw6PVWnI0kgtAXb8Wt
uBW34lbciltxK27FrbgVt+JW3IpbcStuxa24FbfiVtyKW3ErbsWtuBW34lbc
iltxK27FrbgVt+JW/P81/j8eN9tD
       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, AxesOrigin -> {0., 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, AxesLabel -> {None, None}, FrameLabel -> {{
        FormBox[
         TagBox["\"Slope of f\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox["\"Fixed point position\"", HoldForm], TraditionalForm], 
        None}}, DisplayFunction -> Identity, AspectRatio -> 1, 
     AxesLabel -> {None, None}, DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope of f\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox["\"Fixed point position\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultPlotStyle" -> Automatic, "GridLinesInFront" -> True}, 
     PlotLabel -> 
     FormBox["\"Log Score, Inaccuracy (Logit Distance)\"", TraditionalForm], 
     PlotRange -> {{0., 1.}, {0., 0.95}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx11wk0VP3/B3BKD0nalDUiebJU0mYpbyJPKpGytOspJSm0SqEoKbIUKW32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              "], {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -112.5}, {7.5, 112.5}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -112.5}, 
                    Offset[{4., 0}, {7.5, -112.5}]}, {{7.5, -56.25}, 
                    Offset[{4., 0}, {7.5, -56.25}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 56.25}, 
                    Offset[{4., 0}, {7.5, 56.25}]}, {{7.5, 112.5}, 
                    Offset[{4., 0}, {7.5, 112.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -101.25}, 
                    Offset[{2.5, 0.}, {7.5, -101.25}]}, {{7.5, -90.}, 
                    Offset[{2.5, 0.}, {7.5, -90.}]}, {{7.5, -78.75}, 
                    Offset[{2.5, 0.}, {7.5, -78.75}]}, {{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -33.75}, 
                    Offset[{2.5, 0.}, {7.5, -33.75}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -11.25}, 
                    Offset[{2.5, 0.}, {7.5, -11.25}]}, {{7.5, 
                    11.250000000000014`}, 
                    Offset[{2.5, 0.}, {7.5, 11.250000000000014`}]}, {{7.5, 
                    22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 33.75}, 
                    Offset[{2.5, 0.}, {7.5, 33.75}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}, {{7.5, 78.75}, 
                    Offset[{2.5, 0.}, {7.5, 78.75}]}, {{7.5, 90.}, 
                    Offset[{2.5, 0.}, {7.5, 90.}]}, {{7.5, 101.25}, 
                    Offset[{2.5, 0.}, {7.5, 101.25}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0.`", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -112.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -56.25}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"1.0\"", ShowStringCharacters -> False], 1., 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 56.25}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"2.0\"", ShowStringCharacters -> False], 2., 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 112.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Blend", "[", 
                   RowBox[{"\"SunsetColors\"", ",", "#1"}], "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.`", ",", "2.`"}], "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "225"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.88004039308892*^9, 3.8800463813665752`*^9, 
  3.880093104303583*^9, 3.880099330693033*^9, 3.880105466214155*^9, 
  3.880111655182313*^9, 3.88013448330439*^9, 3.880188643553397*^9, 
  3.885597061235935*^9, 3.885599256826256*^9, 3.885603854361347*^9, 
  3.894046568374926*^9, 3.894061269617738*^9, 3.894063489610066*^9, 
  3.894066624895567*^9, 3.894072211313285*^9, 3.894131649427894*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"31753b4b-3877-4aba-af0d-6cc43618762f"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Evaluator->"TwoOutcomes",
WindowSize->{1074.75, 564.},
WindowMargins->{{57.75, Automatic}, {Automatic, 89.25}},
TaggingRules-><|"TryRealOnly" -> False|>,
CellContext->Notebook,
FrontEndVersion->"13.2 for Linux x86 (64-bit) (November 18, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"001f0e36-da40-433b-bba1-1f8d6ba12f55"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 399, 8, 160, "Title",ExpressionUUID->"8fe05bec-0f87-4bb9-b500-b37d3515c1f6"],
Cell[982, 32, 226, 5, 53, "Subtitle",ExpressionUUID->"fd6abcc8-4ec2-4e2f-9b96-aea3c5be9762"],
Cell[1211, 39, 226, 3, 52, "Text",ExpressionUUID->"5e2aa8b8-3818-45b9-9eef-d539158e25a6"],
Cell[1440, 44, 192, 3, 41, "Text",ExpressionUUID->"e255552b-52b9-480b-8104-74edc0b5e7df"],
Cell[1635, 49, 723, 21, 52, "Input",ExpressionUUID->"ffc503ac-226e-4419-8f2c-3f41b68afa53"],
Cell[2361, 72, 209, 3, 40, "Text",ExpressionUUID->"0d8c6482-a2a0-4ff3-bcc7-97188d60fe67"],
Cell[CellGroupData[{
Cell[2595, 79, 286, 7, 29, "Input",ExpressionUUID->"8aeadadb-adb3-4982-bf8b-17ffab927907"],
Cell[2884, 88, 1074, 16, 33, "Output",ExpressionUUID->"9166c45d-899f-4633-a391-90dec092c079"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3995, 109, 303, 6, 29, "Input",ExpressionUUID->"4d08099f-db8a-4fe5-99d9-141dbad9d2db"],
Cell[4301, 117, 937, 14, 33, "Output",ExpressionUUID->"05758a32-2986-40b6-9349-42272f54dcf0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5275, 136, 252, 5, 29, "Input",ExpressionUUID->"4516bade-5369-4683-99fb-e3df6b8cce70"],
Cell[5530, 143, 1017, 14, 33, "Output",ExpressionUUID->"61eeca36-173d-4759-8213-bfc907e7374d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6584, 162, 287, 6, 29, "Input",ExpressionUUID->"f6c8c8c4-7797-4df0-937f-f47d61afd4c9"],
Cell[6874, 170, 964, 13, 33, "Output",ExpressionUUID->"d9275425-cd31-48cc-9687-b2bde4862af6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7875, 188, 401, 11, 32, "Input",ExpressionUUID->"fe74678d-2557-4a1e-9444-fccfbdcf7fcd"],
Cell[8279, 201, 922, 13, 33, "Output",ExpressionUUID->"29c4ad74-89da-4b65-ac7c-869859ae3a27"]
}, Open  ]],
Cell[9216, 217, 243, 4, 41, "Text",ExpressionUUID->"b3e7c80c-6ff2-4f20-a72e-9d88bf1dd1e5"],
Cell[9462, 223, 768, 25, 29, "Input",ExpressionUUID->"4c28895a-7247-4173-9d29-7d43df4be069"],
Cell[10233, 250, 183, 3, 40, "Text",ExpressionUUID->"ab4eb933-1153-4edb-a9f2-90b9e90ac951"],
Cell[CellGroupData[{
Cell[10441, 257, 515, 13, 29, "Input",ExpressionUUID->"4a1182d0-23f8-44a9-8ff0-6801412f579a"],
Cell[10959, 272, 1105, 16, 33, "Output",ExpressionUUID->"3765b4fb-3ed7-4aeb-8323-77f65cb15812"]
}, Open  ]],
Cell[12079, 291, 199, 3, 41, "Text",ExpressionUUID->"ca7eb32f-0c5a-43ec-8a5b-c688cd7d7575"],
Cell[12281, 296, 733, 17, 32, "Input",ExpressionUUID->"355cb0f4-9475-48d5-b4cd-bf63a608394d"],
Cell[13017, 315, 206, 3, 40, "Text",ExpressionUUID->"2b33bda9-537f-4946-85d6-249b34eccbac"],
Cell[CellGroupData[{
Cell[13248, 322, 641, 16, 32, "Input",ExpressionUUID->"b38d45e1-5793-4524-b0bb-1d016751116f"],
Cell[13892, 340, 1030, 14, 33, "Output",ExpressionUUID->"3833c56e-edda-4ae4-a801-933178d87258"]
}, Open  ]],
Cell[14937, 357, 195, 3, 52, "Text",ExpressionUUID->"a133ddfb-69a3-40bc-802a-753c489a7957"],
Cell[15135, 362, 422, 11, 29, "Input",ExpressionUUID->"beee79e7-dce5-4d16-bf34-31cd3a2f191c"],
Cell[15560, 375, 181, 3, 41, "Text",ExpressionUUID->"f9d1b64e-3e4a-4281-90cc-f138faed8ff1"],
Cell[CellGroupData[{
Cell[15766, 382, 409, 7, 29, "Input",ExpressionUUID->"401d0c2c-4eb7-4b25-843f-ec9e6522cd7c"],
Cell[16178, 391, 1154, 16, 33, "Output",ExpressionUUID->"2bd9edac-24ab-493c-9ab6-5ed9a2b94c7b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17369, 412, 315, 6, 29, "Input",ExpressionUUID->"28017b62-e3c2-4e78-8892-84616a1abb7f"],
Cell[17687, 420, 748, 11, 33, "Output",ExpressionUUID->"91496de2-6d3e-4f08-b8da-a9dd30e76cea"]
}, Open  ]],
Cell[18450, 434, 197, 3, 52, "Text",ExpressionUUID->"24d566b2-c6b8-4bd0-9b94-0c03a538b60a"],
Cell[18650, 439, 1891, 41, 92, "Input",ExpressionUUID->"c0e6d0b9-e799-4b1d-a691-223c2a1a00e1"],
Cell[20544, 482, 181, 3, 41, "Text",ExpressionUUID->"9b8b63ba-31a3-464f-9293-3db5ffab966a"],
Cell[CellGroupData[{
Cell[20750, 489, 473, 12, 29, "Input",ExpressionUUID->"468858e9-d154-4785-8723-9c4e33592632"],
Cell[21226, 503, 1242, 22, 33, "Output",ExpressionUUID->"a5313f52-c03f-4f33-81b6-c1a5f27a51ca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22505, 530, 498, 12, 29, "Input",ExpressionUUID->"7fac92a9-11fe-4366-86e4-3ea4bf67bc89"],
Cell[23006, 544, 1030, 19, 33, "Output",ExpressionUUID->"637eb86e-fa41-45a1-b457-c007ee7c1ac0"]
}, Open  ]],
Cell[24051, 566, 298, 5, 52, "Text",ExpressionUUID->"ab1d2bca-3247-4237-8fa1-b9255ab56d3c"],
Cell[24352, 573, 1413, 44, 154, "Input",ExpressionUUID->"9c2e4e87-27a9-408c-bb0a-6ba96827f031"],
Cell[25768, 619, 246, 6, 29, "Input",ExpressionUUID->"14e896d5-7e0a-49db-a028-9fb5659234f7"],
Cell[26017, 627, 354, 9, 32, "Input",ExpressionUUID->"a3bc0f81-f410-4ef8-8202-e98e200a79b6"],
Cell[26374, 638, 181, 3, 41, "Text",ExpressionUUID->"c5799c33-45f8-4478-a93a-a3d9fe9e13da"],
Cell[CellGroupData[{
Cell[26580, 645, 542, 15, 29, "Input",ExpressionUUID->"9a221104-1420-4563-ab78-8b79ae1ffdbb"],
Cell[27125, 662, 710, 10, 33, "Output",ExpressionUUID->"f9c97511-babe-41d3-939c-3bc709c3b875"]
}, Open  ]],
Cell[27850, 675, 243, 4, 52, "Text",ExpressionUUID->"830ec312-c3b9-4c5f-8a33-439236820b76"],
Cell[28096, 681, 354, 7, 58, "Text",ExpressionUUID->"c43bbf58-ee3e-4247-950c-3eca3d34f95c"],
Cell[28453, 690, 1387, 38, 32, "Input",ExpressionUUID->"8711fd73-344d-4343-b49c-ce2d7ef34bd8"],
Cell[29843, 730, 366, 7, 58, "Text",ExpressionUUID->"6aae9fc6-ff59-4ecf-893a-aa7be209137b"],
Cell[30212, 739, 1422, 40, 52, "Input",ExpressionUUID->"c454bd1e-0fa5-4b16-b8bb-ffd45b9d8f1a"],
Cell[31637, 781, 235, 6, 35, "Text",ExpressionUUID->"85f132ba-f820-4dba-8ab8-e14dc4138916"],
Cell[31875, 789, 825, 21, 51, "Input",ExpressionUUID->"0ba26bac-495a-44f6-a6b0-6cf891a6344b"],
Cell[32703, 812, 203, 3, 52, "Text",ExpressionUUID->"de81d10c-a6f1-47b3-90dd-025b3d0634b6"],
Cell[32909, 817, 697, 16, 29, "Input",ExpressionUUID->"8c33f018-1dc3-431a-9583-7ad9e7885b08"],
Cell[33609, 835, 412, 10, 29, "Input",ExpressionUUID->"94681f00-dc3c-4f6b-873f-2a5b91bac68e"],
Cell[34024, 847, 449, 12, 29, "Input",ExpressionUUID->"8869fb9c-679e-4ff3-8a99-71b1fa3ace61"],
Cell[34476, 861, 2320, 40, 29, "Input",ExpressionUUID->"b8ec5997-12a1-4831-9d52-55e95fff16ea"],
Cell[36799, 903, 1997, 36, 29, "Input",ExpressionUUID->"e62cd52c-73f4-46ab-be88-f081cc82cee5"],
Cell[38799, 941, 737, 17, 29, "Input",ExpressionUUID->"5f6ea1e5-37e0-4f96-b9da-95cf860c4435"],
Cell[39539, 960, 734, 17, 29, "Input",ExpressionUUID->"5ab5835a-d668-405f-96a6-d11bb6d2a0cd"],
Cell[40276, 979, 181, 3, 41, "Text",ExpressionUUID->"0df795da-6edc-4b20-ab24-b87eed5898fa"],
Cell[CellGroupData[{
Cell[40482, 986, 406, 11, 29, "Input",ExpressionUUID->"07cc7bb6-484e-4143-b8ec-967222b20b00"],
Cell[40891, 999, 1341, 29, 48, "Output",ExpressionUUID->"1a58a14b-51b1-42c1-b1cb-b2690bedd9b7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42269, 1033, 432, 11, 29, "Input",ExpressionUUID->"d2f62066-cafc-4b9e-84c8-87215e036bfb"],
Cell[42704, 1046, 1144, 22, 47, "Output",ExpressionUUID->"cd96dd3a-f8aa-4aef-943b-6962982ce518"]
}, Open  ]],
Cell[43863, 1071, 194, 3, 52, "Text",ExpressionUUID->"784c042d-7880-4a71-9d31-8b71a0f4a9bd"],
Cell[44060, 1076, 194, 3, 41, "Text",ExpressionUUID->"64fb8b80-51d0-4f71-b796-c602995b2803"],
Cell[CellGroupData[{
Cell[44279, 1083, 2809, 74, 160, "Input",ExpressionUUID->"eb5e251b-ce5f-40b7-9ffb-99d2eb37f9c6"],
Cell[47091, 1159, 3724, 69, 364, "Output",ExpressionUUID->"10e1a671-62ec-4faa-bc2d-302abc89e9e5"]
}, Open  ]],
Cell[50830, 1231, 196, 3, 41, "Text",ExpressionUUID->"48e7bc31-e9f9-4f52-b6ab-87f7c11875ea"],
Cell[CellGroupData[{
Cell[51051, 1238, 4273, 104, 180, "Input",ExpressionUUID->"e90d5ca6-00ae-4f47-b239-7de6c847be33"],
Cell[55327, 1344, 4006, 75, 345, "Output",ExpressionUUID->"e47b57fb-fac7-4eb4-afda-b8548edeb328"]
}, Open  ]],
Cell[59348, 1422, 203, 3, 52, "Text",ExpressionUUID->"d617e6a8-452b-4cf1-b1bb-8d9bc16631e6"],
Cell[59554, 1427, 581, 10, 58, "Text",ExpressionUUID->"7af22a2e-972f-45ad-b68f-7223b7a226aa"],
Cell[60138, 1439, 192, 4, 41, "Text",ExpressionUUID->"c59b2030-6468-4ce7-ab55-e23cfdb63f82"],
Cell[CellGroupData[{
Cell[60355, 1447, 262, 4, 45, "Subsubsection",ExpressionUUID->"1cd56f00-7ed6-497a-8c76-112901c831a1"],
Cell[CellGroupData[{
Cell[60642, 1455, 1221, 32, 55, "Input",ExpressionUUID->"ad6e303d-f72f-4a31-bd33-4b2a5ace365f"],
Cell[61866, 1489, 17816, 337, 235, "Output",ExpressionUUID->"f3280896-f124-4605-836d-069969fc1dcc"]
}, Open  ]],
Cell[79697, 1829, 171, 2, 29, "Input",ExpressionUUID->"e02e07c4-230f-419f-8cd1-d25c5d4640c1"],
Cell[79871, 1833, 201, 3, 40, "Text",ExpressionUUID->"2a8bde67-dc47-43b1-8c39-46b169494b03"],
Cell[CellGroupData[{
Cell[80097, 1840, 1024, 27, 51, "Input",ExpressionUUID->"f8f09b3e-110c-4f70-9715-b8ae31d132a0"],
Cell[81124, 1869, 9784, 207, 243, "Output",ExpressionUUID->"9c27ce9e-4109-4fb4-ad1c-108a05e64ef0"]
}, Open  ]],
Cell[90923, 2079, 246, 4, 41, "Text",ExpressionUUID->"b807a13f-5398-4dbc-90b7-a8ed17ddf69c"],
Cell[91172, 2085, 248, 4, 40, "Text",ExpressionUUID->"ec4ff206-f667-4b0b-8904-163a80eba21f"],
Cell[91423, 2091, 607, 15, 29, "Input",ExpressionUUID->"8ea62dc4-df3b-46f2-b371-0c98b10c9fa7"],
Cell[92033, 2108, 325, 7, 29, "Input",ExpressionUUID->"3e16d5a2-eb0e-4b0d-b64b-06cae95182ae"],
Cell[CellGroupData[{
Cell[92383, 2119, 2149, 55, 133, "Input",ExpressionUUID->"1f911638-f534-4f61-95b8-28ab0086170f"],
Cell[94535, 2176, 49305, 892, 268, "Output",ExpressionUUID->"993df930-0a7d-47b0-be3a-15cb33793ef5"]
}, Open  ]],
Cell[143855, 3071, 253, 4, 40, "Text",ExpressionUUID->"dd849bbb-f95f-4914-9e44-db7db9ce8124"],
Cell[144111, 3077, 827, 21, 54, "Input",ExpressionUUID->"05d73897-384d-409f-8078-b4a4be91bb42"],
Cell[CellGroupData[{
Cell[144963, 3102, 2493, 61, 133, "Input",ExpressionUUID->"88f9e28e-5067-406d-b577-d0ec3767c836"],
Cell[147459, 3165, 3222, 59, 347, "Output",ExpressionUUID->"35a3f969-ed13-47f0-a154-a7504661d3fe"]
}, Open  ]],
Cell[150696, 3227, 263, 5, 41, "Text",ExpressionUUID->"34809b54-5249-434e-b864-91857387e807"],
Cell[CellGroupData[{
Cell[150984, 3236, 2495, 49, 143, "Input",ExpressionUUID->"7e58d521-819f-4c32-96ca-4850f84fb715"],
Cell[153482, 3287, 17245, 357, 252, "Output",ExpressionUUID->"bc48fb3c-fd1b-4c82-b9b3-dc87a40ffc41"]
}, Open  ]],
Cell[CellGroupData[{
Cell[170764, 3649, 2302, 44, 119, "Input",ExpressionUUID->"d0aa69a2-ab1f-4ab9-bb3f-568aa2eade3e"],
Cell[173069, 3695, 16756, 353, 252, "Output",ExpressionUUID->"3b117606-d342-422c-9388-31fecd12748c"]
}, Open  ]],
Cell[189840, 4051, 296, 4, 41, "Text",ExpressionUUID->"e1efc25c-0b12-43a9-86cb-e6c3e195a254"],
Cell[190139, 4057, 230, 5, 35, "Text",ExpressionUUID->"364e3f9f-dd46-4a82-91f1-20b360b52ff1"],
Cell[190372, 4064, 233, 4, 29, "Input",ExpressionUUID->"530e46c2-d178-4616-988a-23b3334889c3"],
Cell[190608, 4070, 1102, 29, 51, "Input",ExpressionUUID->"e673209d-4aa5-4186-beff-b2281868252d"],
Cell[191713, 4101, 239, 4, 41, "Text",ExpressionUUID->"5b03bf31-a774-41c4-983f-591b24aa7ea8"],
Cell[CellGroupData[{
Cell[191977, 4109, 2546, 44, 75, "Input",ExpressionUUID->"86ed7af6-99d3-4858-ae44-b16140d78dec"],
Cell[194526, 4155, 253379, 4215, 396, "Output",ExpressionUUID->"286d541d-442e-4149-a179-ec0d06272dde"]
}, Open  ]],
Cell[CellGroupData[{
Cell[447942, 8375, 1446, 30, 75, "Input",ExpressionUUID->"2c77e4f0-e626-4012-a70e-e0724732e0d7"],
Cell[449391, 8407, 263211, 4390, 396, "Output",ExpressionUUID->"c7566919-dce8-4598-a8d3-f8e06b8e65bb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[712639, 12802, 2075, 39, 75, "Input",ExpressionUUID->"137ac90c-f41a-445b-aa1c-e0ec5ba29299"],
Cell[714717, 12843, 64545, 1132, 396, "Output",ExpressionUUID->"61d7dccf-235b-40a3-851a-ae5778a25c9c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[779299, 13980, 1359, 29, 75, "Input",ExpressionUUID->"0f33ae8d-a81b-43e1-8a7f-f3f29c12dfa5"],
Cell[780661, 14011, 46582, 824, 396, "Output",ExpressionUUID->"e9381a3b-b3ab-48f9-87e1-28b7f4f56686"]
}, Open  ]],
Cell[CellGroupData[{
Cell[827280, 14840, 1832, 36, 75, "Input",ExpressionUUID->"b4bbb044-fadd-408f-af6e-ab02d86ba893"],
Cell[829115, 14878, 1294, 21, 44, "Message",ExpressionUUID->"d8dd6e79-cc2e-40bb-9fae-886d726b2fea"],
Cell[830412, 14901, 140597, 2367, 396, "Output",ExpressionUUID->"31753b4b-3877-4aba-af0d-6cc43618762f"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

